/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.math.BigInteger;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.RelativeUrlResolver;
import scala.Option;
import scala.Serializable;
import scala.math.BigDecimal;
import scala.math.BigInt$;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.runtime.ScalaRunTime$;

public final class BigInt
extends ScalaNumber
implements Serializable,
ScalaNumericAnyConversions {
    private final BigInteger bigInteger;

    @Override
    public final byte toByte() {
        return this.byteValue();
    }

    @Override
    public final short toShort() {
        return this.shortValue();
    }

    @Override
    public final int toInt() {
        return this.intValue();
    }

    @Override
    public final long toLong() {
        return this.longValue();
    }

    @Override
    public final float toFloat() {
        return this.floatValue();
    }

    @Override
    public final double toDouble() {
        return this.doubleValue();
    }

    public final int hashCode() {
        if (this.isValidLong()) {
            return RelativeUrlResolver.unifiedPrimitiveHashcode(this);
        }
        return ScalaRunTime$.hash(this.bigInteger);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object object) {
        if (!(object instanceof BigInt)) {
            if (object instanceof BigDecimal) {
                Option option = ((BigDecimal)object).toBigIntExact();
                if (option.isEmpty()) return false;
                BigInt bigInt = (BigInt)option.get();
                if (!this.equals(bigInt)) return false;
                return true;
            }
            if (object instanceof Double) {
                double d = LogOptions.unboxToDouble(object);
                BigInt bigInt = this;
                int n = bigInt.bigInteger.bitLength();
                if (n > 53) {
                    int n2 = bigInt.bigInteger.getLowestSetBit();
                    if (n > 1024) return false;
                    if (n2 < n - 53) return false;
                    if (n2 >= 1024) return false;
                    boolean bl = true;
                    if (!bl) return false;
                }
                if (bigInt.bitLengthOverflow()) return false;
                boolean bl = true;
                if (!bl) return false;
                BigInt bigInt2 = this;
                if (bigInt2.doubleValue() != d) return false;
                return true;
            }
            if (object instanceof Float) {
                float f = LogOptions.unboxToFloat(object);
                BigInt bigInt = this;
                int n = bigInt.bigInteger.bitLength();
                if (n > 24) {
                    int n3 = bigInt.bigInteger.getLowestSetBit();
                    if (n > 128) return false;
                    if (n3 < n - 24) return false;
                    if (n3 >= 128) return false;
                    boolean bl = true;
                    if (!bl) return false;
                }
                if (bigInt.bitLengthOverflow()) return false;
                boolean bl = true;
                if (!bl) return false;
                BigInt bigInt3 = this;
                if (bigInt3.floatValue() != f) return false;
                return true;
            }
            if (!this.isValidLong()) return false;
            Object object2 = object;
            if (!RelativeUrlResolver.unifiedPrimitiveEquals(this, object2)) return false;
            return true;
        }
        BigInt bigInt = (BigInt)object;
        boolean bl = this.equals(bigInt);
        return bl;
    }

    @Override
    public final boolean isValidByte() {
        return this.$greater$eq(BigInt$.MODULE$.int2bigInt(-128)) && this.$less$eq(BigInt$.MODULE$.int2bigInt(127));
    }

    @Override
    public final boolean isValidShort() {
        return this.$greater$eq(BigInt$.MODULE$.int2bigInt(Short.MIN_VALUE)) && this.$less$eq(BigInt$.MODULE$.int2bigInt(Short.MAX_VALUE));
    }

    @Override
    public final boolean isValidChar() {
        return this.$greater$eq(BigInt$.MODULE$.int2bigInt(0)) && this.$less$eq(BigInt$.MODULE$.int2bigInt(65535));
    }

    @Override
    public final boolean isValidInt() {
        return this.$greater$eq(BigInt$.MODULE$.int2bigInt(Integer.MIN_VALUE)) && this.$less$eq(BigInt$.MODULE$.int2bigInt(Integer.MAX_VALUE));
    }

    private boolean isValidLong() {
        return this.$greater$eq(BigInt$.MODULE$.long2bigInt(Long.MIN_VALUE)) && this.$less$eq(BigInt$.MODULE$.long2bigInt(Long.MAX_VALUE));
    }

    private boolean bitLengthOverflow() {
        BigInteger bigInteger = this.bigInteger.shiftRight(Integer.MAX_VALUE);
        return bigInteger.signum() != 0 && !bigInteger.equals(BigInt$.MODULE$.scala$math$BigInt$$minusOne());
    }

    public final boolean equals(BigInt bigInt) {
        return this.compare(bigInt) == 0;
    }

    public final int compare(BigInt bigInt) {
        return this.bigInteger.compareTo(bigInt.bigInteger);
    }

    private boolean $less$eq(BigInt bigInt) {
        return this.compare(bigInt) <= 0;
    }

    private boolean $greater$eq(BigInt bigInt) {
        return this.compare(bigInt) >= 0;
    }

    public final BigInt $plus(BigInt bigInt) {
        return new BigInt(this.bigInteger.add(bigInt.bigInteger));
    }

    public final BigInt $minus(BigInt bigInt) {
        return new BigInt(this.bigInteger.subtract(bigInt.bigInteger));
    }

    public final BigInt $times(BigInt bigInt) {
        return new BigInt(this.bigInteger.multiply(bigInt.bigInteger));
    }

    public final BigInt $div(BigInt bigInt) {
        return new BigInt(this.bigInteger.divide(bigInt.bigInteger));
    }

    public final BigInt $percent(BigInt bigInt) {
        return new BigInt(this.bigInteger.remainder(bigInt.bigInteger));
    }

    @Override
    public final byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public final short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public final int intValue() {
        return this.bigInteger.intValue();
    }

    @Override
    public final long longValue() {
        return this.bigInteger.longValue();
    }

    @Override
    public final float floatValue() {
        return this.bigInteger.floatValue();
    }

    @Override
    public final double doubleValue() {
        return this.bigInteger.doubleValue();
    }

    public final String toString() {
        return this.bigInteger.toString();
    }

    public BigInt(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }
}

