/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.util.Message;

public class IvyVariableContainerImpl
implements IvyVariableContainer {
    private Map variables;
    private String envPrefix;

    public IvyVariableContainerImpl() {
        this.variables = new HashMap();
    }

    public IvyVariableContainerImpl(Map map) {
        this.variables = map;
    }

    @Override
    public void setVariable(String string, String string2, boolean bl) {
        if (bl || !this.variables.containsKey(string)) {
            Message.debug("setting '" + string + "' to '" + string2 + "'");
            this.variables.put(string, this.substitute(string2));
            return;
        }
        Message.debug("'" + string + "' already set: discarding '" + string2 + "'");
    }

    @Override
    public void setEnvironmentPrefix(String string) {
        if (string != null && !string.endsWith(".")) {
            this.envPrefix = string + ".";
            return;
        }
        this.envPrefix = string;
    }

    protected String substitute(String string) {
        return IvyPatternHelper.substituteVariables(string, this);
    }

    @Override
    public String getVariable(String string) {
        string = this.envPrefix != null && string.startsWith(this.envPrefix) ? System.getenv(string.substring(this.envPrefix.length())) : (String)this.variables.get(string);
        return string;
    }

    @Override
    public Object clone() {
        IvyVariableContainerImpl ivyVariableContainerImpl;
        try {
            ivyVariableContainerImpl = (IvyVariableContainerImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("unable to clone a " + this.getClass());
        }
        ivyVariableContainerImpl.variables = new HashMap(this.variables);
        return ivyVariableContainerImpl;
    }
}

