/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.Serializable;
import java.util.Arrays;
import xsbti.T2;
import xsbti.compile.CompileOrder;
import xsbti.compile.MiniOptions;
import xsbti.compile.Output;

public final class MiniSetup
implements Serializable {
    private Output output;
    private MiniOptions options;
    private String compilerVersion;
    private CompileOrder order;
    private boolean storeApis;
    private T2<String, String>[] extra;

    public static MiniSetup create(Output _output, MiniOptions _options, String _compilerVersion, CompileOrder _order, boolean _storeApis, T2<String, String>[] _extra) {
        return new MiniSetup(_output, _options, _compilerVersion, _order, _storeApis, _extra);
    }

    public static MiniSetup of(Output _output, MiniOptions _options, String _compilerVersion, CompileOrder _order, boolean _storeApis, T2<String, String>[] _extra) {
        return new MiniSetup(_output, _options, _compilerVersion, _order, _storeApis, _extra);
    }

    protected MiniSetup(Output _output, MiniOptions _options, String _compilerVersion, CompileOrder _order, boolean _storeApis, T2<String, String>[] _extra) {
        this.output = _output;
        this.options = _options;
        this.compilerVersion = _compilerVersion;
        this.order = _order;
        this.storeApis = _storeApis;
        this.extra = _extra;
    }

    public Output output() {
        return this.output;
    }

    public MiniOptions options() {
        return this.options;
    }

    public String compilerVersion() {
        return this.compilerVersion;
    }

    public CompileOrder order() {
        return this.order;
    }

    public boolean storeApis() {
        return this.storeApis;
    }

    public T2<String, String>[] extra() {
        return this.extra;
    }

    public MiniSetup withOutput(Output output) {
        return new MiniSetup(output, this.options, this.compilerVersion, this.order, this.storeApis, this.extra);
    }

    public MiniSetup withOptions(MiniOptions options) {
        return new MiniSetup(this.output, options, this.compilerVersion, this.order, this.storeApis, this.extra);
    }

    public MiniSetup withCompilerVersion(String compilerVersion) {
        return new MiniSetup(this.output, this.options, compilerVersion, this.order, this.storeApis, this.extra);
    }

    public MiniSetup withOrder(CompileOrder order) {
        return new MiniSetup(this.output, this.options, this.compilerVersion, order, this.storeApis, this.extra);
    }

    public MiniSetup withStoreApis(boolean storeApis) {
        return new MiniSetup(this.output, this.options, this.compilerVersion, this.order, storeApis, this.extra);
    }

    public MiniSetup withExtra(T2<String, String>[] extra) {
        return new MiniSetup(this.output, this.options, this.compilerVersion, this.order, this.storeApis, extra);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MiniSetup)) {
            return false;
        }
        MiniSetup o = (MiniSetup)obj;
        return this.output().equals(o.output()) && this.options().equals(o.options()) && this.compilerVersion().equals(o.compilerVersion()) && this.order().equals((Object)o.order()) && this.storeApis() == o.storeApis() && Arrays.deepEquals(this.extra(), o.extra());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + "xsbti.compile.MiniSetup".hashCode()) + this.output().hashCode()) + this.options().hashCode()) + this.compilerVersion().hashCode()) + this.order().hashCode()) + Boolean.hashCode(this.storeApis())) + Arrays.deepHashCode(this.extra()));
    }

    public String toString() {
        return "MiniSetup(output: " + this.output() + ", options: " + this.options() + ", compilerVersion: " + this.compilerVersion() + ", order: " + (Object)((Object)this.order()) + ", storeApis: " + this.storeApis() + ", extra: " + this.extra() + ")";
    }
}

