/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import xsbti.compile.AuxiliaryClassFiles;
import xsbti.compile.ClassFileManagerType;
import xsbti.compile.DefaultExternalHooks;
import xsbti.compile.ExternalHooks;

public final class IncOptions
implements Serializable {
    private int transitiveStep;
    private double recompileAllFraction;
    private boolean relationsDebug;
    private boolean apiDebug;
    private int apiDiffContextSize;
    private Optional<File> apiDumpDirectory;
    private Optional<ClassFileManagerType> classfileManagerType;
    private AuxiliaryClassFiles[] auxiliaryClassFiles;
    private boolean useCustomizedFileManager;
    private Optional<Boolean> recompileOnMacroDef;
    private boolean useOptimizedSealed;
    private boolean storeApis;
    private boolean enabled;
    private Map<String, String> extra;
    private boolean logRecompileOnMacro;
    private ExternalHooks externalHooks;
    private String[] ignoredScalacOptions;
    private boolean strictMode;
    private boolean allowMachinePath;
    private boolean pipelining;

    public static int defaultTransitiveStep() {
        return 3;
    }

    public static double defaultRecompileAllFraction() {
        return 0.5;
    }

    public static boolean defaultRelationsDebug() {
        return false;
    }

    public static boolean defaultApiDebug() {
        return false;
    }

    public static int defaultApiDiffContextSize() {
        return 5;
    }

    public static Optional<File> defaultApiDumpDirectory() {
        return Optional.empty();
    }

    public static Optional<ClassFileManagerType> defaultClassFileManagerType() {
        return Optional.empty();
    }

    public static AuxiliaryClassFiles[] defaultAuxiliaryClassFiles() {
        return new AuxiliaryClassFiles[0];
    }

    public static Optional<Boolean> defaultRecompileOnMacroDef() {
        return Optional.empty();
    }

    public static boolean defaultUseOptimizedSealed() {
        return false;
    }

    public static boolean defaultRecompileOnMacroDefImpl() {
        return true;
    }

    public static boolean getRecompileOnMacroDef(IncOptions options) {
        if (options.recompileOnMacroDef().isPresent()) {
            return options.recompileOnMacroDef().get();
        }
        return IncOptions.defaultRecompileOnMacroDefImpl();
    }

    public static boolean defaultUseCustomizedFileManager() {
        return false;
    }

    public static boolean defaultStoreApis() {
        return true;
    }

    public static boolean defaultEnabled() {
        return true;
    }

    public static Map<String, String> defaultExtra() {
        return new HashMap<String, String>();
    }

    public static ExternalHooks defaultExternal() {
        return new DefaultExternalHooks(Optional.empty(), Optional.empty());
    }

    public static String[] defaultIgnoredScalacOptions() {
        return new String[0];
    }

    public static boolean defaultLogRecompileOnMacro() {
        return true;
    }

    public static boolean defaultStrictMode() {
        return false;
    }

    public static boolean defaultAllowMachinePath() {
        return true;
    }

    public static boolean defaultPipelining() {
        return false;
    }

    public static IncOptions create() {
        return new IncOptions();
    }

    public static IncOptions of() {
        return new IncOptions();
    }

    public static IncOptions create(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks);
    }

    public static IncOptions of(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks);
    }

    public static IncOptions create(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks);
    }

    public static IncOptions of(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks);
    }

    public static IncOptions create(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions);
    }

    public static IncOptions of(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions);
    }

    public static IncOptions create(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions);
    }

    public static IncOptions of(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions);
    }

    public static IncOptions create(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode);
    }

    public static IncOptions of(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode);
    }

    public static IncOptions create(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode);
    }

    public static IncOptions of(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode);
    }

    public static IncOptions create(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode, _allowMachinePath, _pipelining);
    }

    public static IncOptions of(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode, _allowMachinePath, _pipelining);
    }

    public static IncOptions create(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode, _allowMachinePath, _pipelining);
    }

    public static IncOptions of(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode, _allowMachinePath, _pipelining);
    }

    public static IncOptions create(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, AuxiliaryClassFiles[] _auxiliaryClassFiles, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _auxiliaryClassFiles, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode, _allowMachinePath, _pipelining);
    }

    public static IncOptions of(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, AuxiliaryClassFiles[] _auxiliaryClassFiles, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _auxiliaryClassFiles, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode, _allowMachinePath, _pipelining);
    }

    public static IncOptions create(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, AuxiliaryClassFiles[] _auxiliaryClassFiles, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _auxiliaryClassFiles, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode, _allowMachinePath, _pipelining);
    }

    public static IncOptions of(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, AuxiliaryClassFiles[] _auxiliaryClassFiles, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        return new IncOptions(_transitiveStep, _recompileAllFraction, _relationsDebug, _apiDebug, _apiDiffContextSize, _apiDumpDirectory, _classfileManagerType, _auxiliaryClassFiles, _useCustomizedFileManager, _recompileOnMacroDef, _useOptimizedSealed, _storeApis, _enabled, _extra, _logRecompileOnMacro, _externalHooks, _ignoredScalacOptions, _strictMode, _allowMachinePath, _pipelining);
    }

    protected IncOptions() {
        this.transitiveStep = IncOptions.defaultTransitiveStep();
        this.recompileAllFraction = IncOptions.defaultRecompileAllFraction();
        this.relationsDebug = IncOptions.defaultRelationsDebug();
        this.apiDebug = IncOptions.defaultApiDebug();
        this.apiDiffContextSize = IncOptions.defaultApiDiffContextSize();
        this.apiDumpDirectory = IncOptions.defaultApiDumpDirectory();
        this.classfileManagerType = IncOptions.defaultClassFileManagerType();
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = IncOptions.defaultUseCustomizedFileManager();
        this.recompileOnMacroDef = IncOptions.defaultRecompileOnMacroDef();
        this.useOptimizedSealed = IncOptions.defaultUseOptimizedSealed();
        this.storeApis = IncOptions.defaultStoreApis();
        this.enabled = IncOptions.defaultEnabled();
        this.extra = IncOptions.defaultExtra();
        this.logRecompileOnMacro = IncOptions.defaultLogRecompileOnMacro();
        this.externalHooks = IncOptions.defaultExternal();
        this.ignoredScalacOptions = IncOptions.defaultIgnoredScalacOptions();
        this.strictMode = IncOptions.defaultStrictMode();
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks) {
        this.transitiveStep = _transitiveStep;
        this.recompileAllFraction = _recompileAllFraction;
        this.relationsDebug = _relationsDebug;
        this.apiDebug = _apiDebug;
        this.apiDiffContextSize = _apiDiffContextSize;
        this.apiDumpDirectory = _apiDumpDirectory;
        this.classfileManagerType = _classfileManagerType;
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = _useCustomizedFileManager;
        this.recompileOnMacroDef = _recompileOnMacroDef;
        this.useOptimizedSealed = _useOptimizedSealed;
        this.storeApis = _storeApis;
        this.enabled = _enabled;
        this.extra = _extra;
        this.logRecompileOnMacro = _logRecompileOnMacro;
        this.externalHooks = _externalHooks;
        this.ignoredScalacOptions = IncOptions.defaultIgnoredScalacOptions();
        this.strictMode = IncOptions.defaultStrictMode();
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks) {
        this.transitiveStep = _transitiveStep;
        this.recompileAllFraction = _recompileAllFraction;
        this.relationsDebug = _relationsDebug;
        this.apiDebug = _apiDebug;
        this.apiDiffContextSize = _apiDiffContextSize;
        this.apiDumpDirectory = Optional.ofNullable(_apiDumpDirectory);
        this.classfileManagerType = Optional.ofNullable(_classfileManagerType);
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = _useCustomizedFileManager;
        this.recompileOnMacroDef = Optional.ofNullable(_recompileOnMacroDef);
        this.useOptimizedSealed = _useOptimizedSealed;
        this.storeApis = _storeApis;
        this.enabled = _enabled;
        this.extra = _extra;
        this.logRecompileOnMacro = _logRecompileOnMacro;
        this.externalHooks = _externalHooks;
        this.ignoredScalacOptions = IncOptions.defaultIgnoredScalacOptions();
        this.strictMode = IncOptions.defaultStrictMode();
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions) {
        this.transitiveStep = _transitiveStep;
        this.recompileAllFraction = _recompileAllFraction;
        this.relationsDebug = _relationsDebug;
        this.apiDebug = _apiDebug;
        this.apiDiffContextSize = _apiDiffContextSize;
        this.apiDumpDirectory = _apiDumpDirectory;
        this.classfileManagerType = _classfileManagerType;
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = _useCustomizedFileManager;
        this.recompileOnMacroDef = _recompileOnMacroDef;
        this.useOptimizedSealed = _useOptimizedSealed;
        this.storeApis = _storeApis;
        this.enabled = _enabled;
        this.extra = _extra;
        this.logRecompileOnMacro = _logRecompileOnMacro;
        this.externalHooks = _externalHooks;
        this.ignoredScalacOptions = _ignoredScalacOptions;
        this.strictMode = IncOptions.defaultStrictMode();
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions) {
        this.transitiveStep = _transitiveStep;
        this.recompileAllFraction = _recompileAllFraction;
        this.relationsDebug = _relationsDebug;
        this.apiDebug = _apiDebug;
        this.apiDiffContextSize = _apiDiffContextSize;
        this.apiDumpDirectory = Optional.ofNullable(_apiDumpDirectory);
        this.classfileManagerType = Optional.ofNullable(_classfileManagerType);
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = _useCustomizedFileManager;
        this.recompileOnMacroDef = Optional.ofNullable(_recompileOnMacroDef);
        this.useOptimizedSealed = _useOptimizedSealed;
        this.storeApis = _storeApis;
        this.enabled = _enabled;
        this.extra = _extra;
        this.logRecompileOnMacro = _logRecompileOnMacro;
        this.externalHooks = _externalHooks;
        this.ignoredScalacOptions = _ignoredScalacOptions;
        this.strictMode = IncOptions.defaultStrictMode();
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode) {
        this.transitiveStep = _transitiveStep;
        this.recompileAllFraction = _recompileAllFraction;
        this.relationsDebug = _relationsDebug;
        this.apiDebug = _apiDebug;
        this.apiDiffContextSize = _apiDiffContextSize;
        this.apiDumpDirectory = _apiDumpDirectory;
        this.classfileManagerType = _classfileManagerType;
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = _useCustomizedFileManager;
        this.recompileOnMacroDef = _recompileOnMacroDef;
        this.useOptimizedSealed = _useOptimizedSealed;
        this.storeApis = _storeApis;
        this.enabled = _enabled;
        this.extra = _extra;
        this.logRecompileOnMacro = _logRecompileOnMacro;
        this.externalHooks = _externalHooks;
        this.ignoredScalacOptions = _ignoredScalacOptions;
        this.strictMode = _strictMode;
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode) {
        this.transitiveStep = _transitiveStep;
        this.recompileAllFraction = _recompileAllFraction;
        this.relationsDebug = _relationsDebug;
        this.apiDebug = _apiDebug;
        this.apiDiffContextSize = _apiDiffContextSize;
        this.apiDumpDirectory = Optional.ofNullable(_apiDumpDirectory);
        this.classfileManagerType = Optional.ofNullable(_classfileManagerType);
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = _useCustomizedFileManager;
        this.recompileOnMacroDef = Optional.ofNullable(_recompileOnMacroDef);
        this.useOptimizedSealed = _useOptimizedSealed;
        this.storeApis = _storeApis;
        this.enabled = _enabled;
        this.extra = _extra;
        this.logRecompileOnMacro = _logRecompileOnMacro;
        this.externalHooks = _externalHooks;
        this.ignoredScalacOptions = _ignoredScalacOptions;
        this.strictMode = _strictMode;
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        this.transitiveStep = _transitiveStep;
        this.recompileAllFraction = _recompileAllFraction;
        this.relationsDebug = _relationsDebug;
        this.apiDebug = _apiDebug;
        this.apiDiffContextSize = _apiDiffContextSize;
        this.apiDumpDirectory = _apiDumpDirectory;
        this.classfileManagerType = _classfileManagerType;
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = _useCustomizedFileManager;
        this.recompileOnMacroDef = _recompileOnMacroDef;
        this.useOptimizedSealed = _useOptimizedSealed;
        this.storeApis = _storeApis;
        this.enabled = _enabled;
        this.extra = _extra;
        this.logRecompileOnMacro = _logRecompileOnMacro;
        this.externalHooks = _externalHooks;
        this.ignoredScalacOptions = _ignoredScalacOptions;
        this.strictMode = _strictMode;
        this.allowMachinePath = _allowMachinePath;
        this.pipelining = _pipelining;
    }

    protected IncOptions(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        this.transitiveStep = _transitiveStep;
        this.recompileAllFraction = _recompileAllFraction;
        this.relationsDebug = _relationsDebug;
        this.apiDebug = _apiDebug;
        this.apiDiffContextSize = _apiDiffContextSize;
        this.apiDumpDirectory = Optional.ofNullable(_apiDumpDirectory);
        this.classfileManagerType = Optional.ofNullable(_classfileManagerType);
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = _useCustomizedFileManager;
        this.recompileOnMacroDef = Optional.ofNullable(_recompileOnMacroDef);
        this.useOptimizedSealed = _useOptimizedSealed;
        this.storeApis = _storeApis;
        this.enabled = _enabled;
        this.extra = _extra;
        this.logRecompileOnMacro = _logRecompileOnMacro;
        this.externalHooks = _externalHooks;
        this.ignoredScalacOptions = _ignoredScalacOptions;
        this.strictMode = _strictMode;
        this.allowMachinePath = _allowMachinePath;
        this.pipelining = _pipelining;
    }

    protected IncOptions(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, Optional<File> _apiDumpDirectory, Optional<ClassFileManagerType> _classfileManagerType, AuxiliaryClassFiles[] _auxiliaryClassFiles, boolean _useCustomizedFileManager, Optional<Boolean> _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        this.transitiveStep = _transitiveStep;
        this.recompileAllFraction = _recompileAllFraction;
        this.relationsDebug = _relationsDebug;
        this.apiDebug = _apiDebug;
        this.apiDiffContextSize = _apiDiffContextSize;
        this.apiDumpDirectory = _apiDumpDirectory;
        this.classfileManagerType = _classfileManagerType;
        this.auxiliaryClassFiles = _auxiliaryClassFiles;
        this.useCustomizedFileManager = _useCustomizedFileManager;
        this.recompileOnMacroDef = _recompileOnMacroDef;
        this.useOptimizedSealed = _useOptimizedSealed;
        this.storeApis = _storeApis;
        this.enabled = _enabled;
        this.extra = _extra;
        this.logRecompileOnMacro = _logRecompileOnMacro;
        this.externalHooks = _externalHooks;
        this.ignoredScalacOptions = _ignoredScalacOptions;
        this.strictMode = _strictMode;
        this.allowMachinePath = _allowMachinePath;
        this.pipelining = _pipelining;
    }

    protected IncOptions(int _transitiveStep, double _recompileAllFraction, boolean _relationsDebug, boolean _apiDebug, int _apiDiffContextSize, File _apiDumpDirectory, ClassFileManagerType _classfileManagerType, AuxiliaryClassFiles[] _auxiliaryClassFiles, boolean _useCustomizedFileManager, boolean _recompileOnMacroDef, boolean _useOptimizedSealed, boolean _storeApis, boolean _enabled, Map<String, String> _extra, boolean _logRecompileOnMacro, ExternalHooks _externalHooks, String[] _ignoredScalacOptions, boolean _strictMode, boolean _allowMachinePath, boolean _pipelining) {
        this.transitiveStep = _transitiveStep;
        this.recompileAllFraction = _recompileAllFraction;
        this.relationsDebug = _relationsDebug;
        this.apiDebug = _apiDebug;
        this.apiDiffContextSize = _apiDiffContextSize;
        this.apiDumpDirectory = Optional.ofNullable(_apiDumpDirectory);
        this.classfileManagerType = Optional.ofNullable(_classfileManagerType);
        this.auxiliaryClassFiles = _auxiliaryClassFiles;
        this.useCustomizedFileManager = _useCustomizedFileManager;
        this.recompileOnMacroDef = Optional.ofNullable(_recompileOnMacroDef);
        this.useOptimizedSealed = _useOptimizedSealed;
        this.storeApis = _storeApis;
        this.enabled = _enabled;
        this.extra = _extra;
        this.logRecompileOnMacro = _logRecompileOnMacro;
        this.externalHooks = _externalHooks;
        this.ignoredScalacOptions = _ignoredScalacOptions;
        this.strictMode = _strictMode;
        this.allowMachinePath = _allowMachinePath;
        this.pipelining = _pipelining;
    }

    public int transitiveStep() {
        return this.transitiveStep;
    }

    public double recompileAllFraction() {
        return this.recompileAllFraction;
    }

    public boolean relationsDebug() {
        return this.relationsDebug;
    }

    public boolean apiDebug() {
        return this.apiDebug;
    }

    public int apiDiffContextSize() {
        return this.apiDiffContextSize;
    }

    public Optional<File> apiDumpDirectory() {
        return this.apiDumpDirectory;
    }

    public Optional<ClassFileManagerType> classfileManagerType() {
        return this.classfileManagerType;
    }

    public AuxiliaryClassFiles[] auxiliaryClassFiles() {
        return this.auxiliaryClassFiles;
    }

    public boolean useCustomizedFileManager() {
        return this.useCustomizedFileManager;
    }

    public Optional<Boolean> recompileOnMacroDef() {
        return this.recompileOnMacroDef;
    }

    public boolean useOptimizedSealed() {
        return this.useOptimizedSealed;
    }

    public boolean storeApis() {
        return this.storeApis;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, String> extra() {
        return this.extra;
    }

    public boolean logRecompileOnMacro() {
        return this.logRecompileOnMacro;
    }

    public ExternalHooks externalHooks() {
        return this.externalHooks;
    }

    public String[] ignoredScalacOptions() {
        return this.ignoredScalacOptions;
    }

    public boolean strictMode() {
        return this.strictMode;
    }

    public boolean allowMachinePath() {
        return this.allowMachinePath;
    }

    public boolean pipelining() {
        return this.pipelining;
    }

    public IncOptions withTransitiveStep(int transitiveStep) {
        return new IncOptions(transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withRecompileAllFraction(double recompileAllFraction) {
        return new IncOptions(this.transitiveStep, recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withRelationsDebug(boolean relationsDebug) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withApiDebug(boolean apiDebug) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withApiDiffContextSize(int apiDiffContextSize) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withApiDumpDirectory(Optional<File> apiDumpDirectory) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withApiDumpDirectory(File apiDumpDirectory) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, Optional.ofNullable(apiDumpDirectory), this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withClassfileManagerType(Optional<ClassFileManagerType> classfileManagerType) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withClassfileManagerType(ClassFileManagerType classfileManagerType) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, Optional.ofNullable(classfileManagerType), this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withAuxiliaryClassFiles(AuxiliaryClassFiles[] auxiliaryClassFiles) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withUseCustomizedFileManager(boolean useCustomizedFileManager) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withRecompileOnMacroDef(Optional<Boolean> recompileOnMacroDef) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withRecompileOnMacroDef(boolean recompileOnMacroDef) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, Optional.ofNullable(recompileOnMacroDef), this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withUseOptimizedSealed(boolean useOptimizedSealed) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withStoreApis(boolean storeApis) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withEnabled(boolean enabled) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withExtra(Map<String, String> extra) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withLogRecompileOnMacro(boolean logRecompileOnMacro) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withExternalHooks(ExternalHooks externalHooks) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withIgnoredScalacOptions(String[] ignoredScalacOptions) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withStrictMode(boolean strictMode) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withAllowMachinePath(boolean allowMachinePath) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, allowMachinePath, this.pipelining);
    }

    public IncOptions withPipelining(boolean pipelining) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, pipelining);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IncOptions)) {
            return false;
        }
        IncOptions o = (IncOptions)obj;
        return this.transitiveStep() == o.transitiveStep() && this.recompileAllFraction() == o.recompileAllFraction() && this.relationsDebug() == o.relationsDebug() && this.apiDebug() == o.apiDebug() && this.apiDiffContextSize() == o.apiDiffContextSize() && this.apiDumpDirectory().equals(o.apiDumpDirectory()) && this.classfileManagerType().equals(o.classfileManagerType()) && Arrays.deepEquals(this.auxiliaryClassFiles(), o.auxiliaryClassFiles()) && this.useCustomizedFileManager() == o.useCustomizedFileManager() && this.recompileOnMacroDef().equals(o.recompileOnMacroDef()) && this.useOptimizedSealed() == o.useOptimizedSealed() && this.storeApis() == o.storeApis() && this.enabled() == o.enabled() && this.extra().equals(o.extra()) && this.logRecompileOnMacro() == o.logRecompileOnMacro() && this.externalHooks().equals(o.externalHooks()) && Arrays.deepEquals(this.ignoredScalacOptions(), o.ignoredScalacOptions()) && this.strictMode() == o.strictMode() && this.allowMachinePath() == o.allowMachinePath() && this.pipelining() == o.pipelining();
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + "xsbti.compile.IncOptions".hashCode()) + Integer.hashCode(this.transitiveStep())) + Double.hashCode(this.recompileAllFraction())) + Boolean.hashCode(this.relationsDebug())) + Boolean.hashCode(this.apiDebug())) + Integer.hashCode(this.apiDiffContextSize())) + this.apiDumpDirectory().hashCode()) + this.classfileManagerType().hashCode()) + Arrays.deepHashCode(this.auxiliaryClassFiles())) + Boolean.hashCode(this.useCustomizedFileManager())) + this.recompileOnMacroDef().hashCode()) + Boolean.hashCode(this.useOptimizedSealed())) + Boolean.hashCode(this.storeApis())) + Boolean.hashCode(this.enabled())) + this.extra().hashCode()) + Boolean.hashCode(this.logRecompileOnMacro())) + this.externalHooks().hashCode()) + Arrays.deepHashCode(this.ignoredScalacOptions())) + Boolean.hashCode(this.strictMode())) + Boolean.hashCode(this.allowMachinePath())) + Boolean.hashCode(this.pipelining()));
    }

    public String toString() {
        return "IncOptions(transitiveStep: " + this.transitiveStep() + ", recompileAllFraction: " + this.recompileAllFraction() + ", relationsDebug: " + this.relationsDebug() + ", apiDebug: " + this.apiDebug() + ", apiDiffContextSize: " + this.apiDiffContextSize() + ", apiDumpDirectory: " + this.apiDumpDirectory() + ", classfileManagerType: " + this.classfileManagerType() + ", auxiliaryClassFiles: " + this.auxiliaryClassFiles() + ", useCustomizedFileManager: " + this.useCustomizedFileManager() + ", recompileOnMacroDef: " + this.recompileOnMacroDef() + ", useOptimizedSealed: " + this.useOptimizedSealed() + ", storeApis: " + this.storeApis() + ", enabled: " + this.enabled() + ", extra: " + this.extra() + ", logRecompileOnMacro: " + this.logRecompileOnMacro() + ", externalHooks: " + this.externalHooks() + ", ignoredScalacOptions: " + this.ignoredScalacOptions() + ", strictMode: " + this.strictMode() + ", allowMachinePath: " + this.allowMachinePath() + ", pipelining: " + this.pipelining() + ")";
    }
}

