/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.Serializable;
import java.util.Arrays;
import xsbti.compile.FileHash;

public final class MiniOptions
implements Serializable {
    private FileHash[] classpathHash;
    private String[] scalacOptions;
    private String[] javacOptions;

    public static MiniOptions create(FileHash[] _classpathHash, String[] _scalacOptions, String[] _javacOptions) {
        return new MiniOptions(_classpathHash, _scalacOptions, _javacOptions);
    }

    public static MiniOptions of(FileHash[] _classpathHash, String[] _scalacOptions, String[] _javacOptions) {
        return new MiniOptions(_classpathHash, _scalacOptions, _javacOptions);
    }

    protected MiniOptions(FileHash[] _classpathHash, String[] _scalacOptions, String[] _javacOptions) {
        this.classpathHash = _classpathHash;
        this.scalacOptions = _scalacOptions;
        this.javacOptions = _javacOptions;
    }

    public FileHash[] classpathHash() {
        return this.classpathHash;
    }

    public String[] scalacOptions() {
        return this.scalacOptions;
    }

    public String[] javacOptions() {
        return this.javacOptions;
    }

    public MiniOptions withClasspathHash(FileHash[] classpathHash) {
        return new MiniOptions(classpathHash, this.scalacOptions, this.javacOptions);
    }

    public MiniOptions withScalacOptions(String[] scalacOptions) {
        return new MiniOptions(this.classpathHash, scalacOptions, this.javacOptions);
    }

    public MiniOptions withJavacOptions(String[] javacOptions) {
        return new MiniOptions(this.classpathHash, this.scalacOptions, javacOptions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MiniOptions)) {
            return false;
        }
        MiniOptions o = (MiniOptions)obj;
        return Arrays.deepEquals(this.classpathHash(), o.classpathHash()) && Arrays.deepEquals(this.scalacOptions(), o.scalacOptions()) && Arrays.deepEquals(this.javacOptions(), o.javacOptions());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (17 + "xsbti.compile.MiniOptions".hashCode()) + Arrays.deepHashCode(this.classpathHash())) + Arrays.deepHashCode(this.scalacOptions())) + Arrays.deepHashCode(this.javacOptions()));
    }

    public String toString() {
        return "MiniOptions(classpathHash: " + this.classpathHash() + ", scalacOptions: " + this.scalacOptions() + ", javacOptions: " + this.javacOptions() + ")";
    }
}

