/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import xsbti.FileConverter;
import xsbti.Position;
import xsbti.VirtualFile;
import xsbti.compile.CompileOrder;
import xsbti.compile.Output;
import xsbti.compile.analysis.ReadStamps;

public final class CompileOptions
implements Serializable {
    private VirtualFile[] classpath;
    private VirtualFile[] sources;
    private Path classesDirectory;
    private String[] scalacOptions;
    private String[] javacOptions;
    private int maxErrors;
    private Function<Position, Position> sourcePositionMapper;
    private CompileOrder order;
    private Optional<Path> temporaryClassesDirectory;
    private Optional<FileConverter> converter;
    private Optional<ReadStamps> stamper;
    private Optional<Output> earlyOutput;

    public static CompileOptions create() {
        return new CompileOptions();
    }

    public static CompileOptions of() {
        return new CompileOptions();
    }

    public static CompileOptions create(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder) {
        return new CompileOptions(virtualFileArray, virtualFileArray2, path, stringArray, stringArray2, n, function, compileOrder);
    }

    public static CompileOptions of(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder) {
        return new CompileOptions(virtualFileArray, virtualFileArray2, path, stringArray, stringArray2, n, function, compileOrder);
    }

    public static CompileOptions create(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Optional<Path> optional) {
        return new CompileOptions(virtualFileArray, virtualFileArray2, path, stringArray, stringArray2, n, function, compileOrder, optional);
    }

    public static CompileOptions of(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Optional<Path> optional) {
        return new CompileOptions(virtualFileArray, virtualFileArray2, path, stringArray, stringArray2, n, function, compileOrder, optional);
    }

    public static CompileOptions create(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Path path2) {
        return new CompileOptions(virtualFileArray, virtualFileArray2, path, stringArray, stringArray2, n, function, compileOrder, path2);
    }

    public static CompileOptions of(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Path path2) {
        return new CompileOptions(virtualFileArray, virtualFileArray2, path, stringArray, stringArray2, n, function, compileOrder, path2);
    }

    public static CompileOptions create(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Optional<Path> optional, Optional<FileConverter> optional2, Optional<ReadStamps> optional3, Optional<Output> optional4) {
        return new CompileOptions(virtualFileArray, virtualFileArray2, path, stringArray, stringArray2, n, function, compileOrder, optional, optional2, optional3, optional4);
    }

    public static CompileOptions of(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Optional<Path> optional, Optional<FileConverter> optional2, Optional<ReadStamps> optional3, Optional<Output> optional4) {
        return new CompileOptions(virtualFileArray, virtualFileArray2, path, stringArray, stringArray2, n, function, compileOrder, optional, optional2, optional3, optional4);
    }

    public static CompileOptions create(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Path path2, FileConverter fileConverter, ReadStamps readStamps, Output output) {
        return new CompileOptions(virtualFileArray, virtualFileArray2, path, stringArray, stringArray2, n, function, compileOrder, path2, fileConverter, readStamps, output);
    }

    public static CompileOptions of(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Path path2, FileConverter fileConverter, ReadStamps readStamps, Output output) {
        return new CompileOptions(virtualFileArray, virtualFileArray2, path, stringArray, stringArray2, n, function, compileOrder, path2, fileConverter, readStamps, output);
    }

    protected CompileOptions() {
        this.classpath = new VirtualFile[0];
        this.sources = new VirtualFile[0];
        this.classesDirectory = Paths.get("classes", new String[0]);
        this.scalacOptions = new String[0];
        this.javacOptions = new String[0];
        this.maxErrors = 100;
        this.sourcePositionMapper = new Function<Position, Position>(){

            @Override
            public Position apply(Position position) {
                return position;
            }
        };
        this.order = CompileOrder.Mixed;
        this.temporaryClassesDirectory = Optional.empty();
        this.converter = Optional.empty();
        this.stamper = Optional.empty();
        this.earlyOutput = Optional.empty();
    }

    protected CompileOptions(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder) {
        this.classpath = virtualFileArray;
        this.sources = virtualFileArray2;
        this.classesDirectory = path;
        this.scalacOptions = stringArray;
        this.javacOptions = stringArray2;
        this.maxErrors = n;
        this.sourcePositionMapper = function;
        this.order = compileOrder;
        this.temporaryClassesDirectory = Optional.empty();
        this.converter = Optional.empty();
        this.stamper = Optional.empty();
        this.earlyOutput = Optional.empty();
    }

    protected CompileOptions(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Optional<Path> optional) {
        this.classpath = virtualFileArray;
        this.sources = virtualFileArray2;
        this.classesDirectory = path;
        this.scalacOptions = stringArray;
        this.javacOptions = stringArray2;
        this.maxErrors = n;
        this.sourcePositionMapper = function;
        this.order = compileOrder;
        this.temporaryClassesDirectory = optional;
        this.converter = Optional.empty();
        this.stamper = Optional.empty();
        this.earlyOutput = Optional.empty();
    }

    protected CompileOptions(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Path path2) {
        this.classpath = virtualFileArray;
        this.sources = virtualFileArray2;
        this.classesDirectory = path;
        this.scalacOptions = stringArray;
        this.javacOptions = stringArray2;
        this.maxErrors = n;
        this.sourcePositionMapper = function;
        this.order = compileOrder;
        this.temporaryClassesDirectory = Optional.ofNullable(path2);
        this.converter = Optional.empty();
        this.stamper = Optional.empty();
        this.earlyOutput = Optional.empty();
    }

    protected CompileOptions(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Optional<Path> optional, Optional<FileConverter> optional2, Optional<ReadStamps> optional3, Optional<Output> optional4) {
        this.classpath = virtualFileArray;
        this.sources = virtualFileArray2;
        this.classesDirectory = path;
        this.scalacOptions = stringArray;
        this.javacOptions = stringArray2;
        this.maxErrors = n;
        this.sourcePositionMapper = function;
        this.order = compileOrder;
        this.temporaryClassesDirectory = optional;
        this.converter = optional2;
        this.stamper = optional3;
        this.earlyOutput = optional4;
    }

    protected CompileOptions(VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, Path path, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder, Path path2, FileConverter fileConverter, ReadStamps readStamps, Output output) {
        this.classpath = virtualFileArray;
        this.sources = virtualFileArray2;
        this.classesDirectory = path;
        this.scalacOptions = stringArray;
        this.javacOptions = stringArray2;
        this.maxErrors = n;
        this.sourcePositionMapper = function;
        this.order = compileOrder;
        this.temporaryClassesDirectory = Optional.ofNullable(path2);
        this.converter = Optional.ofNullable(fileConverter);
        this.stamper = Optional.ofNullable(readStamps);
        this.earlyOutput = Optional.ofNullable(output);
    }

    public VirtualFile[] classpath() {
        return this.classpath;
    }

    public VirtualFile[] sources() {
        return this.sources;
    }

    public Path classesDirectory() {
        return this.classesDirectory;
    }

    public String[] scalacOptions() {
        return this.scalacOptions;
    }

    public String[] javacOptions() {
        return this.javacOptions;
    }

    public int maxErrors() {
        return this.maxErrors;
    }

    public Function<Position, Position> sourcePositionMapper() {
        return this.sourcePositionMapper;
    }

    public CompileOrder order() {
        return this.order;
    }

    public Optional<Path> temporaryClassesDirectory() {
        return this.temporaryClassesDirectory;
    }

    public Optional<FileConverter> converter() {
        return this.converter;
    }

    public Optional<ReadStamps> stamper() {
        return this.stamper;
    }

    public Optional<Output> earlyOutput() {
        return this.earlyOutput;
    }

    public CompileOptions withClasspath(VirtualFile[] virtualFileArray) {
        return new CompileOptions(virtualFileArray, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withSources(VirtualFile[] virtualFileArray) {
        return new CompileOptions(this.classpath, virtualFileArray, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withClassesDirectory(Path path) {
        return new CompileOptions(this.classpath, this.sources, path, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withScalacOptions(String[] stringArray) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, stringArray, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withJavacOptions(String[] stringArray) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, stringArray, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withMaxErrors(int n) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, n, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withSourcePositionMapper(Function<Position, Position> function) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, function, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withOrder(CompileOrder compileOrder) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, compileOrder, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withTemporaryClassesDirectory(Optional<Path> optional) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, optional, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withTemporaryClassesDirectory(Path path) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, Optional.ofNullable(path), this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withConverter(Optional<FileConverter> optional) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, optional, this.stamper, this.earlyOutput);
    }

    public CompileOptions withConverter(FileConverter fileConverter) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, Optional.ofNullable(fileConverter), this.stamper, this.earlyOutput);
    }

    public CompileOptions withStamper(Optional<ReadStamps> optional) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, optional, this.earlyOutput);
    }

    public CompileOptions withStamper(ReadStamps readStamps) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, Optional.ofNullable(readStamps), this.earlyOutput);
    }

    public CompileOptions withEarlyOutput(Optional<Output> optional) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, optional);
    }

    public CompileOptions withEarlyOutput(Output output) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, Optional.ofNullable(output));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompileOptions)) {
            return false;
        }
        CompileOptions compileOptions = (CompileOptions)object;
        return Arrays.deepEquals(this.classpath(), compileOptions.classpath()) && Arrays.deepEquals(this.sources(), compileOptions.sources()) && this.classesDirectory().equals(compileOptions.classesDirectory()) && Arrays.deepEquals(this.scalacOptions(), compileOptions.scalacOptions()) && Arrays.deepEquals(this.javacOptions(), compileOptions.javacOptions()) && this.maxErrors() == compileOptions.maxErrors() && this.sourcePositionMapper().equals(compileOptions.sourcePositionMapper()) && this.order().equals((Object)compileOptions.order()) && this.temporaryClassesDirectory().equals(compileOptions.temporaryClassesDirectory()) && this.converter().equals(compileOptions.converter()) && this.stamper().equals(compileOptions.stamper()) && this.earlyOutput().equals(compileOptions.earlyOutput());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + "xsbti.compile.CompileOptions".hashCode()) + Arrays.deepHashCode(this.classpath())) + Arrays.deepHashCode(this.sources())) + this.classesDirectory().hashCode()) + Arrays.deepHashCode(this.scalacOptions())) + Arrays.deepHashCode(this.javacOptions())) + Integer.hashCode(this.maxErrors())) + this.sourcePositionMapper().hashCode()) + this.order().hashCode()) + this.temporaryClassesDirectory().hashCode()) + this.converter().hashCode()) + this.stamper().hashCode()) + this.earlyOutput().hashCode());
    }

    public String toString() {
        return "CompileOptions(classpath: " + this.classpath() + ", sources: " + this.sources() + ", classesDirectory: " + this.classesDirectory() + ", scalacOptions: " + this.scalacOptions() + ", javacOptions: " + this.javacOptions() + ", maxErrors: " + this.maxErrors() + ", sourcePositionMapper: " + this.sourcePositionMapper() + ", order: " + (Object)((Object)this.order()) + ", temporaryClassesDirectory: " + this.temporaryClassesDirectory() + ", converter: " + this.converter() + ", stamper: " + this.stamper() + ", earlyOutput: " + this.earlyOutput() + ")";
    }
}

