/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc.tasty.comments;

import dotty.tools.scaladoc.tasty.comments.Query;
import dotty.tools.scaladoc.tasty.comments.Query$Id$;
import dotty.tools.scaladoc.tasty.comments.Query$Qual$;
import dotty.tools.scaladoc.tasty.comments.Query$Qual$Id$;
import dotty.tools.scaladoc.tasty.comments.Query$QualifiedId$;
import dotty.tools.scaladoc.tasty.comments.Query$StrictMemberId$;
import dotty.tools.scaladoc.tasty.comments.QuerySegment;
import scala.Product;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Right;

public class QueryParser {
    private final CharSequence query;
    private int idx;
    private StringBuilder bld;

    public QueryParser(CharSequence query) {
        this.query = query;
        this.idx = 0;
        this.bld = new StringBuilder();
    }

    public CharSequence query() {
        return this.query;
    }

    public Either<QueryParseException, Query> tryReadQuery() {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)this.readQuery());
        }
        catch (QueryParseException ex) {
            right = package$.MODULE$.Left().apply((Object)ex);
        }
        return right;
    }

    public Query readQuery() {
        this.assertBounds("expected start of query");
        if (this.lookingAt('#')) {
            this.popCh();
            String res = this.readIdentifier().asString();
            return Query$StrictMemberId$.MODULE$.apply(res);
        }
        return this.readSegmentedQuery();
    }

    public QuerySegment readSegmentedQuery() {
        Product product;
        Query.Qual id = this.readIdentifier();
        if (this.atEnd() || this.lookingAt('(') || this.lookingAt('[')) {
            product = Query$Id$.MODULE$.apply(id.asString());
        } else {
            char ch = this.popCh();
            if (ch == '.' || ch == '#') {
                product = Query$QualifiedId$.MODULE$.apply(id, ch, this.readSegmentedQuery());
            } else {
                throw this.err("expected . or #, instead saw: '" + ch + "'");
            }
        }
        return product;
    }

    public Query.Qual readIdentifier() {
        this.assertBounds("expected start of identifier");
        if (this.lookingAt('`')) {
            this.popCh();
            return this.readQuotedIdentifier();
        }
        return this.readSimpleIdentifier();
    }

    public Query.Qual readSimpleIdentifier() {
        while (!this.atEndOfId$1()) {
            this.pull();
        }
        String res = this.popRes();
        if (res.isEmpty()) {
            throw this.err("empty identifier");
        }
        String string = res;
        if ("this".equals(string)) {
            return Query$Qual$.This;
        }
        if ("package".equals(string)) {
            return Query$Qual$.Package;
        }
        String res2 = string;
        return Query$Qual$Id$.MODULE$.apply(res2);
    }

    public Query.Qual readQuotedIdentifier() {
        while (true) {
            this.assertBounds("unexpected end of quoted identifier (expected '`')");
            if (this.lookingAt('`')) break;
            this.pull();
        }
        this.popCh();
        String res = this.popRes();
        if (res.isEmpty()) {
            throw this.err("empty quoted identifier");
        }
        return Query$Qual$Id$.MODULE$.apply(res);
    }

    private char popCh() {
        char res = this.query().charAt(this.idx);
        ++this.idx;
        return res;
    }

    private String popRes() {
        String res = this.bld.toString();
        this.bld = new StringBuilder();
        return res;
    }

    private void pull() {
        this.bld.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)this.query().charAt(this.idx)));
        ++this.idx;
    }

    private boolean lookingAt(char c) {
        return this.query().charAt(this.idx) == c;
    }

    private boolean atEnd() {
        return this.idx >= this.query().length();
    }

    private void assertBounds(String context) {
        if (this.idx >= this.query().length()) {
            throw this.err(context);
        }
    }

    private Nothing$ err(String problem) {
        throw new QueryParseException(this, this.query(), this.idx, problem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean atEndOfId$1() {
        boolean escaped = false;
        if (this.atEnd()) return true;
        if (this.lookingAt('\\')) {
            this.popCh();
            escaped = true;
            if (this.atEnd()) return true;
        }
        if (this.lookingAt('`')) {
            throw this.err("backquotes are not allowed in identifiers");
        }
        if (!escaped) {
            if (this.lookingAt('#')) return true;
            if (this.lookingAt('.')) return true;
            if (this.lookingAt('(')) return true;
            if (!this.lookingAt('[')) return false;
            return true;
        }
        if (false) return true;
        return false;
    }

    public class QueryParseException
    extends Exception {
        private final CharSequence query;
        private final int at;
        private final String problem;
        private final /* synthetic */ QueryParser $outer;

        public QueryParseException(QueryParser $outer, CharSequence query, int at, String problem) {
            this.query = query;
            this.at = at;
            this.problem = problem;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(problem + " at char " + at + " in query: " + query);
        }

        public CharSequence query() {
            return this.query;
        }

        public int at() {
            return this.at;
        }

        public String problem() {
            return this.problem;
        }

        public final /* synthetic */ QueryParser dotty$tools$scaladoc$tasty$comments$QueryParser$QueryParseException$$$outer() {
            return this.$outer;
        }
    }
}

