/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc.renderers;

import com.vladsch.flexmark.util.ast.Node;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.scaladoc.DRI;
import dotty.tools.scaladoc.DocContext;
import dotty.tools.scaladoc.DocContext$package$;
import dotty.tools.scaladoc.DocLink;
import dotty.tools.scaladoc.DocLink$ToDRI$;
import dotty.tools.scaladoc.DocLink$ToURL$;
import dotty.tools.scaladoc.DocLink$UnresolvedDRI$;
import dotty.tools.scaladoc.renderers.SignatureRenderer;
import dotty.tools.scaladoc.tasty.comments.markdown.DocFlexmarkRenderer$;
import dotty.tools.scaladoc.tasty.comments.wiki.Block;
import dotty.tools.scaladoc.tasty.comments.wiki.Bold;
import dotty.tools.scaladoc.tasty.comments.wiki.Bold$;
import dotty.tools.scaladoc.tasty.comments.wiki.Chain;
import dotty.tools.scaladoc.tasty.comments.wiki.Chain$;
import dotty.tools.scaladoc.tasty.comments.wiki.Code;
import dotty.tools.scaladoc.tasty.comments.wiki.Code$;
import dotty.tools.scaladoc.tasty.comments.wiki.DefinitionList;
import dotty.tools.scaladoc.tasty.comments.wiki.DefinitionList$;
import dotty.tools.scaladoc.tasty.comments.wiki.HorizontalRule$;
import dotty.tools.scaladoc.tasty.comments.wiki.HtmlTag;
import dotty.tools.scaladoc.tasty.comments.wiki.HtmlTag$;
import dotty.tools.scaladoc.tasty.comments.wiki.Inline;
import dotty.tools.scaladoc.tasty.comments.wiki.Italic;
import dotty.tools.scaladoc.tasty.comments.wiki.Italic$;
import dotty.tools.scaladoc.tasty.comments.wiki.Link;
import dotty.tools.scaladoc.tasty.comments.wiki.Link$;
import dotty.tools.scaladoc.tasty.comments.wiki.Monospace;
import dotty.tools.scaladoc.tasty.comments.wiki.Monospace$;
import dotty.tools.scaladoc.tasty.comments.wiki.OrderedList;
import dotty.tools.scaladoc.tasty.comments.wiki.OrderedList$;
import dotty.tools.scaladoc.tasty.comments.wiki.Paragraph;
import dotty.tools.scaladoc.tasty.comments.wiki.Paragraph$;
import dotty.tools.scaladoc.tasty.comments.wiki.RepresentationLink;
import dotty.tools.scaladoc.tasty.comments.wiki.Subscript;
import dotty.tools.scaladoc.tasty.comments.wiki.Subscript$;
import dotty.tools.scaladoc.tasty.comments.wiki.Summary;
import dotty.tools.scaladoc.tasty.comments.wiki.Summary$;
import dotty.tools.scaladoc.tasty.comments.wiki.Superscript;
import dotty.tools.scaladoc.tasty.comments.wiki.Superscript$;
import dotty.tools.scaladoc.tasty.comments.wiki.Text;
import dotty.tools.scaladoc.tasty.comments.wiki.Text$;
import dotty.tools.scaladoc.tasty.comments.wiki.Title;
import dotty.tools.scaladoc.tasty.comments.wiki.Title$;
import dotty.tools.scaladoc.tasty.comments.wiki.Underline;
import dotty.tools.scaladoc.tasty.comments.wiki.Underline$;
import dotty.tools.scaladoc.tasty.comments.wiki.UnorderedList;
import dotty.tools.scaladoc.tasty.comments.wiki.UnorderedList$;
import dotty.tools.scaladoc.tasty.comments.wiki.WikiDocElement;
import dotty.tools.scaladoc.util.HTML$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.SortedMap;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class DocRender {
    private final SignatureRenderer signatureRenderer;
    private final DocContext x$2;

    public DocRender(SignatureRenderer signatureRenderer, DocContext x$2) {
        this.signatureRenderer = signatureRenderer;
        this.x$2 = x$2;
    }

    public StringBuilder renderDocPart(Object doc) {
        StringBuilder stringBuilder;
        Object object = doc;
        if (object instanceof Node) {
            Node md = (Node)object;
            stringBuilder = this.renderMarkdown(md);
        } else {
            Object object2;
            SeqOps seqOps;
            Nil$ nil$ = package$.MODULE$.Nil();
            Object object3 = object;
            if (!(nil$ != null ? !nil$.equals(object3) : object3 != null)) {
                stringBuilder = HTML$.MODULE$.raw("");
            } else if (object instanceof Seq && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)((Seq)object)), 1) == 0 && (object2 = SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) instanceof WikiDocElement) {
                WikiDocElement elem = (WikiDocElement)object2;
                stringBuilder = this.renderElement(elem);
            } else if (object instanceof Seq) {
                Seq list = (Seq)object;
                stringBuilder = HTML$.MODULE$.div().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{list.map((Function1 & Serializable)e -> this.renderElement((WikiDocElement)e))}));
            } else {
                throw new MatchError(object);
            }
        }
        return stringBuilder;
    }

    private StringBuilder renderMarkdown(Node el) {
        return HTML$.MODULE$.raw(DocFlexmarkRenderer$.MODULE$.render(el, (Function2<DocLink, String, String>)(Function2 & Serializable)(link, name) -> this.renderLink((DocLink)link, (Function1<String, Object>)(Function1 & Serializable)string -> HTML$.MODULE$.text(name.isEmpty() ? string : name)).toString()));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Seq<StringBuilder> listItems(Seq<WikiDocElement> items) {
        Nil$ nil$;
        Seq<WikiDocElement> seq = items;
        Nil$ nil$2 = package$.MODULE$.Nil();
        Seq<WikiDocElement> seq2 = seq;
        if (!(nil$2 != null ? !nil$2.equals(seq2) : seq2 != null)) {
            nil$ = package$.MODULE$.Nil();
            return nil$;
        }
        if (!(seq instanceof .colon.colon)) throw new MatchError(seq);
        .colon.colon colon2 = (.colon.colon)seq;
        WikiDocElement wikiDocElement = (WikiDocElement)colon2.head();
        List list = colon2.next$access$1();
        WikiDocElement x = wikiDocElement;
        if (list instanceof .colon.colon) {
            .colon.colon colon3 = (.colon.colon)list;
            WikiDocElement wikiDocElement2 = (WikiDocElement)colon3.head();
            List list2 = colon3.next$access$1();
            if (wikiDocElement2 instanceof UnorderedList || wikiDocElement2 instanceof OrderedList) {
                Serializable y = (Serializable)((Object)wikiDocElement2);
                List tail = list2;
                StringBuilder stringBuilder = HTML$.MODULE$.li().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderElement(x), this.renderElement((WikiDocElement)((Object)y))}));
                nil$ = (Seq)this.listItems((Seq<WikiDocElement>)tail).$plus$colon((Object)stringBuilder);
                return nil$;
            }
        }
        WikiDocElement x2 = wikiDocElement;
        List tail = list;
        StringBuilder stringBuilder = HTML$.MODULE$.li().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderElement(x2)}));
        nil$ = (Seq)this.listItems((Seq<WikiDocElement>)tail).$plus$colon((Object)stringBuilder);
        return nil$;
    }

    private StringBuilder notSupported(String name, StringBuilder content) {
        DocContext$package$.MODULE$.report().warning(Message$.MODULE$.toNoExplanation(() -> this.notSupported$$anonfun$1(name)), DocContext$package$.MODULE$.report().warning$default$2(), DocContext$package$.MODULE$.compilerContext(this.x$2));
        return content;
    }

    /*
     * Enabled aggressive block sorting
     */
    private StringBuilder renderLink(DocLink target, Function1<String, Object> linkBody) {
        StringBuilder stringBuilder;
        DocLink docLink = target;
        if (docLink instanceof DocLink.ToDRI) {
            DocLink.ToDRI toDRI = DocLink$ToDRI$.MODULE$.unapply((DocLink.ToDRI)docLink);
            DRI dRI = toDRI._1();
            String string = toDRI._2();
            if (dRI != null) {
                DRI dri = dRI;
                if (string != null) {
                    String name = string;
                    stringBuilder = this.signatureRenderer.renderLinkContent(linkBody.apply((Object)name), dri, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
                    return stringBuilder;
                }
            }
        }
        if (docLink instanceof DocLink.ToURL) {
            String string;
            DocLink.ToURL toURL = DocLink$ToURL$.MODULE$.unapply((DocLink.ToURL)docLink);
            String url = string = toURL._1();
            stringBuilder = HTML$.MODULE$.a().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.href().$colon$eq(url)}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{linkBody.apply((Object)url)}));
            return stringBuilder;
        }
        if (!(docLink instanceof DocLink.UnresolvedDRI)) throw new MatchError((Object)docLink);
        DocLink.UnresolvedDRI unresolvedDRI = DocLink$UnresolvedDRI$.MODULE$.unapply((DocLink.UnresolvedDRI)docLink);
        String string = unresolvedDRI._1();
        String string2 = unresolvedDRI._2();
        String query = string;
        String msg = string2;
        String tooltip = new java.lang.StringBuilder(18).append("Problem linking ").append(query).append(": ").append(msg).toString();
        stringBuilder = this.signatureRenderer.unresolvedLink(linkBody.apply((Object)query), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HTML$.MODULE$.titleAttr().$colon$eq(tooltip)}));
        return stringBuilder;
    }

    private StringBuilder renderElement(WikiDocElement e2) {
        StringBuilder stringBuilder;
        block30: {
            WikiDocElement wikiDocElement;
            DocRender docRender = this;
            WikiDocElement wikiDocElement2 = e2;
            while (true) {
                Inline inline;
                Chain chain;
                Seq<Inline> seq;
                Code code;
                String string2;
                if ((wikiDocElement = wikiDocElement2) instanceof Title) {
                    Title title = Title$.MODULE$.unapply((Title)wikiDocElement);
                    Inline inline2 = title._1();
                    int n = title._2();
                    Inline text = inline2;
                    int level = n;
                    StringBuilder content = docRender.renderElement(text);
                    int n2 = level;
                    switch (n2) {
                        case 1: {
                            stringBuilder = HTML$.MODULE$.h1().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                            break;
                        }
                        case 2: {
                            stringBuilder = HTML$.MODULE$.h2().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                            break;
                        }
                        case 3: {
                            stringBuilder = HTML$.MODULE$.h3().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                            break;
                        }
                        case 4: {
                            stringBuilder = HTML$.MODULE$.h4().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                            break;
                        }
                        case 5: {
                            stringBuilder = HTML$.MODULE$.h5().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                            break;
                        }
                        case 6: {
                            stringBuilder = HTML$.MODULE$.h6().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                            break;
                        }
                        default: {
                            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
                        }
                    }
                    break block30;
                }
                if (wikiDocElement instanceof Paragraph) {
                    Inline inline3;
                    Paragraph paragraph = Paragraph$.MODULE$.unapply((Paragraph)wikiDocElement);
                    Inline text = inline3 = paragraph._1();
                    stringBuilder = HTML$.MODULE$.p().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{docRender.renderElement(text)}));
                    break block30;
                }
                if (wikiDocElement instanceof Code && (string2 = (code = Code$.MODULE$.unapply((Code)wikiDocElement))._1()) != null) {
                    String data = string2;
                    stringBuilder = HTML$.MODULE$.pre().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.code().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.raw(HTML$.MODULE$.escapeReservedTokens(data))}))}));
                    break block30;
                }
                if (HorizontalRule$.MODULE$.equals(wikiDocElement)) {
                    stringBuilder = HTML$.MODULE$.hr();
                    break block30;
                }
                if (wikiDocElement instanceof UnorderedList) {
                    Seq<Block> seq2;
                    UnorderedList unorderedList = UnorderedList$.MODULE$.unapply((UnorderedList)wikiDocElement);
                    Seq<Block> items = seq2 = unorderedList._1();
                    stringBuilder = HTML$.MODULE$.ul().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{docRender.listItems(items)}));
                    break block30;
                }
                if (wikiDocElement instanceof OrderedList) {
                    OrderedList orderedList = OrderedList$.MODULE$.unapply((OrderedList)wikiDocElement);
                    Seq<Block> seq3 = orderedList._1();
                    String string3 = orderedList._2();
                    Seq<Block> items = seq3;
                    String style = string3;
                    stringBuilder = HTML$.MODULE$.ol().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{docRender.listItems(items)}));
                    break block30;
                }
                if (wikiDocElement instanceof Chain && (seq = (chain = Chain$.MODULE$.unapply((Chain)wikiDocElement))._1()) instanceof Seq) {
                    Seq<Inline> items = seq;
                    stringBuilder = HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{items.map((Function1 & Serializable)e -> docRender.renderElement((WikiDocElement)e))}));
                    break block30;
                }
                if (wikiDocElement instanceof Italic) {
                    Inline inline4;
                    Italic italic = Italic$.MODULE$.unapply((Italic)wikiDocElement);
                    Inline text = inline4 = italic._1();
                    stringBuilder = HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("italic")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{docRender.renderElement(text)}));
                    break block30;
                }
                if (wikiDocElement instanceof Underline) {
                    Inline inline5;
                    Underline underline = Underline$.MODULE$.unapply((Underline)wikiDocElement);
                    Inline text = inline5 = underline._1();
                    stringBuilder = HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("underline")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{docRender.renderElement(text)}));
                    break block30;
                }
                if (wikiDocElement instanceof Bold) {
                    Inline inline6;
                    Bold bold = Bold$.MODULE$.unapply((Bold)wikiDocElement);
                    Inline text = inline6 = bold._1();
                    stringBuilder = HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("bold")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{docRender.renderElement(text)}));
                    break block30;
                }
                if (wikiDocElement instanceof Monospace) {
                    Inline inline7;
                    Monospace monospace = Monospace$.MODULE$.unapply((Monospace)wikiDocElement);
                    Inline text = inline7 = monospace._1();
                    stringBuilder = HTML$.MODULE$.code().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{docRender.renderElement(text)}));
                    break block30;
                }
                if (wikiDocElement instanceof Superscript) {
                    Inline inline8;
                    Superscript superscript = Superscript$.MODULE$.unapply((Superscript)wikiDocElement);
                    Inline text = inline8 = superscript._1();
                    stringBuilder = HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("superscript")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{docRender.renderElement(text)}));
                    break block30;
                }
                if (wikiDocElement instanceof Subscript) {
                    Inline inline9;
                    Subscript subscript = Subscript$.MODULE$.unapply((Subscript)wikiDocElement);
                    Inline text = inline9 = subscript._1();
                    stringBuilder = HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("subscript")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{docRender.renderElement(text)}));
                    break block30;
                }
                if (wikiDocElement instanceof Link) {
                    Link link = Link$.MODULE$.unapply((Link)wikiDocElement);
                    DocLink docLink = link._1();
                    Option<Inline> option = link._2();
                    DocLink target = docLink;
                    Option<Inline> body = option;
                    stringBuilder = docRender.renderLink(target, (Function1<String, Object>)(Function1 & Serializable)string -> body.fold(() -> DocRender.renderElement$$anonfun$3$$anonfun$1(string), (Function1 & Serializable)e -> docRender.renderElement((WikiDocElement)e)));
                    break block30;
                }
                if (wikiDocElement instanceof Text) {
                    String string4;
                    Text text = Text$.MODULE$.unapply((Text)wikiDocElement);
                    String text2 = string4 = text._1();
                    stringBuilder = HTML$.MODULE$.raw(text2);
                    break block30;
                }
                if (!(wikiDocElement instanceof Summary)) break;
                Summary summary = Summary$.MODULE$.unapply((Summary)wikiDocElement);
                Inline text = inline = summary._1();
                DocRender docRender2 = docRender;
                Inline inline10 = text;
                docRender = docRender2;
                wikiDocElement2 = inline10;
            }
            if (wikiDocElement instanceof HtmlTag) {
                String string5;
                HtmlTag htmlTag = HtmlTag$.MODULE$.unapply((HtmlTag)wikiDocElement);
                String content = string5 = htmlTag._1();
                stringBuilder = HTML$.MODULE$.raw(content);
            } else if (wikiDocElement instanceof DefinitionList) {
                SortedMap<Inline, Block> sortedMap;
                DefinitionList definitionList = DefinitionList$.MODULE$.unapply((DefinitionList)wikiDocElement);
                SortedMap<Inline, Block> items = sortedMap = definitionList._1();
                stringBuilder = docRender.notSupported("DefinitionList", HTML$.MODULE$.raw(""));
            } else if (wikiDocElement instanceof RepresentationLink) {
                RepresentationLink link = (RepresentationLink)wikiDocElement;
                stringBuilder = docRender.notSupported("Subscript", docRender.renderElement(link.title()));
            } else {
                throw new MatchError((Object)wikiDocElement);
            }
        }
        return stringBuilder;
    }

    private final String notSupported$$anonfun$1(String name$2) {
        return new java.lang.StringBuilder(33).append("Wiki syntax does not support ").append(name$2).append(" in ").append(this.signatureRenderer.currentDri().location()).toString();
    }

    private static final String renderElement$$anonfun$3$$anonfun$1(String default$1) {
        return default$1;
    }
}

