/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc.tasty.comments;

import dotty.tools.scaladoc.tasty.comments.Query;
import dotty.tools.scaladoc.tasty.comments.Query$Id$;
import dotty.tools.scaladoc.tasty.comments.Query$Qual$;
import dotty.tools.scaladoc.tasty.comments.Query$Qual$Id$;
import dotty.tools.scaladoc.tasty.comments.Query$QualifiedId$;
import dotty.tools.scaladoc.tasty.comments.Query$StrictMemberId$;
import dotty.tools.scaladoc.tasty.comments.QuerySegment;
import scala.Product;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Right;

public class QueryParser {
    private final CharSequence query;
    private int idx;
    private StringBuilder bld;

    public QueryParser(CharSequence query) {
        this.query = query;
        this.idx = 0;
        this.bld = new StringBuilder();
    }

    public CharSequence query() {
        return this.query;
    }

    public Either<QueryParseException, Query> tryReadQuery() {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)this.readQuery());
        }
        catch (QueryParseException ex) {
            right = package$.MODULE$.Left().apply((Object)ex);
        }
        return right;
    }

    public Query readQuery() {
        Query query;
        this.assertBounds("expected start of query");
        if (this.lookingAt('#')) {
            this.popCh();
            String res = this.readIdentifier().asString();
            query = Query$StrictMemberId$.MODULE$.apply(res);
        } else {
            query = this.readSegmentedQuery();
        }
        return query;
    }

    public QuerySegment readSegmentedQuery() {
        Product product;
        Query.Qual id = this.readIdentifier();
        if (this.atEnd() || this.lookingAt('(') || this.lookingAt('[')) {
            product = Query$Id$.MODULE$.apply(id.asString());
        } else {
            char ch = this.popCh();
            if (ch == '.' || ch == '#') {
                product = Query$QualifiedId$.MODULE$.apply(id, ch, this.readSegmentedQuery());
            } else {
                throw this.err(new java.lang.StringBuilder(32).append("expected . or #, instead saw: '").append(ch).append("'").toString());
            }
        }
        return product;
    }

    public Query.Qual readIdentifier() {
        Query.Qual qual;
        this.assertBounds("expected start of identifier");
        if (this.lookingAt('`')) {
            this.popCh();
            qual = this.readQuotedIdentifier();
        } else {
            qual = this.readSimpleIdentifier();
        }
        return qual;
    }

    public Query.Qual readSimpleIdentifier() {
        Query.Qual qual;
        while (!this.atEndOfId$1()) {
            this.pull();
        }
        String res = this.popRes();
        if (res.isEmpty()) {
            throw this.err("empty identifier");
        }
        String string = res;
        if ("this".equals(string)) {
            qual = Query$Qual$.This;
        } else if ("package".equals(string)) {
            qual = Query$Qual$.Package;
        } else {
            String res2 = string;
            qual = Query$Qual$Id$.MODULE$.apply(res2);
        }
        return qual;
    }

    public Query.Qual readQuotedIdentifier() {
        while (true) {
            this.assertBounds("unexpected end of quoted identifier (expected '`')");
            if (!(!this.lookingAt('`'))) break;
            this.pull();
        }
        this.popCh();
        String res = this.popRes();
        if (res.isEmpty()) {
            throw this.err("empty quoted identifier");
        }
        return Query$Qual$Id$.MODULE$.apply(res);
    }

    /*
     * WARNING - void declaration
     */
    private char popCh() {
        void var1_1;
        char res = this.query().charAt(this.idx);
        ++this.idx;
        return (char)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String popRes() {
        void var1_1;
        String res = this.bld.toString();
        this.bld = new StringBuilder();
        return var1_1;
    }

    private void pull() {
        this.bld.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)this.query().charAt(this.idx)));
        ++this.idx;
    }

    private boolean lookingAt(char c) {
        return this.query().charAt(this.idx) == c;
    }

    private boolean atEnd() {
        return this.idx >= this.query().length();
    }

    private void assertBounds(String context) {
        if (this.idx >= this.query().length()) {
            throw this.err(context);
        }
    }

    private Nothing$ err(String problem) {
        throw new QueryParseException(this, this.query(), this.idx, problem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean atEndOfId$1() {
        boolean escaped = false;
        if (this.atEnd()) return true;
        if (this.lookingAt('\\')) {
            this.popCh();
            escaped = true;
            if (this.atEnd()) {
                return true;
            }
        }
        boolean bl = false;
        if (bl) return true;
        if (this.lookingAt('`')) {
            throw this.err("backquotes are not allowed in identifiers");
        }
        if (escaped) {
            return false;
        }
        if (this.lookingAt('#')) return true;
        if (this.lookingAt('.')) return true;
        if (this.lookingAt('(')) return true;
        if (!this.lookingAt('[')) return false;
        return true;
    }

    public class QueryParseException
    extends Exception {
        private final CharSequence query;
        private final int at;
        private final String problem;
        private final QueryParser $outer;

        public QueryParseException(QueryParser $outer, CharSequence query, int at, String problem) {
            this.query = query;
            this.at = at;
            this.problem = problem;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(new java.lang.StringBuilder(20).append(problem).append(" at char ").append(at).append(" in query: ").append(query).toString());
        }

        public CharSequence query() {
            return this.query;
        }

        public int at() {
            return this.at;
        }

        public String problem() {
            return this.problem;
        }

        public final QueryParser dotty$tools$scaladoc$tasty$comments$QueryParser$QueryParseException$$$outer() {
            return this.$outer;
        }
    }
}

