/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc.tasty.comments.markdown;

import dotty.tools.scaladoc.snippets.MessageLevel;
import dotty.tools.scaladoc.snippets.MessageLevel$;
import dotty.tools.scaladoc.snippets.Position;
import dotty.tools.scaladoc.snippets.SnippetCompilerMessage;
import dotty.tools.scaladoc.tasty.comments.markdown.SnippetLine;
import dotty.tools.scaladoc.tasty.comments.markdown.SnippetLine$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;

public final class SnippetRenderer$
implements Serializable {
    public static final SnippetRenderer$ MODULE$ = new SnippetRenderer$();

    private SnippetRenderer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SnippetRenderer$.class);
    }

    private String compileMessageCSSClass(SnippetCompilerMessage msg) {
        String string;
        MessageLevel messageLevel = msg.level();
        MessageLevel messageLevel2 = MessageLevel$.Info;
        MessageLevel messageLevel3 = messageLevel;
        if (!(messageLevel2 != null ? !messageLevel2.equals(messageLevel3) : messageLevel3 != null)) {
            string = "snippet-info";
        } else {
            MessageLevel messageLevel4 = MessageLevel$.Warning;
            MessageLevel messageLevel5 = messageLevel;
            if (!(messageLevel4 != null ? !messageLevel4.equals(messageLevel5) : messageLevel5 != null)) {
                string = "snippet-warn";
            } else {
                MessageLevel messageLevel6 = MessageLevel$.Error;
                MessageLevel messageLevel7 = messageLevel;
                if (!(messageLevel6 != null ? !messageLevel6.equals(messageLevel7) : messageLevel7 != null)) {
                    string = "snippet-error";
                } else {
                    MessageLevel messageLevel8 = MessageLevel$.Debug;
                    MessageLevel messageLevel9 = messageLevel;
                    if (!(messageLevel8 != null ? !messageLevel8.equals(messageLevel9) : messageLevel9 != null)) {
                        string = "snippet-debug";
                    } else {
                        throw new MatchError((Object)messageLevel);
                    }
                }
            }
        }
        return string;
    }

    private <A> Option<A> cutBetweenSymbols(String startSymbol, String endSymbol, Seq<SnippetLine> snippetLines, Function3<Seq<SnippetLine>, Seq<SnippetLine>, Seq<SnippetLine>, A> f) {
        return ((IterableOnceOps)snippetLines.zipWithIndex()).find((Function1 & Serializable)_$1 -> ((SnippetLine)_$1._1()).content().contains(startSymbol)).map((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToInt((Object)_$2._2())).flatMap((Function1 & Serializable)startIdx -> this.cutBetweenSymbols$$anonfun$8(endSymbol, snippetLines, f, BoxesRunTime.unboxToInt((Object)startIdx)));
    }

    private Seq<SnippetLine> wrapHiddenSymbols(Seq<SnippetLine> snippetLines) {
        Option mRes = this.cutBetweenSymbols("//{", "//}", snippetLines, (Function3 & Serializable)(x$1, x$2, x$3) -> {
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$1, x$2, x$3);
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Seq begin = (Seq)tuple3._1();
            Seq mid = (Seq)tuple3._2();
            Seq end = (Seq)tuple3._3();
            return (Seq)((IterableOps)begin.$plus$plus((IterableOnce)((IterableOps)((IterableOps)mid.drop(1)).dropRight(1)).map((Function1 & Serializable)_$5 -> _$5.withClass("hideable")))).$plus$plus(this.wrapHiddenSymbols((Seq<SnippetLine>)end));
        });
        return (Seq)mRes.getOrElse(() -> this.wrapHiddenSymbols$$anonfun$1(snippetLines));
    }

    /*
     * Enabled aggressive block sorting
     */
    private SnippetLine wrapLineInBetween(Option<String> startSymbol, Option<String> endSymbol, SnippetLine line) {
        SnippetLine snippetLine;
        Option endIdx;
        Option startIdx = startSymbol.map((Function1 & Serializable)s -> line.content().indexOf((String)s));
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)startIdx, (Object)(endIdx = endSymbol.map((Function1 & Serializable)s -> line.content().indexOf((String)s))));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                int idx = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (None$.MODULE$.equals(option2)) {
                    String comment;
                    Tuple2 tuple22 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(line.content()), idx);
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    String code = (String)tuple22._1();
                    String comment2 = (String)tuple22._2();
                    Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)code, (Object)comment2);
                    String code2 = (String)tuple23._1();
                    String string = comment = (String)tuple23._2();
                    if (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(code2), (Function1 & Serializable)_$6 -> this.wrapLineInBetween$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$6)))) {
                        snippetLine = line.withClass("hideable");
                        return snippetLine;
                    }
                    if (StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(comment)) == '\n') {
                        snippetLine = line.copy(code2 + ("<span class=\"hideable\">" + StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(comment), 1) + "</span>" + "\n"), line.copy$default$2(), line.copy$default$3(), line.copy$default$4());
                        return snippetLine;
                    }
                    snippetLine = line.copy(code2 + ("<span class=\"hideable\">" + comment + "</span>"), line.copy$default$2(), line.copy$default$3(), line.copy$default$4());
                    return snippetLine;
                }
            }
            if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                int idx = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                Tuple2 tuple24 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(line.content()), idx + StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString((String)endSymbol.get())));
                if (tuple24 == null) throw new MatchError((Object)tuple24);
                String comment = (String)tuple24._1();
                String code = (String)tuple24._2();
                Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)comment, (Object)code);
                String comment3 = (String)tuple25._1();
                String code3 = (String)tuple25._2();
                String string = comment3;
                if (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(code3), (Function1 & Serializable)_$7 -> this.wrapLineInBetween$$anonfun$2(BoxesRunTime.unboxToChar((Object)_$7)))) {
                    snippetLine = line.withClass("hideable");
                    return snippetLine;
                }
                snippetLine = line.copy("<span class=\"hideable\">" + comment3 + "</span>" + code3, line.copy$default$2(), line.copy$default$3(), line.copy$default$4());
                return snippetLine;
            }
            if (option instanceof Some) {
                int startIdx2 = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (option2 instanceof Some) {
                    int endIdx2 = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    Tuple2 tuple26 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(line.content()), endIdx2 + StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString((String)endSymbol.get())));
                    if (tuple26 == null) throw new MatchError((Object)tuple26);
                    String tmp = (String)tuple26._1();
                    String end = (String)tuple26._2();
                    Tuple2 tuple27 = Tuple2$.MODULE$.apply((Object)tmp, (Object)end);
                    String tmp2 = (String)tuple27._1();
                    String end2 = (String)tuple27._2();
                    Tuple2 tuple28 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(tmp2), startIdx2);
                    if (tuple28 == null) throw new MatchError((Object)tuple28);
                    String begin = (String)tuple28._1();
                    String comment = (String)tuple28._2();
                    Tuple2 tuple29 = Tuple2$.MODULE$.apply((Object)begin, (Object)comment);
                    String begin2 = (String)tuple29._1();
                    String comment4 = (String)tuple29._2();
                    snippetLine = line.copy(begin2 + ("<span class=\"hideable\">" + comment4 + "</span>") + end2, line.copy$default$2(), line.copy$default$3(), line.copy$default$4());
                    return snippetLine;
                }
            }
        }
        snippetLine = line;
        return snippetLine;
    }

    private Seq<SnippetLine> wrapSingleLineComments(Seq<SnippetLine> snippetLines) {
        return (Seq)snippetLines.map((Function1 & Serializable)line -> {
            SnippetLine snippetLine;
            int n = line.content().indexOf("//");
            if (-1 == n) {
                snippetLine = line;
            } else {
                int idx = n;
                snippetLine = this.wrapLineInBetween((Option<String>)Some$.MODULE$.apply((Object)"//"), (Option<String>)None$.MODULE$, (SnippetLine)line);
            }
            return snippetLine;
        });
    }

    private Seq<SnippetLine> wrapMultiLineComments(Seq<SnippetLine> snippetLines) {
        Option mRes = this.cutBetweenSymbols("/*", "*/", snippetLines, (Function3 & Serializable)(x$1, x$2, x$3) -> {
            Seq seq;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$1, x$2, x$3);
            if (tuple3 != null) {
                Seq seq2 = (Seq)tuple3._1();
                Seq seq3 = (Seq)tuple3._2();
                Seq seq4 = (Seq)tuple3._3();
                Seq begin = seq2;
                Seq mid = seq3;
                Seq end = seq4;
                if (mid.size() == 1) {
                    Seq midRedacted = (Seq)mid.map((Function1 & Serializable)_$8 -> this.wrapLineInBetween((Option<String>)Some$.MODULE$.apply((Object)"/*"), (Option<String>)Some$.MODULE$.apply((Object)"*/"), (SnippetLine)_$8));
                    seq = (Seq)((IterableOps)begin.$plus$plus((IterableOnce)midRedacted)).$plus$plus((IterableOnce)end);
                } else {
                    Seq begin2 = seq2;
                    Seq mid2 = seq3;
                    Seq end2 = seq4;
                    Seq midRedacted = (Seq)((IterableOps)((IterableOps)((IterableOps)mid2.take(1)).map((Function1 & Serializable)_$9 -> this.wrapLineInBetween((Option<String>)Some$.MODULE$.apply((Object)"/*"), (Option<String>)None$.MODULE$, (SnippetLine)_$9))).$plus$plus((IterableOnce)((IterableOps)((IterableOps)mid2.drop(1)).dropRight(1)).map((Function1 & Serializable)_$10 -> _$10.withClass("hideable")))).$plus$plus((IterableOnce)((IterableOps)mid2.takeRight(1)).map((Function1 & Serializable)_$11 -> this.wrapLineInBetween((Option<String>)None$.MODULE$, (Option<String>)Some$.MODULE$.apply((Object)"*/"), (SnippetLine)_$11)));
                    seq = (Seq)((IterableOps)begin2.$plus$plus((IterableOnce)midRedacted)).$plus$plus(this.wrapMultiLineComments((Seq<SnippetLine>)end2));
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
            return seq;
        });
        return (Seq)mRes.getOrElse(() -> this.wrapMultiLineComments$$anonfun$1(snippetLines));
    }

    private Seq<SnippetLine> wrapCodeLines(Seq<String> codeLines) {
        Seq snippetLines2 = (Seq)((IterableOps)codeLines.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String content = (String)tuple2._1();
            int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
            return SnippetLine$.MODULE$.apply(content, idx, SnippetLine$.MODULE$.$lessinit$greater$default$3(), SnippetLine$.MODULE$.$lessinit$greater$default$4());
        });
        return (Seq)((Function1 & Serializable)(Function1 & Serializable)snippetLines -> this.wrapHiddenSymbols((Seq<SnippetLine>)snippetLines)).andThen((Function1 & Serializable)snippetLines -> this.wrapSingleLineComments((Seq<SnippetLine>)snippetLines)).andThen((Function1 & Serializable)snippetLines -> this.wrapMultiLineComments((Seq<SnippetLine>)snippetLines)).apply((Object)snippetLines2);
    }

    private Seq<SnippetLine> addCompileMessages(Seq<SnippetCompilerMessage> messages, Seq<SnippetLine> codeLines) {
        Map messagesDict = ((IterableOps)messages.filter((Function1 & Serializable)_$12 -> _$12.position().nonEmpty())).groupBy((Function1 & Serializable)_$13 -> ((Position)_$13.position().get()).relativeLine()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (Seq)codeLines.map((Function1 & Serializable)line -> {
            SnippetLine snippetLine;
            Option option = messagesDict.get((Object)BoxesRunTime.boxToInteger((int)line.lineNo()));
            if (None$.MODULE$.equals(option)) {
                snippetLine = line;
            } else if (option instanceof Some) {
                Seq messages = (Seq)((Some)option).value();
                List classes = (List)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{messages.find((Function1 & Serializable)_$14 -> {
                    MessageLevel messageLevel = _$14.level();
                    MessageLevel messageLevel2 = MessageLevel$.Error;
                    return !(messageLevel != null ? !messageLevel.equals(messageLevel2) : messageLevel2 != null);
                }).map((Function1 & Serializable)msg -> this.compileMessageCSSClass((SnippetCompilerMessage)msg)), messages.find((Function1 & Serializable)_$15 -> {
                    MessageLevel messageLevel = _$15.level();
                    MessageLevel messageLevel2 = MessageLevel$.Warning;
                    return !(messageLevel != null ? !messageLevel.equals(messageLevel2) : messageLevel2 != null);
                }).map((Function1 & Serializable)msg -> this.compileMessageCSSClass((SnippetCompilerMessage)msg)), messages.find((Function1 & Serializable)_$16 -> {
                    MessageLevel messageLevel = _$16.level();
                    MessageLevel messageLevel2 = MessageLevel$.Info;
                    return !(messageLevel != null ? !messageLevel.equals(messageLevel2) : messageLevel2 != null);
                }).map((Function1 & Serializable)msg -> this.compileMessageCSSClass((SnippetCompilerMessage)msg))}))).flatten(Predef$.MODULE$.$conforms());
                Set set = (Set)line.classes().$plus$plus((IterableOnce)classes.toSet()).$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tooltip"})));
                Seq seq = (Seq)messages.map((Function1 & Serializable)_$17 -> _$17.message());
                String string = line.copy$default$1();
                int n = line.copy$default$2();
                snippetLine = line.copy(string, n, (Set<String>)set, (Seq<String>)seq);
            } else {
                throw new MatchError((Object)option);
            }
            return snippetLine;
        });
    }

    private String messagesHTML(Seq<SnippetCompilerMessage> messages) {
        String string;
        if (messages.isEmpty()) {
            string = "";
        } else {
            String content = ((IterableOnceOps)messages.map((Function1 & Serializable)msg -> "<span class=\"" + this.compileMessageCSSClass((SnippetCompilerMessage)msg) + "\">" + msg.getSummary() + "</span>")).mkString("<br>");
            string = "<hr>" + content;
        }
        return string;
    }

    public String renderSnippetWithMessages(Seq<String> codeLines2, Seq<SnippetCompilerMessage> messages) {
        Seq transformedLines = (Seq)((IterableOps)((Function1 & Serializable)(Function1 & Serializable)codeLines -> this.wrapCodeLines((Seq<String>)codeLines)).andThen((Function1 & Serializable)codeLines -> this.addCompileMessages(messages, (Seq<SnippetLine>)codeLines)).apply(codeLines2)).map((Function1 & Serializable)_$18 -> _$18.toHTML());
        String codeHTML = "<code class=\"language-scala\">" + transformedLines.mkString("") + "<pre></pre></code>";
        return "<div class=\"snippet\"><pre>" + codeHTML + "</pre></div>";
    }

    private final /* synthetic */ Tuple3 cutBetweenSymbols$$anonfun$5$$anonfun$3(Seq snippetLines$2, int startIdx$1, int endIdx) {
        Tuple2 tuple2 = snippetLines$2.splitAt(endIdx + 1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq tmp = (Seq)tuple2._1();
        Seq end = (Seq)tuple2._2();
        Tuple2 $1$ = tuple2;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)tmp, (Object)end);
        Tuple2 $1$2 = (Tuple2)tuple3._1();
        Seq tmp2 = (Seq)tuple3._2();
        Seq end2 = (Seq)tuple3._3();
        Tuple2 tuple22 = tmp2.splitAt(startIdx$1);
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Seq begin = (Seq)tuple22._1();
        Seq mid = (Seq)tuple22._2();
        Tuple2 $2$ = tuple22;
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)$2$, (Object)begin, (Object)mid);
        Tuple2 $2$2 = (Tuple2)tuple32._1();
        Seq begin2 = (Seq)tuple32._2();
        Seq mid2 = (Seq)tuple32._3();
        return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)endIdx), (Object)$1$2, (Object)$2$2);
    }

    private final /* synthetic */ Option cutBetweenSymbols$$anonfun$8(String endSymbol$1, Seq snippetLines$1, Function3 f$1, int startIdx) {
        return ((IterableOnceOps)snippetLines$1.zipWithIndex()).find((Function1 & Serializable)_$3 -> ((SnippetLine)_$3._1()).content().contains(endSymbol$1)).map((Function1 & Serializable)_$4 -> BoxesRunTime.unboxToInt((Object)_$4._2())).map((Function1 & Serializable)endIdx -> this.cutBetweenSymbols$$anonfun$5$$anonfun$3(snippetLines$1, startIdx, BoxesRunTime.unboxToInt((Object)endIdx))).map((Function1 & Serializable)x$1 -> {
            Seq end;
            Tuple2 tuple2;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x$1;
                    if (tuple3 == null) break block2;
                    Tuple2 tuple22 = (Tuple2)tuple3._2();
                    tuple2 = (Tuple2)tuple3._3();
                    int endIdx = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    if (tuple22 == null) break block2;
                    Seq tmp = (Seq)tuple22._1();
                    end = (Seq)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            Seq begin = (Seq)tuple2._1();
            Seq mid = (Seq)tuple2._2();
            return f$1.apply((Object)begin, (Object)mid, (Object)end);
        });
    }

    private final Seq wrapHiddenSymbols$$anonfun$1(Seq snippetLines$3) {
        return snippetLines$3;
    }

    private final /* synthetic */ boolean wrapLineInBetween$$anonfun$1(char _$6) {
        return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(_$6));
    }

    private final /* synthetic */ boolean wrapLineInBetween$$anonfun$2(char _$7) {
        return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(_$7));
    }

    private final Seq wrapMultiLineComments$$anonfun$1(Seq snippetLines$4) {
        return snippetLines$4;
    }
}

