/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.scaladoc.DocContext;
import dotty.tools.scaladoc.DocContext$package$;
import dotty.tools.scaladoc.SourceLink;
import dotty.tools.scaladoc.SourceLink$;
import dotty.tools.scaladoc.SourceLinks;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SourceLinks$
implements Mirror.Product,
Serializable {
    private static final String usage;
    public static final SourceLinks$ MODULE$;

    private SourceLinks$() {
    }

    static {
        MODULE$ = new SourceLinks$();
        usage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Source links provide a mapping between file in documentation and code repository.\n      |\n      |Accepted formats:\n      |<sub-path>=<source-link>\n      |<source-link>\n      |\n      |where <source-link> is one of following:\n      | - `github://<organization>/<repository>[/revision][#subpath]`\n      |     will match https://github.com/$organization/$repository/[blob|edit]/$revision[/$subpath]/$filePath[$lineNumber]\n      |     when revision is not provided then requires revision to be specified as argument for scaladoc\n      | - `gitlab://<organization>/<repository>`\n      |     will match https://gitlab.com/$organization/$repository/-/[blob|edit]/$revision[/$subpath]/$filePath[$lineNumber]\n      |     when revision is not provided then requires revision to be specified as argument for scaladoc\n      | - <scaladoc-template>\n      |\n      |<scaladoc-template> is a format for `doc-source-url` parameter scaladoc.\n      |NOTE: We only supports `\u20ac{FILE_PATH_EXT}`, `\u20ac{TPL_NAME}`, `\u20ac{FILE_EXT}`,\n      | \u20ac{FILE_PATH}, and \u20ac{FILE_LINE} patterns\n      |\n      |\n      |Template can defined only by subset of sources defined by path prefix represented by `<sub-path>`.\n      |In such case paths used in templates will be relativized against `<sub-path>`"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SourceLinks$.class);
    }

    public SourceLinks apply(Seq<SourceLink> links, Path projectRoot) {
        return new SourceLinks(links, projectRoot);
    }

    public SourceLinks unapply(SourceLinks x$1) {
        return x$1;
    }

    public String toString() {
        return "SourceLinks";
    }

    public String usage() {
        return usage;
    }

    public SourceLinks load(Seq<String> configs, Option<String> revision, Path projectRoot, Contexts.Context x$4) {
        Seq mappings = (Seq)configs.map((Function1 & Serializable)str -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(str);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, SourceLink$.MODULE$.parse((String)str, revision));
        });
        String errors = ((IterableOnceOps)mappings.collect((PartialFunction)new Serializable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 == null) return false;
                Either either = (Either)tuple2._2();
                String template = (String)tuple2._1();
                if (!(either instanceof Left)) return false;
                String message = (String)((Left)either).value();
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Object object;
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Either either = (Either)tuple2._2();
                    String template = (String)tuple2._1();
                    if (either instanceof Left) {
                        String message = (String)((Left)either).value();
                        object = "'" + template + "': " + message;
                        return object;
                    }
                }
                object = function1.apply((Object)x);
                return object;
            }
        })).mkString("\n");
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(errors))) {
            DocContext$package$.MODULE$.report().warning(Message$.MODULE$.toNoExplanation(() -> this.load$$anonfun$1(errors)), DocContext$package$.MODULE$.report().warning$default$2(), x$4);
        }
        return this.apply((Seq<SourceLink>)((Seq)mappings.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                boolean bl;
                Either either;
                Tuple2 tuple2 = x;
                if (tuple2 != null && (either = (Either)tuple2._2()) instanceof Right) {
                    SourceLink link = (SourceLink)((Right)either).value();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Object object;
                Either either;
                Tuple2 tuple2 = x;
                if (tuple2 != null && (either = (Either)tuple2._2()) instanceof Right) {
                    SourceLink link = (SourceLink)((Right)either).value();
                    object = link;
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        })), projectRoot);
    }

    public SourceLinks load(DocContext ctx) {
        return this.load((Seq<String>)ctx.args().sourceLinks(), ctx.args().revision(), Paths.get("", new String[0]).toAbsolutePath(), DocContext$package$.MODULE$.compilerContext(ctx));
    }

    public SourceLinks fromProduct(Product x$0) {
        return new SourceLinks((Seq<SourceLink>)((Seq)x$0.productElement(0)), (Path)x$0.productElement(1));
    }

    private final String load$$anonfun$1(String errors$1) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Following templates has invalid format:\n         |" + errors$1 + "\n         |\n         |" + this.usage() + "\n         |"));
    }
}

