/*
 * Decompiled with CFR 0.152.
 */
package org.scalajs.ir;

import java.util.concurrent.ConcurrentHashMap;
import org.scalajs.ir.IRVersionNotSupportedException;
import org.scalajs.ir.VersionChecks$;
import scala.MatchError;
import scala.Option;
import scala.Tuple3;
import scala.Tuple3$;
import scala.runtime.BoxesRunTime;

public class VersionChecks {
    private final String current;
    private final String binaryEmitted;
    private final int binaryMajor;
    private final int binaryMinor;
    private final Option<String> binaryPreRelease;
    private final String binaryCross;
    private final ConcurrentHashMap.KeySetView<String, Boolean> knownSupportedBinary;

    public VersionChecks(String current, String binaryEmitted) {
        this.current = current;
        this.binaryEmitted = binaryEmitted;
        VersionChecks$.MODULE$.org$scalajs$ir$VersionChecks$$$checkConsistent(current, binaryEmitted);
        Tuple3<Object, Object, Option<String>> tuple3 = VersionChecks$.MODULE$.org$scalajs$ir$VersionChecks$$$parseBinary(binaryEmitted);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int binaryMajor = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int binaryMinor = BoxesRunTime.unboxToInt((Object)tuple3._2());
        Option binaryPreRelease = (Option)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)binaryMajor), (Object)BoxesRunTime.boxToInteger((int)binaryMinor), (Object)binaryPreRelease);
        this.binaryMajor = BoxesRunTime.unboxToInt((Object)tuple32._1());
        this.binaryMinor = BoxesRunTime.unboxToInt((Object)tuple32._2());
        this.binaryPreRelease = (Option)tuple32._3();
        boolean needsFull = this.binaryPreRelease.isDefined() && this.binaryMinor == 0;
        this.binaryCross = needsFull ? binaryEmitted : BoxesRunTime.boxToInteger((int)this.binaryMajor).toString();
        ConcurrentHashMap.KeySetView<String, Boolean> m = ConcurrentHashMap.newKeySet();
        m.add(binaryEmitted);
        this.knownSupportedBinary = m;
    }

    public final String current() {
        return this.current;
    }

    public final String binaryEmitted() {
        return this.binaryEmitted;
    }

    public final String binaryCross() {
        return this.binaryCross;
    }

    public final void checkSupported(String version) {
        if (!this.knownSupportedBinary.contains(version)) {
            boolean supported;
            Tuple3<Object, Object, Option<String>> tuple3 = VersionChecks$.MODULE$.org$scalajs$ir$VersionChecks$$$parseBinary(version);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            int major = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int minor = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Option preRelease = (Option)tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)major), (Object)BoxesRunTime.boxToInteger((int)minor), (Object)preRelease);
            int major2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int minor2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Option preRelease2 = (Option)tuple32._3();
            boolean bl = supported = preRelease2.isEmpty() && major2 == this.binaryMajor && minor2 <= this.binaryMinor && (this.binaryPreRelease.isEmpty() || minor2 < this.binaryMinor);
            if (supported) {
                this.knownSupportedBinary.add(version);
                return;
            }
            throw new IRVersionNotSupportedException(version, this.binaryEmitted(), new StringBuilder(49).append("This version (").append(version).append(") of Scala.js IR is not supported. ").append(new StringBuilder(29).append("Supported versions are up to ").append(this.binaryEmitted()).toString()).toString());
        }
    }
}

