/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.interactive;

import dotty.tools.FatalError;
import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.Driver;
import dotty.tools.dotc.Run;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.Trees$PackageDef$;
import dotty.tools.dotc.ast.tpd$;
import dotty.tools.dotc.ast.tpd$TreeOps$;
import dotty.tools.dotc.classpath.AggregateClassPath;
import dotty.tools.dotc.classpath.AggregateClassPath$;
import dotty.tools.dotc.classpath.JFileDirectoryLookup;
import dotty.tools.dotc.classpath.ZipArchiveFileLookup;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Contexts$;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Denotations;
import dotty.tools.dotc.core.Denotations$;
import dotty.tools.dotc.core.Mode$;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.SymDenotations;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.Types$UnspecifiedErrorType$;
import dotty.tools.dotc.interactive.InteractiveCompiler;
import dotty.tools.dotc.interactive.InteractiveDriver$;
import dotty.tools.dotc.interactive.SourceTree;
import dotty.tools.dotc.interactive.SourceTree$;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.Reporter;
import dotty.tools.dotc.reporting.StoreReporter;
import dotty.tools.dotc.reporting.UniqueMessagePositions;
import dotty.tools.dotc.typer.ImportInfo$;
import dotty.tools.dotc.util.NoSource$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourceFile$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassPath;
import dotty.tools.io.ClassRepresentation;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class InteractiveDriver
extends Driver {
    private final List<String> settings;
    private final Contexts.Context myInitCtx;
    private Contexts.Context myCtx;
    private final Compiler compiler;
    private final scala.collection.mutable.Map<URI, SourceFile> myOpenedFiles;
    private final scala.collection.mutable.Map<URI, List<SourceTree>> myOpenedTrees;
    private final LinkedHashMap<URI, CompilationUnit> myCompilationUnits;
    public final String dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffix;
    private final Seq<JFileDirectoryLookup<? extends ClassRepresentation>> dirClassPaths;
    private final Seq<Names.TypeName> zipClassPathClasses;

    public static Option<URI> toUriOption(AbstractFile abstractFile) {
        return InteractiveDriver$.MODULE$.toUriOption(abstractFile);
    }

    public static Option<URI> toUriOption(SourceFile sourceFile) {
        return InteractiveDriver$.MODULE$.toUriOption(sourceFile);
    }

    /*
     * WARNING - void declaration
     */
    public InteractiveDriver(List<String> settings) {
        Tuple2 tuple2;
        void var3_6;
        Contexts.Context context;
        Tuple2 tuple22;
        this.settings = settings;
        Contexts.FreshContext rootCtx = Contexts$.MODULE$.addMode(Contexts$.MODULE$.addMode(this.initCtx().fresh(), Mode$.MODULE$.ReadPositions()), Mode$.MODULE$.Interactive());
        rootCtx.setSetting(rootCtx.settings().YretainTrees(), BoxesRunTime.boxToBoolean((boolean)true));
        rootCtx.setSetting(rootCtx.settings().YcookComments(), BoxesRunTime.boxToBoolean((boolean)true));
        rootCtx.setSetting(rootCtx.settings().YreadComments(), BoxesRunTime.boxToBoolean((boolean)true));
        Option<Tuple2<List<AbstractFile>, Contexts.Context>> option = this.setup((String[])settings.toArray(ClassTag$.MODULE$.apply(String.class)), rootCtx);
        if (option instanceof Some && (tuple22 = (Tuple2)((Some)option).value()) != null) {
            Contexts.Context ctx = (Contexts.Context)tuple22._2();
            context = ctx;
        } else if (None$.MODULE$.equals(option)) {
            context = rootCtx;
        } else {
            throw new MatchError(option);
        }
        Contexts.FreshContext ctx = context;
        ctx.initialize(ctx);
        this.myCtx = this.myInitCtx = var3_6;
        this.compiler = new InteractiveCompiler();
        this.myOpenedFiles = new LinkedHashMap().withDefaultValue((Object)NoSource$.MODULE$);
        this.myOpenedTrees = new LinkedHashMap().withDefaultValue((Object)package$.MODULE$.Nil());
        this.myCompilationUnits = new LinkedHashMap();
        this.dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffix = ".tasty";
        ClassPath classPath = this.currentCtx().platform().classPath(this.currentCtx());
        if (classPath instanceof AggregateClassPath) {
            scala.collection.immutable.Seq<ClassPath> seq;
            AggregateClassPath aggregateClassPath = AggregateClassPath$.MODULE$.unapply((AggregateClassPath)classPath);
            scala.collection.immutable.Seq<ClassPath> cps = seq = aggregateClassPath._1();
            scala.collection.immutable.Seq zipCps = (scala.collection.immutable.Seq)cps.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(ClassPath x) {
                    ClassPath classPath = x;
                    if (classPath instanceof ZipArchiveFileLookup) {
                        ZipArchiveFileLookup cp = (ZipArchiveFileLookup)classPath;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(ClassPath x, Function1 function1) {
                    ClassPath classPath = x;
                    if (classPath instanceof ZipArchiveFileLookup) {
                        ZipArchiveFileLookup cp = (ZipArchiveFileLookup)classPath;
                        return cp;
                    }
                    return function1.apply((Object)x);
                }
            });
            scala.collection.immutable.Seq dirCps = (scala.collection.immutable.Seq)cps.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(ClassPath x) {
                    ClassPath classPath = x;
                    if (classPath instanceof JFileDirectoryLookup) {
                        JFileDirectoryLookup cp = (JFileDirectoryLookup)classPath;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(ClassPath x, Function1 function1) {
                    ClassPath classPath = x;
                    if (classPath instanceof JFileDirectoryLookup) {
                        JFileDirectoryLookup cp = (JFileDirectoryLookup)classPath;
                        return cp;
                    }
                    return function1.apply((Object)x);
                }
            });
            tuple2 = Tuple2$.MODULE$.apply((Object)zipCps, (Object)dirCps);
        } else {
            tuple2 = Tuple2$.MODULE$.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
        }
        Tuple2 tuple23 = tuple2;
        Seq zipClassPaths = (Seq)tuple23._1();
        this.dirClassPaths = (Seq)tuple23._2();
        ListBuffer names = new ListBuffer();
        zipClassPaths.foreach((Function1)(JProcedure1 & Serializable)cp -> this.classesFromZip(cp.zipFile(), (ListBuffer<Names.TypeName>)names));
        this.zipClassPathClasses = names;
        this.initialize();
    }

    public List<String> settings() {
        return this.settings;
    }

    @Override
    public boolean sourcesRequired() {
        return false;
    }

    public Contexts.Context currentCtx() {
        return this.myCtx;
    }

    public Map<URI, SourceFile> openedFiles() {
        return this.myOpenedFiles;
    }

    public Map<URI, List<SourceTree>> openedTrees() {
        return this.myOpenedTrees;
    }

    public Map<URI, CompilationUnit> compilationUnits() {
        return this.myCompilationUnits;
    }

    public List<SourceTree> sourceTrees(Contexts.Context x$1) {
        return this.sourceTreesContaining("", x$1);
    }

    public List<SourceTree> sourceTreesContaining(String id, Contexts.Context x$2) {
        List fromBuffers = ((IterableOnceOps)this.openedTrees().values().flatten(Predef$.MODULE$.$conforms())).toList();
        ListBuffer classNames = new ListBuffer();
        AbstractFile output = (AbstractFile)Settings$Setting$.MODULE$.value(x$2.settings().outputDir(), x$2);
        if (output.isDirectory()) {
            this.classesFromDir(output.jpath(), (ListBuffer<Names.TypeName>)classNames);
        } else {
            this.classesFromZip(output.file(), (ListBuffer<Names.TypeName>)classNames);
        }
        ListBuffer fromCompilationOutput = (ListBuffer)classNames.flatMap((Function1 & Serializable)cls -> this.treesFromClassName((Names.TypeName)cls, id, x$2));
        return (List)((SeqOps)fromBuffers.$plus$plus((IterableOnce)fromCompilationOutput)).distinct();
    }

    public List<SourceTree> allTrees(Contexts.Context x$1) {
        return this.allTreesContaining("", x$1);
    }

    public List<SourceTree> allTreesContaining(String id, Contexts.Context x$2) {
        List fromSource = ((IterableOnceOps)this.openedTrees().values().flatten(Predef$.MODULE$.$conforms())).toList();
        Seq fromClassPath = (Seq)((IterableOps)this.dirClassPathClasses().$plus$plus(this.zipClassPathClasses)).flatMap((Function1 & Serializable)cls -> this.treesFromClassName((Names.TypeName)cls, id, x$2));
        return (List)((SeqOps)fromSource.$plus$plus((IterableOnce)fromClassPath)).distinct();
    }

    public List<Diagnostic> run(URI uri, String sourceCode) {
        return this.run(uri, SourceFile$.MODULE$.virtual(uri, sourceCode));
    }

    public List<Diagnostic> run(URI uri, SourceFile source) {
        List<Diagnostic> list;
        Contexts.Context previousCtx = this.myCtx;
        try {
            LazyRef lazyRef = new LazyRef();
            UniqueMessagePositions reporter = new UniqueMessagePositions(){
                private HashMap dotty$tools$dotc$reporting$UniqueMessagePositions$$positions;
                {
                    UniqueMessagePositions.$init$(this);
                    Statics.releaseFence();
                }

                public HashMap dotty$tools$dotc$reporting$UniqueMessagePositions$$positions() {
                    return this.dotty$tools$dotc$reporting$UniqueMessagePositions$$positions;
                }

                public void dotty$tools$dotc$reporting$UniqueMessagePositions$_setter_$dotty$tools$dotc$reporting$UniqueMessagePositions$$positions_$eq(HashMap x$0) {
                    this.dotty$tools$dotc$reporting$UniqueMessagePositions$$positions = x$0;
                }

                public /* synthetic */ boolean dotty$tools$dotc$reporting$UniqueMessagePositions$$super$isHidden(Diagnostic dia, Contexts.Context x$2) {
                    return super.isHidden(dia, x$2);
                }

                public /* synthetic */ void dotty$tools$dotc$reporting$UniqueMessagePositions$$super$markReported(Diagnostic dia, Contexts.Context x$2) {
                    super.markReported(dia, x$2);
                }

                public /* synthetic */ boolean dotty$tools$dotc$reporting$HideNonSensicalMessages$$super$isHidden(Diagnostic dia, Contexts.Context x$2) {
                    return UniqueMessagePositions.isHidden$(this, dia, x$2);
                }
            };
            Run run = this.compiler.newRun(this.myInitCtx.fresh().setReporter((Reporter)((Object)reporter)));
            this.myCtx = ImportInfo$.MODULE$.withRootImports(run.runContext());
            this.myOpenedFiles.update((Object)uri, (Object)source);
            run.compileSources((List<SourceFile>)((List)new .colon.colon((Object)source, (List)Nil$.MODULE$)));
            run.printSummary();
            Run x$proxy1 = this.given_Context$1(lazyRef).run();
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            Run ctxRun = x$proxy1;
            CompilationUnit unit = ctxRun.units().nonEmpty() ? (CompilationUnit)ctxRun.units().head() : (CompilationUnit)ctxRun.suspendedUnits().head();
            Trees.Tree<Types.Type> t = unit.tpdTree();
            this.cleanup(t, this.given_Context$1(lazyRef));
            this.myOpenedTrees.update((Object)uri, this.topLevelTrees(t, source));
            this.myCompilationUnits.update((Object)uri, (Object)unit);
            this.myCtx = this.myCtx.fresh().setPhase(this.myInitCtx.base().typerPhase());
            list = ((StoreReporter)((Object)reporter)).removeBufferedMessages(this.given_Context$1(lazyRef));
        }
        catch (FatalError ex) {
            this.myCtx = previousCtx;
            this.close(uri);
            list = package$.MODULE$.Nil();
        }
        return list;
    }

    public void close(URI uri) {
        this.myOpenedFiles.remove((Object)uri);
        this.myOpenedTrees.remove((Object)uri);
        this.myCompilationUnits.remove((Object)uri);
    }

    private List<SourceTree> treesFromClassName(Names.TypeName className, String id, Contexts.Context x$3) {
        List list = InteractiveDriver.trees$3(x$3, className, id);
        return InteractiveDriver.trees$3(x$3, NameOps$.MODULE$.moduleClassName(className), id).$colon$colon$colon(list);
    }

    private Seq<Names.TypeName> dirClassPathClasses() {
        ListBuffer names = new ListBuffer();
        this.dirClassPaths.foreach((Function1)(JProcedure1 & Serializable)dirCp -> {
            Path root = ((File)dirCp.dir()).toPath();
            this.classesFromDir(root, (ListBuffer<Names.TypeName>)names);
        });
        return names;
    }

    private void classesFromZip(File file, ListBuffer<Names.TypeName> buffer) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(this.dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffix)) continue;
                buffer.$plus$eq((Object)Decorators$.MODULE$.toTypeName(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(name.replace("/", ".")), this.dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffix)));
            }
        }
    }

    private void classesFromDir(Path dir, ListBuffer<Names.TypeName> buffer) {
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(buffer, dir, this){
                private final ListBuffer buffer$1;
                private final Path dir$1;
                private final /* synthetic */ InteractiveDriver $outer;
                {
                    this.buffer$1 = buffer$2;
                    this.dir$1 = dir$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    String name;
                    if (!attrs.isDirectory() && (name = path.getFileName().toString()).endsWith(this.$outer.dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffix)) {
                        this.buffer$1.$plus$eq((Object)Decorators$.MODULE$.toTypeName(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.dir$1.relativize(path).toString().replace("/", ".")), this.$outer.dotty$tools$dotc$interactive$InteractiveDriver$$tastySuffix)));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (NoSuchFileException noSuchFileException) {}
    }

    private List<SourceTree> topLevelTrees(Trees.Tree<Types.Type> topTree, SourceFile source) {
        ListBuffer trees = new ListBuffer();
        InteractiveDriver.addTrees$1(trees, source, topTree);
        return trees.toList();
    }

    private void cleanup(Trees.Tree<Types.Type> tree, Contexts.Context x$2) {
        Set seen = (Set)Set$.MODULE$.empty();
        InteractiveDriver.cleanupTree$1(seen, x$2, tree);
    }

    private void initialize() {
        Run run = this.compiler.newRun(this.myInitCtx.fresh());
        this.myCtx = run.runContext();
        run.compileUnits((List<CompilationUnit>)package$.MODULE$.Nil(), this.myCtx);
    }

    private final Contexts.Context given_Context$lzyINIT1$1(LazyRef given_Context$lzy1$1) {
        Contexts.Context context;
        LazyRef lazyRef = given_Context$lzy1$1;
        synchronized (lazyRef) {
            context = (Contexts.Context)(given_Context$lzy1$1.initialized() ? given_Context$lzy1$1.value() : given_Context$lzy1$1.initialize((Object)this.myCtx));
        }
        return context;
    }

    private final Contexts.Context given_Context$1(LazyRef given_Context$lzy1$2) {
        return (Contexts.Context)(given_Context$lzy1$2.initialized() ? given_Context$lzy1$2.value() : this.given_Context$lzyINIT1$1(given_Context$lzy1$2));
    }

    private static final List trees$3(Contexts.Context x$3$1, Names.TypeName className, String id) {
        Denotations.Denotation clsd = Denotations$.MODULE$.staticRef(className, Denotations$.MODULE$.staticRef$default$2(), Denotations$.MODULE$.staticRef$default$3(), x$3$1);
        Denotations.Denotation denotation = clsd;
        if (denotation instanceof SymDenotations.ClassDenotation) {
            SymDenotations.ClassDenotation clsd2 = (SymDenotations.ClassDenotation)denotation;
            clsd2.ensureCompleted(x$3$1);
            return SourceTree$.MODULE$.fromSymbol(clsd2.symbol().asClass(), id, x$3$1);
        }
        return package$.MODULE$.Nil();
    }

    private static final void addTrees$1(ListBuffer trees$1, SourceFile source$1, Trees.Tree tree2) {
        Trees.Tree tree3 = tree2;
        if (tree3 instanceof Trees.PackageDef) {
            List list;
            Trees.PackageDef packageDef = Trees$PackageDef$.MODULE$.unapply((Trees.PackageDef)tree3);
            Trees.RefTree refTree = packageDef._1();
            List stats = list = packageDef._2();
            stats.foreach((Function1)(JProcedure1 & Serializable)tree -> InteractiveDriver.addTrees$1(trees$1, source$1, tree));
            return;
        }
        if (tree3 instanceof Trees.Import) {
            Trees.Import imp = (Trees.Import)tree3;
            trees$1.$plus$eq((Object)SourceTree$.MODULE$.apply(imp, source$1));
            return;
        }
        if (tree3 instanceof Trees.TypeDef) {
            Trees.TypeDef tree4 = (Trees.TypeDef)tree3;
            trees$1.$plus$eq((Object)SourceTree$.MODULE$.apply(tree4, source$1));
            return;
        }
    }

    private static final void cleanupTree$1(Set seen$1, Contexts.Context x$2$3, Trees.Tree tree) {
        seen$1.$plus$eq((Object)tree);
        Trees.Tree tree2 = tpd$.MODULE$.TreeOps(tree);
        tpd$TreeOps$.MODULE$.foreachSubTree$extension(tree2, (Function1<Trees.Tree<Types.Type>, BoxedUnit>)(JProcedure1 & Serializable)t -> {
            if (Symbols$.MODULE$.toDenot(t.symbol(x$2$3), x$2$3).exists() && t.hasType()) {
                if (!Symbols$.MODULE$.toDenot(t.symbol(x$2$3), x$2$3).isCompleted()) {
                    Symbols$.MODULE$.toDenot(t.symbol(x$2$3), x$2$3).info_$eq(Types$UnspecifiedErrorType$.MODULE$);
                }
                Symbols$.MODULE$.toDenot(t.symbol(x$2$3), x$2$3).annotations(x$2$3).foreach((Function1)(JProcedure1 & Serializable)annot -> {
                    if (annot.isEvaluated() && !seen$1.apply(annot.tree(x$2$3))) {
                        InteractiveDriver.cleanupTree$1(seen$1, x$2$3, annot.tree(x$2$3));
                        return;
                    }
                });
            }
            t.removeAllAttachments();
        }, x$2$3);
    }
}

