/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.HashSet$;
import dotty.tools.dotc.util.MutableSet;
import java.util.Arrays;
import scala.Array$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;

public class HashSet<T>
extends MutableSet<T> {
    private final int initialCapacity;
    private final int capacityMultiple;
    private int used;
    private int limit;
    public Object[] dotty$tools$dotc$util$HashSet$$table;

    public static <T> HashSet<T> from(IterableOnce<T> iterableOnce) {
        return HashSet$.MODULE$.from(iterableOnce);
    }

    public static <T> int $lessinit$greater$default$1() {
        return HashSet$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> int $lessinit$greater$default$2() {
        return HashSet$.MODULE$.$lessinit$greater$default$2();
    }

    public HashSet(int initialCapacity, int capacityMultiple) {
        this.initialCapacity = initialCapacity;
        this.capacityMultiple = capacityMultiple;
        this.clear(this.clear$default$1());
    }

    private void allocate(int capacity) {
        this.dotty$tools$dotc$util$HashSet$$table = new Object[capacity];
        this.limit = capacity <= 8 ? capacity - 1 : capacity / this.capacityMultiple;
    }

    private int roundToPower(int n) {
        if (n < 4) {
            return 4;
        }
        if (Integer.bitCount(n) == 1) {
            return n;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(n);
    }

    @Override
    public void clear(boolean resetToInitial) {
        this.used = 0;
        if (resetToInitial) {
            this.allocate(this.roundToPower(this.initialCapacity));
            return;
        }
        Arrays.fill(this.dotty$tools$dotc$util$HashSet$$table, null);
    }

    @Override
    public int size() {
        return this.used;
    }

    public boolean isDense() {
        return this.limit < 8;
    }

    public int hash(T key) {
        int h = key.hashCode();
        int i = (h ^ h >>> 16) * -2048144789;
        int j = (i ^ i >>> 13) & Integer.MAX_VALUE;
        if (j == 0) {
            return 1091049865;
        }
        return j;
    }

    public boolean isEqual(T x, T y) {
        return x.equals(y);
    }

    public int index(int x) {
        return x & this.dotty$tools$dotc$util$HashSet$$table.length - 1;
    }

    public Object[] currentTable() {
        return this.dotty$tools$dotc$util$HashSet$$table;
    }

    public int firstIndex(T x) {
        if (this.isDense()) {
            return 0;
        }
        return this.index(this.hash(x));
    }

    public int nextIndex(int idx) {
        return this.index(idx + 1);
    }

    public Object entryAt(int idx) {
        return this.dotty$tools$dotc$util$HashSet$$table[idx];
    }

    public void setEntry(int idx, T x) {
        this.dotty$tools$dotc$util$HashSet$$table[idx] = x;
    }

    @Override
    public Object lookup(T x) {
        int idx = this.firstIndex(x);
        Object e = this.entryAt(idx);
        while (e != null) {
            Object x$proxy1 = e;
            if (this.isEqual(x$proxy1, x)) {
                return e;
            }
            idx = this.nextIndex(idx);
            e = this.entryAt(idx);
        }
        return null;
    }

    public T addEntryAt(int idx, T x) {
        this.setEntry(idx, x);
        ++this.used;
        if (this.used > this.limit) {
            this.growTable();
        }
        return x;
    }

    @Override
    public T put(T x) {
        int idx = this.firstIndex(x);
        Object e = this.entryAt(idx);
        while (e != null) {
            Object x$proxy2 = e;
            if (this.isEqual(x$proxy2, x)) {
                Object x$proxy3 = e;
                return (T)x$proxy3;
            }
            idx = this.nextIndex(idx);
            e = this.entryAt(idx);
        }
        return this.addEntryAt(idx, x);
    }

    @Override
    public void $plus$eq(T x) {
        this.put(x);
    }

    public boolean remove(T x) {
        int idx = this.firstIndex(x);
        Object e = this.entryAt(idx);
        while (e != null) {
            Object x$proxy4 = e;
            if (this.isEqual(x$proxy4, x)) {
                int hole = idx;
                while ((e = this.entryAt(idx = this.nextIndex(idx))) != null) {
                    Object x$proxy5 = e;
                    int eidx = this.index(this.hash(x$proxy5));
                    if (!this.isDense() && this.index(eidx - (hole + 1)) <= this.index(idx - (hole + 1))) continue;
                    Object x$proxy6 = e;
                    this.setEntry(hole, x$proxy6);
                    hole = idx;
                }
                this.dotty$tools$dotc$util$HashSet$$table[hole] = null;
                --this.used;
                return true;
            }
            idx = this.nextIndex(idx);
            e = this.entryAt(idx);
        }
        return false;
    }

    @Override
    public void $minus$eq(T x) {
        this.remove(x);
    }

    private void addOld(T x) {
        int idx = this.firstIndex(x);
        Object e = this.entryAt(idx);
        while (e != null) {
            idx = this.nextIndex(idx);
            e = this.entryAt(idx);
        }
        this.setEntry(idx, x);
    }

    public void copyFrom(Object[] oldTable) {
        if (this.isDense()) {
            Array$.MODULE$.copy((Object)oldTable, 0, (Object)this.dotty$tools$dotc$util$HashSet$$table, 0, oldTable.length);
            return;
        }
        for (int idx = 0; idx < oldTable.length; ++idx) {
            Object e = oldTable[idx];
            if (e == null) continue;
            Object x$proxy7 = e;
            this.addOld(x$proxy7);
        }
    }

    public void growTable() {
        Object[] oldTable = this.dotty$tools$dotc$util$HashSet$$table;
        int newLength = oldTable.length == 8 ? 16 * this.roundToPower(this.capacityMultiple) : this.dotty$tools$dotc$util$HashSet$$table.length * 2;
        this.allocate(newLength);
        this.copyFrom(oldTable);
    }

    @Override
    public Iterator<T> iterator() {
        return new EntryIterator(this){
            private final /* synthetic */ HashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object entry(int idx) {
                return this.$outer.entryAt(idx);
            }
        };
    }

    public String toString() {
        return this.iterator().mkString("HashSet(", ", ", ")");
    }

    public String statsItem(String op) {
        String prefix = this.isDense() ? "HashSet(dense)." : "HashSet.";
        String suffix = this.getClass().getSimpleName();
        return new StringBuilder(1).append(prefix).append(op).append(" ").append(suffix).toString();
    }

    public abstract class EntryIterator
    implements Iterator<T> {
        private int idx;

        public EntryIterator() {
            if (HashSet.this == null) {
                throw new NullPointerException();
            }
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.idx = 0;
        }

        public abstract Object entry(int var1);

        public boolean hasNext() {
            while (this.idx < HashSet.this.dotty$tools$dotc$util$HashSet$$table.length && HashSet.this.dotty$tools$dotc$util$HashSet$$table[this.idx] == null) {
                ++this.idx;
            }
            return this.idx < HashSet.this.dotty$tools$dotc$util$HashSet$$table.length;
        }

        /*
         * WARNING - void declaration
         */
        public T next() {
            void v0;
            Predef$.MODULE$.require(this.hasNext());
            try {
                void var1_1;
                Object x$proxy8 = this.entry(this.idx);
                v0 = var1_1;
            }
            finally {
                ++this.idx;
            }
            return v0;
        }

        public final /* synthetic */ HashSet dotty$tools$dotc$util$HashSet$EntryIterator$$$outer() {
            return HashSet.this;
        }
    }
}

