/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.MutableMap;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;

public abstract class GenericHashMap<Key, Value>
extends MutableMap<Key, Value> {
    private final int initialCapacity;
    private final int capacityMultiple;
    private int used;
    private int limit;
    private Object[] table;

    public GenericHashMap(int initialCapacity, int capacityMultiple) {
        this.initialCapacity = initialCapacity;
        this.capacityMultiple = capacityMultiple;
        this.clear();
    }

    public int used() {
        return this.used;
    }

    public void used_$eq(int x$1) {
        this.used = x$1;
    }

    public int limit() {
        return this.limit;
    }

    public void limit_$eq(int x$1) {
        this.limit = x$1;
    }

    public Object[] table() {
        return this.table;
    }

    public void table_$eq(Object[] x$1) {
        this.table = x$1;
    }

    private void allocate(int capacity) {
        this.table_$eq(new Object[capacity * 2]);
        this.limit_$eq(capacity <= 8 ? capacity - 1 : capacity / this.capacityMultiple);
    }

    private int roundToPower(int n) {
        if (n < 4) {
            return 4;
        }
        if (Integer.bitCount(n) == 1) {
            return n;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(n);
    }

    @Override
    public void clear() {
        this.used_$eq(0);
        this.allocate(this.roundToPower(this.initialCapacity));
    }

    @Override
    public int size() {
        return this.used();
    }

    public boolean isDense() {
        return this.limit() < 8;
    }

    public abstract int hash(Key var1);

    public abstract boolean isEqual(Key var1, Key var2);

    private int index(int x) {
        return x & this.table().length - 2;
    }

    private int firstIndex(Key key) {
        if (this.isDense()) {
            return 0;
        }
        return this.index(this.hash(key));
    }

    private int nextIndex(int idx) {
        return this.index(idx + 2);
    }

    public Key dotty$tools$dotc$util$GenericHashMap$$keyAt(int idx) {
        return (Key)this.table()[idx];
    }

    public Value dotty$tools$dotc$util$GenericHashMap$$valueAt(int idx) {
        return (Value)this.table()[idx + 1];
    }

    private void setKey(int idx, Key key) {
        this.table()[idx] = key;
    }

    private void setValue(int idx, Value value) {
        this.table()[idx + 1] = value;
    }

    @Override
    public Object lookup(Key key) {
        int idx = this.firstIndex(key);
        Key k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        while (k != null) {
            if (this.isEqual(k, key)) {
                return this.dotty$tools$dotc$util$GenericHashMap$$valueAt(idx);
            }
            idx = this.nextIndex(idx);
            k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        }
        return null;
    }

    @Override
    public void update(Key key, Value value) {
        int idx = this.firstIndex(key);
        Key k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        while (k != null) {
            if (this.isEqual(k, key)) {
                this.setValue(idx, value);
                return;
            }
            idx = this.nextIndex(idx);
            k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        }
        this.setKey(idx, key);
        this.setValue(idx, value);
        this.used_$eq(this.used() + 1);
        if (this.used() > this.limit()) {
            this.growTable();
            return;
        }
    }

    @Override
    public Object remove(Key key) {
        int idx = this.firstIndex(key);
        Key k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        while (k != null) {
            if (this.isEqual(k, key)) {
                Value result = this.dotty$tools$dotc$util$GenericHashMap$$valueAt(idx);
                int hole = idx;
                while ((k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx = this.nextIndex(idx))) != null) {
                    int eidx = this.index(this.hash(k));
                    if (!this.isDense() && this.index(eidx - (hole + 2)) <= this.index(idx - (hole + 2))) continue;
                    this.setKey(hole, k);
                    this.setValue(hole, this.dotty$tools$dotc$util$GenericHashMap$$valueAt(idx));
                    hole = idx;
                }
                this.table()[hole] = null;
                this.used_$eq(this.used() - 1);
                return result;
            }
            idx = this.nextIndex(idx);
            k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        }
        return null;
    }

    @Override
    public Value getOrElseUpdate(Key key, Function0<Value> value) {
        Object v = this.lookup(key);
        if (v == null) {
            Object v1;
            v = v1 = value.apply();
            this.update(key, v1);
        }
        Object x$proxy1 = v;
        return (Value)x$proxy1;
    }

    private void addOld(Key key, Value value) {
        int idx = this.firstIndex(key);
        Key k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        while (k != null) {
            idx = this.nextIndex(idx);
            k = this.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
        }
        this.setKey(idx, key);
        this.setValue(idx, value);
    }

    public void copyFrom(Object[] oldTable) {
        if (this.isDense()) {
            Array$.MODULE$.copy((Object)oldTable, 0, (Object)this.table(), 0, oldTable.length);
            return;
        }
        for (int idx = 0; idx < oldTable.length; idx += 2) {
            Object key = oldTable[idx];
            if (key == null) continue;
            this.addOld(key, oldTable[idx + 1]);
        }
    }

    public void growTable() {
        Object[] oldTable = this.table();
        int newLength = this.table().length == 16 ? this.table().length * this.roundToPower(this.capacityMultiple) : this.table().length;
        this.allocate(newLength);
        this.copyFrom(oldTable);
    }

    @Override
    public Iterator<Tuple2<Key, Value>> iterator() {
        return new EntryIterator<Tuple2<Key, Value>>(this){
            private final /* synthetic */ GenericHashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Tuple2 entry(int idx) {
                return Tuple2$.MODULE$.apply(this.$outer.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx), this.$outer.dotty$tools$dotc$util$GenericHashMap$$valueAt(idx));
            }
        };
    }

    @Override
    public Iterator<Key> keysIterator() {
        return new EntryIterator<Key>(this){
            private final /* synthetic */ GenericHashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object entry(int idx) {
                return this.$outer.dotty$tools$dotc$util$GenericHashMap$$keyAt(idx);
            }
        };
    }

    @Override
    public Iterator<Value> valuesIterator() {
        return new EntryIterator<Value>(this){
            private final /* synthetic */ GenericHashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object entry(int idx) {
                return this.$outer.dotty$tools$dotc$util$GenericHashMap$$valueAt(idx);
            }
        };
    }

    public String toString() {
        return this.iterator().map((Function1 & Serializable)x$1 -> {
            Object object = x$1._1();
            Object object2 = x$1._2();
            return new StringBuilder(4).append(object).append(" -> ").append(object2).toString();
        }).mkString("HashMap(", ", ", ")");
    }

    public String statsItem(String op) {
        String prefix = this.isDense() ? "HashMap(dense)." : "HashMap.";
        String suffix = this.getClass().getSimpleName();
        return new StringBuilder(1).append(prefix).append(op).append(" ").append(suffix).toString();
    }

    public abstract class EntryIterator<T>
    implements Iterator<T> {
        private int idx;

        public EntryIterator() {
            if (GenericHashMap.this == null) {
                throw new NullPointerException();
            }
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.idx = 0;
        }

        public abstract T entry(int var1);

        public boolean hasNext() {
            while (this.idx < GenericHashMap.this.table().length && GenericHashMap.this.table()[this.idx] == null) {
                this.idx += 2;
            }
            return this.idx < GenericHashMap.this.table().length;
        }

        public T next() {
            T t;
            Predef$.MODULE$.require(this.hasNext());
            try {
                t = this.entry(this.idx);
            }
            finally {
                this.idx += 2;
            }
            return t;
        }

        public final /* synthetic */ GenericHashMap dotty$tools$dotc$util$GenericHashMap$EntryIterator$$$outer() {
            return GenericHashMap.this;
        }
    }
}

