/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.backend.jvm;

import dotty.tools.backend.jvm.DottyBackendInterface;
import dotty.tools.backend.jvm.DottyPrimitives;
import dotty.tools.backend.jvm.GenBCode$;
import dotty.tools.backend.jvm.GenBCodePipeline;
import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.Run;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Phases;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.dotc.util.EqHashMap;
import dotty.tools.dotc.util.EqHashMap$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.Jar;
import dotty.tools.io.Jar$WManifest$;
import dotty.tools.io.JarArchive;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.jar.Attributes;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.package$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class GenBCode
extends Phases.Phase {
    private final EqHashMap<Symbols.Symbol, Set<Symbols.ClassSymbol>> superCallsMap = new EqHashMap(EqHashMap$.MODULE$.$lessinit$greater$default$1(), EqHashMap$.MODULE$.$lessinit$greater$default$2());
    private final HashSet<String> entryPoints = new HashSet();
    private AbstractFile myOutput;
    private DottyPrimitives myPrimitives = null;

    public static String name() {
        return GenBCode$.MODULE$.name();
    }

    @Override
    public String phaseName() {
        return GenBCode$.MODULE$.name();
    }

    @Override
    public String description() {
        return GenBCode$.MODULE$.description();
    }

    public void registerSuperCall(Symbols.Symbol sym, Symbols.ClassSymbol calls) {
        Set<Symbols.ClassSymbol> old = this.superCallsMap.getOrElse(sym, (Function0<Set<Symbols.ClassSymbol>>)((Function0 & Serializable)GenBCode::$anonfun$1));
        this.superCallsMap.update(sym, (Set<Symbols.ClassSymbol>)old.$plus((Object)calls));
    }

    public void registerEntryPoint(String s) {
        this.entryPoints.$plus$eq((Object)s);
    }

    private AbstractFile outputDir(Contexts.Context x$1) {
        if (this.myOutput == null) {
            this.myOutput = (AbstractFile)Settings$Setting$.MODULE$.value(x$1.settings().outputDir(), x$1);
        }
        return this.myOutput;
    }

    @Override
    public void run(Contexts.Context x$1) {
        if (this.myPrimitives == null) {
            this.myPrimitives = new DottyPrimitives(x$1);
        }
        new GenBCodePipeline(new DottyBackendInterface(this.outputDir(x$1), this.superCallsMap, x$1), this.myPrimitives, x$1).run(x$1.compilationUnit().tpdTree(), x$1);
    }

    @Override
    public List<CompilationUnit> runOn(List<CompilationUnit> units, Contexts.Context x$2) {
        List<CompilationUnit> list;
        AbstractFile abstractFile = this.outputDir(x$2);
        if (abstractFile instanceof JarArchive) {
            JarArchive jar = (JarArchive)abstractFile;
            this.updateJarManifestWithMainClass(jar, (List<String>)this.entryPoints.toList(), x$2);
        }
        try {
            list = super.runOn(units, x$2);
        }
        finally {
            AbstractFile abstractFile2 = this.outputDir(x$2);
            if (abstractFile2 instanceof JarArchive) {
                JarArchive jar = (JarArchive)abstractFile2;
                Run x$proxy1 = x$2.run();
                if (x$proxy1 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (x$proxy1.suspendedUnits().nonEmpty()) {
                    report$.MODULE$.error(Message$.MODULE$.toNoExplanation((Function0<String>)((Function0 & Serializable)GenBCode::runOn$$anonfun$1)), report$.MODULE$.error$default$2(), report$.MODULE$.error$default$3(), x$2);
                }
                jar.close();
            }
        }
        return list;
    }

    private void updateJarManifestWithMainClass(JarArchive jarArchive, List<String> entryPoints, Contexts.Context x$3) {
        Option mainClass = Option$.MODULE$.when(!Settings$Setting$.MODULE$.isDefault(x$3.settings().XmainClass(), x$3), () -> GenBCode.$anonfun$2(x$3)).orElse(() -> GenBCode.$anonfun$3(entryPoints, x$3));
        mainClass.map((Function1)(JProcedure1 & Serializable)mc -> {
            Jar.WManifest manifest = Jar$WManifest$.MODULE$.apply((Seq<Tuple2<Attributes.Name, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            manifest.mainClass_$eq((String)mc);
            AbstractFile file = jarArchive.subdirectoryNamed("META-INF").fileNamed("MANIFEST.MF");
            OutputStream os = file.output();
            manifest.underlying().write(os);
            os.close();
        });
    }

    private static final Set $anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final String runOn$$anonfun$1() {
        return "Can not suspend and output to a jar at the same time. See suspension with -Xprint-suspension.";
    }

    private static final String $anonfun$2(Contexts.Context x$3$1) {
        return (String)Settings$Setting$.MODULE$.value(x$3$1.settings().XmainClass(), x$3$1);
    }

    private static final String $anonfun$3$$anonfun$1() {
        return "No Main-Class designated or discovered.";
    }

    private static final String $anonfun$3$$anonfun$2(List mcs$1) {
        return new StringBuilder(46).append("No Main-Class due to multiple entry points:\n  ").append(mcs$1.mkString("\n  ")).toString();
    }

    private static final Option $anonfun$3(List entryPoints$1, Contexts.Context x$3$2) {
        SeqOps seqOps;
        List list = entryPoints$1;
        if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list), 1) == 0) {
            String string;
            String mainClass = string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
            return Some$.MODULE$.apply((Object)mainClass);
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            report$.MODULE$.warning(Message$.MODULE$.toNoExplanation((Function0<String>)((Function0 & Serializable)GenBCode::$anonfun$3$$anonfun$1)), report$.MODULE$.warning$default$2(), x$3$2);
            return None$.MODULE$;
        }
        List mcs = list;
        report$.MODULE$.warning(Message$.MODULE$.toNoExplanation((Function0<String>)((Function0 & Serializable)() -> GenBCode.$anonfun$3$$anonfun$2(mcs))), report$.MODULE$.warning$default$2(), x$3$2);
        return None$.MODULE$;
    }
}

