/*
 * Decompiled with CFR 0.152.
 */
package scala.pickling.binary;

import scala.Array$;
import scala.MatchError;
import scala.Tuple2;
import scala.pickling.ArrayOutput;
import scala.pickling.binary.UnsafeMemory$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Util$ {
    public static final Util$ MODULE$;
    private final int SizeOfByte;
    private final int SizeOfShort;
    private final int SizeOfInt;
    private final int SizeOfLong;
    private final int SizeOfFloat;
    private final int SizeOfDouble;
    private final int SizeOfChar;
    private final int SizeOfBoolean;

    static {
        new Util$();
    }

    public int SizeOfByte() {
        return this.SizeOfByte;
    }

    public int SizeOfShort() {
        return this.SizeOfShort;
    }

    public int SizeOfInt() {
        return this.SizeOfInt;
    }

    public int SizeOfLong() {
        return this.SizeOfLong;
    }

    public int SizeOfFloat() {
        return this.SizeOfFloat;
    }

    public int SizeOfDouble() {
        return this.SizeOfDouble;
    }

    public int SizeOfChar() {
        return this.SizeOfChar;
    }

    public int SizeOfBoolean() {
        return this.SizeOfBoolean;
    }

    public short decodeShortFrom(byte[] arr, int i) {
        short fst = (short)(arr[i] << 8 & 0xFFFF);
        short snd = (short)(arr[i + 1] & 0xFF);
        return (short)(fst | snd);
    }

    public int decodeIntFrom(byte[] arr, int i) {
        int fst = arr[i] << 24;
        int snd = arr[i + 1] << 16 & 0xFFFFFF;
        int thrd = arr[i + 2] << 8 & 0xFFFF;
        int frth = arr[i + 3] & 0xFF;
        return fst | snd | thrd | frth;
    }

    public long decodeLongFrom(byte[] arr, int i) {
        long elem1 = (long)arr[i] << 56 & 0xFFFFFFFFFFFFFFFFL;
        long elem2 = (long)arr[i + 1] << 48 & 0xFFFFFFFFFFFFFFL;
        long elem3 = (long)arr[i + 2] << 40 & 0xFFFFFFFFFFFFL;
        long elem4 = (long)arr[i + 3] << 32 & 0xFFFFFFFFFFL;
        long elem5 = (long)arr[i + 4] << 24 & 0xFFFFFFFFL;
        long elem6 = (long)arr[i + 5] << 16 & 0xFFFFFFL;
        long elem7 = (long)arr[i + 6] << 8 & 0xFFFFL;
        long elem8 = (long)arr[i + 7] & 0xFFL;
        return elem1 | elem2 | elem3 | elem4 | elem5 | elem6 | elem7 | elem8;
    }

    public char decodeCharFrom(byte[] arr, int i) {
        char fst = (char)(arr[i] << 8 & 0xFFFF);
        char snd = (char)(arr[i + 1] & 0xFF);
        return (char)(fst | snd);
    }

    public Tuple2<String, Object> decodeStringFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Byte());
        Array$.MODULE$.copy((Object)arr, i + this.SizeOfInt(), (Object)bytes, 0, len);
        return new Tuple2((Object)new String(bytes, "UTF-8"), (Object)BoxesRunTime.boxToInteger((int)(i + this.SizeOfInt() + len)));
    }

    public boolean decodeBooleanFrom(byte[] arr, int i) {
        return arr[i] != 0;
    }

    public byte[] decodeByteArray(byte[] arr, int offset, int len) {
        byte[] newArr = (byte[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Byte());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)offset, newArr, destOffset, len * this.SizeOfByte());
        return newArr;
    }

    public Tuple2<byte[], Object> decodeByteArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + this.SizeOfInt();
        byte[] ia = this.decodeByteArray(arr, nextPos, len);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * this.SizeOfByte())));
    }

    public short[] decodeShortArray(byte[] arr, int offset, int len) {
        short[] newArr = (short[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Short());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.shortArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)offset, newArr, destOffset, len * this.SizeOfShort());
        return newArr;
    }

    public Tuple2<short[], Object> decodeShortArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + this.SizeOfInt();
        short[] ia = this.decodeShortArray(arr, nextPos, len);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * this.SizeOfShort())));
    }

    public char[] decodeCharArray(byte[] arr, int offset, int len) {
        char[] newArr = (char[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Char());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.charArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)offset, newArr, destOffset, len * this.SizeOfChar());
        return newArr;
    }

    public Tuple2<char[], Object> decodeCharArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + this.SizeOfInt();
        char[] ia = this.decodeCharArray(arr, nextPos, len);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * this.SizeOfChar())));
    }

    public int[] decodeIntArray(byte[] arr, int offset, int len) {
        int[] newArr = (int[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Int());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.intArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)offset, newArr, destOffset, len * this.SizeOfInt());
        return newArr;
    }

    public Tuple2<int[], Object> decodeIntArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + this.SizeOfInt();
        int[] ia = this.decodeIntArray(arr, nextPos, len);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * this.SizeOfInt())));
    }

    public long[] decodeLongArray(byte[] arr, int offset, int len) {
        long[] newArr = (long[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Long());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.longArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)offset, newArr, destOffset, len * this.SizeOfLong());
        return newArr;
    }

    public Tuple2<long[], Object> decodeLongArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + this.SizeOfInt();
        long[] ia = this.decodeLongArray(arr, nextPos, len);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * this.SizeOfLong())));
    }

    public float[] decodeFloatArray(byte[] arr, int offset, int len) {
        float[] newArr = (float[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Float());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.floatArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)offset, newArr, destOffset, len * this.SizeOfFloat());
        return newArr;
    }

    public Tuple2<float[], Object> decodeFloatArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + this.SizeOfInt();
        float[] ia = this.decodeFloatArray(arr, nextPos, len);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * this.SizeOfFloat())));
    }

    public double[] decodeDoubleArray(byte[] arr, int offset, int len) {
        double[] newArr = (double[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Double());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.doubleArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)offset, newArr, destOffset, len * this.SizeOfDouble());
        return newArr;
    }

    public Tuple2<double[], Object> decodeDoubleArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + this.SizeOfInt();
        double[] ia = this.decodeDoubleArray(arr, nextPos, len);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * this.SizeOfDouble())));
    }

    public boolean[] decodeBooleanArray(byte[] arr, int offset, int len) {
        boolean[] newArr = (boolean[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Boolean());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.booleanArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)offset, newArr, destOffset, len * this.SizeOfBoolean());
        return newArr;
    }

    public Tuple2<boolean[], Object> decodeBooleanArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + this.SizeOfInt();
        boolean[] ia = this.decodeBooleanArray(arr, nextPos, len);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * this.SizeOfBoolean())));
    }

    public void encodeByte(ArrayOutput<Object> arr, byte value) {
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)value));
    }

    public void encodeShort(ArrayOutput<Object> arr, short value) {
        byte fst = (byte)(value >>> 8 & 0xFF);
        byte snd = (byte)(value & 0xFF);
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)fst));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)snd));
    }

    public void encodeInt(ArrayOutput<Object> arr, int value) {
        byte fst = (byte)(value >>> 24);
        byte snd = (byte)(value >>> 16 & 0xFF);
        byte thrd = (byte)(value >>> 8 & 0xFF);
        byte frth = (byte)(value & 0xFF);
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)fst));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)snd));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)thrd));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)frth));
    }

    public void encodeLong(ArrayOutput<Object> arr, long value) {
        byte elem1 = (byte)(value >>> 56 & 0xFFL);
        byte elem2 = (byte)(value >>> 48 & 0xFFL);
        byte elem3 = (byte)(value >>> 40 & 0xFFL);
        byte elem4 = (byte)(value >>> 32 & 0xFFL);
        byte elem5 = (byte)(value >>> 24 & 0xFFL);
        byte elem6 = (byte)(value >>> 16 & 0xFFL);
        byte elem7 = (byte)(value >>> 8 & 0xFFL);
        byte elem8 = (byte)(value & 0xFFL);
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)elem1));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)elem2));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)elem3));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)elem4));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)elem5));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)elem6));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)elem7));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)elem8));
    }

    public void encodeChar(ArrayOutput<Object> arr, char value) {
        byte fst = (byte)(value >>> 8 & 0xFF);
        byte snd = (byte)(value & 0xFF);
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)fst));
        arr.$plus$eq(BoxesRunTime.boxToByte((byte)snd));
    }

    public void encodeString(ArrayOutput<Object> arr, String value) {
        byte[] bytes = value.getBytes("UTF-8");
        this.encodeInt(arr, bytes.length);
        Tuple2<Object, Object> tuple2 = arr.target(bytes.length * this.SizeOfByte());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), (Object)BoxesRunTime.boxToInteger((int)tuple2._2$mcI$sp()));
            byte[] buf = (byte[])tuple22._1();
            int pos = tuple22._2$mcI$sp();
            this.encodeByteArrayTo(buf, pos, bytes);
            arr.flush(buf);
            return;
        }
        throw new MatchError(tuple2);
    }

    public void encodeBoolean(ArrayOutput<Object> arr, boolean value) {
        arr.$plus$eq(value ? BoxesRunTime.boxToByte((byte)1) : BoxesRunTime.boxToByte((byte)0));
    }

    public void encodeByteArray(ArrayOutput<Object> arr, byte[] value) {
        this.encodeInt(arr, value.length);
        Tuple2<Object, Object> tuple2 = arr.target(value.length * this.SizeOfByte());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), (Object)BoxesRunTime.boxToInteger((int)tuple2._2$mcI$sp()));
            byte[] buf = (byte[])tuple22._1();
            int pos = tuple22._2$mcI$sp();
            this.encodeByteArrayTo(buf, pos, value);
            arr.flush(buf);
            return;
        }
        throw new MatchError(tuple2);
    }

    public void encodeShortArray(ArrayOutput<Object> arr, short[] value) {
        this.encodeInt(arr, value.length);
        Tuple2<Object, Object> tuple2 = arr.target(value.length * this.SizeOfShort());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), (Object)BoxesRunTime.boxToInteger((int)tuple2._2$mcI$sp()));
            byte[] buf = (byte[])tuple22._1();
            int pos = tuple22._2$mcI$sp();
            this.encodeShortArrayTo(buf, pos, value);
            arr.flush(buf);
            return;
        }
        throw new MatchError(tuple2);
    }

    public void encodeIntArray(ArrayOutput<Object> arr, int[] value) {
        this.encodeInt(arr, value.length);
        Tuple2<Object, Object> tuple2 = arr.target(value.length * this.SizeOfInt());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), (Object)BoxesRunTime.boxToInteger((int)tuple2._2$mcI$sp()));
            byte[] buf = (byte[])tuple22._1();
            int pos = tuple22._2$mcI$sp();
            this.encodeIntArrayTo(buf, pos, value);
            arr.flush(buf);
            return;
        }
        throw new MatchError(tuple2);
    }

    public void encodeLongArray(ArrayOutput<Object> arr, long[] value) {
        this.encodeInt(arr, value.length);
        Tuple2<Object, Object> tuple2 = arr.target(value.length * this.SizeOfLong());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), (Object)BoxesRunTime.boxToInteger((int)tuple2._2$mcI$sp()));
            byte[] buf = (byte[])tuple22._1();
            int pos = tuple22._2$mcI$sp();
            this.encodeLongArrayTo(buf, pos, value);
            arr.flush(buf);
            return;
        }
        throw new MatchError(tuple2);
    }

    public void encodeFloatArray(ArrayOutput<Object> arr, float[] value) {
        this.encodeInt(arr, value.length);
        Tuple2<Object, Object> tuple2 = arr.target(value.length * this.SizeOfFloat());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), (Object)BoxesRunTime.boxToInteger((int)tuple2._2$mcI$sp()));
            byte[] buf = (byte[])tuple22._1();
            int pos = tuple22._2$mcI$sp();
            this.encodeFloatArrayTo(buf, pos, value);
            arr.flush(buf);
            return;
        }
        throw new MatchError(tuple2);
    }

    public void encodeDoubleArray(ArrayOutput<Object> arr, double[] value) {
        this.encodeInt(arr, value.length);
        Tuple2<Object, Object> tuple2 = arr.target(value.length * this.SizeOfDouble());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), (Object)BoxesRunTime.boxToInteger((int)tuple2._2$mcI$sp()));
            byte[] buf = (byte[])tuple22._1();
            int pos = tuple22._2$mcI$sp();
            this.encodeDoubleArrayTo(buf, pos, value);
            arr.flush(buf);
            return;
        }
        throw new MatchError(tuple2);
    }

    public void encodeCharArray(ArrayOutput<Object> arr, char[] value) {
        this.encodeInt(arr, value.length);
        Tuple2<Object, Object> tuple2 = arr.target(value.length * this.SizeOfChar());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), (Object)BoxesRunTime.boxToInteger((int)tuple2._2$mcI$sp()));
            byte[] buf = (byte[])tuple22._1();
            int pos = tuple22._2$mcI$sp();
            this.encodeCharArrayTo(buf, pos, value);
            arr.flush(buf);
            return;
        }
        throw new MatchError(tuple2);
    }

    public void encodeBooleanArray(ArrayOutput<Object> arr, boolean[] value) {
        this.encodeInt(arr, value.length);
        Tuple2<Object, Object> tuple2 = arr.target(value.length * this.SizeOfBoolean());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), (Object)BoxesRunTime.boxToInteger((int)tuple2._2$mcI$sp()));
            byte[] buf = (byte[])tuple22._1();
            int pos = tuple22._2$mcI$sp();
            this.encodeBooleanArrayTo(buf, pos, value);
            arr.flush(buf);
            return;
        }
        throw new MatchError(tuple2);
    }

    public int encodeByteArrayTo(byte[] arr, int i, byte[] value) {
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i, value.length * this.SizeOfByte());
        return i + value.length * this.SizeOfByte();
    }

    public int encodeShortArrayTo(byte[] arr, int i, short[] value) {
        long srcOffset = UnsafeMemory$.MODULE$.shortArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i, value.length * this.SizeOfShort());
        return i + value.length * this.SizeOfShort();
    }

    public int encodeIntArrayTo(byte[] arr, int i, int[] value) {
        long srcOffset = UnsafeMemory$.MODULE$.intArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i, value.length * this.SizeOfInt());
        return i + value.length * this.SizeOfInt();
    }

    public int encodeLongArrayTo(byte[] arr, int i, long[] value) {
        long srcOffset = UnsafeMemory$.MODULE$.longArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i, value.length * this.SizeOfLong());
        return i + value.length * this.SizeOfLong();
    }

    public int encodeFloatArrayTo(byte[] arr, int i, float[] value) {
        long srcOffset = UnsafeMemory$.MODULE$.floatArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i, value.length * this.SizeOfFloat());
        return i + value.length * this.SizeOfFloat();
    }

    public int encodeDoubleArrayTo(byte[] arr, int i, double[] value) {
        long srcOffset = UnsafeMemory$.MODULE$.doubleArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i, value.length * this.SizeOfDouble());
        return i + value.length * this.SizeOfDouble();
    }

    public int encodeCharArrayTo(byte[] arr, int i, char[] value) {
        long srcOffset = UnsafeMemory$.MODULE$.charArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i, value.length * this.SizeOfChar());
        return i + value.length * this.SizeOfChar();
    }

    public int encodeBooleanArrayTo(byte[] arr, int i, boolean[] value) {
        long srcOffset = UnsafeMemory$.MODULE$.booleanArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i, value.length * this.SizeOfBoolean());
        return i + value.length * this.SizeOfBoolean();
    }

    private Util$() {
        MODULE$ = this;
        this.SizeOfByte = 1;
        this.SizeOfShort = 2;
        this.SizeOfInt = 4;
        this.SizeOfLong = 8;
        this.SizeOfFloat = 4;
        this.SizeOfDouble = 8;
        this.SizeOfChar = 2;
        this.SizeOfBoolean = 1;
    }
}

