/*
 * Decompiled with CFR 0.152.
 */
package scala.pickling.binary;

import scala.Array$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.pickling.binary.UnsafeMemory$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Util$ {
    public static final Util$ MODULE$;

    static {
        new Util$();
    }

    public void copy(byte[] target, int i, byte[] arr) {
        Array$.MODULE$.copy((Object)arr, 0, (Object)target, i, arr.length);
    }

    public short decodeShortFrom(byte[] arr, int i) {
        short fst = (short)(arr[i] << 8 & 0xFFFF);
        short snd = (short)(arr[i + 1] & 0xFF);
        return (short)(fst | snd);
    }

    public char decodeCharFrom(byte[] arr, int i) {
        char fst = (char)(arr[i] << 8 & 0xFFFF);
        char snd = (char)(arr[i + 1] & 0xFF);
        return (char)(fst | snd);
    }

    public int decodeIntFrom(byte[] arr, int i) {
        int fst = arr[i] << 24;
        int snd = arr[i + 1] << 16 & 0xFFFFFF;
        int thrd = arr[i + 2] << 8 & 0xFFFF;
        int frth = arr[i + 3] & 0xFF;
        return fst | snd | thrd | frth;
    }

    public long decodeLongFrom(byte[] arr, int i) {
        long elem1 = (long)arr[i] << 56 & 0xFFFFFFFFFFFFFFFFL;
        long elem2 = (long)arr[i + 1] << 48 & 0xFFFFFFFFFFFFFFL;
        long elem3 = (long)arr[i + 2] << 40 & 0xFFFFFFFFFFFFL;
        long elem4 = (long)arr[i + 3] << 32 & 0xFFFFFFFFFFL;
        long elem5 = (long)arr[i + 4] << 24 & 0xFFFFFFFFL;
        long elem6 = (long)arr[i + 5] << 16 & 0xFFFFFFL;
        long elem7 = (long)arr[i + 6] << 8 & 0xFFFFL;
        long elem8 = (long)arr[i + 7] & 0xFFL;
        return elem1 | elem2 | elem3 | elem4 | elem5 | elem6 | elem7 | elem8;
    }

    public int fastdecodeIntFrom(byte[] arr, int i) {
        int fst = UnsafeMemory$.MODULE$.getInt(arr, i) << 24;
        int snd = UnsafeMemory$.MODULE$.getInt(arr, i + 1) << 16 & 0xFFFFFF;
        int thrd = UnsafeMemory$.MODULE$.getInt(arr, i + 2) << 8 & 0xFFFF;
        int frth = UnsafeMemory$.MODULE$.getInt(arr, i + 3) & 0xFF;
        return fst | snd | thrd | frth;
    }

    public int encodeShortTo(byte[] arr, int i, short value) {
        byte fst = (byte)(value >>> 8 & 0xFF);
        byte snd = (byte)(value & 0xFF);
        arr[i] = fst;
        arr[i + 1] = snd;
        return i + 2;
    }

    public int encodeCharTo(byte[] arr, int i, char value) {
        byte fst = (byte)(value >>> 8 & 0xFF);
        byte snd = (byte)(value & 0xFF);
        arr[i] = fst;
        arr[i + 1] = snd;
        return i + 2;
    }

    public int encodeIntTo(byte[] arr, int i, int value) {
        byte fst = (byte)(value >>> 24);
        byte snd = (byte)(value >>> 16 & 0xFF);
        byte thrd = (byte)(value >>> 8 & 0xFF);
        byte frth = (byte)(value & 0xFF);
        arr[i] = fst;
        arr[i + 1] = snd;
        arr[i + 2] = thrd;
        arr[i + 3] = frth;
        return i + 4;
    }

    public int encodeLongTo(byte[] arr, int i, long value) {
        byte elem1 = (byte)(value >>> 56 & 0xFFL);
        byte elem2 = (byte)(value >>> 48 & 0xFFL);
        byte elem3 = (byte)(value >>> 40 & 0xFFL);
        byte elem4 = (byte)(value >>> 32 & 0xFFL);
        byte elem5 = (byte)(value >>> 24 & 0xFFL);
        byte elem6 = (byte)(value >>> 16 & 0xFFL);
        byte elem7 = (byte)(value >>> 8 & 0xFFL);
        byte elem8 = (byte)(value & 0xFFL);
        arr[i] = elem1;
        arr[i + 1] = elem2;
        arr[i + 2] = elem3;
        arr[i + 3] = elem4;
        arr[i + 4] = elem5;
        arr[i + 5] = elem6;
        arr[i + 6] = elem7;
        arr[i + 7] = elem8;
        return i + 8;
    }

    public int fastencodeIntTo(byte[] arr, int i, int value) {
        byte fst = (byte)(value >>> 24);
        byte snd = (byte)(value >>> 16 & 0xFF);
        byte thrd = (byte)(value >>> 8 & 0xFF);
        byte frth = (byte)(value & 0xFF);
        UnsafeMemory$.MODULE$.putInt(arr, i, fst);
        UnsafeMemory$.MODULE$.putInt(arr, i + 1, snd);
        UnsafeMemory$.MODULE$.putInt(arr, i + 2, thrd);
        UnsafeMemory$.MODULE$.putInt(arr, i + 3, frth);
        return i + 4;
    }

    public void encodeIntTo(Buffer<Object> buf, int i, int value) {
        byte fst = (byte)(value >>> 24);
        byte snd = (byte)(value >>> 16 & 0xFF);
        byte thrd = (byte)(value >>> 8 & 0xFF);
        byte frth = (byte)(value & 0xFF);
        buf.update(i, (Object)BoxesRunTime.boxToByte((byte)fst));
        buf.update(i + 1, (Object)BoxesRunTime.boxToByte((byte)snd));
        buf.update(i + 2, (Object)BoxesRunTime.boxToByte((byte)thrd));
        buf.update(i + 3, (Object)BoxesRunTime.boxToByte((byte)frth));
    }

    public void encodeIntTo(Buffer<Object> buf, int value) {
        byte fst = (byte)(value >>> 24);
        byte snd = (byte)(value >>> 16 & 0xFF);
        byte thrd = (byte)(value >>> 8 & 0xFF);
        byte frth = (byte)(value & 0xFF);
        buf.$plus$eq((Object)BoxesRunTime.boxToByte((byte)fst));
        buf.$plus$eq((Object)BoxesRunTime.boxToByte((byte)snd));
        buf.$plus$eq((Object)BoxesRunTime.boxToByte((byte)thrd));
        buf.$plus$eq((Object)BoxesRunTime.boxToByte((byte)frth));
    }

    public boolean decodeBooleanFrom(byte[] arr, int i) {
        return arr[i] != 0;
    }

    public boolean fastdecodeBooleanFrom(byte[] arr, int i) {
        return UnsafeMemory$.MODULE$.getInt(arr, i) != 0;
    }

    public int encodeBooleanTo(byte[] arr, int i, boolean value) {
        arr[i] = value ? (byte)1 : 0;
        return i + 1;
    }

    public int fastencodeBooleanTo(byte[] arr, int i, boolean value) {
        UnsafeMemory$.MODULE$.putInt(arr, i, value ? 1 : 0);
        return i + 1;
    }

    public int encodeBooleanTo(Buffer<Object> buf, int i, boolean value) {
        buf.$plus$eq((Object)(value ? BoxesRunTime.boxToByte((byte)1) : BoxesRunTime.boxToByte((byte)0)));
        return i + 1;
    }

    public byte[] readBytesFrom(byte[] arr, int i, int len) {
        byte[] subarr = (byte[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Byte());
        Array$.MODULE$.copy((Object)arr, i, (Object)subarr, 0, len);
        return subarr;
    }

    public Tuple2<String, Object> decodeStringFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Byte());
        Array$.MODULE$.copy((Object)arr, i + 4, (Object)bytes, 0, len);
        return new Tuple2((Object)new String(bytes, "UTF-8"), (Object)BoxesRunTime.boxToInteger((int)(i + 4 + len)));
    }

    public Tuple2<String, Object> fastdecodeStringFrom(byte[] arr, int i) {
        int len = this.fastdecodeIntFrom(arr, i);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Byte());
        Array$.MODULE$.copy((Object)arr, i + 4, (Object)bytes, 0, len);
        return new Tuple2((Object)new String(bytes, "UTF-8"), (Object)BoxesRunTime.boxToInteger((int)(i + 4 + len)));
    }

    public int encodeStringTo(byte[] arr, int i, String value) {
        byte[] bytes = value.getBytes("UTF-8");
        this.encodeIntTo(arr, i, bytes.length);
        this.copy(arr, i + 4, bytes);
        return i + 4 + bytes.length;
    }

    public int fastencodeStringTo(byte[] arr, int i, String value) {
        byte[] bytes = value.getBytes("UTF-8");
        int next = this.fastencodeIntTo(arr, i, bytes.length);
        this.copy(arr, next, bytes);
        return next + bytes.length;
    }

    public int encodeStringTo(Buffer<Object> buf, int i, String value) {
        byte[] bytes = value.getBytes("UTF-8");
        this.encodeIntTo(buf, bytes.length);
        buf.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.byteArrayOps(bytes));
        return i + 4 + bytes.length;
    }

    public int encodeByteArrayTo(byte[] arr, int i, byte[] value) {
        this.encodeIntTo(arr, i, value.length);
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i + 4L, value.length * 1);
        return i + 4 + value.length * 1;
    }

    public int encodeShortArrayTo(byte[] arr, int i, short[] value) {
        this.encodeIntTo(arr, i, value.length);
        long srcOffset = UnsafeMemory$.MODULE$.shortArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i + 4L, value.length * 2);
        return i + 4 + value.length * 2;
    }

    public int encodeCharArrayTo(byte[] arr, int i, char[] value) {
        this.encodeIntTo(arr, i, value.length);
        long srcOffset = UnsafeMemory$.MODULE$.charArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i + 4L, value.length * 2);
        return i + 4 + value.length * 2;
    }

    public int encodeIntArrayTo(byte[] arr, int i, int[] value) {
        this.encodeIntTo(arr, i, value.length);
        long srcOffset = UnsafeMemory$.MODULE$.intArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i + 4L, value.length * 4);
        return i + 4 + value.length * 4;
    }

    public int encodeLongArrayTo(byte[] arr, int i, long[] value) {
        this.encodeIntTo(arr, i, value.length);
        long srcOffset = UnsafeMemory$.MODULE$.longArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i + 4L, value.length * 8);
        return i + 4 + value.length * 8;
    }

    public int encodeBooleanArrayTo(byte[] arr, int i, boolean[] value) {
        this.encodeIntTo(arr, i, value.length);
        long srcOffset = UnsafeMemory$.MODULE$.booleanArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i + 4L, value.length * 1);
        return i + 4 + value.length * 1;
    }

    public int encodeFloatArrayTo(byte[] arr, int i, float[] value) {
        this.encodeIntTo(arr, i, value.length);
        long srcOffset = UnsafeMemory$.MODULE$.floatArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i + 4L, value.length * 4);
        return i + 4 + value.length * 4;
    }

    public int encodeDoubleArrayTo(byte[] arr, int i, double[] value) {
        this.encodeIntTo(arr, i, value.length);
        long srcOffset = UnsafeMemory$.MODULE$.doubleArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(value, srcOffset, arr, destOffset + (long)i + 4L, value.length * 8);
        return i + 4 + value.length * 8;
    }

    public Tuple2<byte[], Object> decodeByteArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + 4;
        byte[] ia = (byte[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Byte());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)nextPos, ia, destOffset, len * 1);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * 1)));
    }

    public Tuple2<short[], Object> decodeShortArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + 4;
        short[] ia = (short[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Short());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.shortArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)nextPos, ia, destOffset, len * 2);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * 2)));
    }

    public Tuple2<char[], Object> decodeCharArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + 4;
        char[] ia = (char[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Char());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.charArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)nextPos, ia, destOffset, len * 2);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * 2)));
    }

    public Tuple2<int[], Object> decodeIntArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + 4;
        int[] ia = (int[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Int());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.intArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)nextPos, ia, destOffset, len * 4);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * 4)));
    }

    public Tuple2<long[], Object> decodeLongArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + 4;
        long[] ia = (long[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Long());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.longArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)nextPos, ia, destOffset, len * 8);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * 8)));
    }

    public Tuple2<boolean[], Object> decodeBooleanArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + 4;
        boolean[] ia = (boolean[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Boolean());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.booleanArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)nextPos, ia, destOffset, len * 1);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * 1)));
    }

    public Tuple2<float[], Object> decodeFloatArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + 4;
        float[] ia = (float[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Float());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.floatArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)nextPos, ia, destOffset, len * 4);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * 4)));
    }

    public Tuple2<double[], Object> decodeDoubleArrayFrom(byte[] arr, int i) {
        int len = this.decodeIntFrom(arr, i);
        int nextPos = i + 4;
        double[] ia = (double[])Array$.MODULE$.ofDim(len, ClassTag$.MODULE$.Double());
        long srcOffset = UnsafeMemory$.MODULE$.byteArrayOffset();
        long destOffset = UnsafeMemory$.MODULE$.doubleArrayOffset();
        UnsafeMemory$.MODULE$.unsafe().copyMemory(arr, srcOffset + (long)nextPos, ia, destOffset, len * 8);
        return new Tuple2((Object)ia, (Object)BoxesRunTime.boxToInteger((int)(nextPos + len * 8)));
    }

    private Util$() {
        MODULE$ = this;
    }
}

