/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.LinearSeq;
import scala.collection.LinearSeqOptimized;
import scala.collection.mutable.Builder;
import scala.runtime.BoxesRunTime;

public abstract class LinearSeqOptimized$class {
    public static int length(LinearSeqOptimized $this) {
        LinearSeqOptimized these = $this;
        int len = 0;
        while (!these.isEmpty()) {
            ++len;
            these = (LinearSeqOptimized)these.tail();
        }
        return len;
    }

    public static Object apply(LinearSeqOptimized $this, int n) {
        Object rest = $this.drop(n);
        if (n < 0 || rest.isEmpty()) {
            throw new IndexOutOfBoundsException(String.valueOf(BoxesRunTime.boxToInteger(n)));
        }
        return rest.head();
    }

    public static void foreach(LinearSeqOptimized $this, Function1 f) {
        LinearSeqOptimized these = $this;
        while (!these.isEmpty()) {
            f.apply(these.head());
            these = (LinearSeqOptimized)these.tail();
        }
        return;
    }

    public static boolean forall(LinearSeqOptimized $this, Function1 p) {
        LinearSeqOptimized these = $this;
        while (true) {
            if (these.isEmpty()) {
                return true;
            }
            if (!BoxesRunTime.unboxToBoolean(p.apply(these.head()))) break;
            these = (LinearSeqOptimized)these.tail();
        }
        return false;
    }

    public static boolean exists(LinearSeqOptimized $this, Function1 p) {
        LinearSeqOptimized these = $this;
        while (!these.isEmpty()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                return true;
            }
            these = (LinearSeqOptimized)these.tail();
        }
        return false;
    }

    public static int count(LinearSeqOptimized $this, Function1 p) {
        LinearSeqOptimized these = $this;
        int cnt = 0;
        while (!these.isEmpty()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                ++cnt;
            }
            these = (LinearSeqOptimized)these.tail();
        }
        return cnt;
    }

    public static Option find(LinearSeqOptimized $this, Function1 p) {
        LinearSeqOptimized these = $this;
        while (!these.isEmpty()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                return new Some(these.head());
            }
            these = (LinearSeqOptimized)these.tail();
        }
        return None$.MODULE$;
    }

    public static Object foldLeft(LinearSeqOptimized $this, Object z, Function2 f) {
        Object acc = z;
        LinearSeqOptimized these = $this;
        while (!these.isEmpty()) {
            acc = f.apply(acc, these.head());
            these = (LinearSeqOptimized)these.tail();
        }
        return acc;
    }

    public static Object foldRight(LinearSeqOptimized $this, Object z, Function2 f) {
        return $this.isEmpty() ? z : f.apply($this.head(), ((LinearSeqOptimized)$this.tail()).foldRight(z, f));
    }

    public static Object reduceLeft(LinearSeqOptimized $this, Function2 f) {
        if ($this.isEmpty()) {
            throw new UnsupportedOperationException("empty.reduceLeft");
        }
        return ((LinearSeqOptimized)$this.tail()).foldLeft($this.head(), f);
    }

    public static Object reduceRight(LinearSeqOptimized $this, Function2 op) {
        if ($this.isEmpty()) {
            throw new UnsupportedOperationException("Nil.reduceRight");
        }
        return ((IterableLike)$this.tail()).isEmpty() ? $this.head() : op.apply($this.head(), ((LinearSeqOptimized)$this.tail()).reduceRight(op));
    }

    public static Object last(LinearSeqOptimized $this) {
        if ($this.isEmpty()) {
            throw new NoSuchElementException();
        }
        LinearSeqOptimized these = $this;
        LinearSeqOptimized nx = (LinearSeqOptimized)these.tail();
        while (!nx.isEmpty()) {
            these = nx;
            nx = (LinearSeqOptimized)nx.tail();
        }
        return these.head();
    }

    public static LinearSeqOptimized take(LinearSeqOptimized $this, int n) {
        Builder b = $this.newBuilder();
        int i = 0;
        LinearSeqOptimized these = (LinearSeqOptimized)$this.repr();
        while (!these.isEmpty() && i < n) {
            ++i;
            b.$plus$eq(these.head());
            these = (LinearSeqOptimized)these.tail();
        }
        return (LinearSeqOptimized)b.result();
    }

    /*
     * WARNING - void declaration
     */
    public static LinearSeqOptimized drop(LinearSeqOptimized $this, int n) {
        void var2_2;
        LinearSeqOptimized these = (LinearSeqOptimized)$this.repr();
        for (int count2 = n; !these.isEmpty() && count2 > 0; --count2) {
            these = (LinearSeqOptimized)these.tail();
        }
        return var2_2;
    }

    public static LinearSeqOptimized dropRight(LinearSeqOptimized $this, int n) {
        Builder b = $this.newBuilder();
        LinearSeqOptimized these = $this;
        Object lead = $this.drop(n);
        while (!lead.isEmpty()) {
            b.$plus$eq(these.head());
            these = (LinearSeqOptimized)these.tail();
            lead = (LinearSeqOptimized)lead.tail();
        }
        return (LinearSeqOptimized)b.result();
    }

    public static LinearSeqOptimized slice(LinearSeqOptimized $this, int from2, int until2) {
        LinearSeqOptimized these = (LinearSeqOptimized)$this.repr();
        int count2 = Predef$.MODULE$.intWrapper(from2).max(0);
        if (until2 <= count2) {
            return (LinearSeqOptimized)$this.newBuilder().result();
        }
        Builder b = $this.newBuilder();
        int sliceElems = until2 - count2;
        while (these.nonEmpty() && count2 > 0) {
            these = (LinearSeqOptimized)these.tail();
            --count2;
        }
        while (these.nonEmpty() && sliceElems > 0) {
            --sliceElems;
            b.$plus$eq(these.head());
            these = (LinearSeqOptimized)these.tail();
        }
        return (LinearSeqOptimized)b.result();
    }

    public static LinearSeqOptimized takeWhile(LinearSeqOptimized $this, Function1 p) {
        Builder b = $this.newBuilder();
        LinearSeqOptimized these = $this;
        while (!these.isEmpty() && BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
            b.$plus$eq(these.head());
            these = (LinearSeqOptimized)these.tail();
        }
        return (LinearSeqOptimized)b.result();
    }

    public static Tuple2 span(LinearSeqOptimized $this, Function1 p) {
        LinearSeqOptimized these = (LinearSeqOptimized)$this.repr();
        Builder b = $this.newBuilder();
        while (!these.isEmpty() && BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
            b.$plus$eq(these.head());
            these = (LinearSeqOptimized)these.tail();
        }
        return new Tuple2(b.result(), these);
    }

    public static boolean sameElements(LinearSeqOptimized $this, GenIterable that) {
        boolean bl;
        GenIterable genIterable = that;
        if (genIterable instanceof LinearSeq) {
            LinearSeq linearSeq;
            LinearSeq that1 = linearSeq = (LinearSeq)genIterable;
            LinearSeqOptimized these = $this;
            LinearSeq those = that1;
            while (!these.isEmpty() && !those.isEmpty() && BoxesRunTime.equals(these.head(), those.head())) {
                these = (LinearSeqOptimized)these.tail();
                those = (LinearSeq)those.tail();
            }
            bl = these.isEmpty() && those.isEmpty();
        } else {
            bl = $this.scala$collection$LinearSeqOptimized$$super$sameElements(that);
        }
        return bl;
    }

    public static int lengthCompare(LinearSeqOptimized $this, int len) {
        int i = 0;
        LinearSeqOptimized these = $this;
        while (!these.isEmpty() && i <= len) {
            ++i;
            these = (LinearSeqOptimized)these.tail();
        }
        return i - len;
    }

    public static boolean isDefinedAt(LinearSeqOptimized $this, int x2) {
        return x2 >= 0 && $this.lengthCompare(x2) > 0;
    }

    /*
     * WARNING - void declaration
     */
    public static int segmentLength(LinearSeqOptimized $this, Function1 p, int from2) {
        void var3_3;
        int i = 0;
        Object these = $this.drop(from2);
        while (!these.isEmpty() && BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
            ++i;
            these = (LinearSeqOptimized)these.tail();
        }
        return (int)var3_3;
    }

    public static int indexWhere(LinearSeqOptimized $this, Function1 p, int from2) {
        int i = from2;
        Object these = $this.drop(from2);
        while (these.nonEmpty()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                return i;
            }
            ++i;
            these = (LinearSeqOptimized)these.tail();
        }
        return -1;
    }

    public static int lastIndexWhere(LinearSeqOptimized $this, Function1 p, int end) {
        LinearSeqOptimized these = $this;
        int last2 = -1;
        for (int i = 0; !these.isEmpty() && i <= end; ++i) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                last2 = i;
            }
            these = (LinearSeqOptimized)these.tail();
        }
        return last2;
    }

    public static void $init$(LinearSeqOptimized $this) {
    }
}

