/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JCodeAttribute;
import ch.epfl.lamp.fjbg.JCodeIterator;
import ch.epfl.lamp.fjbg.JConstantPool;
import ch.epfl.lamp.fjbg.JFieldOrMethod;
import ch.epfl.lamp.fjbg.JLocalVariable;
import ch.epfl.lamp.fjbg.JMethodType;
import ch.epfl.lamp.fjbg.JType;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;

public class JMethod
extends JFieldOrMethod {
    public static final String CLASS_CONSTRUCTOR_NAME = "<clinit>";
    public static final String INSTANCE_CONSTRUCTOR_NAME = "<init>";
    protected final JCode code;
    protected final String[] argNames;
    protected final LinkedList localVariables;
    protected int localVariableIndex;

    protected JMethod(FJBGContext context, JClass owner, int accessFlags, String name, JType returnType, JType[] argTypes, String[] argNames) {
        super(context, owner, accessFlags, name, new JMethodType(returnType, argTypes));
        this.localVariables = new LinkedList();
        this.localVariableIndex = 0;
        this.argNames = argNames;
        assert (argTypes.length == argNames.length);
        if (this.isAbstract() || this.isNative()) {
            this.code = null;
        } else {
            JConstantPool pool = owner.getConstantPool();
            this.code = context.JCode(owner, this);
            this.addAttribute(context.JCodeAttribute(owner, this));
            if (!this.isStatic()) {
                this.addNewLocalVariable(owner.getType(), "this");
            }
            for (int i = 0; i < argTypes.length; ++i) {
                this.addNewLocalVariable(argTypes[i], argNames[i]);
            }
        }
    }

    protected JMethod(FJBGContext context, JClass owner, DataInputStream stream) throws IOException {
        block1: {
            super(context, owner, stream);
            this.localVariables = new LinkedList();
            this.localVariableIndex = 0;
            for (Object attr : this.attributes) {
                if (!(attr instanceof JCodeAttribute)) continue;
                this.code = ((JCodeAttribute)attr).code;
                break block1;
            }
            this.code = null;
        }
        this.argNames = null;
    }

    public void freeze() throws JCode.OffsetTooBigException {
        if (this.code != null) {
            this.code.freeze();
        }
        super.freeze();
    }

    public JType getReturnType() {
        return ((JMethodType)this.type).getReturnType();
    }

    public JType[] getArgumentTypes() {
        return ((JMethodType)this.type).getArgumentTypes();
    }

    public String[] getArgumentNames() {
        return this.argNames;
    }

    public JCode getCode() {
        assert (!this.isAbstract());
        return this.code;
    }

    public JCodeIterator codeIterator() {
        return new JCodeIterator(this.code);
    }

    public JLocalVariable addNewLocalVariable(JType type, String name) {
        assert (!this.frozen);
        JLocalVariable var = this.context.JLocalVariable(this, type, name, this.localVariableIndex);
        this.localVariableIndex += type.getSize();
        this.localVariables.add(var);
        return var;
    }

    public JLocalVariable getLocalVariable(int index) {
        for (int i = 0; i < this.localVariables.size(); ++i) {
            if (((JLocalVariable)this.localVariables.get((int)i)).index != index) continue;
            return (JLocalVariable)this.localVariables.get(i);
        }
        return null;
    }

    public JLocalVariable[] getLocalVariables() {
        return this.localVariables.toArray(new JLocalVariable[this.localVariables.size()]);
    }

    public int getMaxLocals() {
        return this.localVariableIndex;
    }
}

