/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.io.Codec;
import scala.io.Source;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.tools.nsc.io.Directory;
import scala.tools.nsc.io.File$;
import scala.tools.nsc.io.FileOperationException;
import scala.tools.nsc.io.Path;
import scala.tools.nsc.io.Path$;
import scala.tools.nsc.io.Streamable;
import scala.tools.nsc.io.Streamable$Bytes$class;
import scala.tools.nsc.io.Streamable$Chars$class;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class File
extends Path
implements Streamable.Chars,
ScalaObject {
    private final Codec creationCodec;

    public static final java.io.File makeTemp$default$3() {
        return File$.MODULE$.makeTemp$default$3();
    }

    public static final String makeTemp$default$2() {
        return File$.MODULE$.makeTemp$default$2();
    }

    public static final String makeTemp$default$1() {
        return File$.MODULE$.makeTemp$default$1();
    }

    public static final Codec init$default$2(java.io.File file) {
        return File$.MODULE$.init$default$2(file);
    }

    public static final Codec apply$default$2(Path path) {
        return File$.MODULE$.apply$default$2(path);
    }

    public static final void closeQuietly(Object object) {
        File$.MODULE$.closeQuietly(object);
    }

    public static final File makeTemp(String string, String string2, java.io.File file) {
        return File$.MODULE$.makeTemp(string, string2, file);
    }

    public static final File apply(Path path, Codec codec) {
        return File$.MODULE$.apply(path, codec);
    }

    public static final String pathSeparator() {
        return File$.MODULE$.pathSeparator();
    }

    public File(java.io.File jfile, Codec creationCodec) {
        this.creationCodec = creationCodec;
        super(jfile);
        Streamable$Bytes$class.$init$(this);
        Streamable$Chars$class.$init$(this);
    }

    private final FileChannel out$2(File file, ObjectRef objectRef, ObjectRef objectRef2, IntRef intRef) {
        if ((intRef.elem & 8) == 0) {
            objectRef2.elem = this.out_s$1(file, objectRef, intRef).getChannel();
            intRef.elem |= 8;
        }
        return (FileChannel)objectRef2.elem;
    }

    private final FileChannel in$1(ObjectRef objectRef, ObjectRef objectRef2, IntRef intRef) {
        if ((intRef.elem & 4) == 0) {
            objectRef2.elem = this.in_s$1(objectRef, intRef).getChannel();
            intRef.elem |= 4;
        }
        return (FileChannel)objectRef2.elem;
    }

    private final FileOutputStream out_s$1(File file, ObjectRef objectRef, IntRef intRef) {
        if ((intRef.elem & 2) == 0) {
            objectRef.elem = file.outputStream(file.outputStream$default$1());
            intRef.elem |= 2;
        }
        return (FileOutputStream)objectRef.elem;
    }

    private final FileInputStream in_s$1(ObjectRef objectRef, IntRef intRef) {
        if ((intRef.elem & 1) == 0) {
            objectRef.elem = this.inputStream();
            intRef.elem |= 1;
        }
        return (FileInputStream)objectRef.elem;
    }

    @Override
    public String toString() {
        return Predef$.MODULE$.augmentString("File(%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyFile(Path destPath, boolean preserveFileDate) {
        IntRef bitmap$0$1 = new IntRef(0);
        int FIFTY_MB = 0x3200000;
        File dest$1 = destPath.toFile();
        if (!this.isValid()) {
            String string = "Source %s is not a valid file.";
            throw Path$.MODULE$.fail(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
        }
        Path path = this.normalize();
        Path path2 = dest$1.normalize();
        if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
            String string = "Source and destination are the same.";
            throw new FileOperationException(string);
        }
        if (!dest$1.parent().exists()) {
            throw Path$.MODULE$.fail("Destination cannot be created.");
        }
        if (dest$1.exists() && !dest$1.canWrite()) {
            String string = "Destination exists but is not writable.";
            throw new FileOperationException(string);
        }
        if (dest$1.isDirectory()) {
            String string = "Destination exists but is a directory.";
            throw new FileOperationException(string);
        }
        ObjectRef in_s$lzy$1 = new ObjectRef(null);
        ObjectRef out_s$lzy$1 = new ObjectRef(null);
        ObjectRef in$lzy$1 = new ObjectRef(null);
        ObjectRef out$lzy$1 = new ObjectRef(null);
        try {
            long count2;
            long size2 = this.in$1(in_s$lzy$1, in$lzy$1, bitmap$0$1).size();
            for (long pos = 0L; pos < size2; pos += this.out$2(dest$1, out_s$lzy$1, out$lzy$1, bitmap$0$1).transferFrom(this.in$1(in_s$lzy$1, in$lzy$1, bitmap$0$1), pos, count2)) {
                long l = size2 - pos;
                count2 = new RichLong(l).min((long)FIFTY_MB);
            }
        }
        catch (Throwable throwable) {
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.out$2(dest$1, out_s$lzy$1, out$lzy$1, bitmap$0$1), this.out_s$1(dest$1, out_s$lzy$1, bitmap$0$1), this.in$1(in_s$lzy$1, in$lzy$1, bitmap$0$1), this.in_s$1(in_s$lzy$1, bitmap$0$1)})).foreach((Function1)new $anonfun$copyFile$1(this));
            throw throwable;
        }
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.out$2(dest$1, out_s$lzy$1, out$lzy$1, bitmap$0$1), this.out_s$1(dest$1, out_s$lzy$1, bitmap$0$1), this.in$1(in_s$lzy$1, in$lzy$1, bitmap$0$1), this.in_s$1(in_s$lzy$1, bitmap$0$1)})).foreach((Function1)new $anonfun$copyFile$1(this));
        if (this.length() != dest$1.length()) {
            String string = "Failed to completely copy %s to %s";
            throw Path$.MODULE$.fail(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), dest$1.name()})));
        }
        if (preserveFileDate) {
            dest$1.lastModified_$eq(this.lastModified());
        }
    }

    public void writeAll(Traversable<String> xs, boolean append2, Codec codec) {
        BufferedWriter out$1 = this.bufferedWriter(append2, codec);
        try {
            xs.foreach((Function1)new $anonfun$writeAll$1(this, out$1));
            return;
        }
        finally {
            out$1.close();
        }
    }

    public BufferedWriter bufferedWriter(boolean append2, Codec codec) {
        return new BufferedWriter(this.writer(append2, codec));
    }

    public OutputStreamWriter writer(boolean append2, Codec codec) {
        return new OutputStreamWriter((OutputStream)this.outputStream(append2), codec.charSet());
    }

    public BufferedOutputStream bufferedOutput(boolean append2) {
        return new BufferedOutputStream(this.outputStream(append2));
    }

    public FileOutputStream outputStream(boolean append2) {
        return new FileOutputStream(super.jfile(), append2);
    }

    @Override
    public FileInputStream inputStream() {
        return new FileInputStream(super.jfile());
    }

    @Override
    public long length() {
        return super.length();
    }

    @Override
    public boolean isValid() {
        return super.jfile().isFile() || !super.jfile().exists();
    }

    @Override
    public File toFile() {
        return this;
    }

    @Override
    public Directory toDirectory() {
        return new Directory(super.jfile());
    }

    public File withCodec(Codec codec) {
        return new File(super.jfile(), codec);
    }

    @Override
    public Codec creationCodec() {
        return this.creationCodec;
    }

    public /* synthetic */ boolean bufferedOutput$default$1() {
        return false;
    }

    public /* synthetic */ boolean outputStream$default$1() {
        return false;
    }

    public /* synthetic */ boolean writeAll$default$2() {
        return false;
    }

    public /* synthetic */ Codec writeAll$default$3() {
        return this.getCodec(this.getCodec$default$1(), this.getCodec$default$2());
    }

    public /* synthetic */ boolean writer$default$1() {
        return false;
    }

    public /* synthetic */ Codec writer$default$2() {
        return this.getCodec(this.getCodec$default$1(), this.getCodec$default$2());
    }

    public /* synthetic */ boolean bufferedWriter$default$1() {
        return false;
    }

    public /* synthetic */ Codec bufferedWriter$default$2() {
        return this.getCodec(this.getCodec$default$1(), this.getCodec$default$2());
    }

    public /* synthetic */ boolean copyFile$default$2() {
        return false;
    }

    @Override
    public byte[] toByteArray() {
        return Streamable$Bytes$class.toByteArray(this);
    }

    public Iterator bytesAsInts() {
        return Streamable$Bytes$class.bytesAsInts(this);
    }

    public Iterator bytes() {
        return Streamable$Bytes$class.bytes(this);
    }

    @Override
    public BufferedInputStream bufferedInput() {
        return Streamable$Bytes$class.bufferedInput(this);
    }

    @Override
    public /* synthetic */ Codec lines$default$1() {
        return Streamable$Chars$class.lines$default$1(this);
    }

    @Override
    public /* synthetic */ boolean getCodec$default$2() {
        return Streamable$Chars$class.getCodec$default$2(this);
    }

    @Override
    public /* synthetic */ Codec getCodec$default$1() {
        return Streamable$Chars$class.getCodec$default$1(this);
    }

    @Override
    public /* synthetic */ Codec chars$default$1() {
        return Streamable$Chars$class.chars$default$1(this);
    }

    @Override
    public /* synthetic */ Codec slurp$default$1() {
        return Streamable$Chars$class.slurp$default$1(this);
    }

    @Override
    public /* synthetic */ Codec reader$default$1() {
        return Streamable$Chars$class.reader$default$1(this);
    }

    @Override
    public /* synthetic */ Codec bufferedReader$default$1() {
        return Streamable$Chars$class.bufferedReader$default$1(this);
    }

    @Override
    public String slurp(Codec codec) {
        return Streamable$Chars$class.slurp(this, codec);
    }

    @Override
    public BufferedReader bufferedReader(Codec codec) {
        return Streamable$Chars$class.bufferedReader(this, codec);
    }

    @Override
    public InputStreamReader reader(Codec codec) {
        return Streamable$Chars$class.reader(this, codec);
    }

    public Iterator lines(Codec codec) {
        return Streamable$Chars$class.lines(this, codec);
    }

    @Override
    public Source chars(Codec codec) {
        return Streamable$Chars$class.chars(this, codec);
    }

    @Override
    public Codec getCodec(Codec givenCodec, boolean allowDefault) {
        return Streamable$Chars$class.getCodec(this, givenCodec, allowDefault);
    }
}

