/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import jline.CompletionHandler;
import jline.ConsoleReader;
import jline.CursorBuffer;

public class CandidateListCompletionHandler
implements CompletionHandler {
    private static ResourceBundle loc = ResourceBundle.getBundle((class$jline$CandidateListCompletionHandler == null ? (class$jline$CandidateListCompletionHandler = CandidateListCompletionHandler.class$("jline.CandidateListCompletionHandler")) : class$jline$CandidateListCompletionHandler).getName());
    private boolean eagerNewlines = true;
    static /* synthetic */ Class class$jline$CandidateListCompletionHandler;

    public void setAlwaysIncludeNewline(boolean eagerNewlines) {
        this.eagerNewlines = eagerNewlines;
    }

    public boolean complete(ConsoleReader reader, List candidates2, int pos) throws IOException {
        CursorBuffer buf = reader.getCursorBuffer();
        if (candidates2.size() == 1) {
            String value = candidates2.get(0).toString();
            if (value.equals(buf.toString())) {
                return false;
            }
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
            return true;
        }
        if (candidates2.size() > 1) {
            String value = this.getUnambiguousCompletions(candidates2);
            String bufString = buf.toString();
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
        }
        if (this.eagerNewlines) {
            reader.printNewline();
        }
        this.printCandidates(reader, candidates2);
        reader.drawLine();
        return true;
    }

    private static void setBuffer(ConsoleReader reader, String value, int offset) throws IOException {
        while (reader.getCursorBuffer().cursor > offset && reader.backspace()) {
        }
        reader.putString(value);
        reader.setCursorPosition(offset + value.length());
    }

    private final void printCandidates(ConsoleReader reader, Collection candidates2) throws IOException {
        HashSet distinct = new HashSet(candidates2);
        if (distinct.size() > reader.getAutoprintThreshhold()) {
            int c;
            if (!this.eagerNewlines) {
                reader.printNewline();
            }
            reader.printString(MessageFormat.format(loc.getString("display-candidates"), new Integer(candidates2.size())) + " ");
            reader.flushConsole();
            String noOpt = loc.getString("display-candidates-no");
            String yesOpt = loc.getString("display-candidates-yes");
            while ((c = reader.readCharacter(new char[]{yesOpt.charAt(0), noOpt.charAt(0)})) != -1) {
                if (noOpt.startsWith(new String(new char[]{(char)c}))) {
                    reader.printNewline();
                    return;
                }
                if (yesOpt.startsWith(new String(new char[]{(char)c}))) break;
                reader.beep();
            }
        }
        if (distinct.size() != candidates2.size()) {
            ArrayList copy = new ArrayList();
            Iterator i = candidates2.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (copy.contains(next)) continue;
                copy.add(next);
            }
            candidates2 = copy;
        }
        reader.printNewline();
        reader.printColumns(candidates2);
    }

    private final String getUnambiguousCompletions(List candidates2) {
        if (candidates2 == null || candidates2.size() == 0) {
            return null;
        }
        String[] strings = candidates2.toArray(new String[candidates2.size()]);
        String first = strings[0];
        StringBuffer candidate = new StringBuffer();
        for (int i = 0; i < first.length() && this.startsWith(first.substring(0, i + 1), strings); ++i) {
            candidate.append(first.charAt(i));
        }
        return candidate.toString();
    }

    private final boolean startsWith(String starts, String[] candidates2) {
        for (int i = 0; i < candidates2.length; ++i) {
            if (candidates2[i].startsWith(starts)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

