/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.util;

import ch.epfl.lamp.compiler.msil.PEFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

public abstract class Table {
    public static final int MAX_NUMBER = 64;
    public static final long VALID_TABLES_MASK = 4394820566871L;
    public static final int TABLE_SET_LENGTH = 12;
    public static final int _TypeDefOrRef = 0;
    public static final int _HasConstant = 1;
    public static final int _HasCustomAttribute = 2;
    public static final int _HasFieldMarshal = 3;
    public static final int _HasDeclSecurity = 4;
    public static final int _MemberRefParent = 5;
    public static final int _HasSemantics = 6;
    public static final int _MethodDefOrRef = 7;
    public static final int _MemberForwarded = 8;
    public static final int _Implementation = 9;
    public static final int _CustomAttributeType = 10;
    public static final int _ResolutionScope = 11;
    public static final int[][] TableSet;
    public static final int[] NoBits;
    private static final String[] tableName;
    public final int rows;
    public final int id;
    protected final PEFile file;
    protected ByteBuffer buffer;
    protected boolean newMapping = false;
    public final boolean isShort;
    private int rowSize = -1;
    private long start = -1L;
    private int currentRow = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static int getMask(int n) {
        return (1 << NoBits[n]) - 1;
    }

    public static int getTableId(int n, int n2) {
        return TableSet[n][n2 & Table.getMask(n)];
    }

    public static int getTableIndex(int n, int n2) {
        return n2 >> NoBits[n];
    }

    public static int encodeIndex(int n, int n2, int n3) {
        int[] nArray = TableSet[n2];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n3) continue;
            return n << NoBits[n2] | i;
        }
        throw new RuntimeException("Cannot find table #" + n3 + " in table set #" + n2);
    }

    public static Table newTable(PEFile pEFile, int n, int n2) {
        Table table = null;
        switch (n) {
            case 0: {
                table = new ModuleDef(pEFile, n2);
                break;
            }
            case 1: {
                table = new TypeRef(pEFile, n2);
                break;
            }
            case 2: {
                table = new TypeDef(pEFile, n2);
                break;
            }
            case 3: {
                table = new FieldTrans(pEFile, n2);
                break;
            }
            case 4: {
                table = new FieldDef(pEFile, n2);
                break;
            }
            case 5: {
                table = new MethodTrans(pEFile, n2);
                break;
            }
            case 6: {
                table = new MethodDef(pEFile, n2);
                break;
            }
            case 8: {
                table = new ParamDef(pEFile, n2);
                break;
            }
            case 9: {
                table = new InterfaceImpl(pEFile, n2);
                break;
            }
            case 10: {
                table = new MemberRef(pEFile, n2);
                break;
            }
            case 11: {
                table = new Constant(pEFile, n2);
                break;
            }
            case 12: {
                table = new CustomAttribute(pEFile, n2);
                break;
            }
            case 13: {
                table = new FieldMarshal(pEFile, n2);
                break;
            }
            case 14: {
                table = new DeclSecurity(pEFile, n2);
                break;
            }
            case 15: {
                table = new ClassLayout(pEFile, n2);
                break;
            }
            case 16: {
                table = new FieldLayout(pEFile, n2);
                break;
            }
            case 17: {
                table = new StandAloneSig(pEFile, n2);
                break;
            }
            case 18: {
                table = new EventMap(pEFile, n2);
                break;
            }
            case 20: {
                table = new EventDef(pEFile, n2);
                break;
            }
            case 21: {
                table = new PropertyMap(pEFile, n2);
                break;
            }
            case 23: {
                table = new PropertyDef(pEFile, n2);
                break;
            }
            case 24: {
                table = new MethodSemantics(pEFile, n2);
                break;
            }
            case 25: {
                table = new MethodImpl(pEFile, n2);
                break;
            }
            case 26: {
                table = new ModuleRef(pEFile, n2);
                break;
            }
            case 27: {
                table = new TypeSpec(pEFile, n2);
                break;
            }
            case 28: {
                table = new ImplMap(pEFile, n2);
                break;
            }
            case 29: {
                table = new FieldRVA(pEFile, n2);
                break;
            }
            case 32: {
                table = new AssemblyDef(pEFile, n2);
                break;
            }
            case 33: {
                table = new AssemblyProcessor(pEFile, n2);
                break;
            }
            case 34: {
                table = new AssemblyOS(pEFile, n2);
                break;
            }
            case 35: {
                table = new AssemblyRef(pEFile, n2);
                break;
            }
            case 36: {
                table = new AssemblyRefProcessor(pEFile, n2);
                break;
            }
            case 37: {
                table = new AssemblyRefOS(pEFile, n2);
                break;
            }
            case 38: {
                table = new FileDef(pEFile, n2);
                break;
            }
            case 39: {
                table = new ExportedType(pEFile, n2);
                break;
            }
            case 40: {
                table = new ManifestResource(pEFile, n2);
                break;
            }
            case 41: {
                table = new NestedClass(pEFile, n2);
                break;
            }
            default: {
                table = new Empty(n);
            }
        }
        return table;
    }

    protected Table(PEFile pEFile, int n, int n2) {
        this.file = pEFile;
        this.id = n;
        this.rows = n2;
        this.isShort = n2 < 65536;
    }

    public final long init(long l) {
        if (this.rows < 1) {
            return l;
        }
        if (this.start != -1L) {
            throw new RuntimeException("Cannot re-initialize table '" + this.getTableName() + "'");
        }
        this.start = l;
        this.rowSize = this.getRowSize();
        int n = this.rows * this.rowSize();
        this.buffer = this.newMapping ? this.file.mapBuffer(l, n) : this.file.getBuffer(l, n);
        return l + (long)n;
    }

    public final String getTableName() {
        return 0 <= this.id && this.id < 64 ? tableName[this.id] : "<NoTable>";
    }

    public final int rowSize() {
        return this.rowSize;
    }

    public void load() {
        if (this.buffer instanceof MappedByteBuffer) {
            ((MappedByteBuffer)this.buffer).load();
        }
    }

    public final int readByte() {
        return this.buffer.get() + 256 & 0xFF;
    }

    public final int readShort() {
        return this.buffer.getShort() + 65536 & 0xFFFF;
    }

    public final int readInt() {
        return this.buffer.getInt();
    }

    public final int readStringIndex() {
        return this.file.StringIsShort ? this.readShort() : this.readInt();
    }

    public final int readBlobIndex() {
        return this.file.BlobIsShort ? this.readShort() : this.readInt();
    }

    public final int readGUIDIndex() {
        return this.file.GUIDIsShort ? this.readShort() : this.readInt();
    }

    public final int readTableIndex(int n) {
        return this.file.getTable((int)n).isShort ? this.readShort() : this.readInt();
    }

    public final int readTableSetIndex(int n) {
        return this.file.indexSize[n] == 2 ? this.readShort() : this.readInt();
    }

    public final void readRow(int n) {
        this.seekRow(n);
        int n2 = this.buffer.position();
        this.populateFields();
        int n3 = this.buffer.position() - n2;
        if (n3 != this.rowSize()) {
            throw new RuntimeException("Table ID=0x" + PEFile.byte2hex(this.id) + ": read row size = " + n3 + "; expected row size = " + this.rowSize());
        }
        this.currentRow = n;
    }

    protected final void seekRow(int n) {
        if (!($assertionsDisabled || n > 0 && n <= this.rows)) {
            throw new AssertionError((Object)("Index " + n + " is not within the table with #rows = " + this.rows));
        }
        this.buffer.position((n - 1) * this.rowSize());
    }

    public final int currentRow() {
        return this.currentRow;
    }

    public final void nextRow() {
        this.readRow(this.currentRow() + 1);
    }

    protected abstract void populateFields();

    protected abstract int getRowSize();

    static {
        $assertionsDisabled = !Table.class.desiredAssertionStatus();
        TableSet = new int[12][];
        Table.TableSet[0] = new int[]{2, 1, 27};
        Table.TableSet[1] = new int[]{4, 8, 23};
        Table.TableSet[2] = new int[]{6, 4, 1, 2, 8, 9, 10, 0, -1, 23, 20, -1, 26, 27, 32, 35, 38, 39, 40};
        Table.TableSet[3] = new int[]{4, 8};
        Table.TableSet[4] = new int[]{2, 6, 32};
        Table.TableSet[5] = new int[]{-1, 1, 26, 6, 27};
        Table.TableSet[6] = new int[]{20, 23};
        Table.TableSet[7] = new int[]{6, 10};
        Table.TableSet[8] = new int[]{4, 6};
        Table.TableSet[9] = new int[]{38, 35, 39};
        Table.TableSet[10] = new int[]{-1, -1, 6, 10, -1};
        Table.TableSet[11] = new int[]{0, 26, 35, 1};
        NoBits = new int[]{2, 2, 5, 1, 2, 3, 1, 1, 1, 2, 3, 2};
        tableName = new String[]{"Module", "TypeRef", "TypeDef", "   FieldTrans", "Field", "MethodTrans", "Method", "", "Param", "InterfaceImpl", "MemberRef", "Constant", "CustomAttribute", "FieldMarshal", "DeclSecurity", "ClassLayout", "FieldLayout", "StandAloneSig", "EventMap", "", "Event", "PropertyMap", "", "Property", "MethodSemantics", "MethodImpl", "ModuleRef", "TypeSpec", "ImplMap", "FieldRVA", "", "", "Assembly", "AssemblyProcessor", "AssemblyOS", "AssemblyRef", "AssemblyRefProcessor", "AssemblyRefOS", "File", "ExportedType", "ManifestResource", "NestedClass", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    }

    public static final class NestedClass
    extends Table {
        public static final int ID = 41;
        public int NestedClass;
        public int EnclosingClass;

        public NestedClass(PEFile pEFile, int n) {
            super(pEFile, 41, n);
        }

        protected void populateFields() {
            this.NestedClass = this.readTableIndex(2);
            this.EnclosingClass = this.readTableIndex(2);
        }

        protected int getRowSize() {
            return 2 * this.file.getTableIndexSize(2);
        }
    }

    public static final class ManifestResource
    extends Table {
        public static final int ID = 40;
        public int Offset;
        public int Flags;
        public int Name;
        public int Implementation;

        public ManifestResource(PEFile pEFile, int n) {
            super(pEFile, 40, n);
        }

        protected void populateFields() {
            this.Offset = this.readInt();
            this.Flags = this.readInt();
            this.Name = this.readStringIndex();
            this.Implementation = this.readTableSetIndex(9);
        }

        protected int getRowSize() {
            return 8 + this.file.getStringIndexSize() + this.file.getTableSetIndexSize(9);
        }
    }

    public static final class ExportedType
    extends Table {
        public static final int ID = 39;
        public int Flags;
        public int TypeDefId;
        public int TypeName;
        public int TypeNamespace;
        public int Implementation;

        public ExportedType(PEFile pEFile, int n) {
            super(pEFile, 39, n);
        }

        protected void populateFields() {
            this.Flags = this.readInt();
            this.TypeDefId = this.readInt();
            this.TypeName = this.readStringIndex();
            this.TypeNamespace = this.readStringIndex();
            this.Implementation = this.readTableSetIndex(9);
        }

        protected int getRowSize() {
            return 8 + 2 * this.file.getStringIndexSize() + this.file.getTableSetIndexSize(9);
        }

        public String getFullName() {
            String string = this.file.getString(this.TypeNamespace);
            return string.length() == 0 ? this.file.getString(this.TypeName) : string + "." + this.file.getString(this.TypeName);
        }
    }

    public static final class FileDef
    extends Table {
        public static final int ID = 38;
        public int Flags;
        public int Name;
        public int HashValue;

        public FileDef(PEFile pEFile, int n) {
            super(pEFile, 38, n);
        }

        protected void populateFields() {
            this.Flags = this.readInt();
            this.Name = this.readStringIndex();
            this.HashValue = this.readBlobIndex();
        }

        protected int getRowSize() {
            return 4 + this.file.getStringIndexSize() + this.file.getBlobIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class AssemblyRefOS
    extends Table {
        public static final int ID = 37;
        public int OSPlatformId;
        public int OSMajorVersion;
        public int OSMinorVersion;
        public int AssemblyRef;

        public AssemblyRefOS(PEFile pEFile, int n) {
            super(pEFile, 37, n);
        }

        protected void populateFields() {
            this.OSPlatformId = this.readInt();
            this.OSMajorVersion = this.readInt();
            this.OSMinorVersion = this.readInt();
            this.AssemblyRef = this.readTableIndex(35);
        }

        protected int getRowSize() {
            return 12 + this.file.getTableIndexSize(35);
        }
    }

    public static final class AssemblyRefProcessor
    extends Table {
        public static final int ID = 36;
        public int Processor;
        public int AssemblyRef;

        public AssemblyRefProcessor(PEFile pEFile, int n) {
            super(pEFile, 36, n);
        }

        protected void populateFields() {
            this.Processor = this.readInt();
            this.AssemblyRef = this.readTableIndex(35);
        }

        protected int getRowSize() {
            return 4 + this.file.getTableIndexSize(35);
        }
    }

    public static final class AssemblyRef
    extends Table {
        public static final int ID = 35;
        public int MajorVersion;
        public int MinorVersion;
        public int BuildNumber;
        public int RevisionNumber;
        public int Flags;
        public int PublicKeyOrToken;
        public int Name;
        public int Culture;
        public int HashValue;

        public AssemblyRef(PEFile pEFile, int n) {
            super(pEFile, 35, n);
        }

        protected void populateFields() {
            this.MajorVersion = this.readShort();
            this.MinorVersion = this.readShort();
            this.BuildNumber = this.readShort();
            this.RevisionNumber = this.readShort();
            this.Flags = this.readInt();
            this.PublicKeyOrToken = this.readBlobIndex();
            this.Name = this.readStringIndex();
            this.Culture = this.readStringIndex();
            this.HashValue = this.readBlobIndex();
        }

        protected int getRowSize() {
            return 12 + 2 * this.file.getBlobIndexSize() + 2 * this.file.getStringIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class AssemblyOS
    extends Table {
        public static final int ID = 34;
        public int OSPlatformID;
        public int OSMajorVersion;
        public int OSMinorVersion;

        public AssemblyOS(PEFile pEFile, int n) {
            super(pEFile, 34, n);
        }

        protected void populateFields() {
            this.OSPlatformID = this.readInt();
            this.OSMajorVersion = this.readInt();
            this.OSMinorVersion = this.readInt();
        }

        protected int getRowSize() {
            return 12;
        }
    }

    public static final class AssemblyProcessor
    extends Table {
        public static final int ID = 33;
        public int Processor;

        public AssemblyProcessor(PEFile pEFile, int n) {
            super(pEFile, 33, n);
        }

        protected void populateFields() {
            this.Processor = this.readInt();
        }

        protected int getRowSize() {
            return 4;
        }
    }

    public static final class AssemblyDef
    extends Table {
        public static final int ID = 32;
        public int HashAlgId;
        public int MajorVersion;
        public int MinorVersion;
        public int BuildNumber;
        public int RevisionNumber;
        public int Flags;
        public int PublicKey;
        public int Name;
        public int Culture;

        public AssemblyDef(PEFile pEFile, int n) {
            super(pEFile, 32, n);
        }

        protected void populateFields() {
            this.HashAlgId = this.readInt();
            this.MajorVersion = this.readShort();
            this.MinorVersion = this.readShort();
            this.BuildNumber = this.readShort();
            this.RevisionNumber = this.readShort();
            this.Flags = this.readInt();
            this.PublicKey = this.readBlobIndex();
            this.Name = this.readStringIndex();
            this.Culture = this.readStringIndex();
        }

        protected int getRowSize() {
            return 16 + this.file.getBlobIndexSize() + 2 * this.file.getStringIndexSize();
        }
    }

    public static final class FieldRVA
    extends Table {
        public static final int ID = 29;
        public int RVA;
        public int Field;

        public FieldRVA(PEFile pEFile, int n) {
            super(pEFile, 29, n);
        }

        protected void populateFields() {
            this.RVA = this.readInt();
            this.Field = this.readTableIndex(4);
        }

        protected int getRowSize() {
            return 4 + this.file.getTableIndexSize(4);
        }
    }

    public static final class ImplMap
    extends Table {
        public static final int ID = 28;
        public int MappingFlags;
        public int MemberForwarded;
        public int ImportName;
        public int ImportScope;

        public ImplMap(PEFile pEFile, int n) {
            super(pEFile, 28, n);
        }

        protected void populateFields() {
            this.MappingFlags = this.readShort();
            this.MemberForwarded = this.readTableSetIndex(8);
            this.ImportName = this.readStringIndex();
            this.ImportScope = this.readTableIndex(26);
        }

        protected int getRowSize() {
            return 2 + this.file.getTableSetIndexSize(8) + this.file.getStringIndexSize() + this.file.getTableIndexSize(26);
        }
    }

    public static final class TypeSpec
    extends Table {
        public static final int ID = 27;
        public int Signature;

        public TypeSpec(PEFile pEFile, int n) {
            super(pEFile, 27, n);
        }

        protected void populateFields() {
            this.Signature = this.readBlobIndex();
        }

        protected int getRowSize() {
            return this.file.getBlobIndexSize();
        }

        public PEFile.Sig getSignature() {
            return this.file.getSignature(this.Signature);
        }
    }

    public static final class ModuleRef
    extends Table {
        public static final int ID = 26;
        public int Name;

        public ModuleRef(PEFile pEFile, int n) {
            super(pEFile, 26, n);
        }

        protected void populateFields() {
            this.Name = this.readStringIndex();
        }

        protected int getRowSize() {
            return this.file.getStringIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class MethodImpl
    extends Table {
        public static final int ID = 25;
        public int Class;
        public int MethodBody;
        public int MethodDeclaration;

        public MethodImpl(PEFile pEFile, int n) {
            super(pEFile, 25, n);
        }

        protected void populateFields() {
            this.Class = this.readTableIndex(2);
            this.MethodBody = this.readTableSetIndex(7);
            this.MethodDeclaration = this.readTableSetIndex(7);
        }

        protected int getRowSize() {
            return this.file.getTableIndexSize(2) + 2 * this.file.getTableSetIndexSize(7);
        }
    }

    public static final class MethodSemantics
    extends Table {
        public static final int ID = 24;
        public int Semantics;
        public int Method;
        public int Association;
        private static final short Setter = 1;
        private static final short Getter = 2;
        private static final short Other = 4;
        private static final short AddOn = 8;
        private static final short RemoveOn = 16;
        private static final short Fire = 32;

        public MethodSemantics(PEFile pEFile, int n) {
            super(pEFile, 24, n);
        }

        protected void populateFields() {
            this.Semantics = this.readShort();
            this.Method = this.readTableIndex(6);
            this.Association = this.readTableSetIndex(6);
        }

        protected int getRowSize() {
            return 2 + this.file.getTableIndexSize(6) + this.file.getTableSetIndexSize(6);
        }

        public boolean isGetter() {
            return (this.Semantics & 2) != 0;
        }

        public boolean isSetter() {
            return (this.Semantics & 1) != 0;
        }

        public boolean isOther() {
            return (this.Semantics & 4) != 0;
        }

        public boolean isAddOn() {
            return (this.Semantics & 8) != 0;
        }

        public boolean isRemoveOn() {
            return (this.Semantics & 0x10) != 0;
        }

        public boolean isFire() {
            return (this.Semantics & 0x20) != 0;
        }
    }

    public static final class PropertyDef
    extends Table {
        public static final int ID = 23;
        public int Flags;
        public int Name;
        public int Type;

        public PropertyDef(PEFile pEFile, int n) {
            super(pEFile, 23, n);
        }

        protected void populateFields() {
            this.Flags = this.readShort();
            this.Name = this.readStringIndex();
            this.Type = this.readBlobIndex();
        }

        protected int getRowSize() {
            return 2 + this.file.getStringIndexSize() + this.file.getBlobIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }

        public PEFile.Sig getSignature() {
            return this.file.getSignature(this.Type);
        }
    }

    public static final class PropertyMap
    extends Table {
        public static final int ID = 21;
        public int Parent;
        public int PropertyList;

        public PropertyMap(PEFile pEFile, int n) {
            super(pEFile, 21, n);
        }

        protected void populateFields() {
            this.Parent = this.readTableIndex(2);
            this.PropertyList = this.readTableIndex(23);
        }

        protected int getRowSize() {
            return this.file.getTableIndexSize(2) + this.file.getTableIndexSize(23);
        }
    }

    public static final class EventDef
    extends Table {
        public static final int ID = 20;
        public int EventFlags;
        public int Name;
        public int EventType;

        public EventDef(PEFile pEFile, int n) {
            super(pEFile, 20, n);
        }

        protected void populateFields() {
            this.EventFlags = this.readShort();
            this.Name = this.readStringIndex();
            this.EventType = this.readTableSetIndex(0);
        }

        protected int getRowSize() {
            return 2 + this.file.getStringIndexSize() + this.file.getTableSetIndexSize(0);
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class EventMap
    extends Table {
        public static final int ID = 18;
        public int Parent;
        public int EventList;

        public EventMap(PEFile pEFile, int n) {
            super(pEFile, 18, n);
        }

        protected void populateFields() {
            this.Parent = this.readTableIndex(2);
            this.EventList = this.readTableIndex(20);
        }

        protected int getRowSize() {
            return this.file.getTableIndexSize(2) + this.file.getTableIndexSize(20);
        }
    }

    public static final class StandAloneSig
    extends Table {
        public static final int ID = 17;
        public int Signature;

        public StandAloneSig(PEFile pEFile, int n) {
            super(pEFile, 17, n);
        }

        protected void populateFields() {
            this.Signature = this.readBlobIndex();
        }

        protected int getRowSize() {
            return this.file.getBlobIndexSize();
        }
    }

    public static final class FieldLayout
    extends Table {
        public static final int ID = 16;
        public int Offset;
        public int Field;

        public FieldLayout(PEFile pEFile, int n) {
            super(pEFile, 16, n);
        }

        protected void populateFields() {
            this.Offset = this.readInt();
            this.Field = this.readTableIndex(4);
        }

        protected int getRowSize() {
            return 4 + this.file.getTableIndexSize(4);
        }
    }

    public static final class ClassLayout
    extends Table {
        public static final int ID = 15;
        public int PackingSize;
        public int ClassSize;
        public int Parent;

        public ClassLayout(PEFile pEFile, int n) {
            super(pEFile, 15, n);
        }

        protected void populateFields() {
            this.PackingSize = this.readShort();
            this.ClassSize = this.readInt();
            this.Parent = this.readTableIndex(2);
        }

        protected int getRowSize() {
            return 6 + this.file.getTableIndexSize(2);
        }
    }

    public static final class DeclSecurity
    extends Table {
        public static final int ID = 14;
        public int Action;
        public int Parent;
        public int PermissionSet;

        public DeclSecurity(PEFile pEFile, int n) {
            super(pEFile, 14, n);
        }

        protected void populateFields() {
            this.Action = this.readShort();
            this.Parent = this.readTableSetIndex(4);
            this.PermissionSet = this.readBlobIndex();
        }

        protected int getRowSize() {
            return 2 + this.file.getTableSetIndexSize(4) + this.file.getBlobIndexSize();
        }
    }

    public static final class FieldMarshal
    extends Table {
        public static final int ID = 13;
        public int Parent;
        public int NativeType;

        public FieldMarshal(PEFile pEFile, int n) {
            super(pEFile, 13, n);
        }

        protected void populateFields() {
            this.Parent = this.readTableSetIndex(3);
            this.NativeType = this.readBlobIndex();
        }

        protected int getRowSize() {
            return this.file.getTableSetIndexSize(3) + this.file.getBlobIndexSize();
        }
    }

    public static final class CustomAttribute
    extends Table {
        public static final int ID = 12;
        public int Parent;
        public int Type;
        public int Value;

        public CustomAttribute(PEFile pEFile, int n) {
            super(pEFile, 12, n);
        }

        protected void populateFields() {
            this.Parent = this.readTableSetIndex(2);
            this.Type = this.readTableSetIndex(10);
            this.Value = this.readBlobIndex();
        }

        protected int getRowSize() {
            return this.file.getTableSetIndexSize(2) + this.file.getTableSetIndexSize(10) + this.file.getBlobIndexSize();
        }

        public byte[] getValue() {
            return this.Value == 0 ? null : this.file.getBlob(this.Value);
        }
    }

    public static final class Constant
    extends Table {
        public static final int ID = 11;
        public int Type;
        public int Parent;
        public int Value;

        public Constant(PEFile pEFile, int n) {
            super(pEFile, 11, n);
        }

        protected void populateFields() {
            this.Type = this.readShort();
            this.Parent = this.readTableSetIndex(1);
            this.Value = this.readBlobIndex();
        }

        protected int getRowSize() {
            return 2 + this.file.getTableSetIndexSize(1) + this.file.getBlobIndexSize();
        }

        public Object getValue() {
            if (this.Type == 18) {
                return null;
            }
            return this.file.Blob.getConstant(this.Type, this.Value);
        }
    }

    public static final class MemberRef
    extends Table {
        public static final int ID = 10;
        public int Class;
        public int Name;
        public int Signature;

        public MemberRef(PEFile pEFile, int n) {
            super(pEFile, 10, n);
        }

        protected void populateFields() {
            this.Class = this.readTableSetIndex(5);
            this.Name = this.readStringIndex();
            this.Signature = this.readBlobIndex();
        }

        protected int getRowSize() {
            return this.file.getTableSetIndexSize(5) + this.file.getStringIndexSize() + this.file.getBlobIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }

        public PEFile.Sig getSignature() {
            return this.file.getSignature(this.Signature);
        }
    }

    public static final class InterfaceImpl
    extends Table {
        public static final int ID = 9;
        public int Class;
        public int Interface;

        public InterfaceImpl(PEFile pEFile, int n) {
            super(pEFile, 9, n);
        }

        protected void populateFields() {
            this.Class = this.readTableIndex(2);
            this.Interface = this.readTableSetIndex(0);
        }

        protected int getRowSize() {
            return this.file.getTableIndexSize(2) + this.file.getTableSetIndexSize(0);
        }

        public int findType(int n) {
            for (int i = 1; i <= this.rows; ++i) {
                this.seekRow(i);
                if (n != this.readTableIndex(2)) continue;
                return i;
            }
            return 0;
        }
    }

    public static final class ParamDef
    extends Table {
        public static final int ID = 8;
        public int Flags;
        public int Sequence;
        public int Name;

        public ParamDef(PEFile pEFile, int n) {
            super(pEFile, 8, n);
            this.newMapping = true;
        }

        protected void populateFields() {
            this.Flags = this.readShort();
            this.Sequence = this.readShort();
            this.Name = this.readStringIndex();
        }

        protected int getRowSize() {
            return 4 + this.file.getStringIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class MethodDef
    extends Table {
        public static final int ID = 6;
        public int RVA;
        public int ImplFlags;
        public int Flags;
        public int Name;
        public int Signature;
        public int ParamList;

        public MethodDef(PEFile pEFile, int n) {
            super(pEFile, 6, n);
            this.newMapping = true;
        }

        protected void populateFields() {
            this.RVA = this.readInt();
            this.ImplFlags = this.readShort();
            this.Flags = this.readShort();
            this.Name = this.readStringIndex();
            this.Signature = this.readBlobIndex();
            this.ParamList = this.readTableIndex(8);
        }

        protected int getRowSize() {
            return 8 + this.file.getStringIndexSize() + this.file.getBlobIndexSize() + this.file.getTableIndexSize(8);
        }

        public String getName() {
            return this.file.getString(this.Name);
        }

        public PEFile.Sig getSignature() {
            return this.file.getSignature(this.Signature);
        }
    }

    public static final class MethodTrans
    extends Table {
        public static final int ID = 5;
        public int Method;

        public MethodTrans(PEFile pEFile, int n) {
            super(pEFile, 5, n);
            this.newMapping = true;
        }

        protected void populateFields() {
            this.Method = this.readTableIndex(4);
        }

        protected int getRowSize() {
            return this.file.getTableIndexSize(6);
        }
    }

    public static final class FieldDef
    extends Table {
        public static final int ID = 4;
        public int Flags;
        public int Name;
        public int Signature;

        public FieldDef(PEFile pEFile, int n) {
            super(pEFile, 4, n);
            this.newMapping = true;
        }

        protected void populateFields() {
            this.Flags = this.readShort();
            this.Name = this.readStringIndex();
            this.Signature = this.readBlobIndex();
        }

        protected int getRowSize() {
            return 2 + this.file.getStringIndexSize() + this.file.getBlobIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }

        public PEFile.Sig getSignature() {
            return this.file.getSignature(this.Signature);
        }
    }

    public static final class FieldTrans
    extends Table {
        public static final int ID = 3;
        public int Field;

        public FieldTrans(PEFile pEFile, int n) {
            super(pEFile, 3, n);
            this.newMapping = true;
        }

        protected void populateFields() {
            this.Field = this.readTableIndex(4);
        }

        protected int getRowSize() {
            return this.file.getTableIndexSize(4);
        }
    }

    public static final class TypeDef
    extends Table {
        public static final int ID = 2;
        public int Flags;
        public int Name;
        public int Namespace;
        public int Extends;
        public int FieldList;
        public int MethodList;

        public TypeDef(PEFile pEFile, int n) {
            super(pEFile, 2, n);
            this.newMapping = true;
        }

        public String getFullName() {
            String string = this.file.getString(this.Namespace);
            return string.length() == 0 ? this.file.getString(this.Name) : string + "." + this.file.getString(this.Name);
        }

        protected void populateFields() {
            this.Flags = this.readInt();
            this.Name = this.readStringIndex();
            this.Namespace = this.readStringIndex();
            this.Extends = this.readTableSetIndex(0);
            this.FieldList = this.readTableIndex(4);
            this.MethodList = this.readTableIndex(6);
        }

        protected int getRowSize() {
            return 4 + 2 * this.file.getStringIndexSize() + this.file.getTableSetIndexSize(0) + this.file.getTableIndexSize(4) + this.file.getTableIndexSize(6);
        }
    }

    public static final class TypeRef
    extends Table {
        public static final int ID = 1;
        public int ResolutionScope;
        public int Name;
        public int Namespace;

        public TypeRef(PEFile pEFile, int n) {
            super(pEFile, 1, n);
        }

        protected void populateFields() {
            this.ResolutionScope = this.readTableSetIndex(11);
            this.Name = this.readStringIndex();
            this.Namespace = this.readStringIndex();
        }

        protected int getRowSize() {
            return this.file.getTableSetIndexSize(11) + 2 * this.file.getStringIndexSize();
        }

        public String getFullName() {
            String string = this.file.getString(this.Namespace);
            return string.length() == 0 ? this.file.getString(this.Name) : string + "." + this.file.getString(this.Name);
        }
    }

    public static final class ModuleDef
    extends Table {
        public static final int ID = 0;
        public int Generation;
        public int Name;
        public int Mvid;
        public int EncId;
        public int EncBaseId;

        public ModuleDef(PEFile pEFile, int n) {
            super(pEFile, 0, n);
        }

        protected void populateFields() {
            this.Generation = this.readShort();
            this.Name = this.readStringIndex();
            this.Mvid = this.readGUIDIndex();
            this.EncId = this.readGUIDIndex();
            this.EncBaseId = this.readGUIDIndex();
        }

        protected int getRowSize() {
            return 2 + this.file.getStringIndexSize() + 3 * this.file.getGUIDIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    private static final class Empty
    extends Table {
        public Empty(int n) {
            super(null, n, 0);
        }

        protected int getRowSize() {
            return 0;
        }

        protected void populateFields() {
            throw new RuntimeException("Table 0x" + PEFile.byte2hex(this.id));
        }
    }
}

