/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.emit;

import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.Module;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.emit.ConstructorBuilder;
import ch.epfl.lamp.compiler.msil.emit.FieldBuilder;
import ch.epfl.lamp.compiler.msil.emit.ICustomAttributeSetter;
import ch.epfl.lamp.compiler.msil.emit.MethodBuilder;
import ch.epfl.lamp.compiler.msil.emit.ModuleBuilder;
import ch.epfl.lamp.compiler.msil.emit.Visitable;
import ch.epfl.lamp.compiler.msil.emit.Visitor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class TypeBuilder
extends Type
implements ICustomAttributeSetter,
Visitable {
    int sourceLine;
    String sourceFilename;
    protected ArrayList fieldBuilders = new ArrayList();
    protected ArrayList methodBuilders = new ArrayList();
    protected ArrayList constructorBuilders = new ArrayList();
    protected ArrayList nestedTypeBuilders = new ArrayList();
    private boolean raw = true;

    public Type CreateType() {
        this.fields = this.fieldBuilders.toArray(new FieldInfo[this.fieldBuilders.size()]);
        this.methods = this.methodBuilders.toArray(new MethodInfo[this.methodBuilders.size()]);
        this.constructors = this.constructorBuilders.toArray(new ConstructorInfo[this.constructorBuilders.size()]);
        this.nestedTypes = this.nestedTypeBuilders.toArray(new Type[this.nestedTypeBuilders.size()]);
        this.raw = false;
        if (this.DeclaringType == null) {
            ((ModuleBuilder)this.Module).addType(this);
        }
        return this;
    }

    public FieldBuilder DefineField(String string, Type type, short s) {
        FieldBuilder fieldBuilder = new FieldBuilder(string, this, s, type);
        this.fieldBuilders.add(fieldBuilder);
        return fieldBuilder;
    }

    public MethodBuilder DefineMethod(String string, short s, Type type, Type[] typeArray) {
        MethodBuilder methodBuilder = new MethodBuilder(string, (Type)this, (int)s, type, typeArray);
        Iterator iterator = ((AbstractList)this.methodBuilders).iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            if (!TypeBuilder.methodsEqual(methodInfo, methodBuilder)) continue;
            throw new RuntimeException(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[".concat(String.valueOf(String.valueOf(this.Assembly()))))).concat("] Method has already been defined: "))).concat(String.valueOf(String.valueOf(methodInfo))));
        }
        this.methodBuilders.add(methodBuilder);
        return methodBuilder;
    }

    public ConstructorBuilder DefineConstructor(short s, short s2, Type[] typeArray) {
        ConstructorBuilder constructorBuilder = new ConstructorBuilder((Type)this, (int)s, typeArray);
        this.constructorBuilders.add(constructorBuilder);
        return constructorBuilder;
    }

    public TypeBuilder DefineNestedType(String string, int n, Type type, Type[] typeArray) {
        TypeBuilder typeBuilder;
        Iterator iterator = ((AbstractList)this.nestedTypeBuilders).iterator();
        while (iterator.hasNext()) {
            typeBuilder = (TypeBuilder)iterator.next();
            if (!typeBuilder.Name.equals(string)) continue;
            String string2 = String.valueOf(String.valueOf(String.valueOf(String.valueOf("Nested type ".concat(String.valueOf(String.valueOf(string))))).concat(" has already been defined: "))).concat(String.valueOf(String.valueOf(typeBuilder)));
            throw new RuntimeException(string2);
        }
        typeBuilder = new TypeBuilder(this.Module, n, string, type, typeArray, this);
        this.nestedTypeBuilders.add(typeBuilder);
        return typeBuilder;
    }

    public FieldInfo GetField(String string) {
        this.testRaw(string);
        return super.GetField(string);
    }

    public FieldInfo[] GetFields() {
        this.testRaw("<GetFields>");
        return super.GetFields();
    }

    public ConstructorInfo GetConstructor(Type[] typeArray) {
        this.testRaw(".ctor".concat(String.valueOf(String.valueOf(TypeBuilder.types2String(typeArray)))));
        return super.GetConstructor(typeArray);
    }

    public ConstructorInfo[] GetConstructors() {
        this.testRaw("<GetConstructors>");
        return super.GetConstructors();
    }

    public MethodInfo GetMethod(String string, Type[] typeArray) {
        this.testRaw(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(TypeBuilder.types2String(typeArray)))));
        return super.GetMethod(string, typeArray);
    }

    public MethodInfo[] GetMethods() {
        this.testRaw("<GetMethods>");
        return super.GetMethods();
    }

    public Type GetNestedType(String string) {
        this.testRaw(string);
        return super.GetNestedType(string);
    }

    public Type[] GetNestedTypes() {
        this.testRaw("<GetNestedTypes>");
        return super.GetNestedTypes();
    }

    public void SetCustomAttribute(ConstructorInfo constructorInfo, byte[] byArray) {
        this.addCustomAttribute(constructorInfo, byArray);
    }

    public void setPosition(int n, String string) {
        this.sourceLine = n;
        this.sourceFilename = string;
    }

    protected TypeBuilder(Module module, int n, String string, Type type, Type[] typeArray, Type type2) {
        super(module, n, string, type, typeArray, type2, 0);
    }

    protected void testRaw(String string) {
        if (this.raw) {
            throw new RuntimeException(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Not supported for TypeBuilder before CreateType(): ".concat(String.valueOf(String.valueOf(this.FullName))))).concat("::"))).concat(String.valueOf(String.valueOf(string))));
        }
    }

    public void apply(Visitor visitor2) {
        visitor2.caseTypeBuilder(this);
    }

    static String types2String(Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < typeArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(typeArray[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static boolean methodsEqual(MethodInfo methodInfo, MethodInfo methodInfo2) {
        ParameterInfo[] parameterInfoArray;
        if (!methodInfo.Name.equals(methodInfo2.Name)) {
            return false;
        }
        if (methodInfo.ReturnType != methodInfo2.ReturnType) {
            return false;
        }
        ParameterInfo[] parameterInfoArray2 = methodInfo.GetParameters();
        if (parameterInfoArray2.length != (parameterInfoArray = methodInfo2.GetParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameterInfoArray2.length; ++i) {
            if (parameterInfoArray2[i].ParameterType == parameterInfoArray[i].ParameterType) continue;
            return false;
        }
        return true;
    }
}

