/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.reporters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.Settings;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.reporters.AbstractReporter;
import scala.tools.nsc.reporters.ConsoleReporter$;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.FakePos;
import scala.tools.nsc.util.Position;
import scala.tools.nsc.util.SourceFile;

public class ConsoleReporter
extends AbstractReporter
implements ScalaObject {
    private boolean shortname;
    private final PrintWriter writer;
    private final BufferedReader reader;
    private final Settings settings;

    public ConsoleReporter(Settings settings, BufferedReader reader, PrintWriter writer) {
        this.settings = settings;
        this.reader = reader;
        this.writer = writer;
        this.shortname = false;
    }

    private final /* synthetic */ boolean gd1$1(Position position) {
        return !position.source().isEmpty();
    }

    public void flush() {
        this.writer.flush();
    }

    public void displayPrompt() {
        try {
            boolean bl = true;
            while (bl) {
                this.writer.print("r)esume, a)bort: ");
                this.writer.flush();
                String line = this.reader.readLine();
                if (line == null) continue;
                if ("abort".startsWith(line = line.toLowerCase())) {
                    throw new Error("user abort");
                }
                if (!"resume".startsWith(line)) continue;
                bl = false;
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("input read error");
        }
    }

    public void display(Position pos, String msg, Reporter.Severity severity) {
        severity.count_$eq(severity.count() + 1);
        this.print(pos, msg, severity);
    }

    public void printSummary() {
        if (this.WARNING().count() > 0) {
            this.printMessage(this.getCountString(this.WARNING()) + " found");
        }
        if (this.ERROR().count() > 0) {
            this.printMessage(this.getCountString(this.ERROR()) + " found");
        }
    }

    public void printColumnMarker(Position pos) {
        if (!pos.column().isEmpty()) {
            StringBuilder buffer = new StringBuilder(BoxesRunTime.unboxToInt((Object)pos.column().get()));
            for (int i = 1; i < BoxesRunTime.unboxToInt((Object)pos.column().get()); ++i) {
                buffer.append(' ');
            }
            if (BoxesRunTime.unboxToInt((Object)pos.column().get()) > 0) {
                buffer.append('^');
            }
            this.printMessage(buffer.toString());
        }
    }

    public void printSourceLine(Position pos) {
        this.printMessage(Predef$.MODULE$.stringWrapper(pos.lineContent()).stripLineEnd());
        this.printColumnMarker(pos);
    }

    public void print(Position pos, String msg, Reporter.Severity severity) {
        this.printMessage(pos, this.clabel(severity) + msg);
    }

    public void printMessage(Position posIn, String msg) {
        if (posIn == null) {
            this.printMessage(msg);
        } else {
            BoxedUnit boxedUnit;
            Position position;
            Position pos$1 = posIn.inUltimateSource((SourceFile)posIn.source().getOrElse((Function0)new $anonfun$1(this)));
            StringBuilder buf = new StringBuilder(msg);
            if (!pos$1.source().isEmpty()) {
                buf.insert(0, " ");
                buf.insert(0, (String)pos$1.line().map((Function1)new $anonfun$printMessage$1(this, pos$1)).getOrElse((Function0)new $anonfun$printMessage$2(this)));
            }
            if ((position = pos$1) instanceof FakePos) {
                boxedUnit = buf.insert(0, ((FakePos)position).msg() + " ");
            } else if (this.gd1$1(pos$1)) {
                AbstractFile file = ((SourceFile)pos$1.source().get()).file();
                boxedUnit = buf.insert(0, this.shortname() ? file.name() : file.path());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.printMessage(buf.toString());
            if (!pos$1.line().isEmpty()) {
                this.printSourceLine(pos$1);
            }
        }
    }

    public void printMessage(String msg) {
        this.writer.print(msg + "\n");
        this.writer.flush();
    }

    private String getCountString(Reporter.Severity severity) {
        return this.countElementsAsString(severity.count(), this.label(severity));
    }

    public ConsoleReporter(Settings settings) {
        this(settings, Console$.MODULE$.in(), new PrintWriter(Console$.MODULE$.err(), true));
    }

    private String clabel(Reporter.Severity severity) {
        String label0 = this.label(severity);
        return label0 == null ? "" : label0 + ": ";
    }

    private String label(Reporter.Severity severity) {
        Reporter.Severity severity2;
        block5: {
            String string;
            block3: {
                Reporter.Severity severity3;
                block4: {
                    block2: {
                        Reporter.Severity severity4 = severity2 = severity;
                        severity3 = this.ERROR();
                        if (severity4 != null ? !((Object)((Object)severity4)).equals((Object)severity3) : severity3 != null) break block2;
                        string = "error";
                        break block3;
                    }
                    Reporter.Severity severity5 = severity2;
                    severity3 = this.WARNING();
                    if (severity5 != null ? !((Object)((Object)severity5)).equals((Object)severity3) : severity3 != null) break block4;
                    string = "warning";
                    break block3;
                }
                Reporter.Severity severity6 = severity2;
                severity3 = this.INFO();
                if (severity6 != null ? !((Object)((Object)severity6)).equals((Object)severity3) : severity3 != null) break block5;
                string = null;
            }
            return string;
        }
        throw new MatchError((Object)severity2);
    }

    public void shortname_$eq(boolean x$1) {
        this.shortname = x$1;
    }

    public boolean shortname() {
        return this.shortname;
    }

    public Settings settings() {
        return this.settings;
    }
}

