/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.emit;

import ch.epfl.lamp.compiler.msil.emit.Label$Kind$;

public abstract class Label {
    private static final int DUMMY = -2147483647;
    static final Label NewScope = new SpecialLabel(Kind.NewScope);
    static final Label EndScope = new SpecialLabel(Kind.EndScope);
    static final Label Try = new SpecialLabel(Kind.Try);
    static final Label Catch = new SpecialLabel(Kind.Catch);
    static final Label Filter = new SpecialLabel(Kind.Filter);
    static final Label EndFilter = new SpecialLabel(Kind.EndFilter);
    static final Label Finally = new SpecialLabel(Kind.Finally);
    static final Label EndTry = new SpecialLabel(Kind.EndTry);

    protected Label() {
    }

    abstract boolean isInitialized();

    abstract Kind getKind();

    abstract int getAddress();

    abstract int getStacksize();

    abstract void setStacksize(int var1);

    abstract void incStacksize();

    abstract void mergeWith(Label var1);

    static final /* synthetic */ int access$0() {
        return -2147483647;
    }

    static final class SpecialLabel
    extends Label {
        private final Kind kind;

        public SpecialLabel(Kind kind) {
            this.kind = kind;
        }

        boolean isInitialized() {
            return true;
        }

        int getAddress() {
            throw new RuntimeException("".concat(String.valueOf(String.valueOf(this.kind.toString()))));
        }

        int getStacksize() {
            throw new RuntimeException("".concat(String.valueOf(String.valueOf(this.kind.toString()))));
        }

        void setStacksize(int n) {
            throw new RuntimeException(this.kind.toString());
        }

        void incStacksize() {
            throw new RuntimeException(this.kind.toString());
        }

        Kind getKind() {
            return this.kind;
        }

        void mergeWith(Label label) {
            throw new RuntimeException(this.kind.toString());
        }

        public String toString() {
            return String.valueOf(String.valueOf("Label(".concat(String.valueOf(String.valueOf(this.kind.toString()))))).concat(")");
        }
    }

    static class Kind {
        public static /* synthetic */ Kind[] $extensions;
        public static /* synthetic */ int $subIDs;
        public static /* synthetic */ boolean[] $castable;
        public static final /* synthetic */ int $subID;
        public final /* synthetic */ int $tag;
        public static final Kind$$Var Catch;
        public static final Kind$$Var EndFilter;
        public static final Kind$$Var EndScope;
        public static final Kind$$Var EndTry;
        public static final Kind$$Var Filter;
        public static final Kind$$Var Finally;
        public static final Kind$$Var NewScope;
        public static final Kind$$Var Normal;
        public static final Kind$$Var Try;

        public static /* synthetic */ int $register(Kind kind) {
            if ($subIDs == $extensions.length) {
                Kind[] kindArray = new Kind[$extensions.length * 2];
                System.arraycopy($extensions, 0, kindArray, 0, $extensions.length);
                $extensions = kindArray;
                for (int i = 0; i < $subIDs; ++i) {
                    $extensions[i].$extend();
                }
            }
            Kind.$extensions[Kind.$subIDs] = kind;
            return $subIDs++;
        }

        public static /* synthetic */ Kind throw$cast$exception() {
            throw new ClassCastException();
        }

        public /* synthetic */ void $extend() {
            boolean[] blArray = new boolean[$castable.length * 2];
            System.arraycopy($castable, 0, blArray, 0, $castable.length);
            $castable = blArray;
        }

        public /* synthetic */ int $getSubID() {
            return $subID;
        }

        protected /* synthetic */ Kind(int n) {
            this.$tag = n;
        }

        static {
            $extensions = new Kind[]{null, null, null, null};
            $castable = new boolean[]{true, false, false, false};
            $subID = Kind.$register(new Kind(-1));
            Catch = new Kind$$Var(0);
            EndFilter = new Kind$$Var(1);
            EndScope = new Kind$$Var(2);
            EndTry = new Kind$$Var(3);
            Filter = new Kind$$Var(4);
            Finally = new Kind$$Var(5);
            NewScope = new Kind$$Var(6);
            Normal = new Kind$$Var(7);
            Try = new Kind$$Var(8);
        }
    }

    static final class NormalLabel
    extends Label {
        private int address;
        private int stacksize;
        private static final /* synthetic */ boolean $assertionsDisabled;

        NormalLabel(int n, int n2) {
            this.address = n;
            this.stacksize = n2;
        }

        NormalLabel() {
            this(-1, Label.access$0());
        }

        NormalLabel(Label label) {
            this(label.getAddress(), label.getStacksize());
        }

        boolean isInitialized() {
            return this.getAddress() != -1 || this.stacksize != Label.access$0();
        }

        int getAddress() {
            return this.address;
        }

        int getStacksize() {
            return this.stacksize;
        }

        void setStacksize(int n) {
            if (!$assertionsDisabled && n < 0) {
                throw new AssertionError();
            }
            this.stacksize = n;
        }

        void incStacksize() {
            ++this.stacksize;
        }

        Kind getKind() {
            return Kind.Normal;
        }

        void mergeWith(Label label) {
            int n;
            this.address = label.getAddress();
            this.stacksize = n = Math.max(this.stacksize, label.getStacksize());
            label.setStacksize(n);
        }

        public String toString() {
            String string = "";
            if (this.address < 16) {
                string = "000";
            } else if (this.address < 256) {
                string = "00";
            } else if (this.address < 4096) {
                string = "0";
            }
            return String.valueOf(String.valueOf("IL_".concat(String.valueOf(String.valueOf(string))))).concat(String.valueOf(String.valueOf(Integer.toHexString(this.address))));
        }

        public String getString() {
            String string = super.toString();
            int n = string.lastIndexOf(46);
            return string.substring(n + 1, string.length());
        }

        static {
            $assertionsDisabled = !Class.forName("ch.epfl.lamp.compiler.msil.emit.Label").desiredAssertionStatus();
        }
    }
}

