/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.reporters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.compat.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesUtility;
import scala.tools.nsc.Settings;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.reporters.AbstractReporter;
import scala.tools.nsc.reporters.ConsoleReporter$;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.FakePos;
import scala.tools.nsc.util.NoPosition$;
import scala.tools.nsc.util.Position;
import scala.tools.nsc.util.SourceFile;

public class ConsoleReporter
extends AbstractReporter
implements ScalaObject {
    private boolean shortname;
    private PrintWriter writer;
    private BufferedReader reader;
    private Settings settings;

    public ConsoleReporter(Settings settings, BufferedReader reader, PrintWriter writer) {
        this.settings = settings;
        this.reader = reader;
        this.writer = writer;
        this.shortname = false;
    }

    private final /* synthetic */ boolean gd0$0(Position position) {
        return !position.source().isEmpty();
    }

    public void flush() {
        this.writer.flush();
    }

    public void displayPrompt() {
        try {
            boolean bl = true;
            while (bl) {
                this.writer.print("r)esume, a)bort: ");
                this.writer.flush();
                String line = this.reader.readLine();
                if (line == null) continue;
                if ("abort".startsWith(line = line.toLowerCase())) {
                    throw new Error("user abort");
                }
                if (!"resume".startsWith(line)) continue;
                bl = false;
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("input read error");
        }
    }

    public void display(Position pos, String msg, Reporter.Severity severity) {
        severity.count_$eq(severity.count() + 1);
        this.print(pos, msg, severity);
    }

    public void printSummary() {
        if (this.WARNING().count() > 0) {
            this.printMessage(this.getCountString(this.WARNING()) + " found");
        }
        if (this.ERROR().count() > 0) {
            this.printMessage(this.getCountString(this.ERROR()) + " found");
        }
    }

    public void printColumnMarker(Position pos) {
        if (!pos.column().isEmpty()) {
            StringBuilder buffer = new StringBuilder(BoxesUtility.unboxToInt((Object)pos.column().get()));
            for (int i = 1; i < BoxesUtility.unboxToInt((Object)pos.column().get()); ++i) {
                buffer.append(' ');
            }
            if (BoxesUtility.unboxToInt((Object)pos.column().get()) > 0) {
                buffer.append('^');
            }
            this.printMessage(buffer.toString());
        }
    }

    public void printSourceLine(Position pos) {
        this.printMessage(Predef$.MODULE$.stringWrapper(pos.lineContent()).stripLineEnd());
        this.printColumnMarker(pos);
    }

    public void print(Position pos, String msg, Reporter.Severity severity) {
        this.printMessage(pos, this.clabel(severity) + msg);
    }

    public void printMessage(Position posIn, String msg) {
        Position position;
        block7: {
            block3: {
                StringBuilder buf;
                Position pos$0;
                block5: {
                    BoxedUnit boxedUnit;
                    block6: {
                        block4: {
                            block2: {
                                if (posIn != null) break block2;
                                this.printMessage(msg);
                                break block3;
                            }
                            pos$0 = posIn.inUltimateSource();
                            buf = new StringBuilder(msg);
                            buf.insert(0, " ");
                            buf.insert(0, (String)pos$0.line().map((Function1)new $anonfun$0(this, pos$0)).get((Object)":"));
                            position = pos$0;
                            if (NoPosition$.MODULE$ != position) break block4;
                            boxedUnit = BoxedUnit.UNIT;
                            break block5;
                        }
                        if (!(position instanceof FakePos)) break block6;
                        boxedUnit = buf.insert(0, ((FakePos)position).msg());
                        break block5;
                    }
                    if (!this.gd0$0(pos$0)) break block7;
                    AbstractFile file = ((SourceFile)pos$0.source().get()).file();
                    boxedUnit = buf.insert(0, this.shortname() ? file.name() : file.path());
                }
                this.printMessage(buf.toString());
                this.printSourceLine(pos$0);
            }
            return;
        }
        throw new MatchError((Object)position);
    }

    public void printMessage(String msg) {
        this.writer.println(msg);
    }

    private String getCountString(Reporter.Severity severity) {
        return this.countElementsAsString(severity.count(), this.label(severity));
    }

    public ConsoleReporter(Settings settings) {
        this(settings, Console$.MODULE$.in(), new PrintWriter(Console$.MODULE$.err(), true));
    }

    private String clabel(Reporter.Severity severity) {
        String label0 = this.label(severity);
        return label0 == null ? "" : label0 + ": ";
    }

    private String label(Reporter.Severity severity) {
        Reporter.Severity severity2;
        block5: {
            String string;
            block3: {
                Reporter.Severity severity3;
                block4: {
                    block2: {
                        Reporter.Severity severity4 = severity2 = severity;
                        severity3 = this.ERROR();
                        if (severity4 != null ? !((Object)((Object)severity4)).equals((Object)severity3) : severity3 != null) break block2;
                        string = "error";
                        break block3;
                    }
                    Reporter.Severity severity5 = severity2;
                    severity3 = this.WARNING();
                    if (severity5 != null ? !((Object)((Object)severity5)).equals((Object)severity3) : severity3 != null) break block4;
                    string = "warning";
                    break block3;
                }
                Reporter.Severity severity6 = severity2;
                severity3 = this.INFO();
                if (severity6 != null ? !((Object)((Object)severity6)).equals((Object)severity3) : severity3 != null) break block5;
                string = null;
            }
            return string;
        }
        throw new MatchError((Object)severity2);
    }

    public void shortname_$eq(boolean x$1) {
        this.shortname = x$1;
    }

    public boolean shortname() {
        return this.shortname;
    }

    public Settings settings() {
        return this.settings;
    }
}

