/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.AssemblyName;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.PEModule;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.util.Table;
import java.io.File;

final class PEAssembly
extends Assembly {
    private final PEFile pefile;
    private PEModule mainModule;

    public PEAssembly(PEFile pEFile, AssemblyName assemblyName) {
        super(assemblyName);
        this.pefile = pEFile;
        String string = pEFile.ModuleDef(1).getName();
        this.mainModule = new PEModule(pEFile, 1, string, (Assembly)this);
        this.addModule(string, this.mainModule);
    }

    protected void loadModules() {
        File file = this.pefile.getParentFile();
        Table.FileDef fileDef = this.pefile.FileDef;
        for (int i = 1; i <= fileDef.rows; ++i) {
            fileDef.readRow(i);
            String string = fileDef.getName();
            File file2 = new File(file, string);
            PEFile pEFile = Assembly.getPEFile(file2);
            if (pEFile == null && (pEFile = Assembly.getPEFile(file2 = new File(string))) == null) continue;
            String string2 = pEFile.ModuleDef(1).getName();
            PEModule pEModule = new PEModule(pEFile, 1, string2, (Assembly)this);
            this.addModule(string2, pEModule);
        }
    }

    public File getFile() {
        return this.pefile.getUnderlyingFile();
    }

    protected void loadCustomAttributes(Type type) {
        this.initModules();
        this.mainModule.initAttributes(this, 1, 32, type);
    }
}

