/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.factory;

import java.io.File;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import scala.collection.immutable.List;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.Source$;
import scala.xml.TopScope$;
import scala.xml.parsing.FactoryAdapter;
import scala.xml.parsing.NoBindingFactoryAdapter;

public interface XMLLoader<T extends Node> {
    default public FactoryAdapter adapter() {
        return new NoBindingFactoryAdapter();
    }

    default public SAXParser parser() {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setNamespaceAware(false);
        return f.newSAXParser();
    }

    default public T loadXML(InputSource source, SAXParser parser) {
        FactoryAdapter newAdapter = this.adapter();
        TopScope$ topScope$ = TopScope$.MODULE$;
        newAdapter.scopeStack_$eq((List<NamespaceBinding>)newAdapter.scopeStack().$colon$colon((Object)topScope$));
        parser.parse(source, (DefaultHandler)newAdapter);
        newAdapter.scopeStack_$eq((List<NamespaceBinding>)((List)newAdapter.scopeStack().tail()));
        return (T)newAdapter.rootElem();
    }

    default public T loadFile(File file) {
        return this.loadXML(Source$.MODULE$.fromFile(file), this.parser());
    }

    default public T loadFile(FileDescriptor fd) {
        return this.loadXML(Source$.MODULE$.fromFile(fd), this.parser());
    }

    default public T loadFile(String name) {
        return this.loadXML(Source$.MODULE$.fromFile(name), this.parser());
    }

    default public T load(InputStream is) {
        return this.loadXML(Source$.MODULE$.fromInputStream(is), this.parser());
    }

    default public T load(Reader reader) {
        return this.loadXML(Source$.MODULE$.fromReader(reader), this.parser());
    }

    default public T load(String sysID) {
        return this.loadXML(Source$.MODULE$.fromSysId(sysID), this.parser());
    }

    default public T load(InputSource source) {
        return this.loadXML(source, this.parser());
    }

    default public T load(URL url) {
        return this.loadXML(Source$.MODULE$.fromInputStream(url.openStream()), this.parser());
    }

    default public T loadString(String string) {
        return this.loadXML(Source$.MODULE$.fromString(string), this.parser());
    }
}

