/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.console;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.fusesource.jansi.AnsiOutputStream;
import scala.tools.jline.Terminal;
import scala.tools.jline.TerminalFactory;
import scala.tools.jline.console.CursorBuffer;
import scala.tools.jline.console.Operation;
import scala.tools.jline.console.completer.CandidateListCompletionHandler;
import scala.tools.jline.console.completer.Completer;
import scala.tools.jline.console.completer.CompletionHandler;
import scala.tools.jline.console.history.History;
import scala.tools.jline.console.history.MemoryHistory;
import scala.tools.jline.internal.Configuration;
import scala.tools.jline.internal.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleReader {
    public static final String JLINE_NOBELL = "jline.nobell";
    public static final String JLINE_EXPANDEVENTS = "jline.expandevents";
    public static final char BACKSPACE = '\b';
    public static final char RESET_LINE = '\r';
    public static final char KEYBOARD_BELL = '\u0007';
    public static final char NULL_MASK = '\u0000';
    public static final int TAB_WIDTH = 4;
    private static final ResourceBundle resources = ResourceBundle.getBundle(CandidateListCompletionHandler.class.getName());
    private final Terminal terminal;
    private InputStream in;
    private final Writer out;
    private final CursorBuffer buf = new CursorBuffer();
    private String prompt;
    private boolean bellEnabled = true;
    private boolean expandEvents = false;
    private Character mask;
    private Character echoCharacter;
    private StringBuffer searchTerm = null;
    private String previousSearchTerm = "";
    private int searchIndex = -1;
    public static final String JLINE_COMPLETION_THRESHOLD = "jline.completion.threshold";
    public static final String JLINE_KEYBINDINGS = "jline.keybindings";
    public static final String JLINEBINDINGS_PROPERTIES = ".jlinebindings.properties";
    private final short[] keyBindings;
    private final List<Completer> completers = new LinkedList<Completer>();
    private CompletionHandler completionHandler = new CandidateListCompletionHandler();
    private int autoprintThreshold = Integer.getInteger("jline.completion.threshold", 100);
    private boolean paginationEnabled;
    private History history = new MemoryHistory();
    private boolean historyEnabled = true;
    public static final String CR = System.getProperty("line.separator");
    private final Map<Character, ActionListener> triggeredActions = new HashMap<Character, ActionListener>();
    private Thread maskThread;

    public ConsoleReader(InputStream inputStream, OutputStream outputStream, InputStream inputStream2, Terminal terminal) throws IOException {
        this.in = inputStream;
        this.terminal = terminal != null ? terminal : TerminalFactory.get();
        this.out = new PrintWriter(this.getTerminal().wrapOutIfNeeded(outputStream));
        this.keyBindings = this.loadKeyBindings(inputStream2);
        this.setBellEnabled(Configuration.getBoolean(JLINE_NOBELL, false) == false);
        this.setExpandEvents(Configuration.getBoolean(JLINE_EXPANDEVENTS, false));
    }

    public ConsoleReader(InputStream inputStream, Writer writer, InputStream inputStream2, Terminal terminal) throws IOException {
        this.in = inputStream;
        this.out = writer;
        this.terminal = terminal != null ? terminal : TerminalFactory.get();
        this.keyBindings = this.loadKeyBindings(inputStream2);
        this.setBellEnabled(Configuration.getBoolean(JLINE_NOBELL, false) == false);
    }

    public ConsoleReader(InputStream inputStream, Writer writer, Terminal terminal) throws IOException {
        this(inputStream, writer, null, terminal);
    }

    public ConsoleReader(InputStream inputStream, Writer writer) throws IOException {
        this(inputStream, writer, null, null);
    }

    public ConsoleReader() throws IOException {
        this((InputStream)new FileInputStream(FileDescriptor.in), System.out, null, null);
    }

    void setInput(InputStream inputStream) {
        this.in = inputStream;
    }

    public InputStream getInput() {
        return this.in;
    }

    public Writer getOutput() {
        return this.out;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public CursorBuffer getCursorBuffer() {
        return this.buf;
    }

    public void setBellEnabled(boolean bl) {
        this.bellEnabled = bl;
    }

    public boolean isBellEnabled() {
        return this.bellEnabled;
    }

    public void setExpandEvents(boolean bl) {
        this.expandEvents = bl;
    }

    public boolean getExpandEvents() {
        return this.expandEvents;
    }

    public void setPrompt(String string) {
        this.prompt = string;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setEchoCharacter(Character c) {
        this.echoCharacter = c;
    }

    public Character getEchoCharacter() {
        return this.echoCharacter;
    }

    protected final boolean resetLine() throws IOException {
        if (this.buf.cursor == 0) {
            return false;
        }
        this.backspaceAll();
        return true;
    }

    int getCursorPosition() {
        String string = this.getPrompt();
        return (string == null ? 0 : this.stripAnsi(this.lastLine(string)).length()) + this.buf.cursor;
    }

    private String lastLine(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf("\n");
        if (n >= 0) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    private String stripAnsi(String string) {
        if (string == null) {
            return "";
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            AnsiOutputStream ansiOutputStream = new AnsiOutputStream(byteArrayOutputStream);
            ansiOutputStream.write(string.getBytes());
            ansiOutputStream.flush();
            return byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public final boolean setCursorPosition(int n) throws IOException {
        return this.moveCursor(n - this.buf.cursor) != 0;
    }

    private void setBuffer(String string) throws IOException {
        int n;
        if (string.equals(this.buf.buffer.toString())) {
            return;
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = this.buf.buffer.length();
        for (n = 0; n < n3 && n < n4 && string.charAt(n) == this.buf.buffer.charAt(n); ++n) {
            ++n2;
        }
        n = this.buf.cursor - n2;
        if (n < 0) {
            this.moveToEnd();
            n = this.buf.buffer.length() - n2;
        }
        this.backspace(n);
        this.killLine();
        this.buf.buffer.setLength(n2);
        this.putString(string.substring(n2));
    }

    private void setBuffer(CharSequence charSequence) throws IOException {
        this.setBuffer(String.valueOf(charSequence));
    }

    public final void drawLine() throws IOException {
        String string = this.getPrompt();
        if (string != null) {
            this.print(string);
        }
        this.print(this.buf.buffer.toString());
        if (this.buf.length() != this.buf.cursor) {
            this.back(this.buf.length() - this.buf.cursor - 1);
        }
        this.drawBuffer();
    }

    public final void redrawLine() throws IOException {
        this.print(13);
        this.drawLine();
    }

    final String finishBuffer() throws IOException {
        String string = this.buf.buffer.toString();
        if (this.expandEvents) {
            string = this.expandEvents(string);
        }
        if (string.length() > 0) {
            if (this.mask == null && this.isHistoryEnabled()) {
                this.history.add(string);
            } else {
                this.mask = null;
            }
        }
        this.history.moveToEnd();
        this.buf.buffer.setLength(0);
        this.buf.cursor = 0;
        return string;
    }

    protected String expandEvents(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        block14: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '!': {
                    String string2;
                    int n;
                    if (i + 1 < string.length()) {
                        c = string.charAt(++i);
                        n = 0;
                        String string3 = null;
                        switch (c) {
                            case '!': {
                                if (this.history.size() == 0) {
                                    throw new IllegalArgumentException("!!: event not found");
                                }
                                string3 = this.history.get(this.history.index() - 1).toString();
                                break;
                            }
                            case '#': {
                                stringBuilder.append(stringBuilder.toString());
                                break;
                            }
                            case '?': {
                                int n2 = string.indexOf(63, i + 1);
                                if (n2 < 0) {
                                    n2 = string.length();
                                }
                                string2 = string.substring(i + 1, n2);
                                i = n2;
                                int n3 = this.searchBackwards(string2);
                                if (n3 < 0) {
                                    throw new IllegalArgumentException("!?" + string2 + ": event not found");
                                }
                                string3 = this.history.get(n3).toString();
                                break;
                            }
                            case '\t': 
                            case ' ': {
                                stringBuilder.append('!');
                                stringBuilder.append(c);
                                break;
                            }
                            case '-': {
                                n = 1;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                int n4 = ++i;
                                while (i < string.length() && (c = string.charAt(i)) >= '0' && c <= '9') {
                                    ++i;
                                }
                                int n5 = 0;
                                try {
                                    n5 = Integer.parseInt(string.substring(n4, i));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new IllegalArgumentException((n != 0 ? "!-" : "!") + string.substring(n4, i) + ": event not found");
                                }
                                if (n != 0) {
                                    if (n5 < this.history.size()) {
                                        string3 = this.history.get(this.history.index() - n5).toString();
                                        break;
                                    }
                                    throw new IllegalArgumentException((n != 0 ? "!-" : "!") + string.substring(n4, i) + ": event not found");
                                }
                                if (n5 >= this.history.index() - this.history.size() && n5 < this.history.index()) {
                                    string3 = this.history.get(n5).toString();
                                    break;
                                }
                                throw new IllegalArgumentException((n != 0 ? "!-" : "!") + string.substring(n4, i) + ": event not found");
                            }
                            default: {
                                String string4 = string.substring(i);
                                i = string.length();
                                int n6 = this.searchBackwards(string4, this.history.index(), true);
                                if (n6 < 0) {
                                    throw new IllegalArgumentException("!" + string4 + ": event not found");
                                }
                                string3 = this.history.get(n6).toString();
                            }
                        }
                        if (string3 == null) continue block14;
                        stringBuilder.append(string3);
                        continue block14;
                    }
                    stringBuilder.append(c);
                    continue block14;
                }
                case '^': {
                    String string2;
                    int n;
                    if (i == 0) {
                        n = string.indexOf(94, i + 1);
                        int n7 = string.indexOf(94, n + 1);
                        if (n7 < 0) {
                            n7 = string.length();
                        }
                        if (n > 0 && n7 > 0) {
                            String string5 = string.substring(i + 1, n);
                            String string6 = string.substring(n + 1, n7);
                            string2 = this.history.get(this.history.index() - 1).toString().replace(string5, string6);
                            stringBuilder.append(string2);
                            i = n7 + 1;
                            continue block14;
                        }
                    }
                    stringBuilder.append(c);
                    continue block14;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        String string7 = stringBuilder.toString();
        if (!string.equals(string7)) {
            this.print(string7);
            this.println();
            this.flush();
        }
        return string7;
    }

    public final void putString(CharSequence charSequence) throws IOException {
        this.buf.write(charSequence);
        this.print(charSequence);
        this.drawBuffer();
    }

    private void putChar(int n, boolean bl) throws IOException {
        this.buf.write((char)n);
        if (bl) {
            if (this.mask == null) {
                this.print(n);
            } else if (this.mask.charValue() != '\u0000') {
                this.print((int)this.mask.charValue());
            }
            this.drawBuffer();
        }
    }

    private void drawBuffer(int n) throws IOException {
        if (this.buf.cursor != this.buf.length() || n != 0) {
            char[] cArray = this.buf.buffer.substring(this.buf.cursor).toCharArray();
            if (this.mask != null) {
                Arrays.fill(cArray, this.mask.charValue());
            }
            if (this.getTerminal().hasWeirdWrap()) {
                int n2 = this.getTerminal().getWidth();
                int n3 = this.getCursorPosition();
                for (int i = 0; i < cArray.length; ++i) {
                    this.print((int)cArray[i]);
                    if ((n3 + i + 1) % n2 != 0) continue;
                    this.print(32);
                    this.print(13);
                }
            } else {
                this.print(cArray);
            }
            this.clearAhead(n, cArray.length);
            if (this.getTerminal().isAnsiSupported()) {
                if (cArray.length > 0) {
                    this.back(cArray.length);
                }
            } else {
                this.back(cArray.length);
            }
        }
        if (this.getTerminal().hasWeirdWrap()) {
            int n4 = this.getTerminal().getWidth();
            if (this.getCursorPosition() > 0 && this.getCursorPosition() % n4 == 0 && this.buf.cursor == this.buf.length() && n == 0) {
                this.print(32);
                this.print(13);
            }
        }
    }

    private void drawBuffer() throws IOException {
        this.drawBuffer(0);
    }

    private void clearAhead(int n, int n2) throws IOException {
        if (n == 0) {
            return;
        }
        if (this.getTerminal().isAnsiSupported()) {
            int n3;
            int n4 = this.getTerminal().getWidth();
            int n5 = this.getCursorPosition() + n2;
            this.printAnsiSequence("K");
            int n6 = n5 % n4;
            int n7 = (n5 + n - 1) % n4;
            int n8 = n / n4;
            if (n7 < n6) {
                ++n8;
            }
            for (n3 = 0; n3 < n8; ++n3) {
                this.printAnsiSequence("B");
                this.printAnsiSequence("2K");
            }
            for (n3 = 0; n3 < n8; ++n3) {
                this.printAnsiSequence("A");
            }
            return;
        }
        this.print(' ', n);
        this.back(n);
    }

    protected void back(int n) throws IOException {
        if (n == 0) {
            return;
        }
        if (this.getTerminal().isAnsiSupported()) {
            int n2 = this.getTerminal().getWidth();
            int n3 = this.getCursorPosition();
            int n4 = n3 + n;
            int n5 = n4 % n2;
            int n6 = n3 % n2;
            int n7 = n / n2;
            int n8 = n5 - n6;
            if (n8 < 0) {
                ++n7;
            }
            if (n7 > 0) {
                this.printAnsiSequence(n7 + "A");
            }
            this.printAnsiSequence(1 + n6 + "G");
            return;
        }
        this.print('\b', n);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    private int backspaceAll() throws IOException {
        return this.backspace(Integer.MAX_VALUE);
    }

    private int backspace(int n) throws IOException {
        if (this.buf.cursor == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = this.getTerminal().getWidth();
        int n4 = this.getCursorPosition() / n3;
        n2 = this.moveCursor(-1 * n) * -1;
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + n2);
        if (this.getCursorPosition() / n3 != n4 && this.getTerminal().isAnsiSupported()) {
            this.printAnsiSequence("K");
        }
        this.drawBuffer(n2);
        return n2;
    }

    public boolean backspace() throws IOException {
        return this.backspace(1) == 1;
    }

    protected boolean moveToEnd() throws IOException {
        return this.moveCursor(this.buf.length() - this.buf.cursor) > 0;
    }

    private boolean deleteCurrentCharacter() throws IOException {
        if (this.buf.length() == 0 || this.buf.cursor == this.buf.length()) {
            return false;
        }
        this.buf.buffer.deleteCharAt(this.buf.cursor);
        this.drawBuffer(1);
        return true;
    }

    private boolean previousWord() throws IOException {
        while (this.isDelimiter(this.buf.charLeftOfCursor()) && this.moveCursor(-1) != 0) {
        }
        while (!this.isDelimiter(this.buf.charLeftOfCursor()) && this.moveCursor(-1) != 0) {
        }
        return true;
    }

    private boolean nextWord() throws IOException {
        while (this.isDelimiter(this.buf.charAtCursor()) && this.moveCursor(1) != 0) {
        }
        while (!this.isDelimiter(this.buf.charAtCursor()) && this.moveCursor(1) != 0) {
        }
        return true;
    }

    private boolean deletePreviousWord() throws IOException {
        while (this.isDelimiter(this.buf.charLeftOfCursor()) && this.backspace()) {
        }
        while (!this.isDelimiter(this.buf.charLeftOfCursor()) && this.backspace()) {
        }
        return true;
    }

    private boolean deleteNextWord() throws IOException {
        while (this.isDelimiter(this.buf.charAtCursor()) && this.deleteCurrentCharacter()) {
        }
        while (!this.isDelimiter(this.buf.charAtCursor()) && this.deleteCurrentCharacter()) {
        }
        return true;
    }

    public int moveCursor(int n) throws IOException {
        int n2 = n;
        if (this.buf.cursor == 0 && n2 <= 0) {
            return 0;
        }
        if (this.buf.cursor == this.buf.buffer.length() && n2 >= 0) {
            return 0;
        }
        if (this.buf.cursor + n2 < 0) {
            n2 = -this.buf.cursor;
        } else if (this.buf.cursor + n2 > this.buf.buffer.length()) {
            n2 = this.buf.buffer.length() - this.buf.cursor;
        }
        this.moveInternal(n2);
        return n2;
    }

    private void moveInternal(int n) throws IOException {
        this.buf.cursor += n;
        if (this.getTerminal().isAnsiSupported()) {
            if (n < 0) {
                this.back(Math.abs(n));
            } else {
                int n2;
                int n3 = this.getTerminal().getWidth();
                int n4 = this.getCursorPosition();
                int n5 = n4 / n3;
                if (n5 > (n2 = (n4 - n) / n3)) {
                    if (this.getTerminal().hasWeirdWrap() && this.getCurrentAnsiRow() == this.getTerminal().getHeight()) {
                        this.printAnsiSequence(n5 - n2 + "S");
                    }
                    this.printAnsiSequence(n5 - n2 + "B");
                }
                this.printAnsiSequence(1 + n4 % n3 + "G");
            }
            return;
        }
        if (n < 0) {
            int n6 = 0;
            for (int i = this.buf.cursor; i < this.buf.cursor - n; ++i) {
                if (this.buf.buffer.charAt(i) == '\t') {
                    n6 += 4;
                    continue;
                }
                ++n6;
            }
            char[] cArray = new char[n6];
            Arrays.fill(cArray, '\b');
            this.out.write(cArray);
            return;
        }
        if (this.buf.cursor == 0) {
            return;
        }
        if (this.mask == null) {
            this.print(this.buf.buffer.substring(this.buf.cursor - n, this.buf.cursor).toCharArray());
            return;
        }
        char c = this.mask.charValue();
        if (this.mask.charValue() == '\u0000') {
            return;
        }
        this.print(c, Math.abs(n));
    }

    public final boolean replace(int n, String string) {
        this.buf.buffer.replace(this.buf.cursor - n, this.buf.cursor, string);
        try {
            this.moveCursor(-n);
            this.drawBuffer(Math.max(0, n - string.length()));
            this.moveCursor(string.length());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public final int readVirtualKey() throws IOException {
        int n = this.getTerminal().readVirtualKey(this.in);
        Log.trace("Keystroke: ", n);
        this.clearEcho(n);
        return n;
    }

    private int clearEcho(int n) throws IOException {
        if (!this.getTerminal().isEchoEnabled()) {
            return 0;
        }
        int n2 = this.countEchoCharacters((char)n);
        this.back(n2);
        this.drawBuffer(n2);
        return n2;
    }

    private int countEchoCharacters(char c) {
        if (c == '\t') {
            int n = 8;
            int n2 = this.getCursorPosition();
            return n - n2 % n;
        }
        return this.getPrintableCharacters(c).length();
    }

    private StringBuilder getPrintableCharacters(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        if (c >= ' ') {
            if (c < '\u007f') {
                stringBuilder.append(c);
            } else if (c == '\u007f') {
                stringBuilder.append('^');
                stringBuilder.append('?');
            } else {
                stringBuilder.append('M');
                stringBuilder.append('-');
                if (c >= '\u00a0') {
                    if (c < '\u00ff') {
                        stringBuilder.append((char)(c - 128));
                    } else {
                        stringBuilder.append('^');
                        stringBuilder.append('?');
                    }
                } else {
                    stringBuilder.append('^');
                    stringBuilder.append((char)(c - 128 + 64));
                }
            }
        } else {
            stringBuilder.append('^');
            stringBuilder.append((char)(c + 64));
        }
        return stringBuilder;
    }

    public final int readCharacter(char ... cArray) throws IOException {
        char c;
        Arrays.sort(cArray);
        while (Arrays.binarySearch(cArray, c = (char)this.readVirtualKey()) < 0) {
        }
        return c;
    }

    private short[] loadKeyBindings(InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        if (inputStream == null) {
            try {
                object2 = new File(Configuration.getUserHome(), JLINEBINDINGS_PROPERTIES);
                object = Configuration.getString(JLINE_KEYBINDINGS);
                if (object != null) {
                    object2 = new File((String)object);
                }
                if (((File)object2).isFile()) {
                    Log.debug("Loading user bindings from: ", object2);
                    inputStream = new FileInputStream((File)object2);
                }
            }
            catch (Exception exception) {
                Log.error("Failed to load user bindings", exception);
            }
        }
        if (inputStream == null) {
            Log.debug("Using default bindings");
            inputStream = this.getTerminal().getDefaultBindings();
        }
        object2 = new short[131070];
        Arrays.fill((short[])object2, Operation.UNKNOWN.code);
        if (inputStream != null) {
            inputStream = new BufferedInputStream(inputStream);
            object = new Properties();
            ((Properties)object).load(inputStream);
            inputStream.close();
            for (Object object3 : ((Properties)object).keySet()) {
                String string = (String)object3;
                try {
                    short s = Short.parseShort(string);
                    String string2 = ((Properties)object).getProperty(string);
                    Operation operation = Operation.valueOf(string2);
                    object2[s] = operation.code;
                }
                catch (NumberFormatException numberFormatException) {
                    Log.error("Failed to convert binding code: ", string, numberFormatException);
                }
            }
        }
        return object2;
    }

    int getKeyForAction(short s) {
        for (int i = 0; i < this.keyBindings.length; ++i) {
            if (this.keyBindings[i] != s) continue;
            return i;
        }
        return -1;
    }

    int getKeyForAction(Operation operation) {
        assert (operation != null);
        return this.getKeyForAction(operation.code);
    }

    public void printBindings() {
        System.out.println("printBindings(): keyBindings.length = " + this.keyBindings.length);
        for (int i = 0; i < this.keyBindings.length; ++i) {
            if (this.keyBindings[i] == Operation.UNKNOWN.code) continue;
            System.out.println("keyBindings[" + i + "] = " + this.keyBindings[i]);
        }
    }

    private int[] readBinding() throws IOException {
        int n = this.readVirtualKey();
        if (n == -1) {
            return null;
        }
        int n2 = this.keyBindings[n];
        Log.trace("Translated: ", n, " -> ", (short)n2);
        return new int[]{n, n2};
    }

    public String readLine() throws IOException {
        return this.readLine((String)null);
    }

    public String readLine(Character c) throws IOException {
        return this.readLine(null, c);
    }

    public String readLine(String string) throws IOException {
        return this.readLine(string, null);
    }

    public String readLine(String string, Character c) throws IOException {
        this.mask = c;
        if (string != null) {
            this.setPrompt(string);
        } else {
            string = this.getPrompt();
        }
        try {
            if (!this.getTerminal().isSupported()) {
                this.beforeReadLine(string, c);
            }
            if (string != null && string.length() > 0) {
                this.out.write(string);
                this.out.flush();
            }
            if (!this.getTerminal().isSupported()) {
                String string2 = this.readLine(this.in);
                return string2;
            }
            String string3 = this.prompt;
            int n = 1;
            boolean bl = true;
            while (true) {
                int[] nArray;
                if ((nArray = this.readBinding()) == null) {
                    String string4 = null;
                    return string4;
                }
                int n2 = nArray[0];
                Operation operation = Operation.valueOf(nArray[1]);
                if (n2 == -1) {
                    String string5 = null;
                    return string5;
                }
                if (n == 2) {
                    int n3 = -1;
                    switch (operation) {
                        case ABORT: {
                            n = 1;
                            break;
                        }
                        case SEARCH_PREV: {
                            if (this.searchTerm.length() == 0) {
                                this.searchTerm.append(this.previousSearchTerm);
                            }
                            if (this.searchIndex == -1) {
                                this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                                break;
                            }
                            this.searchIndex = this.searchBackwards(this.searchTerm.toString(), this.searchIndex);
                            break;
                        }
                        case DELETE_PREV_CHAR: {
                            if (this.searchTerm.length() <= 0) break;
                            this.searchTerm.deleteCharAt(this.searchTerm.length() - 1);
                            this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                            break;
                        }
                        case UNKNOWN: {
                            this.searchTerm.appendCodePoint(n2);
                            this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                            break;
                        }
                        default: {
                            if (this.searchIndex != -1) {
                                this.history.moveTo(this.searchIndex);
                                n3 = this.history.current().toString().indexOf(this.searchTerm.toString());
                            }
                            n = 1;
                        }
                    }
                    if (n == 2) {
                        if (this.searchTerm.length() == 0) {
                            this.printSearchStatus("", "");
                            this.searchIndex = -1;
                        } else if (this.searchIndex == -1) {
                            this.beep();
                        } else {
                            this.printSearchStatus(this.searchTerm.toString(), this.history.get(this.searchIndex).toString());
                        }
                    } else {
                        this.restoreLine(string3, n3);
                    }
                }
                if (n != 1) continue;
                switch (operation) {
                    case EXIT: {
                        if (this.buf.buffer.length() == 0) {
                            String string6 = null;
                            return string6;
                        }
                        bl = this.deleteCurrentCharacter();
                        break;
                    }
                    case COMPLETE: {
                        bl = this.complete();
                        break;
                    }
                    case MOVE_TO_BEG: {
                        bl = this.setCursorPosition(0);
                        break;
                    }
                    case KILL_LINE: {
                        bl = this.killLine();
                        break;
                    }
                    case CLEAR_SCREEN: {
                        bl = this.clearScreen();
                        break;
                    }
                    case KILL_LINE_PREV: {
                        bl = this.resetLine();
                        break;
                    }
                    case NEWLINE: {
                        this.moveToEnd();
                        this.println();
                        this.flush();
                        String string7 = this.finishBuffer();
                        return string7;
                    }
                    case DELETE_PREV_CHAR: {
                        bl = this.backspace();
                        break;
                    }
                    case DELETE_NEXT_CHAR: {
                        bl = this.deleteCurrentCharacter();
                        break;
                    }
                    case MOVE_TO_END: {
                        bl = this.moveToEnd();
                        break;
                    }
                    case PREV_CHAR: {
                        bl = this.moveCursor(-1) != 0;
                        break;
                    }
                    case NEXT_CHAR: {
                        bl = this.moveCursor(1) != 0;
                        break;
                    }
                    case NEXT_HISTORY: {
                        bl = this.moveHistory(true);
                        break;
                    }
                    case PREV_HISTORY: {
                        bl = this.moveHistory(false);
                        break;
                    }
                    case ABORT: 
                    case REDISPLAY: {
                        break;
                    }
                    case PASTE: {
                        bl = this.paste();
                        break;
                    }
                    case DELETE_PREV_WORD: {
                        bl = this.deletePreviousWord();
                        break;
                    }
                    case DELETE_NEXT_WORD: {
                        bl = this.deleteNextWord();
                        break;
                    }
                    case PREV_WORD: {
                        bl = this.previousWord();
                        break;
                    }
                    case NEXT_WORD: {
                        bl = this.nextWord();
                        break;
                    }
                    case START_OF_HISTORY: {
                        bl = this.history.moveToFirst();
                        if (!bl) break;
                        this.setBuffer(this.history.current());
                        break;
                    }
                    case END_OF_HISTORY: {
                        bl = this.history.moveToLast();
                        if (!bl) break;
                        this.setBuffer(this.history.current());
                        break;
                    }
                    case CLEAR_LINE: {
                        this.moveInternal(-this.buf.cursor);
                        this.killLine();
                        break;
                    }
                    case INSERT: {
                        this.buf.setOverTyping(!this.buf.isOverTyping());
                        break;
                    }
                    case SEARCH_PREV: {
                        if (this.searchTerm != null) {
                            this.previousSearchTerm = this.searchTerm.toString();
                        }
                        this.searchTerm = new StringBuffer(this.buf.buffer);
                        n = 2;
                        if (this.searchTerm.length() > 0) {
                            this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                            if (this.searchIndex == -1) {
                                this.beep();
                            }
                            this.printSearchStatus(this.searchTerm.toString(), this.searchIndex > -1 ? this.history.get(this.searchIndex).toString() : "");
                            break;
                        }
                        this.searchIndex = -1;
                        this.printSearchStatus("", "");
                        break;
                    }
                    default: {
                        if (n2 != 0) {
                            ActionListener actionListener = this.triggeredActions.get(Character.valueOf((char)n2));
                            if (actionListener != null) {
                                actionListener.actionPerformed(null);
                                break;
                            }
                            this.putChar(n2, true);
                            break;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    this.beep();
                }
                this.flush();
            }
        }
        finally {
            if (!this.getTerminal().isSupported()) {
                this.afterReadLine();
            }
        }
    }

    private String readLine(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n;
        while ((n = inputStream.read()) != -1 && n != 10 && n != 13) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public boolean addCompleter(Completer completer) {
        return this.completers.add(completer);
    }

    public boolean removeCompleter(Completer completer) {
        return this.completers.remove(completer);
    }

    public Collection<Completer> getCompleters() {
        return Collections.unmodifiableList(this.completers);
    }

    public void setCompletionHandler(CompletionHandler completionHandler) {
        assert (completionHandler != null);
        this.completionHandler = completionHandler;
    }

    public CompletionHandler getCompletionHandler() {
        return this.completionHandler;
    }

    protected boolean complete() throws IOException {
        Completer completer;
        if (this.completers.size() == 0) {
            return false;
        }
        LinkedList<CharSequence> linkedList = new LinkedList<CharSequence>();
        String string = this.buf.buffer.toString();
        int n = this.buf.cursor;
        int n2 = -1;
        Iterator<Completer> iterator = this.completers.iterator();
        while (iterator.hasNext() && (n2 = (completer = iterator.next()).complete(string, n, linkedList)) == -1) {
        }
        return linkedList.size() != 0 && this.getCompletionHandler().complete(this, linkedList, n2);
    }

    public void setAutoprintThreshold(int n) {
        this.autoprintThreshold = n;
    }

    public int getAutoprintThreshold() {
        return this.autoprintThreshold;
    }

    public void setPaginationEnabled(boolean bl) {
        this.paginationEnabled = bl;
    }

    public boolean isPaginationEnabled() {
        return this.paginationEnabled;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public History getHistory() {
        return this.history;
    }

    public void setHistoryEnabled(boolean bl) {
        this.historyEnabled = bl;
    }

    public boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    private boolean moveHistory(boolean bl) throws IOException {
        if (bl && !this.history.next()) {
            return false;
        }
        if (!bl && !this.history.previous()) {
            return false;
        }
        this.setBuffer(this.history.current());
        return true;
    }

    private void print(int n) throws IOException {
        if (n == 9) {
            char[] cArray = new char[4];
            Arrays.fill(cArray, ' ');
            this.out.write(cArray);
            return;
        }
        this.out.write(n);
    }

    private void print(char ... cArray) throws IOException {
        char[] cArray2;
        int n = 0;
        for (char n2 : cArray) {
            if (n2 == '\t') {
                n += 4;
                continue;
            }
            ++n;
        }
        if (n == cArray.length) {
            cArray2 = cArray;
        } else {
            cArray2 = new char[n];
            int n3 = 0;
            for (char c : cArray) {
                if (c == '\t') {
                    Arrays.fill(cArray2, n3, n3 + 4, ' ');
                    n3 += 4;
                    continue;
                }
                cArray2[n3] = c;
                ++n3;
            }
        }
        this.out.write(cArray2);
    }

    private void print(char c, int n) throws IOException {
        if (n == 1) {
            this.print((int)c);
        } else {
            char[] cArray = new char[n];
            Arrays.fill(cArray, c);
            this.print(cArray);
        }
    }

    public final void print(CharSequence charSequence) throws IOException {
        assert (charSequence != null);
        this.print(charSequence.toString().toCharArray());
    }

    public final void println(CharSequence charSequence) throws IOException {
        assert (charSequence != null);
        this.print(charSequence.toString().toCharArray());
        this.println();
    }

    public final void println() throws IOException {
        this.print(CR);
    }

    public final boolean delete() throws IOException {
        return this.delete(1) == 1;
    }

    private int delete(int n) throws IOException {
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + 1);
        this.drawBuffer(1);
        return 1;
    }

    public boolean killLine() throws IOException {
        int n = this.buf.cursor;
        int n2 = this.buf.buffer.length();
        if (n >= n2) {
            return false;
        }
        int n3 = this.buf.buffer.length() - n;
        this.clearAhead(n3, 0);
        for (int i = 0; i < n3; ++i) {
            this.buf.buffer.deleteCharAt(n2 - i - 1);
        }
        return true;
    }

    public boolean clearScreen() throws IOException {
        if (!this.getTerminal().isAnsiSupported()) {
            return false;
        }
        this.printAnsiSequence("2J");
        this.printAnsiSequence("1;1H");
        this.redrawLine();
        return true;
    }

    public void beep() throws IOException {
        if (this.isBellEnabled()) {
            this.print(7);
            this.flush();
        }
    }

    public boolean paste() throws IOException {
        Clipboard clipboard;
        try {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            return false;
        }
        if (clipboard == null) {
            return false;
        }
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return false;
        }
        try {
            String string;
            Object object = transferable.getTransferData(DataFlavor.plainTextFlavor);
            if (object == null) {
                try {
                    object = new DataFlavor().getReaderForText(transferable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object == null) {
                return false;
            }
            if (object instanceof Reader) {
                String string2;
                string = "";
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string.length() > 0) {
                        string = string + "\n";
                    }
                    string = string + string2;
                }
            } else {
                string = object.toString();
            }
            if (string == null) {
                return true;
            }
            this.putString(string);
            return true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Log.error("Paste failed: ", unsupportedFlavorException);
            return false;
        }
    }

    public void addTriggeredAction(char c, ActionListener actionListener) {
        this.triggeredActions.put(Character.valueOf(c), actionListener);
    }

    public void printColumns(Collection<? extends CharSequence> collection) throws IOException {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        int n = this.getTerminal().getWidth();
        int n2 = this.getTerminal().getHeight();
        int n3 = 0;
        for (CharSequence charSequence2 : collection) {
            n3 = Math.max(n3, charSequence2.length());
        }
        Log.debug("Max width: ", n3);
        int n4 = this.isPaginationEnabled() ? n2 - 1 : Integer.MAX_VALUE;
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence charSequence : collection) {
            int n5;
            if (stringBuilder.length() + n3 > n) {
                this.println(stringBuilder);
                stringBuilder.setLength(0);
                if (--n4 == 0) {
                    this.print(resources.getString("display-more"));
                    this.flush();
                    n5 = this.readVirtualKey();
                    if (n5 == 13 || n5 == 10) {
                        n4 = 1;
                    } else if (n5 != 113) {
                        n4 = n2 - 1;
                    }
                    this.back(resources.getString("display-more").length());
                    if (n5 == 113) break;
                }
            }
            stringBuilder.append(charSequence.toString());
            for (n5 = 0; n5 < n3 + 3 - charSequence.length(); ++n5) {
                stringBuilder.append(' ');
            }
        }
        if (stringBuilder.length() > 0) {
            this.println(stringBuilder);
        }
    }

    private void beforeReadLine(String string, Character c) {
        if (c != null && this.maskThread == null) {
            final String string2 = "\r" + string + "                 " + "                 " + "                 " + "\r" + string;
            this.maskThread = new Thread(){

                public void run() {
                    while (!1.interrupted()) {
                        try {
                            Writer writer = ConsoleReader.this.getOutput();
                            writer.write(string2);
                            writer.flush();
                            1.sleep(3L);
                        }
                        catch (IOException iOException) {
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
            };
            this.maskThread.setPriority(10);
            this.maskThread.setDaemon(true);
            this.maskThread.start();
        }
    }

    private void afterReadLine() {
        if (this.maskThread != null && this.maskThread.isAlive()) {
            this.maskThread.interrupt();
        }
        this.maskThread = null;
    }

    public void resetPromptLine(String string, String string2, int n) throws IOException {
        this.moveToEnd();
        this.buf.buffer.append(this.prompt);
        this.buf.cursor += this.prompt.length();
        this.prompt = "";
        this.backspaceAll();
        this.prompt = string;
        this.redrawLine();
        this.setBuffer(string2);
        if (n < 0) {
            n = string2.length();
        }
        this.setCursorPosition(n);
        this.flush();
    }

    public void printSearchStatus(String string, String string2) throws IOException {
        String string3 = "(reverse-i-search)`" + string + "': ";
        String string4 = string2;
        int n = string2.indexOf(string);
        this.resetPromptLine(string3, string4, n);
    }

    public void restoreLine(String string, int n) throws IOException {
        String string2 = this.lastLine(string);
        String string3 = this.buf.buffer.toString();
        this.resetPromptLine(string2, string3, n);
    }

    public int searchBackwards(String string, int n) {
        return this.searchBackwards(string, n, false);
    }

    public int searchBackwards(String string) {
        return this.searchBackwards(string, this.history.index());
    }

    public int searchBackwards(String string, int n, boolean bl) {
        ListIterator<History.Entry> listIterator = this.history.entries(n);
        while (listIterator.hasPrevious()) {
            History.Entry entry = listIterator.previous();
            if (!(bl ? entry.value().toString().startsWith(string) : entry.value().toString().contains(string))) continue;
            return entry.index();
        }
        return -1;
    }

    private boolean isDelimiter(char c) {
        return !Character.isLetterOrDigit(c);
    }

    private void printAnsiSequence(String string) throws IOException {
        this.print(27);
        this.print(91);
        this.print(string);
        this.flush();
    }

    private int getCurrentPosition() {
        if (this.getTerminal().isAnsiSupported() && !(this.in instanceof ByteArrayInputStream)) {
            try {
                int n;
                this.printAnsiSequence("6n");
                this.flush();
                StringBuffer stringBuffer = new StringBuffer(8);
                while ((n = this.in.read()) > -1 && n != 82) {
                    if (n == 27 || n == 91) continue;
                    stringBuffer.append((char)n);
                }
                String[] stringArray = stringBuffer.toString().split(";");
                return Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    private int getCurrentAnsiRow() {
        if (this.getTerminal().isAnsiSupported() && !(this.in instanceof ByteArrayInputStream)) {
            try {
                int n;
                this.printAnsiSequence("6n");
                this.flush();
                StringBuffer stringBuffer = new StringBuffer(8);
                while ((n = this.in.read()) > -1 && n != 82) {
                    if (n == 27 || n == 91) continue;
                    stringBuffer.append((char)n);
                }
                String[] stringArray = stringBuffer.toString().split(";");
                return Integer.parseInt(stringArray[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }
}

