/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.logic.messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupTrackingItem;
import org.sakaiproject.signup.logic.messages.OrganizerEmailBase;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.user.api.User;

public class AttendeeCancellationEmail
extends OrganizerEmailBase {
    private final User organizer;
    private final User initiator;
    private final List<SignupTrackingItem> items;

    public AttendeeCancellationEmail(User organizer, User initiator, List<SignupTrackingItem> items, SignupMeeting meeting, SakaiFacade sakaiFacade) {
        this.organizer = organizer;
        this.initiator = initiator;
        this.items = items;
        this.meeting = meeting;
        this.setSakaiFacade(sakaiFacade);
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> rv = new ArrayList<String>();
        rv.add("Content-Type: text/html; charset=UTF-8");
        rv.add("Subject: " + this.getSubject());
        rv.add("From: " + this.getFromAddress());
        rv.add("To: " + this.organizer.getEmail());
        return rv;
    }

    @Override
    public String getMessage() {
        SignupTrackingItem intiatorItem = null;
        for (SignupTrackingItem item : this.items) {
            if (!item.isInitiator()) continue;
            intiatorItem = item;
            break;
        }
        StringBuilder message = new StringBuilder();
        message.append(MessageFormat.format(rb.getString("body.top.greeting.part"), this.makeFirstCapLetter(this.organizer.getDisplayName())));
        Object[] params = new Object[]{this.makeFirstCapLetter(this.initiator.getDisplayName()), this.getSiteTitleWithQuote(), this.getServiceName()};
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.attendee.cancel.appointment.part"), params));
        message.append("<BR>\r\n<BR>\r\n" + MessageFormat.format(rb.getString("body.meetingTopic.part"), this.meeting.getTitle()));
        message.append("<BR>\r\n" + rb.getString("body.timeslot") + " ");
        if (intiatorItem.getRemovedFromTimeslot() != null && !intiatorItem.getRemovedFromTimeslot().isEmpty()) {
            if (!this.meeting.isMeetingCrossDays()) {
                Object[] paramsTimeframe = new Object[]{this.getTime(((SignupTimeslot)intiatorItem.getRemovedFromTimeslot().get(0)).getStartTime()).toStringLocalTime(), this.getTime(((SignupTimeslot)intiatorItem.getRemovedFromTimeslot().get(0)).getEndTime()).toStringLocalTime(), this.getTime(((SignupTimeslot)intiatorItem.getRemovedFromTimeslot().get(0)).getStartTime()).toStringLocalDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
                message.append(MessageFormat.format(rb.getString("body.meeting.timeslot.timeframe"), paramsTimeframe));
            } else {
                Object[] paramsTimeframe = new Object[]{this.getTime(((SignupTimeslot)intiatorItem.getRemovedFromTimeslot().get(0)).getStartTime()).toStringLocalTime(), this.getTime(((SignupTimeslot)intiatorItem.getRemovedFromTimeslot().get(0)).getStartTime()).toStringLocalShortDate(), this.getTime(((SignupTimeslot)intiatorItem.getRemovedFromTimeslot().get(0)).getEndTime()).toStringLocalTime(), this.getTime(((SignupTimeslot)intiatorItem.getRemovedFromTimeslot().get(0)).getEndTime()).toStringLocalShortDate(), this.getSakaiFacade().getTimeService().getLocalTimeZone().getID()};
                message.append(MessageFormat.format(rb.getString("body.meeting.crossdays.timeslot.timeframe"), paramsTimeframe));
            }
        }
        message.append("<BR>\r\n" + this.getFooter("<BR>\r\n"));
        return message.toString();
    }

    @Override
    public String getFromAddress() {
        return StringUtils.defaultIfEmpty((String)this.initiator.getEmail(), (String)this.getServerFromAddress());
    }

    @Override
    public String getSubject() {
        return MessageFormat.format(rb.getString("subject.Cancel.appointment.field"), this.getTime(this.meeting.getStartTime()).toStringLocalDate(), this.initiator.getDisplayName(), this.getAbbreviatedMeetingTitle());
    }
}

