/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.xml.impl;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import org.jdom.Element;
import org.jdom.Namespace;
import org.sakaiproject.metaobj.utils.xml.NormalizationException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.utils.xml.impl.NumberElementType;

public class DecimalElementType
extends NumberElementType {
    private Format format = null;
    private int fractionDigits = -1;

    public DecimalElementType(String typeName, Element schemaElement, SchemaNode parentNode, Namespace xsdNamespace) {
        super(typeName, schemaElement, parentNode, xsdNamespace);
        Element restrictions;
        Element simpleType = schemaElement.getChild("simpleType", xsdNamespace);
        if (simpleType != null && (restrictions = simpleType.getChild("restriction", xsdNamespace)) != null) {
            this.fractionDigits = this.processIntRestriction(restrictions, "fractionDigits", xsdNamespace, this.fractionDigits);
            if (this.fractionDigits != -1) {
                ((DecimalFormat)this.getFormatter()).setMaximumFractionDigits(this.fractionDigits);
                ((DecimalFormat)this.getFormatter()).setMinimumFractionDigits(this.fractionDigits);
            }
        }
    }

    @Override
    protected Format getFormatter() {
        if (this.format == null) {
            this.format = new DecimalFormat();
        }
        return this.format;
    }

    @Override
    protected Object checkConstraints(Object o) {
        double i = ((Number)o).doubleValue();
        if (this.maxIncl != null && i > this.maxIncl.doubleValue()) {
            throw new NormalizationException("Invalid number", "TOO_LARGE_INCLUSIVE_ERROR_CODE", new Object[]{o, this.maxIncl});
        }
        if (this.minIncl != null && i < this.minIncl.doubleValue()) {
            throw new NormalizationException("Invalid number", "TOO_SMALL_INCLUSIVE_ERROR_CODE", new Object[]{o, this.minIncl});
        }
        if (this.maxExcl != null && i >= this.maxExcl.doubleValue()) {
            throw new NormalizationException("Invalid number", "TOO_LARGE_ERROR_CODE", new Object[]{o, this.maxExcl});
        }
        if (this.minExcl != null && i <= this.minExcl.doubleValue()) {
            throw new NormalizationException("Invalid number", "TOO_SMALL_ERROR_CODE", new Object[]{o, this.minExcl});
        }
        if (this.totalDigits != -1 && o.toString().length() > this.totalDigits) {
            throw new NormalizationException("Invalid number", "TOO_MANY_DIGITS_ERROR_CODE", new Object[]{o, new Integer(this.totalDigits)});
        }
        return o;
    }

    @Override
    protected String parserException(String value, ParseException e) {
        throw new NormalizationException("Invalid number", "INVALID_DECIMAL_NUMBER_ERROR_CODE", new Object[]{value});
    }
}

