/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.metaobj.shared.mgt.AgentManager;
import org.sakaiproject.metaobj.shared.mgt.IdManager;
import org.sakaiproject.metaobj.shared.mgt.impl.FileArtifactFinder;
import org.sakaiproject.metaobj.shared.model.Agent;
import org.sakaiproject.metaobj.shared.model.ContentResourceArtifact;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.shared.model.MimeType;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.cover.SiteService;

public class WrappedStructuredArtifactFinder
extends FileArtifactFinder {
    private ContentHostingService contentHostingService;
    private AgentManager agentManager;
    private IdManager idManager;
    private int finderPageSize = 1000;
    private static Log log = LogFactory.getLog(WrappedStructuredArtifactFinder.class);

    @Override
    public Collection findByOwnerAndType(Id owner, String type) {
        if (owner == null) {
            log.info((Object)"Null owner passed to findByOwnerAndType -- returning all users' forms");
            return this.findByType(type);
        }
        TreeSet<String> siteIds = new TreeSet<String>();
        Site site2 = null;
        List siteList = SiteService.getSites((SiteService.SelectionType)SiteService.SelectionType.ACCESS, null, null, null, (SiteService.SortType)SiteService.SortType.NONE, null);
        for (Site site2 : siteList) {
            siteIds.add(site2.getId());
        }
        try {
            site2 = SiteService.getSite((String)SiteService.getUserSiteId((String)owner.getValue()));
            siteIds.add(site2.getId());
        }
        catch (Exception e) {
            log.info((Object)"findOwnerAndType", (Throwable)e);
        }
        Collection artifacts = this.getContentHostingService().getContextResourcesOfType("org.sakaiproject.metaobj.shared.FormHelper", siteIds);
        ArrayList<ContentResourceArtifact> returned = new ArrayList<ContentResourceArtifact>();
        for (ContentResource resource : artifacts) {
            Agent resourceOwner = this.getAgentManager().getAgent(resource.getProperties().getProperty("CHEF:creator"));
            String actualType = resource.getProperties().getProperty("SAKAI:structobj_type");
            if (owner != null && (!owner.equals((Object)resourceOwner.getId()) || type != null && !type.equals(actualType))) continue;
            Id resourceId = this.getIdManager().getId(this.getContentHostingService().getUuid(resource.getId()));
            returned.add(new ContentResourceArtifact(resource, resourceId, resourceOwner));
        }
        return returned;
    }

    @Override
    public Collection findByOwnerAndType(Id owner, String type, MimeType mimeType) {
        return null;
    }

    @Override
    public Collection findByOwner(Id owner) {
        return null;
    }

    @Override
    public Collection findByWorksiteAndType(Id worksiteId, String type) {
        return null;
    }

    @Override
    public Collection findByWorksite(Id worksiteId) {
        return null;
    }

    @Override
    public Collection findByType(String type) {
        return null;
    }

    @Override
    public boolean getLoadArtifacts() {
        return false;
    }

    @Override
    public void setLoadArtifacts(boolean loadArtifacts) {
    }

    @Override
    public ContentHostingService getContentHostingService() {
        return this.contentHostingService;
    }

    @Override
    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    @Override
    public AgentManager getAgentManager() {
        return this.agentManager;
    }

    @Override
    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    @Override
    public IdManager getIdManager() {
        return this.idManager;
    }

    @Override
    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public int getFinderPageSize() {
        return this.finderPageSize;
    }

    public void setFinderPageSize(int finderPageSize) {
        this.finderPageSize = finderPageSize;
    }
}

