/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.authz.cover.FunctionManager;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentCollectionEdit;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.event.cover.NotificationService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUniquenessException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.ImportException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.exception.UnsupportedFileTypeException;
import org.sakaiproject.metaobj.security.AllowChildrenMapSecurityAdvisor;
import org.sakaiproject.metaobj.security.AllowMapSecurityAdvisor;
import org.sakaiproject.metaobj.security.AuthenticationManager;
import org.sakaiproject.metaobj.security.AuthorizationFacade;
import org.sakaiproject.metaobj.shared.ArtifactFinder;
import org.sakaiproject.metaobj.shared.DownloadableManager;
import org.sakaiproject.metaobj.shared.mgt.FormConsumer;
import org.sakaiproject.metaobj.shared.mgt.IdManager;
import org.sakaiproject.metaobj.shared.mgt.PresentableObjectHome;
import org.sakaiproject.metaobj.shared.mgt.ReadableObjectHome;
import org.sakaiproject.metaobj.shared.mgt.StructuredArtifactDefinitionManager;
import org.sakaiproject.metaobj.shared.mgt.home.StructuredArtifactDefinition;
import org.sakaiproject.metaobj.shared.mgt.home.StructuredArtifactHomeInterface;
import org.sakaiproject.metaobj.shared.model.Agent;
import org.sakaiproject.metaobj.shared.model.Artifact;
import org.sakaiproject.metaobj.shared.model.ElementBean;
import org.sakaiproject.metaobj.shared.model.FormConsumptionDetail;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.shared.model.MimeType;
import org.sakaiproject.metaobj.shared.model.OspException;
import org.sakaiproject.metaobj.shared.model.PersistenceException;
import org.sakaiproject.metaobj.shared.model.StructuredArtifact;
import org.sakaiproject.metaobj.shared.model.StructuredArtifactDefinitionBean;
import org.sakaiproject.metaobj.utils.xml.SchemaFactory;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.worksite.mgt.WorksiteManager;
import org.sakaiproject.service.legacy.resource.DuplicatableToolService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class StructuredArtifactDefinitionManagerImpl
extends HibernateDaoSupport
implements StructuredArtifactDefinitionManager,
DuplicatableToolService,
DownloadableManager,
FormConsumer {
    private static final String DOWNLOAD_FORM_ID_PARAM = "formId";
    private static final String SYSTEM_COLLECTION_ID = "/system/";
    private static final String IMPORT_BASE_FOLDER_ID = "importedForms";
    private static final String HAS_HOMES_TAG = "org.sakaiproject.metaobj.hasHomes";
    private AuthorizationFacade authzManager = null;
    private IdManager idManager;
    private WorksiteManager worksiteManager;
    private ContentHostingService contentHosting;
    private ToolManager toolManager;
    private List globalSites;
    private List globalSiteTypes;
    private ArtifactFinder artifactFinder;
    private ArtifactFinder structuredArtifactFinder;
    private int expressionMax = 999;
    private boolean replaceViews = true;
    private List formConsumers;
    private SecurityService securityService;
    private boolean autoDdl = true;
    private boolean enableLocksConversion = true;
    private static ResourceLoader messages = new ResourceLoader("org.sakaiproject.metaobj.messages");

    public Map getHomes() {
        HashMap<String, StructuredArtifactDefinitionBean> returnMap = new HashMap<String, StructuredArtifactDefinitionBean>();
        List list = this.findHomes();
        for (StructuredArtifactDefinitionBean sad : list) {
            returnMap.put(sad.getId().getValue(), sad);
        }
        return returnMap;
    }

    public Map getWorksiteHomes(Id worksiteId) {
        return this.getWorksiteHomes(worksiteId, false);
    }

    public Map getWorksiteHomes(Id worksiteId, boolean includeHidden) {
        return this.getWorksiteHomes(worksiteId, null, includeHidden);
    }

    public Map getWorksiteHomes(Id worksiteId, String currentUserId, boolean includeHidden) {
        HashMap<String, StructuredArtifactDefinitionBean> returnMap = new HashMap<String, StructuredArtifactDefinitionBean>();
        List list = this.findGlobalHomes();
        if (currentUserId == null) {
            list.addAll(this.findHomes(worksiteId, includeHidden, false));
        } else {
            list.addAll(this.findAvailableHomes(worksiteId, currentUserId, includeHidden, false));
        }
        for (StructuredArtifactDefinitionBean sad : list) {
            returnMap.put(sad.getId().getValue(), sad);
        }
        return returnMap;
    }

    public List findHomes() {
        return this.findHomes(true);
    }

    public List findHomes(boolean includeHidden) {
        return this.findHomes(true, includeHidden);
    }

    public List findHomes(boolean includeGlobal, boolean includeHidden) {
        List sites = this.getWorksiteManager().getUserSites();
        ArrayList returned = new ArrayList();
        while (sites.size() > this.getExpressionMax()) {
            returned.addAll(this.findHomes(sites.subList(0, this.getExpressionMax() - 1), false, includeHidden));
            sites.subList(0, this.getExpressionMax() - 1).clear();
        }
        returned.addAll(this.findHomes(sites, includeGlobal, includeHidden));
        return returned;
    }

    public Map findCategorizedHomes(boolean includeHidden) {
        List homes = this.findHomes(false, includeHidden);
        Hashtable<String, ArrayList<StructuredArtifactDefinitionBean>> catHomes = new Hashtable<String, ArrayList<StructuredArtifactDefinitionBean>>();
        for (StructuredArtifactDefinitionBean bean : homes) {
            ArrayList<StructuredArtifactDefinitionBean> beanList = (ArrayList<StructuredArtifactDefinitionBean>)catHomes.get(bean.getSiteId());
            if (beanList == null) {
                beanList = new ArrayList<StructuredArtifactDefinitionBean>();
                catHomes.put(bean.getSiteId(), beanList);
            }
            beanList.add(bean);
        }
        return catHomes;
    }

    protected List findHomes(List sites, boolean includeGlobal, boolean includeHidden) {
        Object[] params;
        String query;
        if (includeGlobal) {
            query = "from StructuredArtifactDefinitionBean where ((globalState = ? or (owner = ? and siteId = null)) or ((owner = ? or siteState = ?)  and siteId in (";
            params = new Object[]{new Integer(2), this.getAuthManager().getAgent(), this.getAuthManager().getAgent(), new Integer(2)};
        } else {
            query = "from StructuredArtifactDefinitionBean where ((globalState != ? and (owner = ? or siteState = ?) and siteId in (";
            params = new Object[]{new Integer(2), this.getAuthManager().getAgent(), new Integer(2)};
        }
        StringBuffer bufQuery = new StringBuffer();
        for (Site site : sites) {
            bufQuery.append("'" + site.getId() + "',");
        }
        query = query + bufQuery.toString();
        query = query + "''))";
        query = includeHidden ? query + ")" : query + ") and systemOnly != true";
        return this.getHibernateTemplate().find(query, params);
    }

    private List<StructuredArtifactDefinitionBean> findAllHomes() {
        String query = "from StructuredArtifactDefinitionBean";
        return this.getHibernateTemplate().find(query);
    }

    public List findBySchema(ContentResource resource) {
        try {
            Object[] params = new Object[]{resource.getContent()};
            return this.getHibernateTemplate().findByNamedQuery("findBySchema", params);
        }
        catch (ServerOverloadException serverOverloadException) {
            return new ArrayList();
        }
    }

    public List findGlobalHomes() {
        Object[] params = new Object[]{new Integer(2), this.getAuthManager().getAgent()};
        return this.getHibernateTemplate().findByNamedQuery("findGlobalHomes", params);
    }

    public List findHomes(Id currentWorksiteId) {
        String queryName = "findHomes";
        return this.findHomes(currentWorksiteId, queryName);
    }

    protected List findHomes(Id currentWorksiteId, String queryName) {
        Object[] params = new Object[]{new Integer(2), currentWorksiteId.getValue(), this.getAuthManager().getAgent(), new Integer(2)};
        return this.getHibernateTemplate().findByNamedQuery(queryName, params);
    }

    public List findHomes(Id currentWorksiteId, boolean includeHidden) {
        return this.findHomes(currentWorksiteId, includeHidden, true);
    }

    public List findHomes(Id currentWorksiteId, boolean includeHidden, boolean includeGlobal) {
        if (includeGlobal) {
            return this.findHomes(currentWorksiteId, includeHidden ? "findHomesIncludeHidden" : "findHomes");
        }
        return this.findHomes(currentWorksiteId, includeHidden ? "findWorksiteHomesIncludeHidden" : "findWorksiteHomes");
    }

    public List<StructuredArtifactDefinitionBean> findAvailableHomes(Id currentWorksiteId, String currentUserId, boolean includeHidden, boolean includeGlobal) {
        List homes = new ArrayList();
        ArrayList<StructuredArtifactDefinitionBean> filteredHomes = new ArrayList<StructuredArtifactDefinitionBean>();
        String queryName = "";
        queryName = includeGlobal ? (includeHidden ? "findAvailableHomesIncludeHidden" : "findAvailableHomes") : (includeHidden ? "findAvailableWorksiteHomesIncludeHidden" : "findAvailableWorksiteHomes");
        Object[] params = new Object[]{new Integer(2), currentWorksiteId.getValue()};
        homes = this.getHibernateTemplate().findByNamedQuery(queryName, params);
        String siteRef = this.getWorksiteManager().getSite(currentWorksiteId.getValue()).getReference();
        boolean canEdit = this.getSecurityService().unlock("metaobj.edit", siteRef);
        for (StructuredArtifactDefinitionBean sadb : homes) {
            Agent owner = sadb.getOwner();
            if (!canEdit && !owner.getId().getValue().equals(currentUserId) && !sadb.isPublished()) continue;
            filteredHomes.add(sadb);
        }
        return filteredHomes;
    }

    public StructuredArtifactDefinitionBean loadHome(String type) {
        return this.loadHome(this.getIdManager().getId(type));
    }

    public StructuredArtifactDefinitionBean loadHome(Id id) {
        return (StructuredArtifactDefinitionBean)this.getHibernateTemplate().get(StructuredArtifactDefinitionBean.class, (Serializable)id);
    }

    public StructuredArtifactDefinitionBean loadHomeByExternalType(String externalType, Id worksiteId) {
        List homes = this.getHibernateTemplate().findByNamedQuery("loadHomeByExternalType", new Object[]{externalType, new Integer(2), worksiteId.getValue()});
        if (homes.size() == 0) {
            return null;
        }
        if (homes.size() == 1) {
            return (StructuredArtifactDefinitionBean)homes.get(0);
        }
        for (StructuredArtifactDefinitionBean def : homes) {
            if (def.getSiteId() == null || !def.getSiteId().equals(worksiteId.getValue())) continue;
            return def;
        }
        return (StructuredArtifactDefinitionBean)homes.get(0);
    }

    public StructuredArtifactDefinitionBean save(StructuredArtifactDefinitionBean bean) {
        return this.save(bean, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StructuredArtifactDefinitionBean save(StructuredArtifactDefinitionBean bean, boolean updateModTime) {
        StructuredArtifactDefinition sad;
        block6: {
            if (this.sadExists(bean)) {
                throw new PersistenceException("Form name {0} exists", new Object[]{bean.getDescription()}, "description");
            }
            if (updateModTime) {
                bean.setModified(new Date(System.currentTimeMillis()));
            }
            sad = null;
            try {
                if (bean.getId() == null) {
                    this.loadNode(bean);
                    bean.setCreated(new Date(System.currentTimeMillis()));
                    break block6;
                }
                if (bean.getSchemaFile() != null) {
                    this.loadNode(bean);
                    sad = new StructuredArtifactDefinition(bean);
                    this.updateExistingArtifacts(sad);
                }
            }
            catch (Exception e) {
                throw new OspException("Invalid schema", (Throwable)e);
            }
        }
        sad = new StructuredArtifactDefinition(bean);
        bean.setExternalType(sad.getExternalType());
        bean.setSchemaHash(this.calculateSchemaHash(bean));
        this.getHibernateTemplate().saveOrUpdate((Object)bean);
        this.lockSADFiles(bean);
        return bean;
    }

    protected void clearLocks(Id id) {
        this.getContentHosting().removeAllLocks(id.getValue());
    }

    protected void lockSADFiles(StructuredArtifactDefinitionBean bean) {
        this.clearLocks(bean.getId());
        if (bean.getAlternateCreateXslt() != null) {
            this.getContentHosting().lockObject(bean.getAlternateCreateXslt().getValue(), bean.getId().getValue(), "saving a form definition", true);
        }
        if (bean.getAlternateViewXslt() != null) {
            this.getContentHosting().lockObject(bean.getAlternateViewXslt().getValue(), bean.getId().getValue(), "saving a form definition", true);
        }
    }

    public void delete(StructuredArtifactDefinitionBean sad) {
        Iterator i = this.getFormConsumers().iterator();
        while (i.hasNext()) {
            if (!((FormConsumer)i.next()).checkFormConsumption(sad.getId())) continue;
            throw new PersistenceException("unable_to_delete_published", new Object[0], "siteState");
        }
        this.clearLocks(sad.getId());
        this.getHibernateTemplate().delete((Object)sad);
    }

    public Collection<FormConsumptionDetail> findFormUsage(StructuredArtifactDefinitionBean sad) {
        ArrayList<FormConsumptionDetail> results = new ArrayList<FormConsumptionDetail>();
        for (FormConsumer cons : this.getFormConsumers()) {
            results.addAll(cons.getFormConsumptionDetails(sad.getId()));
        }
        return results;
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public boolean isGlobal() {
        String siteId = this.getWorksiteManager().getCurrentWorksiteId().getValue();
        return this.isGlobal(siteId);
    }

    protected boolean isGlobal(String siteId) {
        if (this.getGlobalSites().contains(siteId)) {
            return true;
        }
        Site site = this.getWorksiteManager().getSite(siteId);
        return site.getType() != null && this.getGlobalSiteTypes().contains(site.getType());
    }

    protected Site getCurrentSite() {
        String siteId = this.getWorksiteManager().getCurrentWorksiteId().getValue();
        return this.getWorksiteManager().getSite(siteId);
    }

    public Collection getRootElements(StructuredArtifactDefinitionBean sad) {
        try {
            SchemaNode node = this.loadNode(sad);
            return node.getRootChildren();
        }
        catch (Exception e) {
            throw new OspException("Invalid schema.", (Throwable)e);
        }
    }

    public void validateSchema(StructuredArtifactDefinitionBean sad) {
        SchemaNode node = null;
        try {
            node = this.loadNode(sad);
        }
        catch (Exception e) {
            throw new OspException("Invlid schema file.", (Throwable)e);
        }
        if (node == null) {
            throw new OspException("Invlid schema file.");
        }
    }

    public StructuredArtifactHomeInterface convertToHome(StructuredArtifactDefinitionBean sad) {
        return new StructuredArtifactDefinition(sad);
    }

    protected SchemaNode loadNode(StructuredArtifactDefinitionBean sad) throws TypeException, IdUnusedException, PermissionException, ServerOverloadException {
        if (sad.getSchemaFile() != null) {
            ContentResource resource = this.getContentHosting().getResource(sad.getSchemaFile().getValue());
            sad.setSchema(resource.getContent());
        }
        if (sad.getSchema() == null) {
            return null;
        }
        SchemaFactory schemaFactory = SchemaFactory.getInstance();
        return schemaFactory.getSchema(new ByteArrayInputStream(sad.getSchema()));
    }

    protected boolean sadExists(StructuredArtifactDefinitionBean sad) throws PersistenceException {
        String query = "from StructuredArtifactDefinitionBean where description = ? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(sad.getDescription());
        if (sad.getId() != null) {
            query = query + " and id != ? ";
            params.add((String)sad.getId());
        }
        if (sad.getSiteId() != null) {
            query = query + " and siteId = ? ";
            params.add(sad.getSiteId());
        } else {
            query = query + " and siteId is null";
        }
        List sads = this.getHibernateTemplate().find(query, params.toArray());
        return sads.size() > 0;
    }

    protected void validateAfterTransform(StructuredArtifactDefinition sad, StructuredArtifact artifact) throws OspException {
    }

    protected void saveAll(StructuredArtifactDefinition sad, Collection artifacts) {
        for (StructuredArtifact artifact : artifacts) {
            try {
                sad.store((Artifact)artifact);
            }
            catch (PersistenceException e) {
                this.logger.error((Object)("problem saving artifact with id " + artifact.getId().getValue() + ":" + (Object)((Object)e)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateExistingArtifacts(StructuredArtifactDefinition sad) throws OspException {
        if (!sad.getRequiresXslFile()) {
            return;
        }
        if (sad.getRequiresXslFile() && (sad.getXslConversionFileId() == null || sad.getXslConversionFileId().getValue().length() == 0)) {
            throw new OspException("xsl conversion file required");
        }
        StructuredArtifactDefinitionBean currentHome = this.loadHome(sad.getId());
        boolean originalSystemOnlyState = currentHome.isSystemOnly();
        currentHome.setSystemOnly(true);
        this.getHibernateTemplate().saveOrUpdate((Object)currentHome);
        boolean finished = false;
        String type = sad.getType().getId().getValue();
        Collection artifacts = this.getArtifactFinder().findByType(type);
        ArrayList<StructuredArtifact> modifiedArtifacts = new ArrayList<StructuredArtifact>();
        try {
            for (StructuredArtifact artifact : artifacts) {
                try {
                    this.transform(sad, artifact);
                    this.validateAfterTransform(sad, artifact);
                    modifiedArtifacts.add(artifact);
                }
                catch (TransformerException e) {
                    throw new OspException("problem transforming item with id=" + artifact.getId().getValue(), (Throwable)e);
                }
                catch (IOException e) {
                    throw new OspException((Throwable)e);
                }
                catch (JDOMException e) {
                    throw new OspException("problem with xsl file: " + e.getMessage(), (Throwable)e);
                }
            }
            finished = true;
        }
        finally {
            if (!originalSystemOnlyState && !finished) {
                currentHome.setSystemOnly(false);
                this.getHibernateTemplate().saveOrUpdate((Object)currentHome);
            }
        }
        this.saveAll(sad, modifiedArtifacts);
    }

    protected Element getStructuredArtifactRootElement(StructuredArtifactDefinition sad, StructuredArtifact artifact) {
        return sad.getArtifactAsXml((Artifact)artifact).getChild("structuredData").getChild(sad.getRootNode());
    }

    protected void transform(StructuredArtifactDefinition sad, StructuredArtifact artifact) throws IOException, TransformerException, JDOMException {
    }

    public AuthenticationManager getAuthManager() {
        return (AuthenticationManager)ComponentManager.getInstance().get("authManager");
    }

    public AuthorizationFacade getAuthzManager() {
        return this.authzManager;
    }

    public void setAuthzManager(AuthorizationFacade authzManager) {
        this.authzManager = authzManager;
    }

    public WorksiteManager getWorksiteManager() {
        return this.worksiteManager;
    }

    public void setWorksiteManager(WorksiteManager worksiteManager) {
        this.worksiteManager = worksiteManager;
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    protected Id getToolId() {
        Placement placement = this.toolManager.getCurrentPlacement();
        return this.idManager.getId(placement.getId());
    }

    public void importResources(String fromContext, String toContext, List resourceIds) {
        Map homes = this.getWorksiteHomes(this.getIdManager().getId(fromContext), true);
        for (Map.Entry entry : homes.entrySet()) {
            StructuredArtifactDefinitionBean bean = (StructuredArtifactDefinitionBean)entry.getValue();
            if (!fromContext.equals(bean.getSiteId())) continue;
            this.getHibernateTemplate().evict((Object)bean);
            bean.setSiteId(toContext);
            bean.setId(null);
            bean.setSiteState(0);
            if (this.findBean(bean) != null) continue;
            this.getHibernateTemplate().save((Object)bean);
        }
    }

    public ContentHostingService getContentHosting() {
        return this.contentHosting;
    }

    public void setContentHosting(ContentHostingService contentHosting) {
        this.contentHosting = contentHosting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws Exception {
        this.logger.info((Object)"init()");
        FunctionManager.registerFunction((String)"metaobj.create");
        FunctionManager.registerFunction((String)"metaobj.edit");
        FunctionManager.registerFunction((String)"metaobj.export");
        FunctionManager.registerFunction((String)"metaobj.delete");
        FunctionManager.registerFunction((String)"metaobj.publish");
        FunctionManager.registerFunction((String)"metaobj.suggest.global.publish");
        this.addConsumer(this);
        boolean runOnInit = ServerConfigurationService.getBoolean((String)"metaobj.schemahash.runOnInit", (boolean)false);
        if (runOnInit) {
            boolean updateSchemaHashes = ServerConfigurationService.getBoolean((String)"metaobj.schemahash.update", (boolean)false);
            this.verifySchemaHashes(updateSchemaHashes);
        }
        if (this.isAutoDdl()) {
            this.updateSchemaHash();
            Session sakaiSession = SessionManager.getCurrentSession();
            String userId = sakaiSession.getUserId();
            sakaiSession.setUserId("admin");
            sakaiSession.setUserEid("admin");
            try {
                this.logger.info((Object)"Updating base Metaobj XSLT files (auto.ddl is on).");
                this.createResource("/org/sakaiproject/metaobj/shared/control/formCreate.xslt", "formCreate.xslt", "used for default rendering of form add and update", "text/xml", this.isReplaceViews(), true);
                this.createResource("/org/sakaiproject/metaobj/shared/control/formFieldTemplate.xslt", "formFieldTemplate.xslt", "used for default rendering of form fields", "text/xml", this.isReplaceViews(), true);
                this.createResource("/org/sakaiproject/metaobj/shared/control/formView.xslt", "formView.xslt", "used for default rendering of form viewing", "text/xml", this.isReplaceViews(), true);
            }
            finally {
                sakaiSession.setUserEid(userId);
                sakaiSession.setUserId(userId);
            }
        }
        if (this.isEnableLocksConversion()) {
            List<StructuredArtifactDefinitionBean> homes = this.findAllHomes();
            for (StructuredArtifactDefinitionBean bean : homes) {
                this.lockSADFiles(bean);
            }
        }
    }

    protected void updateSchemaHash() {
        List forms = this.getHibernateTemplate().findByNamedQuery("findByNullSchemaHash");
        for (StructuredArtifactDefinitionBean bean : forms) {
            bean.setSchemaHash(this.calculateSchemaHash(bean));
            this.getHibernateTemplate().saveOrUpdate((Object)bean);
        }
    }

    protected String calculateSchemaHash(StructuredArtifactDefinitionBean bean) {
        String hashString = "";
        if (bean.getSchema() != null) {
            hashString = hashString + new String(bean.getSchema());
        }
        hashString = hashString + this.convertNull2Empty(bean.getDocumentRoot());
        hashString = hashString + this.convertNull2Empty(bean.getDescription());
        hashString = hashString + this.convertNull2Empty(bean.getInstruction());
        return hashString.hashCode() + "";
    }

    private String convertNull2Empty(String input) {
        String output = "";
        if (input != null) {
            output = input;
        }
        return output;
    }

    public void verifySchemaHashes(boolean updateInvalid) {
        List<StructuredArtifactDefinitionBean> homes = this.findAllHomes();
        int badCount = 0;
        for (StructuredArtifactDefinitionBean bean : homes) {
            String calcHash = this.calculateSchemaHash(bean);
            if (bean.getSchemaHash().equalsIgnoreCase(calcHash)) continue;
            String text = "Form has invalid schema hash: " + bean.getId() + "; stored: " + bean.getSchemaHash() + "; calc: " + calcHash;
            this.logger.warn((Object)text);
            ++badCount;
            if (!updateInvalid) continue;
            if (bean.getOwner() == null || bean.getOwner().getId() == null) {
                text = "Unable to update schema hash because unable to get owner for bean: " + bean.getId();
                this.logger.warn((Object)text);
                continue;
            }
            bean.setSchemaHash(this.calculateSchemaHash(bean));
            this.getHibernateTemplate().saveOrUpdate((Object)bean);
            text = "Form schema hash has been updated: " + bean.getId();
            this.logger.info((Object)text);
        }
        String text = "There are " + badCount + " forms with invalid schema hashes.";
        this.logger.warn((Object)text);
    }

    public String packageForDownload(Map params, OutputStream out) throws IOException {
        String[] formIdObj = (String[])params.get(DOWNLOAD_FORM_ID_PARAM);
        this.packageFormForExport(formIdObj[0], out);
        return "";
    }

    public void packageFormForExport(String formId, OutputStream os) throws IOException {
        this.packageFormForExport(formId, os, true);
    }

    public void packageFormForExport(String formId, OutputStream os, boolean checkPermission) throws IOException {
        if (checkPermission) {
            this.getAuthzManager().checkPermission("metaobj.export", this.getToolId());
        }
        CheckedOutputStream checksum = new CheckedOutputStream(os, new Adler32());
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(checksum));
        StructuredArtifactDefinitionBean bean = this.loadHome(formId);
        this.writeSADtoZip(bean, zos, "");
        zos.finish();
        zos.flush();
    }

    public Document exportSADAsXML(StructuredArtifactDefinitionBean bean) {
        Element rootNode = new Element("metaobjForm");
        rootNode.setAttribute("formatVersion", "2.1");
        Element attrNode = new Element("description");
        attrNode.addContent((Content)new CDATA(bean.getDescription()));
        rootNode.addContent((Content)attrNode);
        attrNode = new Element("instruction");
        attrNode.addContent((Content)new CDATA(bean.getInstruction()));
        rootNode.addContent((Content)attrNode);
        attrNode = new Element("documentRootNode");
        attrNode.addContent((Content)new CDATA(bean.getDocumentRoot()));
        rootNode.addContent((Content)attrNode);
        if (bean.getAlternateCreateXslt() != null) {
            attrNode = new Element("altCreateXslt");
            attrNode.addContent((Content)new CDATA(bean.getAlternateCreateXslt().getValue()));
            rootNode.addContent((Content)attrNode);
        }
        if (bean.getAlternateViewXslt() != null) {
            attrNode = new Element("altViewXslt");
            attrNode.addContent((Content)new CDATA(bean.getAlternateViewXslt().getValue()));
            rootNode.addContent((Content)attrNode);
        }
        return new Document(rootNode);
    }

    public void writeSADasXMLtoStream(StructuredArtifactDefinitionBean bean, OutputStream os) throws IOException {
        Document doc = this.exportSADAsXML(bean);
        String docStr = new XMLOutputter().outputString(doc);
        os.write(docStr.getBytes("UTF-8"));
    }

    public void writeSADtoZip(StructuredArtifactDefinitionBean bean, ZipOutputStream zos) throws IOException {
        this.writeSADtoZip(bean, zos, "");
    }

    public void writeSADtoZip(StructuredArtifactDefinitionBean bean, ZipOutputStream zos, String path) throws IOException {
        if (!path.endsWith("/") && path.length() > 0) {
            path = path + "/";
        }
        ZipEntry definitionFile = new ZipEntry(path + "formDefinition.xml");
        zos.putNextEntry(definitionFile);
        this.writeSADasXMLtoStream(bean, zos);
        zos.closeEntry();
        ZipEntry schemeFile = new ZipEntry(path + "schema.xsd");
        zos.putNextEntry(schemeFile);
        zos.write(bean.getSchema());
        zos.closeEntry();
        ArrayList existingEntries = new ArrayList();
        this.storeFile(zos, bean.getAlternateCreateXslt(), existingEntries);
        this.storeFile(zos, bean.getAlternateViewXslt(), existingEntries);
    }

    public boolean importSADResource(Id worksiteId, String resourceId, boolean findExisting) throws IOException, ServerOverloadException, PermissionException, IdUnusedException, ImportException, UnsupportedFileTypeException {
        String id = this.getContentHosting().resolveUuid(resourceId);
        try {
            InputStream zipContent;
            StructuredArtifactDefinitionBean bean;
            ContentResource resource = this.getContentHosting().getResource(id);
            MimeType mimeType = new MimeType(resource.getContentType());
            if (!mimeType.equals((Object)new MimeType("application/zip")) && !mimeType.equals((Object)new MimeType("application/x-zip-compressed"))) {
                this.logger.warn((Object)(".importSADResource has identified the mime type as something unsupported: " + mimeType.toString() + "."));
                this.logger.warn((Object)"The import file must be a zip file for the import to work properly.");
                this.logger.warn((Object)"It's possible that the browser has identified the mime type incorrectly, so the import may still work.");
            }
            return (bean = this.importSad(worksiteId, zipContent = resource.streamContent(), findExisting, false)) != null;
        }
        catch (TypeException te) {
            this.logger.error((Object)".importSADResource", (Throwable)te);
            return false;
        }
    }

    public StructuredArtifactDefinitionBean importSad(Id worksiteId, InputStream in, boolean findExisting, boolean publish) throws IOException, ImportException {
        return this.importSad(worksiteId, in, findExisting, publish, true);
    }

    public StructuredArtifactDefinitionBean importSad(Id worksiteId, InputStream in, boolean findExisting, boolean publish, boolean foundThrowsException) throws IOException, ImportException {
        ZipInputStream zis = new ZipInputStream(in);
        StructuredArtifactDefinitionBean bean = this.readSADfromZip(zis, worksiteId.getValue(), publish);
        if (bean != null) {
            StructuredArtifactDefinitionBean found;
            if (findExisting && (found = this.findBean(bean)) != null) {
                if (foundThrowsException) {
                    throw new ImportException("The Form being imported already exists and has been published");
                }
                return found;
            }
            String origTitle = bean.getDescription();
            int index = 0;
            while (this.sadExists(bean)) {
                bean.setDescription(origTitle + " " + ++index);
            }
            this.save(bean);
            this.getHibernateTemplate().flush();
        }
        return bean;
    }

    protected StructuredArtifactDefinitionBean findBean(StructuredArtifactDefinitionBean bean) {
        Object[] params = new Object[]{new Integer(2), bean.getSiteId(), bean.getSchemaHash()};
        List beans = this.getHibernateTemplate().findByNamedQuery("findBean", params);
        if (beans.size() > 0) {
            return (StructuredArtifactDefinitionBean)beans.get(0);
        }
        return null;
    }

    public StructuredArtifactDefinitionBean readSADfromZip(ZipInputStream zis, String worksite, boolean publish) throws IOException {
        ZipEntry currentEntry;
        StructuredArtifactDefinitionBean bean = new StructuredArtifactDefinitionBean();
        boolean hasXML = false;
        boolean hasXSD = false;
        bean.setCreated(new Date(System.currentTimeMillis()));
        bean.setModified(bean.getCreated());
        bean.setOwner(this.getAuthManager().getAgent());
        bean.setSiteId(worksite);
        bean.setSiteState(publish ? 2 : 0);
        if (this.isGlobal(worksite)) {
            bean.setGlobalState(publish ? 2 : 0);
            bean.setSiteId(null);
        }
        if ((currentEntry = zis.getNextEntry()) == null) {
            return null;
        }
        if (currentEntry.getName().endsWith("/")) {
            zis.closeEntry();
            currentEntry = zis.getNextEntry();
        }
        try {
            Hashtable fileMap = new Hashtable();
            String tempDirName = this.getIdManager().createId().getValue();
            ContentCollectionEdit fileParent = this.getExpandedFileDir(tempDirName);
            boolean gotFile = false;
            while (currentEntry != null) {
                this.logger.debug((Object)("current entry name: " + currentEntry.getName()));
                File entryFile = new File(currentEntry.getName());
                if (entryFile.getName().startsWith(".")) {
                    this.logger.warn((Object)(".readSADfromZip skipping control file: " + currentEntry.getName()));
                } else if (currentEntry.getName().endsWith("xml")) {
                    this.readSADfromXML(bean, zis);
                    hasXML = true;
                } else if (currentEntry.getName().endsWith("xsd")) {
                    this.readSADSchemaFromXML(bean, zis);
                    hasXSD = true;
                } else if (!currentEntry.isDirectory()) {
                    gotFile = true;
                    this.processFile(currentEntry, zis, fileMap, (ContentCollection)fileParent);
                }
                zis.closeEntry();
                currentEntry = zis.getNextEntry();
            }
            if (gotFile) {
                fileParent.getPropertiesEdit().addProperty("DAV:displayname", bean.getDescription());
                this.getContentHosting().commitCollection(fileParent);
            } else {
                this.getContentHosting().cancelCollection(fileParent);
            }
            if (bean.getAlternateCreateXslt() != null) {
                bean.setAlternateCreateXslt((Id)fileMap.get(bean.getAlternateCreateXslt()));
            }
            if (bean.getAlternateViewXslt() != null) {
                bean.setAlternateViewXslt((Id)fileMap.get(bean.getAlternateViewXslt()));
            }
        }
        catch (Exception exp) {
            this.logger.error((Object)".readSADFromZip", (Throwable)exp);
            return null;
        }
        bean.setSchemaHash(this.calculateSchemaHash(bean));
        return bean;
    }

    protected ContentCollectionEdit getExpandedFileDir(String origName) throws TypeException, IdUnusedException, PermissionException, IdUsedException, IdInvalidException, InconsistentException {
        ContentCollection userCollection = this.getUserCollection();
        try {
            ResourceLoader rb = new ResourceLoader("org/sakaiproject/metaobj/registry/messages");
            ContentCollectionEdit groupCollection = this.getContentHosting().addCollection(userCollection.getId() + IMPORT_BASE_FOLDER_ID);
            groupCollection.getPropertiesEdit().addProperty("DAV:displayname", rb.getString("form_import_folder"));
            this.getContentHosting().commitCollection(groupCollection);
        }
        catch (IdUsedException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)".getExpandedFileDir", (Throwable)e);
            return null;
        }
        ContentCollection collection = this.getContentHosting().getCollection(userCollection.getId() + IMPORT_BASE_FOLDER_ID + "/");
        String childId = collection.getId() + origName;
        return this.getContentHosting().addCollection(childId);
    }

    protected ContentCollection getUserCollection() throws TypeException, IdUnusedException, PermissionException {
        User user = UserDirectoryService.getCurrentUser();
        String userId = user.getId();
        String wsId = SiteService.getUserSiteId((String)userId);
        String wsCollectionId = this.getContentHosting().getSiteCollection(wsId);
        ContentCollection collection = this.getContentHosting().getCollection(wsCollectionId);
        return collection;
    }

    private StructuredArtifactDefinitionBean readSADfromXML(StructuredArtifactDefinitionBean bean, InputStream inStream) {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            byte[] bytes = this.readStreamToBytes(inStream);
            bytes = new String(bytes, "UTF-8").getBytes("UTF-8");
            Document document = builder.build((InputStream)new ByteArrayInputStream(bytes));
            Element topNode = document.getRootElement();
            bean.setDescription(new String(topNode.getChildTextTrim("description").getBytes(), "UTF-8"));
            bean.setInstruction(new String(topNode.getChildTextTrim("instruction").getBytes(), "UTF-8"));
            bean.setDocumentRoot(new String(topNode.getChildTextTrim("documentRootNode").getBytes(), "UTF-8"));
            if (topNode.getChildTextTrim("altCreateXslt") != null) {
                bean.setAlternateCreateXslt(this.getIdManager().getId(new String(topNode.getChildTextTrim("altCreateXslt").getBytes(), "UTF-8")));
            }
            if (topNode.getChildTextTrim("altViewXslt") != null) {
                bean.setAlternateViewXslt(this.getIdManager().getId(new String(topNode.getChildTextTrim("altViewXslt").getBytes(), "UTF-8")));
            }
        }
        catch (Exception jdome) {
            this.logger.error((Object)".readSADfromXML", (Throwable)jdome);
            return null;
        }
        return bean;
    }

    private byte[] readStreamToBytes(InputStream inStream) throws IOException {
        int count;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] data = new byte[10240];
        while ((count = inStream.read(data, 0, 10240)) != -1) {
            bytes.write(data, 0, count);
        }
        byte[] tmp = bytes.toByteArray();
        bytes.close();
        return tmp;
    }

    private StructuredArtifactDefinitionBean readSADSchemaFromXML(StructuredArtifactDefinitionBean bean, InputStream inStream) throws IOException {
        bean.setSchema(this.readStreamToBytes(inStream));
        return bean;
    }

    public List getGlobalSites() {
        return this.globalSites;
    }

    public void setGlobalSites(List globalSites) {
        this.globalSites = globalSites;
    }

    public List getGlobalSiteTypes() {
        return this.globalSiteTypes;
    }

    public void setGlobalSiteTypes(List globalSiteTypes) {
        this.globalSiteTypes = globalSiteTypes;
    }

    public Element createFormViewXml(String formId, String returnUrl) {
        formId = this.getContentHosting().getUuid(formId);
        Artifact art = this.getArtifactFinder().load(this.getIdManager().getId(formId));
        return this.createFormViewXml(art, returnUrl);
    }

    public Element createFormViewXml(Artifact art, String returnUrl) {
        Element root = new Element("formView");
        Element data = new Element("formData");
        ReadableObjectHome home = art.getHome();
        if (home instanceof PresentableObjectHome) {
            data.addContent((Content)((PresentableObjectHome)home).getArtifactAsXml(art));
        }
        root.addContent((Content)data);
        if (returnUrl != null) {
            Element returnUrlElement = new Element("returnUrl");
            returnUrlElement.addContent((Content)new CDATA(returnUrl));
            root.addContent((Content)returnUrlElement);
        }
        Element css = new Element("css");
        String skin = null;
        try {
            skin = this.getCurrentSite().getSkin();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (skin == null || skin.length() == 0) {
            skin = ServerConfigurationService.getString((String)"skin.default");
        }
        String skinRepo = ServerConfigurationService.getString((String)"skin.repo");
        Element uri = new Element("uri");
        uri.setAttribute("order", "1");
        uri.setText(skinRepo + "/tool_base.css");
        css.addContent((Content)uri);
        uri = new Element("uri");
        uri.setAttribute("order", "2");
        uri.setText(skinRepo + "/" + skin + "/tool.css");
        css.addContent((Content)uri);
        root.addContent((Content)css);
        return root;
    }

    public Element createFormViewXml(ElementBean bean, String returnUrl) {
        Element root = new Element("formView");
        Element data = new Element("formData");
        root.addContent((Content)data);
        if (returnUrl != null) {
            Element returnUrlElement = new Element("returnUrl");
            returnUrlElement.addContent((Content)new CDATA(returnUrl));
            root.addContent((Content)returnUrlElement);
        }
        Element css = new Element("css");
        String skin = null;
        try {
            skin = this.getCurrentSite().getSkin();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (skin == null || skin.length() == 0) {
            skin = ServerConfigurationService.getString((String)"skin.default");
        }
        String skinRepo = ServerConfigurationService.getString((String)"skin.repo");
        Element uri = new Element("uri");
        uri.setText(skinRepo + "/tool_base.css");
        css.addContent((Content)uri);
        uri = new Element("uri");
        uri.setText(skinRepo + "/" + skin + "/tool.css");
        css.addContent((Content)uri);
        root.addContent((Content)css);
        return root;
    }

    public InputStream getTransformer(String type, boolean readOnly) {
        try {
            String id;
            String viewLocation = "/group/PortfolioAdmin/system/formCreate.xslt";
            StructuredArtifactDefinitionBean sadb = this.loadHome(type);
            if (sadb == null) {
                ToolSession toolSession = SessionManager.getCurrentToolSession();
                sadb = (StructuredArtifactDefinitionBean)toolSession.getAttribute("org.sakaiproject.metaobj.shared.control.AddStructuredArtifactDefinitionController.sad");
            }
            if (sadb != null && sadb.getAlternateCreateXslt() != null && (id = this.getContentHosting().resolveUuid(sadb.getAlternateCreateXslt().getValue())) != null) {
                viewLocation = id;
            }
            if (readOnly) {
                viewLocation = "/group/PortfolioAdmin/system/formView.xslt";
                if (sadb != null && sadb.getAlternateViewXslt() != null && (id = this.getContentHosting().resolveUuid(sadb.getAlternateViewXslt().getValue())) != null) {
                    viewLocation = id;
                }
            }
            ArrayList<String> refs = new ArrayList<String>();
            refs.add(this.getContentHosting().getReference(viewLocation));
            refs.add(this.getContentHosting().getReference("/group/PortfolioAdmin/system"));
            HashMap<String, ArrayList<String>> funcs = new HashMap<String, ArrayList<String>>();
            funcs.put("content.read", refs);
            funcs.put("content.hidden", refs);
            this.getSecurityService().pushAdvisor((SecurityAdvisor)new AllowChildrenMapSecurityAdvisor(funcs));
            return this.getContentHosting().getResource(viewLocation).streamContent();
        }
        catch (Exception e) {
            this.logger.error((Object)".getTransformer", (Throwable)e);
            return null;
        }
    }

    public boolean hasHomes() {
        if (ThreadLocalManager.get((String)HAS_HOMES_TAG) == null) {
            ThreadLocalManager.set((String)HAS_HOMES_TAG, (Object)new Boolean(this.findHomes(false).size() > 0));
        }
        return (Boolean)ThreadLocalManager.get((String)HAS_HOMES_TAG);
    }

    public void addConsumer(FormConsumer consumer) {
        this.getFormConsumers().add(consumer);
    }

    public ArtifactFinder getArtifactFinder() {
        return this.artifactFinder;
    }

    public void setArtifactFinder(ArtifactFinder artifactFinder) {
        this.artifactFinder = artifactFinder;
    }

    public int getExpressionMax() {
        return this.expressionMax;
    }

    public void setExpressionMax(int expressionMax) {
        this.expressionMax = expressionMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteArrayOutputStream loadResource(String name) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        try {
            int c = is.read();
            while (c != -1) {
                bos.write(c);
                c = is.read();
            }
            bos.flush();
        }
        catch (IOException e) {
            this.logger.error((Object)".loadResource", (Throwable)e);
        }
        finally {
            block13: {
                try {
                    is.close();
                }
                catch (IOException e) {
                    if (!this.logger.isDebugEnabled()) break block13;
                    this.logger.debug((Object)e);
                }
            }
        }
        return bos;
    }

    protected String createResource(String resourceLocation, String name, String description, String type, boolean replace, boolean pubview) {
        ContentResource resource;
        ByteArrayOutputStream bos = this.loadResource(resourceLocation);
        ResourcePropertiesEdit resourceProperties = this.getContentHosting().newResourceProperties();
        resourceProperties.addProperty("DAV:displayname", name);
        resourceProperties.addProperty("CHEF:description", description);
        resourceProperties.addProperty("encoding", "UTF-8");
        String folder = "/group/PortfolioAdmin/system/";
        try {
            ContentCollectionEdit groupCollection = this.getContentHosting().addCollection("/group/PortfolioAdmin");
            groupCollection.getPropertiesEdit().addProperty("DAV:displayname", "Portfolio Admin");
            this.getContentHosting().commitCollection(groupCollection);
        }
        catch (IdUsedException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)".createResource", (Throwable)e);
            return null;
        }
        try {
            ContentCollectionEdit collection = this.getContentHosting().addCollection(folder);
            collection.getPropertiesEdit().addProperty("DAV:displayname", "system");
            this.getContentHosting().commitCollection(collection);
        }
        catch (IdUsedException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)".createResource", (Throwable)e);
            return null;
        }
        String resourceId = folder + name;
        try {
            ContentResource testResource;
            if (!replace && (testResource = this.getContentHosting().getResource(resourceId)) != null) {
                return testResource.getId();
            }
            this.getContentHosting().removeResource(resourceId);
        }
        catch (TypeException e) {
            this.logger.warn((Object)e);
        }
        catch (IdUnusedException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
        }
        catch (PermissionException e) {
            this.logger.warn((Object)e);
        }
        catch (InUseException e) {
            this.logger.warn((Object)e);
        }
        try {
            resource = this.getContentHosting().addResource(name, folder, 1, type, bos.toByteArray(), (ResourceProperties)resourceProperties, NotificationService.NOTI_NONE);
            this.getContentHosting().setPubView(resource.getId(), pubview);
        }
        catch (IdUniquenessException e) {
            this.logger.info((Object)("Failure trying to write Metaobj file: " + folder + name), (Throwable)e);
            return resourceId;
        }
        catch (Exception e) {
            this.logger.error((Object)".createResource", (Throwable)e);
            return null;
        }
        return resource.getId();
    }

    protected void storeFile(ZipOutputStream zos, Id fileId, List existingEntries) throws IOException {
        if (fileId == null) {
            return;
        }
        try {
            String userId = SessionManager.getCurrentSessionUserId();
            String id = this.getContentHosting().resolveUuid(fileId.getValue());
            String ref = this.getContentHosting().getReference(id);
            this.getSecurityService().pushAdvisor(new SecurityAdvisor(){

                public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                    return SecurityAdvisor.SecurityAdvice.ALLOWED;
                }
            });
            ContentResource resource = this.getContentHosting().getResource(id);
            String newName = resource.getProperties().getProperty(resource.getProperties().getNamePropDisplayName());
            String cleanedName = newName.substring(newName.lastIndexOf(92) + 1);
            if (!existingEntries.contains(fileId)) {
                existingEntries.add(fileId);
                this.storeFileInZip(zos, resource.streamContent(), resource.getContentType() + File.separator + fileId.getValue() + File.separator + cleanedName);
            }
            this.getSecurityService().popAdvisor();
        }
        catch (PermissionException e) {
            this.logger.error((Object)".storeFile", (Throwable)e);
        }
        catch (IdUnusedException e) {
            this.logger.error((Object)".storeFile", (Throwable)e);
        }
        catch (TypeException e) {
            this.logger.error((Object)".storeFile", (Throwable)e);
        }
        catch (ServerOverloadException e) {
            this.logger.error((Object)".storeFile", (Throwable)e);
        }
    }

    protected void storeFileInZip(ZipOutputStream zos, InputStream in, String entryName) throws IOException {
        int count;
        byte[] data = new byte[10240];
        if (File.separatorChar == '\\') {
            entryName = entryName.replace('\\', '/');
        }
        ZipEntry newfileEntry = new ZipEntry(entryName);
        zos.putNextEntry(newfileEntry);
        BufferedInputStream origin = new BufferedInputStream(in, data.length);
        while ((count = origin.read(data, 0, data.length)) != -1) {
            zos.write(data, 0, count);
        }
        zos.closeEntry();
        in.close();
    }

    protected void processFile(ZipEntry currentEntry, ZipInputStream zis, Hashtable fileMap, ContentCollection fileParent) throws IOException {
        File file = new File(currentEntry.getName());
        if (file.getParentFile() == null || file.getParentFile().getParentFile() == null || file.getParentFile().getParentFile().getParentFile() == null) {
            this.logger.warn((Object)("StructuredArtifactDefinitionManagerImpl.processFile() found unexpected file " + currentEntry.getName()));
            return;
        }
        MimeType mimeType = new MimeType(file.getParentFile().getParentFile().getParentFile().getName(), file.getParentFile().getParentFile().getName());
        String contentType = mimeType.getValue();
        Id oldId = this.getIdManager().getId(file.getParentFile().getName());
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int c = zis.read();
            while (c != -1) {
                bos.write(c);
                c = zis.read();
            }
            String fileName = this.findUniqueFileName(fileParent.getId(), file.getName());
            ResourcePropertiesEdit resourceProperties = this.getContentHosting().newResourceProperties();
            resourceProperties.addProperty("DAV:displayname", fileName);
            ContentResource resource = this.getContentHosting().addResource(fileParent.getId() + fileName, contentType, bos.toByteArray(), (ResourceProperties)resourceProperties, NotificationService.NOTI_NONE);
            Id newId = this.getIdManager().getId(this.getContentHosting().getUuid(resource.getId()));
            fileMap.put(oldId, newId);
        }
        catch (Exception exp) {
            this.logger.error((Object)".processFile", (Throwable)exp);
        }
    }

    protected String findUniqueFileName(String id, String name) throws TypeException, PermissionException {
        String orig = name;
        String testId = id + name;
        int current = 0;
        while (this.resourceExists(testId)) {
            int dotPos = orig.lastIndexOf(46);
            name = dotPos == -1 ? orig + current : orig.substring(0, dotPos) + "-" + ++current + orig.substring(dotPos);
            testId = id + name;
        }
        return name;
    }

    protected boolean resourceExists(String returned) throws TypeException, PermissionException {
        try {
            return this.getContentHosting().getResource(returned) != null;
        }
        catch (IdUnusedException e) {
            return false;
        }
    }

    public boolean isReplaceViews() {
        return this.replaceViews;
    }

    public void setReplaceViews(boolean replaceViews) {
        this.replaceViews = replaceViews;
    }

    public List getFormConsumers() {
        return this.formConsumers;
    }

    public void setFormConsumers(List formConsumers) {
        this.formConsumers = formConsumers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFormConsumption(Id formId) {
        String type = formId.getValue();
        this.getSecurityService().pushAdvisor(new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        });
        try {
            Collection arts = this.getStructuredArtifactFinder().findByType(type);
            boolean bl = arts != null && arts.size() > 0;
            return bl;
        }
        finally {
            this.getSecurityService().popAdvisor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FormConsumptionDetail> getFormConsumptionDetails(Id formId) {
        ArrayList<FormConsumptionDetail> results = new ArrayList<FormConsumptionDetail>();
        String type = formId.getValue();
        this.getSecurityService().pushAdvisor(new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        });
        try {
            Collection arts = this.getStructuredArtifactFinder().findByType(type);
            String formConsumptionType = messages.getString("content_resource_type");
            String formNameText = messages.getString("form_name");
            String formOwnerText = messages.getString("form_owner");
            for (StructuredArtifact art : arts) {
                Reference ref = EntityManager.newReference((String)art.getBaseResource().getReference());
                String context = ref.getContext();
                FormConsumptionDetail fcd = new FormConsumptionDetail(art.getHome().getType().getId().getValue(), context, formConsumptionType, formNameText + art.getDisplayName(), formOwnerText + art.getOwner().getDisplayName());
                results.add(fcd);
            }
            ArrayList<FormConsumptionDetail> arrayList = results;
            return arrayList;
        }
        finally {
            this.getSecurityService().popAdvisor();
        }
    }

    public void checkFormAccess(String resource_uuid) {
        String resourceId = this.getContentHosting().resolveUuid(resource_uuid);
        boolean allowed = this.getContentHosting().allowGetResource(resourceId);
        if (!allowed) {
            return;
        }
        Artifact art = this.getArtifactFinder().load(this.getIdManager().getId(resource_uuid));
        PresentableObjectHome home = (PresentableObjectHome)art.getHome();
        Element elm = home.getArtifactAsXml(art);
        ArrayList<String> files = new ArrayList<String>();
        List<Element> elms = this.findElementNamesForFileType(elm);
        for (Element element : elms) {
            String name = element.getAttributeValue("name");
            try {
                XPath fileAttachPath = XPath.newInstance((String)(".//" + name));
                List fileElements = fileAttachPath.selectNodes((Object)elm);
                for (Element theElm : fileElements) {
                    String file = theElm.getText();
                    String fileRef = this.getContentHosting().getReference(file);
                    this.logger.debug((Object)("Pushing " + fileRef + " on advisor stack"));
                    files.add(fileRef);
                }
            }
            catch (JDOMException e) {
                this.logger.error((Object)"unable to get element", (Throwable)e);
            }
        }
        this.getSecurityService().pushAdvisor((SecurityAdvisor)new AllowMapSecurityAdvisor("content.read", files));
    }

    private List<Element> findElementNamesForFileType(Element root) {
        ArrayList<Element> fileElements = new ArrayList();
        try {
            XPath fileAttachPath = XPath.newInstance((String)".//element[@type='xs:anyURI']");
            fileElements = fileAttachPath.selectNodes((Object)root);
        }
        catch (JDOMException e) {
            this.logger.error((Object)"unable to get element", (Throwable)e);
        }
        return fileElements;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ArtifactFinder getStructuredArtifactFinder() {
        return this.structuredArtifactFinder;
    }

    public void setStructuredArtifactFinder(ArtifactFinder structuredArtifactFinder) {
        this.structuredArtifactFinder = structuredArtifactFinder;
    }

    public boolean isAutoDdl() {
        return this.autoDdl;
    }

    public void setAutoDdl(boolean autoDdl) {
        this.autoDdl = autoDdl;
    }

    public boolean isEnableLocksConversion() {
        return this.enableLocksConversion;
    }

    public void setEnableLocksConversion(boolean enableLocksConversion) {
        this.enableLocksConversion = enableLocksConversion;
    }
}

