/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt.home;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.metaobj.shared.mgt.IdManager;
import org.sakaiproject.metaobj.shared.mgt.ReadableObjectHome;
import org.sakaiproject.metaobj.shared.mgt.home.StructuredArtifactHomeInterface;
import org.sakaiproject.metaobj.shared.model.Agent;
import org.sakaiproject.metaobj.shared.model.Artifact;
import org.sakaiproject.metaobj.shared.model.FinderException;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.shared.model.OspException;
import org.sakaiproject.metaobj.shared.model.PersistenceException;
import org.sakaiproject.metaobj.shared.model.StructuredArtifact;
import org.sakaiproject.metaobj.shared.model.Type;
import org.sakaiproject.metaobj.utils.xml.SchemaFactory;
import org.sakaiproject.metaobj.utils.xml.SchemaInvalidException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class XmlElementHome
implements StructuredArtifactHomeInterface,
InitializingBean,
ResourceLoaderAware {
    private SchemaNode schema = null;
    private String rootNode = null;
    private Date schemaDate = null;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private File homeDirectory = null;
    private String schemaFileName;
    private Type type = null;
    private String typeId = null;
    private IdManager idManager = null;
    public static final String XSD_DIR = "xsd";
    public static final String XML_HOME_PATH = "xmlHome";
    private ResourceLoader resourceLoader;
    private String instruction;

    public XmlElementHome() {
    }

    public XmlElementHome(String rootNode) {
        this.rootNode = rootNode;
    }

    public SchemaNode getSchema() {
        if (this.schema == null) {
            File schemaFile = this.getSchemaFile(this.schemaFileName);
            this.schema = SchemaFactory.getInstance().getSchema(schemaFile);
            this.schemaDate = new Date(schemaFile.lastModified());
        }
        return this.schema;
    }

    public String getDocumentRoot() {
        return null;
    }

    protected File getSchemaFile(String schemaFileName) {
        return new File(this.pathToWebInf() + File.separator + XSD_DIR + File.separator + schemaFileName);
    }

    public void setSchema(SchemaNode schema) {
        this.schema = schema;
    }

    public Artifact store(Artifact object) throws PersistenceException {
        String id = object.getId().getValue();
        File objectFile = null;
        if (id == null) {
            try {
                objectFile = File.createTempFile(this.rootNode, ".xml", this.homeDirectory);
            }
            catch (IOException e) {
                this.logger.error((Object)"", (Throwable)e);
                throw new OspException((Throwable)e);
            }
        } else {
            objectFile = new File(this.homeDirectory, id);
            if (objectFile.exists()) {
                objectFile.delete();
            }
        }
        XMLOutputter outputter = new XMLOutputter();
        StructuredArtifact xmlObject = (StructuredArtifact)object;
        xmlObject.setId((Object)objectFile.getName());
        FileOutputStream outstream = null;
        try {
            outstream = new FileOutputStream(objectFile);
            Format format = Format.getPrettyFormat();
            outputter.setFormat(format);
            outputter.output(xmlObject.getBaseElement(), (OutputStream)outstream);
        }
        catch (IOException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new OspException((Throwable)e);
        }
        finally {
            try {
                if (outstream != null) {
                    outstream.close();
                }
            }
            catch (Exception e2) {
                this.logger.warn((Object)"Problem closing stream: ", (Throwable)e2);
            }
        }
        return object;
    }

    public void remove(Artifact object) {
        File objectFile = null;
        if (object != null && object.getId() != null) {
            objectFile = new File(this.homeDirectory, object.getId().getValue());
        }
        boolean deleted = false;
        if (objectFile != null) {
            deleted = objectFile.delete();
        }
        if (!deleted) {
            this.logger.warn((Object)("Could not delete file: " + objectFile.getPath()));
        }
    }

    public Artifact store(String displayName, String contentType, Type type, InputStream in) throws PersistenceException {
        return null;
    }

    public Artifact update(Artifact object, InputStream in) throws PersistenceException {
        return null;
    }

    public Type getType() {
        return this.type;
    }

    public String getExternalType() {
        if (this.getSchema() == null) {
            return "";
        }
        return this.getSchema().getTargetNamespace().getURI() + "?" + this.getRootNode();
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Artifact load(Id id) throws PersistenceException {
        return this.load(id.getValue());
    }

    public StructuredArtifact load(ContentResource resource) {
        return null;
    }

    public StructuredArtifact load(ContentResource resource, Id artifactId) {
        return null;
    }

    protected Artifact load(String id) throws PersistenceException {
        File objectFile = new File(this.homeDirectory, id);
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            Document doc = builder.build(objectFile);
            StructuredArtifact xmlObject = new StructuredArtifact(doc.getRootElement(), this.getSchema().getChild(this.rootNode));
            xmlObject.setId((Object)id);
            xmlObject.setHome((ReadableObjectHome)this);
            return xmlObject;
        }
        catch (Exception e) {
            throw new SchemaInvalidException(e);
        }
    }

    public Artifact createInstance() {
        StructuredArtifact instance = new StructuredArtifact(this.rootNode, this.getSchema().getChild(this.rootNode));
        this.prepareInstance((Artifact)instance);
        return instance;
    }

    public void prepareInstance(Artifact object) {
        object.setHome((ReadableObjectHome)this);
        StructuredArtifact xmlObject = (StructuredArtifact)object;
        xmlObject.getBaseElement().setName(this.rootNode);
    }

    public Artifact createSample() {
        return this.createInstance();
    }

    public Collection findByOwner(Agent owner) throws FinderException {
        String[] files = this.homeDirectory.list();
        ArrayList<Artifact> returnedList = new ArrayList<Artifact>();
        for (int i = 0; i < files.length; ++i) {
            try {
                returnedList.add(this.load(files[i]));
                continue;
            }
            catch (PersistenceException e) {
                throw new FinderException();
            }
        }
        return returnedList;
    }

    public boolean isInstance(Artifact testObject) {
        return testObject instanceof StructuredArtifact;
    }

    public void refresh() {
        this.schema = null;
        this.getSchema();
    }

    public String getExternalUri(Id artifactId, String name) {
        return "viewNode.osp?pid=" + ToolManager.getCurrentPlacement().getId() + "&nodeId=" + artifactId.getValue();
    }

    public InputStream getStream(Id artifactId) {
        return null;
    }

    public boolean isSystemOnly() {
        return false;
    }

    public Class getInterface() {
        return StructuredArtifactHomeInterface.class;
    }

    public String getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(String rootNode) {
        this.rootNode = rootNode;
    }

    public Date getModified() {
        return this.schemaDate;
    }

    public void setModified(Date schemaDate) {
        this.schemaDate = schemaDate;
    }

    public String getSchemaFileName() {
        return this.schemaFileName;
    }

    public void setSchemaFileName(String schemaFileName) {
        this.schemaFileName = schemaFileName;
    }

    public void afterPropertiesSet() throws SchemaInvalidException {
        this.homeDirectory = new File(this.pathToWebInf(), XML_HOME_PATH + File.separator + this.rootNode);
        if (!this.homeDirectory.exists() && !this.homeDirectory.mkdirs()) {
            this.logger.warn((Object)("Couldn't create homeDirectory: " + this.homeDirectory.getPath()));
        }
        this.getSchema();
        this.getType().setId(this.getIdManager().getId(this.getTypeId()));
    }

    protected String pathToWebInf() {
        try {
            return this.resourceLoader.getResource("WEB-INF").getFile().getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public byte[] getBytes(StructuredArtifact artifact) {
        return new byte[0];
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public SchemaNode getRootSchema() {
        return this.getSchema().getChild(this.getRootNode());
    }

    public String getSiteId() {
        return null;
    }

    public Artifact cloneArtifact(Artifact copy, String newName) throws PersistenceException {
        return null;
    }

    public Element getArtifactAsXml(Artifact art) {
        return null;
    }

    public Element getArtifactAsXml(Artifact artifact, String container, String site, String context) {
        return null;
    }

    public StructuredArtifactHomeInterface getParentHome() {
        return this;
    }
}

