/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt.factories;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.metaobj.shared.mgt.HomeFactory;
import org.sakaiproject.metaobj.shared.mgt.ReadableObjectHome;
import org.sakaiproject.metaobj.shared.mgt.StructuredArtifactDefinitionManager;
import org.sakaiproject.metaobj.shared.mgt.factories.HomeFactoryBase;
import org.sakaiproject.metaobj.shared.mgt.home.StructuredArtifactDefinition;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.shared.model.StructuredArtifactDefinitionBean;
import org.sakaiproject.metaobj.utils.xml.SchemaInvalidException;

public class DbXmlHomeFactoryImpl
extends HomeFactoryBase
implements HomeFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private StructuredArtifactDefinitionManager structuredArtifactDefinitionManager;

    public boolean handlesType(String objectType) {
        return this.getHome(objectType) != null;
    }

    @Override
    public Map getHomes(Class requiredHomeType) {
        return super.getHomes(requiredHomeType);
    }

    @Override
    public ReadableObjectHome findHomeByExternalId(String externalId, Id worksiteId) {
        return this.createHome(this.getStructuredArtifactDefinitionManager().loadHomeByExternalType(externalId, worksiteId));
    }

    public ReadableObjectHome getHome(String objectType) {
        StructuredArtifactDefinitionBean sad = this.getStructuredArtifactDefinitionManager().loadHome(objectType);
        if (sad == null) {
            this.logger.warn((Object)(this + " Null StructuredArtifactDefinitionBean (perhaps multiple submits) for: " + objectType));
            return null;
        }
        return this.createHome(sad);
    }

    @Override
    public Map getWorksiteHomes(Id worksiteId) {
        return this.createHomes(this.getStructuredArtifactDefinitionManager().getWorksiteHomes(worksiteId));
    }

    @Override
    public Map getWorksiteHomes(Id worksiteId, boolean includeHidden) {
        return this.createHomes(this.getStructuredArtifactDefinitionManager().getWorksiteHomes(worksiteId, true));
    }

    @Override
    public Map getWorksiteHomes(Id worksiteId, String currentUserId, boolean includeHidden) {
        return this.createHomes(this.getStructuredArtifactDefinitionManager().getWorksiteHomes(worksiteId, currentUserId, true));
    }

    public Map getHomes() {
        return this.createHomes(this.getStructuredArtifactDefinitionManager().getHomes());
    }

    protected Map createHomes(Map homeBeans) {
        HashMap homeBeansSet = new HashMap();
        for (Map.Entry entry : homeBeans.entrySet()) {
            ReadableObjectHome roh = this.createHome((StructuredArtifactDefinitionBean)entry.getValue());
            if (roh == null) continue;
            homeBeansSet.put(entry.getKey(), roh);
        }
        return homeBeansSet;
    }

    protected ReadableObjectHome createHome(StructuredArtifactDefinitionBean sadBean) {
        try {
            return new StructuredArtifactDefinition(sadBean);
        }
        catch (SchemaInvalidException e) {
            this.logger.warn((Object)e);
            return null;
        }
    }

    public StructuredArtifactDefinitionManager getStructuredArtifactDefinitionManager() {
        return this.structuredArtifactDefinitionManager;
    }

    public void setStructuredArtifactDefinitionManager(StructuredArtifactDefinitionManager structuredArtifactDefinitionManager) {
        this.structuredArtifactDefinitionManager = structuredArtifactDefinitionManager;
    }
}

