/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Element;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;

public class ContentHostingUtil {
    private static final Log log = LogFactory.getLog(ContentHostingUtil.class);

    public static Element createRepoNode(ContentResource contentResource) {
        String modifiedUser;
        Date modified;
        Element repositoryNode = new Element("repositoryNode");
        Date created = ContentHostingUtil.getDate(contentResource, contentResource.getProperties().getNamePropCreationDate());
        if (created != null) {
            repositoryNode.addContent((Content)ContentHostingUtil.createNode("created", created.toString()));
        }
        if ((modified = ContentHostingUtil.getDate(contentResource, contentResource.getProperties().getNamePropModifiedDate())) != null) {
            repositoryNode.addContent((Content)ContentHostingUtil.createNode("modified", modified.toString()));
        }
        UserDirectoryService uds = (UserDirectoryService)ComponentManager.get(UserDirectoryService.class);
        String createdUser = contentResource.getProperties().getProperty(contentResource.getProperties().getNamePropCreator());
        if (createdUser != null) {
            try {
                User owner = uds.getUser(createdUser);
                repositoryNode.addContent((Content)ContentHostingUtil.createUserNode("owner", owner));
            }
            catch (UserNotDefinedException e) {
                log.warn((Object)("Cannot find owner of content resource with reference: " + contentResource.getReference()));
            }
        }
        if ((modifiedUser = contentResource.getProperties().getProperty(contentResource.getProperties().getNamePropModifiedBy())) != null) {
            try {
                User modifiedBy = uds.getUser(modifiedUser);
                repositoryNode.addContent((Content)ContentHostingUtil.createUserNode("modifiedBy", modifiedBy));
            }
            catch (UserNotDefinedException e) {
                log.warn((Object)("Cannot find modifier of content resource with reference: " + contentResource.getReference()));
            }
        }
        return repositoryNode;
    }

    private static Element createUserNode(String elementName, User user) {
        Element userNode = new Element(elementName);
        userNode.addContent((Content)ContentHostingUtil.createNode("id", user.getId()));
        userNode.addContent((Content)ContentHostingUtil.createNode("eid", user.getEid()));
        userNode.addContent((Content)ContentHostingUtil.createNode("displayName", user.getDisplayName()));
        userNode.addContent((Content)ContentHostingUtil.createNode("email", user.getEmail()));
        userNode.addContent((Content)ContentHostingUtil.createNode("firstName", user.getFirstName()));
        userNode.addContent((Content)ContentHostingUtil.createNode("lastName", user.getLastName()));
        return userNode;
    }

    public static Element createNode(String name, String value) {
        Element newNode = new Element(name);
        newNode.addContent(value);
        return newNode;
    }

    public static Date getDate(ContentResource resource, String propName) {
        try {
            Time time = resource.getProperties().getTimeProperty(propName);
            return new Date(time.getTime());
        }
        catch (EntityPropertyNotDefinedException e) {
            return null;
        }
        catch (EntityPropertyTypeException e) {
            throw new RuntimeException(e);
        }
    }
}

