/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.security.impl.sakai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.metaobj.security.AnonymousAgent;
import org.sakaiproject.metaobj.security.impl.sakai.AgentWrapper;
import org.sakaiproject.metaobj.security.impl.sakai.RoleWrapper;
import org.sakaiproject.metaobj.security.impl.sakai.SecurityBase;
import org.sakaiproject.metaobj.shared.model.Agent;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.shared.model.OspException;
import org.sakaiproject.metaobj.shared.model.impl.AgentImpl;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserEdit;
import org.sakaiproject.user.api.UserNotDefinedException;

public class AgentManager
extends SecurityBase
implements org.sakaiproject.metaobj.shared.mgt.AgentManager {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private UserDirectoryService directoryService;
    private int PASSWORD_LENGTH = 8;

    public Agent getAgent(Id id) {
        if (id != null && id.equals((Object)AnonymousAgent.ANONYMOUS_AGENT_ID)) {
            return this.getAnonymousAgent();
        }
        IdUnusedException exception = null;
        Agent returned = null;
        if (id != null) {
            try {
                returned = this.getAgentInternal(id.getValue());
            }
            catch (IdUnusedException e) {
                exception = e;
            }
        }
        if (returned != null) {
            return returned;
        }
        if (exception != null) {
            this.logger.warn((Object)("Unable to find user: " + id + " " + exception.toString()));
        } else {
            this.logger.warn((Object)("Unable to find user: " + id));
        }
        return new AgentWrapper(null, null, null, null, null);
    }

    public Agent getAgent(String username) {
        if (username.equals(AnonymousAgent.ANONYMOUS_AGENT_ID.getValue())) {
            return this.getAnonymousAgent();
        }
        IdUnusedException exception = null;
        Agent returned = null;
        try {
            returned = this.getAgentInternal(username);
        }
        catch (IdUnusedException e) {
            exception = e;
        }
        if (returned != null) {
            return returned;
        }
        if (exception != null) {
            this.logger.warn((Object)("Unable to find user: " + username + " " + exception.toString()));
        } else {
            this.logger.warn((Object)("Unable to find user: " + username));
        }
        return new AgentWrapper(null, null, null, null, null);
    }

    public Agent getWorksiteRole(String roleName) {
        return this.getWorksiteRole(roleName, ToolManager.getCurrentPlacement().getContext());
    }

    public List getWorksiteRoles(String siteId) {
        ArrayList<RoleWrapper> roles = new ArrayList<RoleWrapper>();
        try {
            AuthzGroup siteRealm = AuthzGroupService.getAuthzGroup((String)("/site/" + siteId));
            for (Role sakaiRole : siteRealm.getRoles()) {
                roles.add(this.convertRole(sakaiRole, siteRealm));
            }
        }
        catch (GroupNotDefinedException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new OspException((Throwable)e);
        }
        return roles;
    }

    public Agent getWorksiteRole(String roleName, String siteId) {
        try {
            AuthzGroup siteRealm = AuthzGroupService.getAuthzGroup((String)("/site/" + siteId));
            Role sakaiRole = siteRealm.getRole(roleName);
            return this.convertRole(sakaiRole, siteRealm);
        }
        catch (GroupNotDefinedException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new OspException((Throwable)e);
        }
    }

    public Agent getTempWorksiteRole(String roleName, String siteId) {
        Id roleId = this.getOspiIdManager().getId("/site/" + siteId + "/" + roleName);
        return new RoleWrapper(roleId, roleId, null, null);
    }

    public Agent getRealmRole(String roleName, String realmId) {
        try {
            AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)realmId);
            Role role = realm.getRole(roleName);
            return this.convertRole(role, realm);
        }
        catch (GroupNotDefinedException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new OspException((Throwable)e);
        }
    }

    protected Agent getAgentInternal(String username) throws IdUnusedException {
        if (username == null) {
            return null;
        }
        if (username.startsWith("/site/")) {
            return this.getRole(username);
        }
        User sakaiUser = null;
        try {
            sakaiUser = this.getDirectoryService().getUser(username);
        }
        catch (UserNotDefinedException e) {
            throw new IdUnusedException(e.getId());
        }
        return this.morphAgent(sakaiUser);
    }

    protected Agent getRole(String username) throws IdUnusedException {
        int pos = username.lastIndexOf(47);
        String siteId = username.substring(0, pos);
        String roleName = username.substring(pos + 1);
        Role role = null;
        AuthzGroup realm = null;
        try {
            realm = AuthzGroupService.getAuthzGroup((String)siteId);
        }
        catch (GroupNotDefinedException e) {
            throw new IdUnusedException(e.getId());
        }
        if (realm != null) {
            role = realm.getRole(roleName);
        }
        if (role == null || realm == null) {
            return null;
        }
        return this.convertRole(role, realm);
    }

    public List getWorksiteAgents(String siteId) {
        ArrayList users = new ArrayList();
        ArrayList<Agent> participants = new ArrayList<Agent>();
        String realmId = "/site/" + siteId;
        try {
            AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)realmId);
            users.addAll(this.getDirectoryService().getUsers((Collection)realm.getUsers()));
            Collections.sort(users);
            for (int i = 0; i < users.size(); ++i) {
                User user = (User)users.get(i);
                participants.add(this.morphAgent(user));
            }
        }
        catch (GroupNotDefinedException e) {
            this.logger.warn((Object)("" + realmId));
        }
        return participants;
    }

    public Agent getAnonymousAgent() {
        return new AnonymousAgent();
    }

    public Agent getAdminAgent() {
        return this.getAgent("admin");
    }

    public List findByProperty(String type, Object object) {
        if (type.equals("displayName")) {
            try {
                ArrayList<Agent> users = new ArrayList<Agent>();
                users.add(this.morphAgent(this.getDirectoryService().getUser((String)object)));
                return users;
            }
            catch (UserNotDefinedException e) {
                return null;
            }
        }
        if (type.equals("eid")) {
            try {
                ArrayList<Agent> users = new ArrayList<Agent>();
                users.add(this.morphAgent(this.getDirectoryService().getUserByEid((String)object)));
                return users;
            }
            catch (UserNotDefinedException e) {
                return null;
            }
        }
        if (type.equals("email")) {
            ArrayList<Agent> users = new ArrayList<Agent>();
            Collection directoryUsers = this.getDirectoryService().findUsersByEmail((String)object);
            if (directoryUsers == null || directoryUsers.isEmpty()) {
                return null;
            }
            for (User u : directoryUsers) {
                users.add(this.morphAgent(u));
            }
            return users;
        }
        return null;
    }

    public Agent createAgent(String displayName, Id id) {
        try {
            UserEdit uEdit = this.getDirectoryService().addUser(id.getValue(), id.getValue());
            uEdit.setEmail(id.getValue());
            uEdit.setType("guest");
            String pw = this.passwordGenerator();
            uEdit.setPassword(pw);
            this.getDirectoryService().commitEdit(uEdit);
            AgentImpl agent = new AgentImpl();
            agent.setDisplayName(displayName);
            agent.setRole("ROLE_GUEST");
            agent.setId(id);
            agent.setPassword(pw);
            agent.setMd5Password(DigestUtils.md5Hex((String)pw));
            return agent;
        }
        catch (Exception e) {
            this.logger.warn((Object)("Unable to create guest user: " + id), (Throwable)e);
            return null;
        }
    }

    private String passwordGenerator() {
        Random rand = new Random();
        char[] pass = new char[this.PASSWORD_LENGTH];
        for (int i = 0; i < this.PASSWORD_LENGTH; ++i) {
            int val = rand.nextInt(52);
            val = val < 26 ? (val += 65) : (val += 71);
            pass[i] = (char)val;
        }
        return new String(pass);
    }

    public UserDirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public void setDirectoryService(UserDirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    public void deleteAgent(Agent agent) {
        throw new UnsupportedOperationException();
    }

    public void updateAgent(Agent agent) {
        throw new UnsupportedOperationException();
    }
}

