/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.registry;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.sakaiproject.content.api.ContentEntity;
import org.sakaiproject.content.api.ResourceToolAction;
import org.sakaiproject.content.api.ResourceType;
import org.sakaiproject.content.api.ResourceTypeRegistry;
import org.sakaiproject.content.api.SiteSpecificResourceType;
import org.sakaiproject.content.util.BaseInteractionAction;
import org.sakaiproject.content.util.BaseServiceLevelAction;
import org.sakaiproject.metaobj.registry.CreateFormInteractionAction;
import org.sakaiproject.metaobj.shared.mgt.StructuredArtifactDefinitionManager;
import org.sakaiproject.metaobj.shared.model.StructuredArtifactDefinitionBean;
import org.sakaiproject.util.ResourceLoader;

public class FormResourceType
implements SiteSpecificResourceType {
    private EnumMap<ResourceToolAction.ActionType, List<ResourceToolAction>> actionMap = new EnumMap(ResourceToolAction.ActionType.class);
    private Map<String, ResourceToolAction> actions = new Hashtable<String, ResourceToolAction>();
    private ResourceTypeRegistry resourceTypeRegistry;
    private ResourceLoader rb;
    private StructuredArtifactDefinitionManager structuredArtifactDefinitionManager;
    public static final String FORM_TYPE_ID = "org.sakaiproject.metaobj.shared.FormHelper";
    private static final String CREATE_HELPER = "sakai.metaobj.form.resourceCreateHelper";
    private static final String REVISE_HELPER = "sakai.metaobj.form.resourceEditHelper";

    public void init() {
        this.rb = new ResourceLoader("org/sakaiproject/metaobj/registry/messages");
        ArrayList<String> requiredKeys = new ArrayList<String>();
        requiredKeys.add("SAKAI:structobj_type");
        requiredKeys.add("sakai:reference-root");
        CreateFormInteractionAction create = new CreateFormInteractionAction(this.getStructuredArtifactDefinitionManager(), "create", ResourceToolAction.ActionType.CREATE, FORM_TYPE_ID, CREATE_HELPER, requiredKeys);
        BaseInteractionAction revise = new BaseInteractionAction("revise", ResourceToolAction.ActionType.REVISE_CONTENT, FORM_TYPE_ID, REVISE_HELPER, (List)null);
        BaseServiceLevelAction copy = new BaseServiceLevelAction("copy", ResourceToolAction.ActionType.COPY, FORM_TYPE_ID, true);
        BaseServiceLevelAction delete = new BaseServiceLevelAction("delete", ResourceToolAction.ActionType.DELETE, FORM_TYPE_ID, true);
        BaseServiceLevelAction reviseMetadata = new BaseServiceLevelAction("properties", ResourceToolAction.ActionType.REVISE_METADATA, FORM_TYPE_ID, false);
        BaseServiceLevelAction move = new BaseServiceLevelAction("move", ResourceToolAction.ActionType.MOVE, FORM_TYPE_ID, true);
        this.actionMap.put(create.getActionType(), this.makeList((ResourceToolAction)create));
        this.actionMap.put(revise.getActionType(), this.makeList((ResourceToolAction)revise));
        this.actionMap.put(copy.getActionType(), this.makeList((ResourceToolAction)copy));
        this.actionMap.put(delete.getActionType(), this.makeList((ResourceToolAction)delete));
        this.actionMap.put(reviseMetadata.getActionType(), this.makeList((ResourceToolAction)reviseMetadata));
        this.actionMap.put(move.getActionType(), this.makeList((ResourceToolAction)move));
        this.actions.put(create.getId(), (ResourceToolAction)create);
        this.actions.put(revise.getId(), (ResourceToolAction)revise);
        this.actions.put(copy.getId(), (ResourceToolAction)copy);
        this.actions.put(delete.getId(), (ResourceToolAction)delete);
        this.actions.put(reviseMetadata.getId(), (ResourceToolAction)reviseMetadata);
        this.actions.put(move.getId(), (ResourceToolAction)move);
        this.getResourceTypeRegistry().register((ResourceType)this);
    }

    protected List<ResourceToolAction> makeList(ResourceToolAction create) {
        ArrayList<ResourceToolAction> returned = new ArrayList<ResourceToolAction>();
        returned.add(create);
        return returned;
    }

    public List<ResourceToolAction> getActions(ResourceToolAction.ActionType type) {
        List<ResourceToolAction> list = this.actionMap.get(type);
        if (list == null) {
            list = new Vector<ResourceToolAction>();
            this.actionMap.put(type, list);
        }
        return new Vector<ResourceToolAction>(list);
    }

    public List<ResourceToolAction> getActions(List<ResourceToolAction.ActionType> types) {
        Vector<ResourceToolAction> list = new Vector<ResourceToolAction>();
        if (types != null) {
            for (ResourceToolAction.ActionType type : types) {
                List<ResourceToolAction> sublist = this.actionMap.get(type);
                if (sublist == null) {
                    sublist = new Vector<ResourceToolAction>();
                    this.actionMap.put(type, sublist);
                }
                list.addAll(sublist);
            }
        }
        return list;
    }

    public ResourceToolAction getAction(String actionId) {
        return this.actions.get(actionId);
    }

    public String getIconLocation(ContentEntity entity) {
        return "silk/application_form.gif";
    }

    public String getId() {
        return FORM_TYPE_ID;
    }

    public String getLabel() {
        return this.rb.getString("form_item");
    }

    public String getLocalizedHoverText(ContentEntity member) {
        StructuredArtifactDefinitionBean home;
        String formName = "";
        if (member != null && (home = this.getStructuredArtifactDefinitionManager().loadHome((String)member.getProperties().get("SAKAI:structobj_type"))) != null) {
            formName = home.getDescription();
        }
        return this.rb.getFormattedMessage("form_item_tip", new Object[]{formName});
    }

    public boolean hasAvailabilityDialog() {
        return true;
    }

    public boolean hasDescription() {
        return true;
    }

    public boolean hasGroupsDialog() {
        return true;
    }

    public boolean hasNotificationDialog() {
        return true;
    }

    public boolean hasOptionalPropertiesDialog() {
        return true;
    }

    public boolean hasPublicDialog() {
        return true;
    }

    public boolean hasRightsDialog() {
        return true;
    }

    public ResourceTypeRegistry getResourceTypeRegistry() {
        return this.resourceTypeRegistry;
    }

    public void setResourceTypeRegistry(ResourceTypeRegistry resourceTypeRegistry) {
        this.resourceTypeRegistry = resourceTypeRegistry;
    }

    public StructuredArtifactDefinitionManager getStructuredArtifactDefinitionManager() {
        return this.structuredArtifactDefinitionManager;
    }

    public void setStructuredArtifactDefinitionManager(StructuredArtifactDefinitionManager structuredArtifactDefinitionManager) {
        this.structuredArtifactDefinitionManager = structuredArtifactDefinitionManager;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean isExpandable() {
        return false;
    }

    public String getSizeLabel(ContentEntity entity) {
        return null;
    }

    public String getLongSizeLabel(ContentEntity entity) {
        return null;
    }
}

