/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.memory.util;

import java.io.IOException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.memory.util.CacheInitializer;

public class EhCacheManagerFactoryBean
extends org.springframework.cache.ehcache.EhCacheManagerFactoryBean {
    private ServerConfigurationService serverConfigurationService = (ServerConfigurationService)ComponentManager.get(ServerConfigurationService.class);

    public void afterPropertiesSet() throws IOException, CacheException {
        super.afterPropertiesSet();
        CacheManager cm = this.getObject();
        if (cm != null) {
            String[] cacheNames;
            for (String cacheName : cacheNames = cm.getCacheNames()) {
                String config;
                if (this.serverConfigurationService.getString(cacheName) == null) {
                    this.logger.warn((Object)("Old cache configuration " + cacheName + " must be changed to memory." + cacheName));
                }
                if ((config = this.serverConfigurationService.getString("memory." + cacheName)) == null || config.length() <= 0) continue;
                this.logger.info((Object)("Found configuration override for cache: " + cacheName + " of: " + config));
                Cache cache = cm.getCache(cacheName);
                if (cache == null) continue;
                new CacheInitializer().configure(config).initialize(cache.getCacheConfiguration());
            }
        }
    }
}

