/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.memory.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheInitializer {
    private static final Log M_log = LogFactory.getLog(CacheInitializer.class);
    private Map<String, String> configMap;

    public CacheInitializer configure(String config) {
        String[] configParts;
        this.configMap = new HashMap<String, String>();
        for (String part : configParts = config.split(",")) {
            String[] splitParts = part.split("=", 2);
            if (splitParts.length == 2) {
                String key = splitParts[0];
                String value = splitParts[1];
                this.configMap.put(key, value);
                continue;
            }
            M_log.warn((Object)("Couldn't parse cache config of: " + part));
        }
        return this;
    }

    public CacheInitializer initialize(CacheConfiguration cacheConfig) {
        Method[] methods;
        if (this.configMap == null) {
            throw new IllegalStateException("You must configure the initializer first.");
        }
        for (Method method : methods = cacheConfig.getClass().getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            String key = Character.toLowerCase(method.getName().charAt("set".length())) + method.getName().substring("set".length() + 1);
            M_log.debug((Object)("Looking in config map for: " + key));
            String value = this.configMap.get(key);
            if (value == null) continue;
            Class<?> clazz = method.getParameterTypes()[0];
            M_log.debug((Object)("Need to convert to :" + clazz));
            Object obj = this.covertValue(value, clazz);
            if (obj == null) continue;
            this.invokeMethod(method, cacheConfig, obj);
            M_log.debug((Object)("Setting " + clazz + "#" + key + " to " + value));
        }
        return this;
    }

    private Object covertValue(String value, Class clazz) {
        Object obj = null;
        try {
            if (String.class.equals((Object)clazz)) {
                obj = value;
            } else if (Integer.class.equals((Object)clazz) || Integer.TYPE.equals(clazz)) {
                obj = Integer.valueOf(value);
            } else if (Boolean.class.equals((Object)clazz) || Boolean.TYPE.equals(clazz)) {
                obj = Boolean.valueOf(value);
            } else if (Long.class.equals((Object)clazz) || Long.TYPE.equals(clazz)) {
                obj = Long.valueOf(value);
            } else if (Float.class.equals((Object)clazz) || Float.TYPE.equals(clazz)) {
                obj = Float.valueOf(value);
            } else if (Double.class.equals((Object)clazz) || Double.TYPE.equals(clazz)) {
                obj = Double.valueOf(value);
            } else if (Character.class.equals((Object)clazz) || Character.TYPE.equals(clazz)) {
                obj = Character.valueOf(value.charAt(0));
            } else {
                M_log.debug((Object)("Can't convert to :" + clazz));
            }
        }
        catch (NumberFormatException nfe) {
            M_log.debug((Object)("Ignored bad number: " + value));
        }
        return obj;
    }

    private void invokeMethod(Method method, Object obj, Object value) {
        try {
            method.invoke(obj, value);
        }
        catch (Exception e) {
            M_log.debug((Object)e);
        }
    }
}

