/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.IOException;
import java.security.MessageDigest;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;

public class TrustedLoginFilter
implements Filter {
    private static final Log log = LogFactory.getLog(TrustedLoginFilter.class);
    private SessionManager sessionManager;
    private String sharedSecret;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)req;
        String token = hreq.getHeader("X-SAKAI-TOKEN");
        if (token == null) {
            token = hreq.getParameter("t");
        }
        Session currentSession = null;
        Session requestSession = null;
        String user = this.decodeToken(token);
        if (user != null && !user.equals((currentSession = this.sessionManager.getCurrentSession()).getUserEid())) {
            requestSession = this.sessionManager.startSession();
            try {
                User usr = UserDirectoryService.getUserByEid(user);
                requestSession.setUserEid(usr.getEid());
                requestSession.setUserId(usr.getId());
                requestSession.setActive();
            }
            catch (UserNotDefinedException e) {
                e.printStackTrace();
            }
            this.sessionManager.setCurrentSession(requestSession);
        }
        try {
            chain.doFilter(req, resp);
        }
        finally {
            if (requestSession != null) {
                if (currentSession != null) {
                    this.sessionManager.setCurrentSession(currentSession);
                }
                requestSession.invalidate();
            }
        }
    }

    protected String decodeToken(String token) {
        try {
            int sep = token.indexOf(";");
            if (sep > 0) {
                String hash = token.substring(0, sep);
                String data = token.substring(sep + 1);
                String key = this.sharedSecret + ";" + data;
                String computedHash = this.byteArrayToHexStr(MessageDigest.getInstance("SHA1").digest(key.getBytes("UTF-8")));
                if (hash.equals(computedHash)) {
                    sep = data.indexOf(";");
                    return data.substring(0, sep);
                }
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to decode token " + token + "  :" + ex.getMessage()));
        }
        return null;
    }

    public void init(FilterConfig config) throws ServletException {
        this.sessionManager = org.sakaiproject.tool.cover.SessionManager.getInstance();
        this.sharedSecret = config.getInitParameter("shared.secret");
    }

    protected String byteArrayToHexStr(byte[] data) {
        char[] chars = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            byte current = data[i];
            int hi = (current & 0xF0) >> 4;
            int lo = current & 0xF;
            chars[2 * i] = (char)(hi < 10 ? 48 + hi : 65 + hi - 10);
            chars[2 * i + 1] = (char)(lo < 10 ? 48 + lo : 65 + lo - 10);
        }
        return new String(chars);
    }

    protected void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }
}

