/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.event.api.UsageSession;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import org.sakaiproject.tool.api.RebuildBreakdownService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.ServerCookie;

public class RequestFilter
implements Filter {
    public static final String ATTR_SESSION = "sakai.session";
    public static final String ATTR_SET_COOKIE = "sakai.set.cookie";
    public static final String ATTR_FILTERED = "sakai.filtered";
    public static final String ATTR_UPLOADS_DONE = "sakai.uploads.done";
    public static final String ATTR_CHARACTER_ENCODING_DONE = "sakai.character.encoding.done";
    public static final String ATTR_REDIRECT = "sakai.redirect";
    public static final String PARAM_AUTO = "auto";
    public static final String CONFIG_SESSION = "http.session";
    public static final String CONFIG_SESSION_AUTH = "sakai.session.auth";
    public static final String CONFIG_REMOTE_USER = "remote.user";
    public static final String CONFIG_TOOL_PLACEMENT = "tool.placement";
    public static final String CONFIG_CHARACTER_ENCODING_ENABLED = "encoding.enabled";
    public static final String CONFIG_CHARACTER_ENCODING = "encoding";
    public static final String CONFIG_UPLOAD_ENABLED = "upload.enabled";
    public static final String CONFIG_UPLOAD_MAX = "upload.max";
    public static final String SYSTEM_UPLOAD_MAX = "sakai.content.upload.max";
    public static final String SYSTEM_UPLOAD_CEILING = "sakai.content.upload.ceiling";
    public static final String CONFIG_UPLOAD_THRESHOLD = "upload.threshold";
    public static final String CONFIG_UPLOAD_DIR = "upload.dir";
    public static final String SYSTEM_UPLOAD_DIR = "sakai.content.upload.dir";
    public static final String CONFIG_CONTEXT = "context";
    public static final String CURRENT_HTTP_REQUEST = "org.sakaiproject.util.RequestFilter.http_request";
    public static final String CURRENT_HTTP_RESPONSE = "org.sakaiproject.util.RequestFilter.http_response";
    public static final String CURRENT_SERVLET_CONTEXT = "org.sakaiproject.util.RequestFilter.servlet_context";
    protected static final String CONFIG_CONTINUE = "upload.continueOverMax";
    protected static final String CONFIG_MAX_PER_FILE = "upload.maxPerFile";
    protected static final int CONTAINER_SESSION = 0;
    protected static final int SAKAI_SESSION = 1;
    protected static final int CONTEXT_SESSION = 2;
    protected static final int TOOL_SESSION = 3;
    protected int m_sakaiHttpSession = 3;
    protected static final String CURRENT_REMOTE_USER = "org.sakaiproject.util.RequestFilter.remote_user";
    protected static final String CURRENT_HTTP_SESSION = "org.sakaiproject.util.RequestFilter.http_session";
    protected static final String CURRENT_CONTEXT = "org.sakaiproject.util.RequestFilter.context";
    protected static final String DOT = ".";
    protected static final String SAKAI_SERVERID = "sakai.serverId";
    protected static final String SAKAI_COOKIE_NAME = "sakai.cookieName";
    protected static final String SAKAI_COOKIE_DOMAIN = "sakai.cookieDomain";
    protected static final String SAKAI_COOKIE_HTTP_ONLY = "sakai.cookieHttpOnly";
    protected static final String SAKAI_UA_COMPATIBLE = "sakai.X-UA-Compatible";
    protected static final String SAKAI_SESSION_PARAM_ALLOW = "session.parameter.allow";
    protected static final String SAKAI_BLTI_PROVIDER_TOOLS = "basiclti.provider.allowedtools";
    private static Log M_log = LogFactory.getLog(RequestFilter.class);
    protected boolean m_sakaiRemoteUser = true;
    protected boolean m_toolPlacement = true;
    protected String m_contextId = null;
    protected String m_characterEncoding = "UTF-8";
    protected boolean m_characterEncodingEnabled = true;
    protected boolean m_uploadEnabled = true;
    protected boolean m_checkPrincipal = false;
    protected long m_uploadMaxSize = 0x100000L;
    protected long m_uploadCeiling = 0x100000L;
    protected int m_uploadThreshold = 1024;
    protected String m_uploadTempDir = null;
    protected boolean m_displayModJkWarning = true;
    protected boolean m_uploadContinue = false;
    protected boolean m_uploadMaxPerFile = false;
    protected ServletContext m_servletContext = null;
    protected boolean TERRACOTTA_CLUSTER = false;
    protected boolean m_sessionParamAllow = false;
    protected String cookieName = "JSESSIONID";
    protected String cookieDomain = null;
    protected boolean m_cookieHttpOnly = true;
    protected String m_UACompatible = null;
    private String chsDomain;
    private String appUrl;
    private String chsUrl;
    private boolean useContentHostingDomain;
    private String[] contentPaths;
    private String[] loginPaths;
    private String[] contentExceptions;

    public static String serverUrl(HttpServletRequest req) {
        String transport = null;
        int port = 0;
        boolean secure = false;
        String forceSecure = System.getProperty("sakai.force.url.secure");
        if (forceSecure != null && !"".equals(forceSecure)) {
            int portNum;
            try {
                portNum = Integer.parseInt(forceSecure);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("force.url.secure must be set to the port number which should be a numeric value > 0 (or set it to 0 to disable secure urls)", e);
            }
            if (portNum > 0) {
                transport = "https";
                port = portNum;
                secure = true;
            }
        } else {
            transport = req.getScheme();
            port = req.getServerPort();
            secure = req.isSecure();
        }
        StringBuilder url = new StringBuilder();
        url.append(transport);
        url.append("://");
        url.append(req.getServerName());
        if (port != 80 && !secure || port != 443 && secure) {
            url.append(":");
            url.append(port);
        }
        return url.toString();
    }

    public void destroy() {
    }

    private boolean startsWithAny(String source, String[] toMatch) {
        for (String test : toMatch) {
            if (!source.startsWith(test)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest requestObj, ServletResponse responseObj, FilterChain chain) throws IOException, ServletException {
        ArrayList<FileItem> tempFiles;
        long startTime;
        StringBuffer sb;
        block39: {
            HttpServletResponse resp;
            HttpServletRequest req;
            boolean cleared;
            ServletResponse curResponse;
            ServletRequest curRequest;
            String curContext;
            Integer curHttpSession;
            Boolean curRemoteUser;
            block34: {
                block37: {
                    String requestURI;
                    block35: {
                        block36: {
                            block32: {
                                block33: {
                                    sb = null;
                                    startTime = System.currentTimeMillis();
                                    curRemoteUser = (Boolean)ThreadLocalManager.get(CURRENT_REMOTE_USER);
                                    curHttpSession = (Integer)ThreadLocalManager.get(CURRENT_HTTP_SESSION);
                                    curContext = (String)ThreadLocalManager.get(CURRENT_CONTEXT);
                                    curRequest = (ServletRequest)ThreadLocalManager.get(CURRENT_HTTP_REQUEST);
                                    curResponse = (ServletResponse)ThreadLocalManager.get(CURRENT_HTTP_RESPONSE);
                                    cleared = false;
                                    tempFiles = new ArrayList<FileItem>();
                                    try {
                                        ThreadLocalManager.set(CURRENT_REMOTE_USER, this.m_sakaiRemoteUser);
                                        ThreadLocalManager.set(CURRENT_HTTP_SESSION, this.m_sakaiHttpSession);
                                        ThreadLocalManager.set(CURRENT_CONTEXT, this.m_contextId);
                                        ThreadLocalManager.set(CURRENT_SERVLET_CONTEXT, this.m_servletContext);
                                        if (requestObj instanceof HttpServletRequest && responseObj instanceof HttpServletResponse) break block32;
                                        chain.doFilter(requestObj, responseObj);
                                        if (cleared) break block33;
                                    }
                                    catch (Throwable throwable) {
                                        if (!cleared) {
                                            ThreadLocalManager.set(CURRENT_REMOTE_USER, curRemoteUser);
                                            ThreadLocalManager.set(CURRENT_HTTP_SESSION, curHttpSession);
                                            ThreadLocalManager.set(CURRENT_CONTEXT, curContext);
                                            ThreadLocalManager.set(CURRENT_HTTP_REQUEST, curRequest);
                                            ThreadLocalManager.set(CURRENT_HTTP_RESPONSE, curResponse);
                                        }
                                        this.deleteTempFiles(tempFiles);
                                        if (M_log.isDebugEnabled() && sb != null) {
                                            long elapsedTime = System.currentTimeMillis() - startTime;
                                            M_log.debug((Object)("request timing (ms): " + elapsedTime + " for " + sb));
                                        }
                                        throw throwable;
                                    }
                                    ThreadLocalManager.set(CURRENT_REMOTE_USER, curRemoteUser);
                                    ThreadLocalManager.set(CURRENT_HTTP_SESSION, curHttpSession);
                                    ThreadLocalManager.set(CURRENT_CONTEXT, curContext);
                                    ThreadLocalManager.set(CURRENT_HTTP_REQUEST, curRequest);
                                    ThreadLocalManager.set(CURRENT_HTTP_RESPONSE, curResponse);
                                }
                                this.deleteTempFiles(tempFiles);
                                if (M_log.isDebugEnabled() && sb != null) {
                                    long elapsedTime = System.currentTimeMillis() - startTime;
                                    M_log.debug((Object)("request timing (ms): " + elapsedTime + " for " + sb));
                                }
                                return;
                            }
                            req = (HttpServletRequest)requestObj;
                            resp = (HttpServletResponse)responseObj;
                            if (!this.useContentHostingDomain) break block34;
                            requestURI = req.getRequestURI();
                            if (!this.startsWithAny(requestURI, this.contentPaths) || !"GET".equalsIgnoreCase(req.getMethod())) break block35;
                            if (req.getServerName().equals(this.chsDomain) || this.startsWithAny(requestURI, this.contentExceptions)) break block34;
                            resp.sendRedirect(this.chsUrl + requestURI);
                            if (cleared) break block36;
                            ThreadLocalManager.set(CURRENT_REMOTE_USER, curRemoteUser);
                            ThreadLocalManager.set(CURRENT_HTTP_SESSION, curHttpSession);
                            ThreadLocalManager.set(CURRENT_CONTEXT, curContext);
                            ThreadLocalManager.set(CURRENT_HTTP_REQUEST, curRequest);
                            ThreadLocalManager.set(CURRENT_HTTP_RESPONSE, curResponse);
                        }
                        this.deleteTempFiles(tempFiles);
                        if (M_log.isDebugEnabled() && sb != null) {
                            long elapsedTime = System.currentTimeMillis() - startTime;
                            M_log.debug((Object)("request timing (ms): " + elapsedTime + " for " + sb));
                        }
                        return;
                    }
                    if (!req.getServerName().equals(this.chsDomain) || this.startsWithAny(requestURI, this.contentPaths) && !"GET".equalsIgnoreCase(req.getMethod()) || this.startsWithAny(requestURI, this.loginPaths)) break block34;
                    resp.sendRedirect(this.appUrl + requestURI);
                    if (cleared) break block37;
                    ThreadLocalManager.set(CURRENT_REMOTE_USER, curRemoteUser);
                    ThreadLocalManager.set(CURRENT_HTTP_SESSION, curHttpSession);
                    ThreadLocalManager.set(CURRENT_CONTEXT, curContext);
                    ThreadLocalManager.set(CURRENT_HTTP_REQUEST, curRequest);
                    ThreadLocalManager.set(CURRENT_HTTP_RESPONSE, curResponse);
                }
                this.deleteTempFiles(tempFiles);
                if (M_log.isDebugEnabled() && sb != null) {
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    M_log.debug((Object)("request timing (ms): " + elapsedTime + " for " + sb));
                }
                return;
            }
            this.handleCharacterEncoding(req, resp);
            req = this.handleFileUpload(req, resp, tempFiles);
            if (req.getAttribute(ATTR_FILTERED) != null) {
                ThreadLocalManager.set(CURRENT_HTTP_REQUEST, req);
                ThreadLocalManager.set(CURRENT_HTTP_RESPONSE, resp);
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            } else {
                if (M_log.isDebugEnabled()) {
                    sb = new StringBuffer("http-request: ");
                    sb.append(req.getMethod());
                    sb.append(" ");
                    sb.append(req.getRequestURL());
                    if (req.getQueryString() != null) {
                        sb.append("?");
                        sb.append(req.getQueryString());
                    }
                    M_log.debug((Object)sb);
                }
                try {
                    req.setAttribute(ATTR_FILTERED, (Object)ATTR_FILTERED);
                    ThreadLocalManager.set("sakai:request.server.url", RequestFilter.serverUrl(req));
                    Session s = this.assureSession(req, resp);
                    req = this.preProcessRequest(s, req);
                    this.detectToolPlacement(s, req);
                    resp = this.preProcessResponse(s, req, resp);
                    ThreadLocalManager.set(CURRENT_HTTP_REQUEST, req);
                    ThreadLocalManager.set(CURRENT_HTTP_RESPONSE, resp);
                    if (this.m_contextId != null && this.m_contextId.length() > 0) {
                        ThreadLocalManager.set("sakai:request.portal.path", "/" + this.m_contextId);
                    }
                    if (this.TERRACOTTA_CLUSTER) {
                        Session elapsedTime = s;
                        synchronized (elapsedTime) {
                            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                            this.postProcessResponse(s, req, resp);
                        }
                    } else {
                        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                        this.postProcessResponse(s, req, resp);
                    }
                    if (s != null && req.getAttribute(ATTR_SET_COOKIE) != null) {
                        String suffix = this.getCookieSuffix();
                        Cookie c = this.findCookie(req, this.cookieName, suffix);
                        String sessionId = s.getId() + DOT + suffix;
                        if (c == null || !c.getValue().equals(sessionId)) {
                            c = new Cookie(this.cookieName, sessionId);
                            c.setPath("/");
                            c.setMaxAge(-1);
                            if (this.cookieDomain != null) {
                                c.setDomain(this.cookieDomain);
                            }
                            if (req.isSecure()) {
                                c.setSecure(true);
                            }
                            this.addCookie(resp, c);
                        }
                    }
                }
                catch (RuntimeException t) {
                    M_log.warn((Object)"", (Throwable)t);
                    throw t;
                }
                catch (IOException ioe) {
                    M_log.warn((Object)"", (Throwable)ioe);
                    throw ioe;
                }
                catch (ServletException se) {
                    M_log.warn((Object)se.getMessage(), (Throwable)se);
                    throw se;
                }
                finally {
                    ThreadLocalManager.clear();
                    cleared = true;
                }
            }
            if (cleared) break block39;
            ThreadLocalManager.set(CURRENT_REMOTE_USER, curRemoteUser);
            ThreadLocalManager.set(CURRENT_HTTP_SESSION, curHttpSession);
            ThreadLocalManager.set(CURRENT_CONTEXT, curContext);
            ThreadLocalManager.set(CURRENT_HTTP_REQUEST, curRequest);
            ThreadLocalManager.set(CURRENT_HTTP_RESPONSE, curResponse);
        }
        this.deleteTempFiles(tempFiles);
        if (M_log.isDebugEnabled() && sb != null) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            M_log.debug((Object)("request timing (ms): " + elapsedTime + " for " + sb));
        }
    }

    protected void deleteTempFiles(List<FileItem> tempFiles) {
        for (FileItem item : tempFiles) {
            item.delete();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServerConfigurationService configService = org.sakaiproject.component.cover.ServerConfigurationService.getInstance();
        this.appUrl = configService.getString("serverUrl", null);
        this.chsDomain = configService.getString("content.chs.serverName", null);
        this.chsUrl = configService.getString("content.chs.serverUrl", null);
        this.useContentHostingDomain = configService.getBoolean("content.separateDomains", false);
        this.contentPaths = configService.getStrings("content.chs.urlprefixes");
        if (this.contentPaths == null) {
            this.contentPaths = new String[]{"/access/", "/web/"};
        }
        this.loginPaths = configService.getStrings("content.login.urlprefixes");
        if (this.loginPaths == null) {
            this.loginPaths = new String[]{"/access/login", "/sakai-login-tool", "/access/require", "/access/accept"};
        }
        this.contentExceptions = configService.getStrings("content.chsexception.urlprefixes");
        if (this.contentExceptions == null) {
            this.contentExceptions = new String[]{"/access/calendar/", "/access/citation/export_ris_sel/", "/access/citation/export_ris_all/"};
        }
        this.m_servletContext = filterConfig.getServletContext();
        if (filterConfig.getInitParameter(CONFIG_SESSION) != null) {
            String s = filterConfig.getInitParameter(CONFIG_SESSION);
            if ("container".equalsIgnoreCase(s)) {
                this.m_sakaiHttpSession = 0;
            } else if ("sakai".equalsIgnoreCase(s)) {
                this.m_sakaiHttpSession = 1;
            } else if (CONFIG_CONTEXT.equalsIgnoreCase(s)) {
                this.m_sakaiHttpSession = 2;
            } else if ("tool".equalsIgnoreCase(s)) {
                this.m_sakaiHttpSession = 3;
            } else {
                M_log.warn((Object)("invalid http.session setting (" + s + "): not one of container, sakai, context, tool"));
            }
        }
        if (filterConfig.getInitParameter(CONFIG_REMOTE_USER) != null) {
            this.m_sakaiRemoteUser = Boolean.valueOf(filterConfig.getInitParameter(CONFIG_REMOTE_USER));
        }
        if (filterConfig.getInitParameter(CONFIG_SESSION_AUTH) != null) {
            this.m_checkPrincipal = "basic".equals(filterConfig.getInitParameter(CONFIG_SESSION_AUTH));
        }
        if (filterConfig.getInitParameter(CONFIG_TOOL_PLACEMENT) != null) {
            this.m_toolPlacement = Boolean.valueOf(filterConfig.getInitParameter(CONFIG_TOOL_PLACEMENT));
        }
        if (filterConfig.getInitParameter(CONFIG_CONTEXT) != null) {
            this.m_contextId = filterConfig.getInitParameter(CONFIG_CONTEXT);
        } else {
            this.m_contextId = this.m_servletContext.getServletContextName();
            if (this.m_contextId == null) {
                this.m_contextId = this.toString();
            }
        }
        if (filterConfig.getInitParameter(CONFIG_CHARACTER_ENCODING) != null) {
            this.m_characterEncoding = filterConfig.getInitParameter(CONFIG_CHARACTER_ENCODING);
        }
        if (filterConfig.getInitParameter(CONFIG_CHARACTER_ENCODING_ENABLED) != null) {
            this.m_characterEncodingEnabled = Boolean.valueOf(filterConfig.getInitParameter(CONFIG_CHARACTER_ENCODING_ENABLED));
        }
        if (filterConfig.getInitParameter(CONFIG_UPLOAD_ENABLED) != null) {
            this.m_uploadEnabled = Boolean.valueOf(filterConfig.getInitParameter(CONFIG_UPLOAD_ENABLED));
        }
        if (System.getProperty(SYSTEM_UPLOAD_MAX) != null) {
            this.m_uploadCeiling = this.m_uploadMaxSize = Long.valueOf(System.getProperty(SYSTEM_UPLOAD_MAX).trim()) * 1024L * 1024L;
        }
        if (filterConfig.getInitParameter(CONFIG_UPLOAD_MAX) != null) {
            this.m_uploadMaxSize = Long.valueOf(filterConfig.getInitParameter(CONFIG_UPLOAD_MAX).trim()) * 1024L * 1024L;
        }
        if (System.getProperty(SYSTEM_UPLOAD_CEILING) != null) {
            this.m_uploadCeiling = Long.valueOf(System.getProperty(SYSTEM_UPLOAD_CEILING).trim()) * 1024L * 1024L;
        }
        if (System.getProperty(SYSTEM_UPLOAD_DIR) != null) {
            this.m_uploadTempDir = System.getProperty(SYSTEM_UPLOAD_DIR);
        }
        if (filterConfig.getInitParameter(CONFIG_UPLOAD_DIR) != null) {
            this.m_uploadTempDir = filterConfig.getInitParameter(CONFIG_UPLOAD_DIR);
        }
        if (filterConfig.getInitParameter(CONFIG_UPLOAD_THRESHOLD) != null) {
            this.m_uploadThreshold = Integer.valueOf(filterConfig.getInitParameter(CONFIG_UPLOAD_THRESHOLD));
        }
        if (filterConfig.getInitParameter(CONFIG_CONTINUE) != null) {
            this.m_uploadContinue = Boolean.valueOf(filterConfig.getInitParameter(CONFIG_CONTINUE));
        }
        if (filterConfig.getInitParameter(CONFIG_MAX_PER_FILE) != null) {
            this.m_uploadMaxPerFile = Boolean.valueOf(filterConfig.getInitParameter(CONFIG_MAX_PER_FILE));
        }
        if (this.m_uploadContinue && !this.m_uploadMaxPerFile) {
            M_log.warn((Object)"overridding upload.maxPerFile setting: must be 'true' with upload.continueOverMax ='true'");
            this.m_uploadMaxPerFile = true;
        }
        String clusterTerracotta = System.getProperty("sakai.cluster.terracotta");
        this.TERRACOTTA_CLUSTER = "true".equals(clusterTerracotta);
        if (System.getProperty(SAKAI_COOKIE_NAME) != null) {
            this.cookieName = System.getProperty(SAKAI_COOKIE_NAME);
        }
        if (System.getProperty(SAKAI_COOKIE_DOMAIN) != null) {
            this.cookieDomain = System.getProperty(SAKAI_COOKIE_DOMAIN);
        }
        this.m_sessionParamAllow = configService.getBoolean(SAKAI_SESSION_PARAM_ALLOW, false);
        this.m_cookieHttpOnly = configService.getBoolean(SAKAI_COOKIE_HTTP_ONLY, true);
        this.m_UACompatible = configService.getString(SAKAI_UA_COMPATIBLE, null);
    }

    protected void handleCharacterEncoding(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        if (this.m_characterEncodingEnabled && req.getCharacterEncoding() == null && this.m_characterEncoding != null && this.m_characterEncoding.length() > 0 && req.getAttribute(ATTR_CHARACTER_ENCODING_DONE) == null) {
            req.setAttribute(ATTR_CHARACTER_ENCODING_DONE, (Object)ATTR_CHARACTER_ENCODING_DONE);
            req.setCharacterEncoding(this.m_characterEncoding);
        }
    }

    protected HttpServletRequest handleFileUpload(HttpServletRequest req, HttpServletResponse resp, List<FileItem> tempFiles) throws ServletException, UnsupportedEncodingException {
        String override;
        if (!this.m_uploadEnabled || !ServletFileUpload.isMultipartContent((HttpServletRequest)req) || req.getAttribute(ATTR_UPLOADS_DONE) != null) {
            return req;
        }
        req.setAttribute(ATTR_UPLOADS_DONE, (Object)ATTR_UPLOADS_DONE);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        if (this.m_uploadTempDir != null) {
            factory.setRepository(new File(this.m_uploadTempDir));
        }
        if (this.m_uploadThreshold > 0) {
            factory.setSizeThreshold(this.m_uploadThreshold);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        String encoding = req.getCharacterEncoding();
        if (encoding != null && encoding.length() > 0) {
            upload.setHeaderEncoding(encoding);
        }
        long uploadMax = -1L;
        if (this.m_uploadMaxSize > 0L) {
            uploadMax = this.m_uploadMaxSize;
        }
        if ((override = req.getParameter(CONFIG_UPLOAD_MAX)) != null) {
            try {
                uploadMax = Long.parseLong(override) * 1024L * 1024L;
            }
            catch (NumberFormatException e) {
                M_log.warn((Object)("upload.max set to non-numeric: " + override));
            }
        }
        if (uploadMax > this.m_uploadCeiling) {
            M_log.debug((Object)("Upload size exceeds ceiling: " + uploadMax / 1024L / 1024L + " > " + this.m_uploadCeiling / 1024L / 1024L + " megs"));
            uploadMax = this.m_uploadCeiling;
        }
        if (!this.m_uploadContinue) {
            upload.setSizeMax(uploadMax);
        }
        try {
            boolean uploadOk = true;
            List list = upload.parseRequest(req);
            for (int i = 0; i < list.size(); ++i) {
                FileItem item = (FileItem)list.get(i);
                if (item.isFormField()) {
                    String str = item.getString(encoding);
                    Object obj = map.get(item.getFieldName());
                    if (obj == null) {
                        map.put(item.getFieldName(), new String[]{str});
                        continue;
                    }
                    if (obj instanceof String[]) {
                        String[] old_vals = (String[])obj;
                        String[] values = new String[old_vals.length + 1];
                        for (int i1 = 0; i1 < old_vals.length; ++i1) {
                            values[i1] = old_vals[i1];
                        }
                        values[values.length - 1] = str;
                        map.put(item.getFieldName(), values);
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    String[] values = new String[]{(String)obj, str};
                    map.put(item.getFieldName(), values);
                    continue;
                }
                tempFiles.add(item);
                if (this.m_uploadContinue && item.getSize() > uploadMax) {
                    uploadOk = false;
                    M_log.info((Object)("Upload size limit exceeded: " + uploadMax / 1024L / 1024L));
                    req.setAttribute("upload.status", (Object)"size_limit_exceeded");
                    req.setAttribute("upload.exception", (Object)new FileUploadBase.SizeLimitExceededException("", item.getSize(), uploadMax));
                    req.setAttribute("upload.limit", (Object)(uploadMax / 1024L / 1024L));
                    continue;
                }
                req.setAttribute(item.getFieldName(), (Object)item);
            }
            if (uploadOk) {
                req.setAttribute("upload.status", (Object)"ok");
            }
        }
        catch (FileUploadBase.SizeLimitExceededException ex) {
            M_log.info((Object)("Upload size limit exceeded: " + upload.getSizeMax() / 1024L / 1024L));
            req.setAttribute("upload.status", (Object)"size_limit_exceeded");
            req.setAttribute("upload.exception", (Object)ex);
            req.setAttribute("upload.limit", (Object)(upload.getSizeMax() / 1024L / 1024L));
        }
        catch (FileUploadException ex) {
            M_log.info((Object)"Unexpected exception in upload parsing", (Throwable)ex);
            req.setAttribute("upload.status", (Object)"exception");
            req.setAttribute("upload.exception", (Object)ex);
        }
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String[] values = req.getParameterValues(name);
            map.put(name, values);
        }
        return new WrappedRequestFileUpload(req, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session assureSession(HttpServletRequest req, HttpServletResponse res) {
        RebuildBreakdownService rebuildBreakdownService;
        Session s = null;
        String sessionId = null;
        boolean allowSetCookieEarly = true;
        Cookie c = null;
        boolean auto = req.getParameter(PARAM_AUTO) != null;
        boolean reqsession = this.m_sessionParamAllow && req.getParameter(ATTR_SESSION) != null;
        String suffix = this.getCookieSuffix();
        Principal principal = req.getUserPrincipal();
        if (this.m_checkPrincipal && principal != null && principal.getName() != null) {
            sessionId = SessionManager.makeSessionId(req, principal);
            allowSetCookieEarly = false;
            s = SessionManager.getSession(sessionId);
            if (s == null) {
                s = SessionManager.startSession(sessionId);
            }
            s.setMaxInactiveInterval(600);
        }
        if (sessionId == null || s == null) {
            if (this.m_sessionParamAllow) {
                sessionId = req.getParameter(ATTR_SESSION);
            }
            c = this.findCookie(req, this.cookieName, suffix);
            if (sessionId == null && c != null) {
                sessionId = c.getValue();
            }
            if (sessionId != null) {
                int dotPosition = sessionId.indexOf(DOT);
                if (dotPosition > -1) {
                    sessionId = sessionId.substring(0, dotPosition);
                }
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)("assureSession found sessionId in cookie: " + sessionId));
                }
                s = SessionManager.getSession(sessionId);
            }
            if (reqsession && s != null && s.getUserId() == null) {
                s = null;
            }
        }
        if (s != null && !auto) {
            Session dotPosition = s;
            synchronized (dotPosition) {
                s.setActive();
            }
        }
        if (s == null && sessionId != null && (rebuildBreakdownService = (RebuildBreakdownService)ComponentManager.get(RebuildBreakdownService.class)) != null && !rebuildBreakdownService.rebuildSession(s = SessionManager.startSession(sessionId))) {
            s.invalidate();
            s = null;
        }
        if (s == null) {
            s = SessionManager.startSession();
            if (c != null) {
                ThreadLocalManager.set("sakai:session.was.invalid", "sakai:session.was.invalid");
            }
        }
        req.setAttribute(ATTR_SESSION, (Object)s);
        SessionManager.setCurrentSession(s);
        UsageSession us = null;
        Session session = s;
        synchronized (session) {
            ServerConfigurationService configService;
            String serverInstanceId;
            us = (UsageSession)s.getAttribute("org.sakaiproject.event.api.UsageSessionService");
            if (us != null && (serverInstanceId = (configService = org.sakaiproject.component.cover.ServerConfigurationService.getInstance()).getServerIdInstance()) != null && !serverInstanceId.equals(us.getServer())) {
                M_log.info((Object)("UsageSession: Server change detected: Old Server=" + us.getServer() + "    New Server=" + serverInstanceId));
                us.setServer(serverInstanceId);
            }
        }
        if (s == null && c != null) {
            c = new Cookie(this.cookieName, "");
            c.setPath("/");
            c.setMaxAge(0);
            if (this.cookieDomain != null) {
                c.setDomain(this.cookieDomain);
            }
            this.addCookie(res, c);
        }
        if (s != null && allowSetCookieEarly) {
            sessionId = s.getId() + DOT + suffix;
            if (c == null || !c.getValue().equals(sessionId)) {
                c = new Cookie(this.cookieName, sessionId);
                c.setPath("/");
                c.setMaxAge(-1);
                if (this.cookieDomain != null) {
                    c.setDomain(this.cookieDomain);
                }
                if (req.isSecure()) {
                    c.setSecure(true);
                }
                this.addCookie(res, c);
            }
        }
        return s;
    }

    protected ToolSession detectToolPlacement(Session s, HttpServletRequest req) {
        if (!this.m_toolPlacement) {
            return null;
        }
        ToolSession toolSession = null;
        String placementId = req.getParameter("sakai.tool.placement.id");
        if (placementId != null) {
            toolSession = s.getToolSession(placementId);
            req.setAttribute("sakai.tool.session", (Object)toolSession);
            SessionManager.setCurrentToolSession(toolSession);
            req.setAttribute("sakai.tool.placement.id", (Object)placementId);
        }
        return toolSession;
    }

    protected HttpServletRequest preProcessRequest(Session s, HttpServletRequest req) {
        req = new WrappedRequest(s, this.m_contextId, (HttpServletRequest)req);
        return req;
    }

    protected HttpServletResponse preProcessResponse(Session s, HttpServletRequest req, HttpServletResponse res) {
        res = new WrappedResponse(s, req, (HttpServletResponse)res);
        if (this.m_UACompatible != null) {
            res.setHeader("X-UA-Compatible", this.m_UACompatible);
        }
        return res;
    }

    protected void postProcessResponse(Session s, HttpServletRequest req, HttpServletResponse res) {
        RebuildBreakdownService rebuildBreakdownService = (RebuildBreakdownService)ComponentManager.get(RebuildBreakdownService.class);
        if (rebuildBreakdownService != null) {
            rebuildBreakdownService.storeSession(s, req);
        }
    }

    private boolean isSessionClusteringEnabled() {
        RebuildBreakdownService rebuildBreakdownService = (RebuildBreakdownService)ComponentManager.get(RebuildBreakdownService.class);
        return this.TERRACOTTA_CLUSTER || rebuildBreakdownService.isSessionHandlingEnabled();
    }

    protected Cookie findCookie(HttpServletRequest req, String name, String suffix) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(name) || !this.isSessionClusteringEnabled() && suffix != null && !cookies[i].getValue().endsWith(suffix)) continue;
                return cookies[i];
            }
        }
        return null;
    }

    private String getCookieSuffix() {
        String suffix = System.getProperty(SAKAI_SERVERID);
        if (suffix == null || suffix.length() == 0) {
            if (this.m_displayModJkWarning) {
                M_log.warn((Object)"no sakai.serverId system property set - mod_jk load balancing will not function properly");
            }
            this.m_displayModJkWarning = false;
            suffix = "sakai";
        }
        return suffix;
    }

    protected void addCookie(HttpServletResponse res, Cookie cookie) {
        if (!this.m_cookieHttpOnly) {
            res.addCookie(cookie);
        } else {
            StringBuffer sb = new StringBuffer();
            ServerCookie.appendCookieValue(sb, cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure(), this.m_cookieHttpOnly);
            res.addHeader("Set-Cookie", sb.toString());
        }
    }

    public class WrappedResponse
    extends HttpServletResponseWrapper {
        protected HttpServletRequest m_req;
        protected HttpServletResponse m_res;

        public WrappedResponse(Session s, HttpServletRequest req, HttpServletResponse res) {
            super(res);
            this.m_req = null;
            this.m_res = null;
            this.m_req = req;
            this.m_res = res;
        }

        public String encodeRedirectUrl(String url) {
            return this.rewriteURL(url);
        }

        public String encodeRedirectURL(String url) {
            return this.rewriteURL(url);
        }

        public String encodeUrl(String url) {
            return this.rewriteURL(url);
        }

        public String encodeURL(String url) {
            return this.rewriteURL(url);
        }

        public void sendRedirect(String url) throws IOException {
            url = this.rewriteURL(url);
            this.m_req.setAttribute(RequestFilter.ATTR_REDIRECT, (Object)url);
            super.sendRedirect(url);
        }

        protected String rewriteURL(String url) {
            String placementId;
            if (RequestFilter.this.m_toolPlacement && (placementId = (String)this.m_req.getAttribute("sakai.tool.placement.id")) != null) {
                StringBuilder full = new StringBuilder();
                full.append(this.m_req.getScheme());
                full.append("://");
                full.append(this.m_req.getServerName());
                if (this.m_req.getServerPort() != 80 && !this.m_req.isSecure() || this.m_req.getServerPort() != 443 && this.m_req.isSecure()) {
                    full.append(":");
                    full.append(this.m_req.getServerPort());
                }
                StringBuilder rel = new StringBuilder();
                rel.append(this.m_req.getContextPath());
                full.append(rel.toString());
                if (url.startsWith(full.toString()) || url.startsWith(rel.toString())) {
                    StringBuilder newUrl = new StringBuilder(url);
                    if (url.indexOf(63) != -1) {
                        newUrl.append('&');
                    } else {
                        newUrl.append('?');
                    }
                    newUrl.append("sakai.tool.placement.id");
                    newUrl.append("=");
                    newUrl.append(placementId);
                    url = newUrl.toString();
                }
            }
            if (this.m_res != null) {
                url = this.m_res.encodeURL(url);
            }
            return url;
        }
    }

    public class WrappedRequest
    extends HttpServletRequestWrapper {
        protected Session m_session;
        protected String m_contextId;

        public WrappedRequest(Session s, String contextId, HttpServletRequest req) {
            super(req);
            this.m_session = null;
            this.m_contextId = null;
            this.m_session = s;
            this.m_contextId = contextId;
            if (RequestFilter.this.m_toolPlacement) {
                this.extractPlacementFromParams();
            }
        }

        public String getRemoteUser() {
            boolean remoteUser = (Boolean)ThreadLocalManager.get(RequestFilter.CURRENT_REMOTE_USER);
            if (remoteUser && this.m_session != null && this.m_session.getUserEid() != null) {
                return this.m_session.getUserEid();
            }
            return super.getRemoteUser();
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public HttpSession getSession(boolean create) {
            HttpSession rv = null;
            int curHttpSession = (Integer)ThreadLocalManager.get(RequestFilter.CURRENT_HTTP_SESSION);
            String curContext = (String)ThreadLocalManager.get(RequestFilter.CURRENT_CONTEXT);
            switch (curHttpSession) {
                case 0: {
                    rv = super.getSession(create);
                    break;
                }
                case 1: {
                    rv = (HttpSession)this.m_session;
                    break;
                }
                case 2: {
                    rv = (HttpSession)this.m_session.getContextSession(curContext);
                    break;
                }
                case 3: {
                    rv = (HttpSession)SessionManager.getCurrentToolSession();
                    if (rv != null) break;
                    rv = (HttpSession)this.m_session.getContextSession(curContext);
                }
            }
            return rv;
        }

        protected void extractPlacementFromParams() {
            String placementId = this.getParameter("sakai.tool.placement.id");
            if (placementId != null) {
                this.setAttribute("sakai.tool.placement.id", placementId);
            }
        }
    }

    static class WrappedRequestFileUpload
    extends HttpServletRequestWrapper {
        private Map map;

        public WrappedRequestFileUpload(HttpServletRequest req, Map paramMap) {
            super(req);
            this.map = paramMap;
        }

        public Map getParameterMap() {
            return this.map;
        }

        public String[] getParameterValues(String name) {
            Object ret = null;
            Map map = this.getParameterMap();
            return (String[])map.get(name);
        }

        public String getParameter(String name) {
            String[] params = this.getParameterValues(name);
            if (params == null) {
                return null;
            }
            return params[0];
        }

        public Enumeration getParameterNames() {
            Map map = this.getParameterMap();
            return Collections.enumeration(map.keySet());
        }
    }
}

