/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.user.api;

import java.util.Collection;
import java.util.List;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.user.api.PasswordPolicyProvider;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserAlreadyDefinedException;
import org.sakaiproject.user.api.UserEdit;
import org.sakaiproject.user.api.UserIdInvalidException;
import org.sakaiproject.user.api.UserLockedException;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.api.UserPermissionException;
import org.w3c.dom.Element;

public interface UserDirectoryService
extends EntityProducer {
    public static final String APPLICATION_ID = "sakai:user";
    public static final String REFERENCE_ROOT = "/user";
    public static final String SECURE_ADD_USER = "user.add";
    public static final String SECURE_REMOVE_USER = "user.del";
    public static final String SECURE_UPDATE_USER_ANY = "user.upd.any";
    public static final String SECURE_UPDATE_USER_OWN = "user.upd.own";
    public static final String SECURE_UPDATE_USER_OWN_NAME = "user.upd.own.name";
    public static final String SECURE_UPDATE_USER_OWN_EMAIL = "user.upd.own.email";
    public static final String SECURE_UPDATE_USER_OWN_PASSWORD = "user.upd.own.passwd";
    public static final String SECURE_UPDATE_USER_OWN_TYPE = "user.upd.own.type";
    public static final String ADMIN_ID = "admin";
    public static final String ADMIN_EID = "admin";

    public PasswordRating validatePassword(String var1, User var2);

    public PasswordPolicyProvider getPasswordPolicy();

    public UserEdit addUser(String var1, String var2) throws UserIdInvalidException, UserAlreadyDefinedException, UserPermissionException;

    public User addUser(String var1, String var2, String var3, String var4, String var5, String var6, String var7, ResourceProperties var8) throws UserIdInvalidException, UserAlreadyDefinedException, UserPermissionException;

    public boolean allowAddUser();

    public boolean allowRemoveUser(String var1);

    public boolean allowUpdateUser(String var1);

    public boolean allowUpdateUserName(String var1);

    public boolean allowUpdateUserEmail(String var1);

    public boolean allowUpdateUserPassword(String var1);

    public boolean allowUpdateUserType(String var1);

    public User authenticate(String var1, String var2);

    public void cancelEdit(UserEdit var1);

    public void commitEdit(UserEdit var1) throws UserAlreadyDefinedException;

    public int countSearchUsers(String var1);

    public int countUsers();

    public void destroyAuthentication();

    public UserEdit editUser(String var1) throws UserNotDefinedException, UserPermissionException, UserLockedException;

    public Collection<User> findUsersByEmail(String var1);

    public User getAnonymousUser();

    public User getCurrentUser();

    public User getUser(String var1) throws UserNotDefinedException;

    public User getUserByEid(String var1) throws UserNotDefinedException;

    public String getUserEid(String var1) throws UserNotDefinedException;

    public String getUserId(String var1) throws UserNotDefinedException;

    public List<User> getUsers();

    public List<User> getUsers(Collection<String> var1);

    public List<User> getUsers(int var1, int var2);

    public List<User> getUsersByEids(Collection<String> var1);

    public UserEdit mergeUser(Element var1) throws UserIdInvalidException, UserAlreadyDefinedException, UserPermissionException;

    public void removeUser(UserEdit var1) throws UserPermissionException;

    public List<User> searchUsers(String var1, int var2, int var3);

    public List<User> searchExternalUsers(String var1, int var2, int var3);

    public String userReference(String var1);

    public static enum PasswordRating {
        FAILED,
        PASSED_DEFAULT,
        PASSED_UNRATED,
        WEAK,
        MODERATE,
        STRONG;


        public boolean passed() {
            return !this.equals((Object)FAILED);
        }

        public boolean checked() {
            return !this.equals((Object)PASSED_DEFAULT);
        }
    }
}

