/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.api;

import java.io.Serializable;
import org.sakaiproject.tool.api.Breakdownable;

public class StoreableBreakdown
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String className;
    private Breakdownable.BreakdownableSize size;
    private Serializable data;
    private transient String sessionId;
    private transient String attributeKey;

    public StoreableBreakdown(String className, Breakdownable.BreakdownableSize size, Serializable data) {
        this.size = size;
        this.className = className;
        this.data = data;
    }

    public static String makeStashKey(String sessionId, String attributeKey) {
        if (sessionId != null && attributeKey != null) {
            return sessionId + "_" + attributeKey;
        }
        return null;
    }

    public String makeStash(String sessionId, String attributeKey) {
        this.sessionId = sessionId;
        this.attributeKey = attributeKey;
        return StoreableBreakdown.makeStashKey(sessionId, attributeKey);
    }

    public String generateStashKey() {
        if (this.isStashed() && this.sessionId != null && this.attributeKey != null) {
            return this.sessionId + "_" + this.attributeKey;
        }
        throw new IllegalStateException("no stash data in this storeable");
    }

    public boolean isStashed() {
        return this.attributeKey != null;
    }

    public Breakdownable.BreakdownableSize getSize() {
        return this.size;
    }

    public void setSize(Breakdownable.BreakdownableSize size) {
        this.size = size;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Serializable getData() {
        return this.data;
    }

    public void setData(Serializable data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreableBreakdown that = (StoreableBreakdown)o;
        return this.className.equals(that.className) && this.size == that.size && this.data.equals(that.data);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + this.size.hashCode();
        result = 31 * result + this.data.hashCode();
        return result;
    }

    public String toString() {
        return "SB{className='" + this.className + '\'' + ", size=" + (Object)((Object)this.size) + ", data=" + this.data.hashCode() + '}';
    }
}

