/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.site.api;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.javax.PagingPosition;
import org.sakaiproject.site.api.AllowedJoinableAccount;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteAdvisor;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.w3c.dom.Element;

public interface SiteService
extends EntityProducer {
    public static final String APPLICATION_ID = "sakai:site";
    public static final String SITE_SUBTYPE = "site";
    public static final String GROUP_SUBTYPE = "group";
    public static final String PAGE_SUBTYPE = "page";
    public static final String TOOL_SUBTYPE = "tool";
    public static final String REFERENCE_ROOT = "/site";
    public static final String SITE_ROLE_SWAP = "site.roleswap";
    public static final String SITE_VISIT = "site.visit";
    public static final String SITE_VISIT_UNPUBLISHED = "site.visit.unp";
    public static final String SECURE_ADD_SITE = "site.add";
    public static final String SECURE_ADD_COURSE_SITE = "site.add.course";
    public static final String SECURE_ADD_PORTFOLIO_SITE = "site.add.portfolio";
    public static final String SECURE_ADD_PROJECT_SITE = "site.add.project";
    public static final String SECURE_ADD_USER_SITE = "site.add.usersite";
    public static final String SECURE_REMOVE_SITE = "site.del";
    public static final String SECURE_REMOVE_SOFTLY_DELETED_SITE = "site.del.softly.deleted";
    public static final String SITE_VISIT_SOFTLY_DELETED = "site.visit.softly.deleted";
    public static final String SECURE_UPDATE_SITE = "site.upd";
    public static final String SECURE_UPDATE_SITE_MEMBERSHIP = "site.upd.site.mbrshp";
    public static final String SECURE_UPDATE_GROUP_MEMBERSHIP = "site.upd.grp.mbrshp";
    public static final String SECURE_VIEW_ROSTER = "site.viewRoster";
    public static final String MAIN_CONTAINER = "main";
    public static final String SITE_TEMPLATE = "!worksite";
    public static final String USER_SITE_TEMPLATE = "!user";
    public static final String SITE_ERROR = "!error";
    public static final String URL_ERROR = "!urlError";
    public static final String PROP_PARENT_ID = "sakai:parent-id";
    public static final String PROP_SHOW_SUBSITES = "sakai:show-subsites";
    public static final String PROP_CACHE_USER_SITES = "user.site.cache.enabled";
    public static final String EVENT_USER_SITE_MEMBERSHIP_ADD = "user.site.membership.add";
    public static final String EVENT_USER_SITE_MEMBERSHIP_UPDATE = "user.site.membership.update";
    public static final String EVENT_USER_SITE_MEMBERSHIP_REMOVE = "user.site.membership.delete";
    public static final String EVENT_USER_GROUP_MEMBERSHIP_ADD = "user.group.membership.add";
    public static final String EVENT_USER_GROUP_MEMBERSHIP_UPDATE = "user.group.membership.update";
    public static final String EVENT_USER_GROUP_MEMBERSHIP_REMOVE = "user.group.membership.delete";
    public static final String EVENT_SITE_VISIT_DENIED = "site.visit.denied";
    public static final String EVENT_SITE_USER_INVALIDATE = "site.usersite.invalidate";
    public static final String EVENT_SITE_IMPORT_START = "site.import.start";
    public static final String EVENT_SITE_IMPORT_END = "site.import.end";
    public static final String EVENT_SITE_DUPLICATE_START = "site.duplicate.start";
    public static final String EVENT_SITE_DUPLICATE_END = "site.duplicate.end";
    public static final String EVENT_SITE_ROSTER_ADD = "site.roster.add";

    public String[] getLayoutNames();

    public boolean allowAccessSite(String var1);

    public boolean siteExists(String var1);

    public Site getSite(String var1) throws IdUnusedException;

    public Site getSiteVisit(String var1) throws IdUnusedException, PermissionException;

    public boolean allowUpdateSite(String var1);

    public boolean allowUpdateSiteMembership(String var1);

    public boolean allowUpdateGroupMembership(String var1);

    public void save(Site var1) throws IdUnusedException, PermissionException;

    public void saveSiteMembership(Site var1) throws IdUnusedException, PermissionException;

    public void saveGroupMembership(Site var1) throws IdUnusedException, PermissionException;

    public void saveSiteInfo(String var1, String var2, String var3) throws IdUnusedException, PermissionException;

    public boolean allowAddSite(String var1);

    public boolean allowAddCourseSite();

    public boolean allowAddPortfolioSite();

    public boolean allowAddProjectSite();

    public Site addSite(String var1, String var2) throws IdInvalidException, IdUsedException, PermissionException;

    public Site addSite(String var1, Site var2) throws IdInvalidException, IdUsedException, PermissionException;

    public boolean allowRemoveSite(String var1);

    public void removeSite(Site var1) throws PermissionException, IdUnusedException;

    public String siteReference(String var1);

    public String sitePageReference(String var1, String var2);

    public String siteToolReference(String var1, String var2);

    public String siteGroupReference(String var1, String var2);

    public boolean isUserSite(String var1);

    public String getSiteUserId(String var1);

    public String getUserSiteId(String var1);

    public boolean isSpecialSite(String var1);

    public String getSiteSpecialId(String var1);

    public String getSpecialSiteId(String var1);

    public String getSiteDisplay(String var1);

    public ToolConfiguration findTool(String var1);

    public SitePage findPage(String var1);

    public boolean allowViewRoster(String var1);

    public void join(String var1) throws IdUnusedException, PermissionException;

    public boolean isAllowedToJoin(String var1);

    public String getJoinGroupId(String var1);

    public boolean isCurrentUserMemberOfSite(String var1);

    public boolean isLimitByAccountTypeEnabled(String var1);

    public LinkedHashSet<String> getAllowedJoinableAccountTypeCategories();

    public List<String> getAllowedJoinableAccountTypes();

    public List<AllowedJoinableAccount> getAllowedJoinableAccounts();

    public boolean isGlobalJoinGroupEnabled();

    public boolean isGlobalJoinExcludedFromPublicListEnabled();

    public boolean isGlobalJoinLimitByAccountTypeEnabled();

    public boolean isGlobalJoinFromSiteBrowserEnabled();

    public boolean allowUnjoinSite(String var1);

    public void unjoin(String var1) throws IdUnusedException, PermissionException;

    public String getSiteSkin(String var1);

    public List<String> getSiteTypes();

    public List<Site> getUserSites();

    public List<Site> getUserSites(boolean var1);

    public List<Site> getSites(SelectionType var1, Object var2, String var3, Map<String, String> var4, SortType var5, PagingPosition var6);

    public List<Site> getSites(SelectionType var1, Object var2, String var3, Map<String, String> var4, SortType var5, PagingPosition var6, boolean var7);

    public List<String> getSiteIds(SelectionType var1, Object var2, String var3, Map<String, String> var4, SortType var5, PagingPosition var6);

    public List<Site> getSoftlyDeletedSites();

    public int countSites(SelectionType var1, Object var2, String var3, Map<String, String> var4);

    public void setSiteSecurity(String var1, Set<String> var2, Set<String> var3, Set<String> var4);

    public void setUserSecurity(String var1, Set<String> var2, Set<String> var3, Set<String> var4);

    public String merge(String var1, Element var2, String var3);

    public Group findGroup(String var1);

    public void addSiteAdvisor(SiteAdvisor var1);

    public boolean removeSiteAdvisor(SiteAdvisor var1);

    public List<SiteAdvisor> getSiteAdvisors();

    public boolean allowRoleSwap(String var1);

    public List<String> getSiteTypeStrings(String var1);

    public static class SortType {
        private final String m_id;
        private final boolean m_asc;
        public static final SortType NONE = new SortType("none", true);
        public static final SortType ID_ASC = new SortType("id", true);
        public static final SortType ID_DESC = new SortType("id", false);
        public static final SortType TITLE_ASC = new SortType("title", true);
        public static final SortType TITLE_DESC = new SortType("title", false);
        public static final SortType TYPE_ASC = new SortType("type", true);
        public static final SortType TYPE_DESC = new SortType("type", false);
        public static final SortType PUBLISHED_ASC = new SortType("published", true);
        public static final SortType PUBLISHED_DESC = new SortType("published", false);
        public static final SortType CREATED_BY_ASC = new SortType("created by", true);
        public static final SortType CREATED_BY_DESC = new SortType("created by", false);
        public static final SortType MODIFIED_BY_ASC = new SortType("modified by", true);
        public static final SortType MODIFIED_BY_DESC = new SortType("modified by", false);
        public static final SortType CREATED_ON_ASC = new SortType("created on", true);
        public static final SortType CREATED_ON_DESC = new SortType("created on", false);
        public static final SortType MODIFIED_ON_ASC = new SortType("modified on", true);
        public static final SortType MODIFIED_ON_DESC = new SortType("modified on", false);
        public static final SortType SOFTLY_DELETED_ASC = new SortType("softly deleted", true);
        public static final SortType SOFTLY_DELETED_DESC = new SortType("softly deleted", false);
        public static final SortType SOFTLY_DELETED_DATE_ASC = new SortType("softly deleted date", true);
        public static final SortType SOFTLY_DELETED_DATE_DESC = new SortType("softly deleted date", false);

        private SortType(String id, boolean asc) {
            this.m_id = id;
            this.m_asc = asc;
        }

        public String toString() {
            return this.m_id;
        }

        public boolean isAsc() {
            return this.m_asc;
        }
    }

    public static class SelectionType {
        private final String m_id;
        private final boolean m_ignoreSpecial;
        private final boolean m_ignoreUser;
        private final boolean m_ignoreUnpublished;
        private final boolean m_ignoreSoftlyDeleted;
        public static final SelectionType ACCESS = new SelectionType("access", true, true, false, true);
        public static final SelectionType UPDATE = new SelectionType("update", true, true, false, true);
        public static final SelectionType JOINABLE = new SelectionType("joinable", true, true, true, true);
        public static final SelectionType PUBVIEW = new SelectionType("pubView", true, true, true, true);
        public static final SelectionType ANY = new SelectionType("any", false, false, false, true);
        public static final SelectionType NON_USER = new SelectionType("nonUser", false, true, false, true);
        public static final SelectionType DELETED = new SelectionType("deleted", true, true, true, false);
        public static final SelectionType ANY_DELETED = new SelectionType("anyDeleted", false, false, false, false);

        private SelectionType(String id, boolean ignoreSpecial, boolean ignoreUser, boolean ignoreUnpublished, boolean ignoreSoftlyDeleted) {
            this.m_id = id;
            this.m_ignoreSpecial = ignoreSpecial;
            this.m_ignoreUser = ignoreUser;
            this.m_ignoreUnpublished = ignoreUnpublished;
            this.m_ignoreSoftlyDeleted = ignoreSoftlyDeleted;
        }

        public String toString() {
            return this.m_id;
        }

        public boolean isIgnoreSpecial() {
            return this.m_ignoreSpecial;
        }

        public boolean isIgnoreUser() {
            return this.m_ignoreUser;
        }

        public boolean isIgnoreUnpublished() {
            return this.m_ignoreUnpublished;
        }

        public boolean isIgnoreSoftlyDeleted() {
            return this.m_ignoreSoftlyDeleted;
        }
    }
}

