/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.memory.mock;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.sakaiproject.memory.api.CacheEventListener;
import org.sakaiproject.memory.api.CacheLoader;
import org.sakaiproject.memory.api.CacheStatistics;
import org.sakaiproject.memory.api.Configuration;
import org.sakaiproject.memory.api.GenericMultiRefCache;
import org.sakaiproject.memory.api.SimpleConfiguration;

public class Cache
implements GenericMultiRefCache,
org.sakaiproject.memory.api.Cache {
    String name;
    private Map<String, Object> map = new HashMap<String, Object>();

    Cache(String name) {
        this.name = name;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Configuration getConfiguration() {
        return new SimpleConfiguration(1000L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.map = null;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return (T)this.map;
    }

    @Override
    public void registerCacheEventListener(CacheEventListener cacheEventListener) {
    }

    @Override
    public CacheStatistics getCacheStatistics() {
        return new CacheStatistics(){

            @Override
            public long getCacheHits() {
                return 0L;
            }

            @Override
            public long getCacheMisses() {
                return 0L;
            }
        };
    }

    @Override
    public Properties getProperties(boolean includeExpensiveDetails) {
        return new Properties();
    }

    @Override
    public Object get(String key) {
        return this.map.get(key);
    }

    @Override
    public Map<String, Object> getAll(Set<String> keys) {
        HashMap<String, Object> m = new HashMap<String, Object>(this.map);
        for (String key : keys) {
            m.remove(key);
        }
        return m;
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public void put(String key, Object object) {
        this.map.put(key, object);
    }

    @Override
    public void putAll(Map<String, Object> map) {
        this.map.putAll(map);
    }

    @Override
    public boolean remove(String key) {
        Object o = this.map.remove(key);
        return o != null;
    }

    @Override
    public void removeAll(Set<String> keys) {
        for (String key : keys) {
            this.map.remove(key);
        }
    }

    @Override
    public void removeAll() {
        this.clear();
    }

    @Override
    public void put(String key, Object payload, String ref, Collection<String> dependRefs) {
        this.map.put(key, payload);
    }

    @Override
    public void destroy() {
        this.close();
    }

    @Override
    public void attachLoader(CacheLoader cacheLoader) {
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public String getDescription() {
        return this.name;
    }

    @Override
    public void put(Object key, Object payload, int duration) {
        this.put((String)key, payload);
    }
}

