/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.javax;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sakaiproject.javax.Order;
import org.sakaiproject.javax.Restriction;

public class Search {
    private long start = 0L;
    private long limit = 0L;
    public boolean conjunction = true;
    private Restriction[] restrictions = new Restriction[0];
    private Order[] orders = new Order[0];
    private String queryString = null;

    public void setStart(long start) {
        this.start = start < 0L ? 0L : start;
    }

    public long getStart() {
        return this.start;
    }

    public void setLimit(long limit) {
        this.limit = limit < 0L ? 0L : limit;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean isConjunction() {
        return this.conjunction;
    }

    public void setConjunction(boolean conjunction) {
        this.conjunction = conjunction;
    }

    public Restriction[] getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(Restriction[] restrictions) {
        this.restrictions = restrictions;
    }

    public Order[] getOrders() {
        return this.orders;
    }

    public void setOrders(Order[] orders) {
        this.orders = orders;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public Search() {
    }

    public Search(Search search) {
        Search.copy(search, this);
    }

    public Search(String queryString) {
        this.queryString = queryString;
    }

    public Search(String property, Object value) {
        this.restrictions = new Restriction[]{new Restriction(property, value)};
    }

    public Search(String property, Object value, int comparison) {
        this.restrictions = new Restriction[]{new Restriction(property, value, comparison)};
    }

    public Search(String[] properties, Object[] values) {
        this.restrictions = new Restriction[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.restrictions[i] = new Restriction(properties[i], values[i]);
        }
    }

    public Search(String[] properties, Object[] values, boolean conjunction) {
        this.restrictions = new Restriction[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.restrictions[i] = new Restriction(properties[i], values[i]);
        }
        this.conjunction = conjunction;
    }

    public Search(String[] properties, Object[] values, int[] comparisons) {
        this.restrictions = new Restriction[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.restrictions[i] = new Restriction(properties[i], values[i], comparisons[i]);
        }
    }

    public Search(String[] properties, Object[] values, int[] comparisons, boolean conjunction) {
        this.restrictions = new Restriction[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.restrictions[i] = new Restriction(properties[i], values[i], comparisons[i]);
        }
        this.conjunction = conjunction;
    }

    public Search(String[] properties, Object[] values, int[] comparisons, Order[] orders) {
        this.restrictions = new Restriction[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.restrictions[i] = new Restriction(properties[i], values[i], comparisons[i]);
        }
        this.orders = orders;
    }

    public Search(String[] properties, Object[] values, int[] comparisons, Order[] orders, long firstResult, long maxResults) {
        this.restrictions = new Restriction[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.restrictions[i] = new Restriction(properties[i], values[i], comparisons[i]);
        }
        this.orders = orders;
        this.start = firstResult;
        this.limit = maxResults;
    }

    public Search(Restriction restriction) {
        this.restrictions = new Restriction[]{restriction};
    }

    public Search(Restriction[] restrictions) {
        this.restrictions = restrictions;
    }

    public Search(Restriction restriction, Order order) {
        this.restrictions = new Restriction[]{restriction};
        this.orders = new Order[]{order};
    }

    public Search(Restriction[] restrictions, Order order) {
        this.restrictions = restrictions;
        this.orders = new Order[]{order};
    }

    public Search(Restriction[] restrictions, Order[] orders) {
        this.restrictions = restrictions;
        this.orders = orders;
    }

    public Search(Restriction restriction, Order order, long start, long limit) {
        this.restrictions = new Restriction[]{restriction};
        this.orders = new Order[]{order};
        this.start = start;
        this.limit = limit;
    }

    public Search(Restriction[] restrictions, Order order, long start, long limit) {
        this.restrictions = restrictions;
        this.orders = new Order[]{order};
        this.start = start;
        this.limit = limit;
    }

    public Search(Restriction[] restrictions, Order[] orders, long start, long limit) {
        this.restrictions = restrictions;
        this.orders = orders;
        this.start = start;
        this.limit = limit;
    }

    public Search(Restriction[] restrictions, Order order, long start, long limit, boolean conjunction) {
        this.restrictions = restrictions;
        this.orders = new Order[]{order};
        this.start = start;
        this.limit = limit;
        this.conjunction = conjunction;
    }

    public Search(Restriction[] restrictions, Order[] orders, long start, long limit, boolean conjunction) {
        this.restrictions = restrictions;
        this.orders = orders;
        this.start = start;
        this.limit = limit;
        this.conjunction = conjunction;
    }

    public void addRestriction(Restriction restriction) {
        if (this.restrictions != null) {
            int location = Search.contains(this.restrictions, restriction);
            if (location >= 0 && location < this.restrictions.length) {
                this.restrictions[location] = restriction;
            } else {
                this.restrictions = Search.appendArray(this.restrictions, restriction);
            }
        } else {
            this.restrictions = new Restriction[]{restriction};
        }
    }

    public void addOrder(Order order) {
        if (this.orders != null) {
            int location = Search.contains(this.orders, order);
            if (location >= 0 && location < this.orders.length) {
                this.orders[location] = order;
            } else {
                this.orders = Search.appendArray(this.orders, order);
            }
        } else {
            this.orders = new Order[]{order};
        }
    }

    public Restriction getRestrictionByProperty(String property) {
        Restriction r = null;
        if (this.restrictions != null && property != null) {
            for (int i = 0; i < this.restrictions.length; ++i) {
                if (!property.equals(this.restrictions[i].property)) continue;
                r = this.restrictions[i];
                break;
            }
        }
        return r;
    }

    public List<String> getRestrictionsProperties() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.restrictions != null) {
            for (int i = 0; i < this.restrictions.length; ++i) {
                l.add(this.restrictions[i].property);
            }
        }
        return l;
    }

    public boolean isEmpty() {
        boolean empty = false;
        if (!(this.restrictions != null && this.restrictions.length != 0 || this.orders != null && this.orders.length != 0 || this.queryString != null)) {
            empty = true;
        }
        return empty;
    }

    public void reset() {
        this.restrictions = new Restriction[0];
        this.orders = new Order[0];
        this.conjunction = false;
        this.queryString = null;
        this.start = 0L;
        this.limit = 0L;
    }

    public static <T> int contains(T[] array, T value) {
        int position = -1;
        if (value != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!value.equals(array[i])) continue;
                position = i;
                break;
            }
        }
        return position;
    }

    public static <T> T[] appendArray(T[] array, T value) {
        Class<?> type = array.getClass().getComponentType();
        Object[] newArray = (Object[])Array.newInstance(type, array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }

    public static String arrayToString(Object[] array) {
        StringBuilder result = new StringBuilder();
        if (array != null && array.length > 0) {
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    result.append(",");
                }
                if (array[i] == null) continue;
                result.append(array[i].toString());
            }
        }
        return result.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        return Search.copy(this, null);
    }

    public static Search copy(Search original, Search copy) {
        if (copy == null) {
            copy = new Search();
        }
        copy.setStart(original.getStart());
        copy.setLimit(original.getLimit());
        copy.setConjunction(original.isConjunction());
        copy.setQueryString(original.getQueryString());
        copy.setRestrictions(original.getRestrictions());
        copy.setOrders(original.getOrders());
        return copy;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof Search)) {
            return false;
        }
        Search castObj = (Search)obj;
        boolean eq = this.start == castObj.start && this.limit == castObj.limit && this.conjunction == castObj.conjunction && (this.queryString == null ? castObj.queryString == null : this.queryString.equals(castObj.queryString)) && Arrays.deepEquals(this.restrictions, castObj.restrictions) && Arrays.deepEquals(this.orders, castObj.orders);
        return eq;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return super.hashCode();
        }
        String hashStr = this.getClass().getName() + ":" + this.start + ":" + this.limit + ":" + this.conjunction + ":" + this.queryString + ":" + Search.arrayToString(this.restrictions) + ":" + Search.arrayToString(this.orders);
        return hashStr.hashCode();
    }

    public String toString() {
        return "search::start:" + this.start + ",limit:" + this.limit + ",conj:" + this.conjunction + ",query:" + this.queryString + ",restricts:" + Search.arrayToString(this.restrictions) + ",orders:" + Search.arrayToString(this.orders);
    }
}

