/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.email.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sakaiproject.email.api.Attachment;
import org.sakaiproject.email.api.EmailAddress;

public class EmailMessage {
    private EmailAddress from;
    private List<EmailAddress> replyTo;
    private Map<EmailAddress.RecipientType, List<EmailAddress>> recipients = new HashMap<EmailAddress.RecipientType, List<EmailAddress>>();
    private String subject;
    private String body;
    private List<Attachment> attachments;
    private Map<String, String> headers;
    private String contentType = "text/plain";
    private String characterSet = "utf-8";
    private String format;

    public EmailMessage() {
    }

    public EmailMessage(String from, String subject, String body) {
        this.setFrom(from);
        this.setSubject(subject);
        this.setBody(body);
    }

    public EmailAddress getFrom() {
        return this.from;
    }

    public void setFrom(String email) {
        this.from = new EmailAddress(email);
    }

    public void setFrom(EmailAddress emailAddress) {
        this.from = emailAddress;
    }

    public List<EmailAddress> getReplyTo() {
        return this.replyTo;
    }

    public void addReplyTo(EmailAddress emailAddress) {
        if (this.replyTo == null) {
            this.replyTo = new ArrayList<EmailAddress>();
        }
        this.replyTo.add(emailAddress);
    }

    public void setReplyTo(List<EmailAddress> replyTo) {
        this.replyTo = replyTo;
    }

    public Map<EmailAddress.RecipientType, List<EmailAddress>> getRecipients() {
        return this.recipients;
    }

    public List<EmailAddress> getRecipients(EmailAddress.RecipientType type) {
        List<EmailAddress> retval = null;
        if (this.recipients != null) {
            retval = this.recipients.get((Object)type);
        }
        return retval;
    }

    public void addRecipient(EmailAddress.RecipientType type, String email) {
        List<EmailAddress> addresses = this.recipients.get((Object)type);
        if (addresses == null) {
            addresses = new ArrayList<EmailAddress>();
        }
        addresses.add(new EmailAddress(email));
        this.recipients.put(type, addresses);
    }

    public void addRecipient(EmailAddress.RecipientType type, String name, String email) {
        List<EmailAddress> addresses = this.recipients.get((Object)type);
        if (addresses == null) {
            addresses = new ArrayList<EmailAddress>();
        }
        addresses.add(new EmailAddress(email, name));
        this.recipients.put(type, addresses);
    }

    public void addRecipients(EmailAddress.RecipientType type, List<EmailAddress> addresses) {
        List<EmailAddress> currentAddresses = this.recipients.get((Object)type);
        if (currentAddresses == null) {
            this.recipients.put(type, addresses);
        } else {
            currentAddresses.addAll(addresses);
        }
    }

    public void setRecipients(EmailAddress.RecipientType type, List<EmailAddress> addresses) {
        if (addresses != null) {
            this.recipients.put(type, addresses);
        } else {
            this.recipients.remove((Object)type);
        }
    }

    public void setRecipients(Map<EmailAddress.RecipientType, List<EmailAddress>> recipients) {
        this.recipients = recipients;
    }

    public List<EmailAddress> getAllRecipients() {
        ArrayList<EmailAddress> rcpts = new ArrayList<EmailAddress>();
        if (this.recipients.containsKey((Object)EmailAddress.RecipientType.TO)) {
            rcpts.addAll((Collection)this.recipients.get((Object)EmailAddress.RecipientType.TO));
        }
        if (this.recipients.containsKey((Object)EmailAddress.RecipientType.CC)) {
            rcpts.addAll((Collection)this.recipients.get((Object)EmailAddress.RecipientType.CC));
        }
        if (this.recipients.containsKey((Object)EmailAddress.RecipientType.BCC)) {
            rcpts.addAll((Collection)this.recipients.get((Object)EmailAddress.RecipientType.BCC));
        }
        if (this.recipients.containsKey((Object)EmailAddress.RecipientType.ACTUAL)) {
            rcpts.addAll((Collection<EmailAddress>)this.recipients.get((Object)EmailAddress.RecipientType.ACTUAL));
        }
        return rcpts;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void addAttachment(Attachment attachment) {
        if (attachment != null) {
            if (this.attachments == null) {
                this.attachments = new ArrayList<Attachment>();
            }
            this.attachments.add(attachment);
        }
    }

    public void addAttachment(File file) {
        this.addAttachment(new Attachment(file, file.getPath()));
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<String> extractHeaders() {
        ArrayList<String> retval = new ArrayList<String>();
        if (this.headers != null) {
            for (String key : this.headers.keySet()) {
                String value = this.headers.get(key);
                if (key == null || value == null) continue;
                retval.add(key + ": " + value);
            }
        }
        return retval;
    }

    public void removeHeader(String key) {
        if (this.headers != null && !this.headers.isEmpty() && this.headers.containsKey(key)) {
            this.headers.remove(key);
        }
    }

    public void addHeader(String key, String value) {
        if (this.headers == null || this.headers.get(key) == null) {
            this.setHeader(key, value);
        } else if (key != null && value != null) {
            String prevVal = this.headers.get(key);
            prevVal = prevVal + " " + value;
            this.headers.put(key, prevVal);
        } else if (value == null) {
            this.removeHeader(key);
        }
    }

    public void setHeader(String key, String value) {
        if (key != null && value != null) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(key, value);
        }
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setHeaders(List<String> headers) {
        if (headers != null) {
            for (String header : headers) {
                int splitPoint = header.indexOf(":");
                String key = header.substring(0, splitPoint);
                String value = null;
                if (splitPoint != header.length() - 1) {
                    value = header.substring(splitPoint + 1).trim();
                }
                this.setHeader(key, value);
            }
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String mimeType) {
        this.contentType = mimeType;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

