/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.content.api;

import java.util.Collection;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.time.api.Time;

public interface GroupAwareEntity
extends Entity {
    public Collection getGroups();

    public Collection getGroupObjects();

    public AccessMode getAccess();

    public Collection getInheritedGroups();

    public Collection getInheritedGroupObjects();

    public AccessMode getInheritedAccess();

    public Time getReleaseDate();

    public Time getRetractDate();

    public boolean isHidden();

    public boolean isAvailable();

    public static class AccessMode {
        protected final String m_id;
        public static final AccessMode SITE = new AccessMode("site");
        public static final AccessMode GROUPED = new AccessMode("grouped");
        public static final AccessMode INHERITED = new AccessMode("inherited");

        private AccessMode(String id) {
            this.m_id = id;
        }

        public String toString() {
            return this.m_id;
        }

        public boolean equals(Object obj) {
            boolean rv = false;
            if (obj instanceof AccessMode) {
                rv = ((AccessMode)obj).toString().equals(this.toString());
            }
            return rv;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public static AccessMode fromString(String access) {
            if (AccessMode.SITE.m_id.equals(access)) {
                return SITE;
            }
            if (AccessMode.GROUPED.m_id.equals(access)) {
                return GROUPED;
            }
            if (AccessMode.INHERITED.m_id.equals(access)) {
                return INHERITED;
            }
            return null;
        }
    }
}

